\page Doxygen_for_CGAL Doxygen for CGAL

This is the documentation of doxygen hacks that are applied to make
the output of Doxygen more suitable to CGAL. It explains the general
structure of the build system, the ordinary customizations and the
hacks that create what you see.

## Overall structure ##

## Ordinary Customization ##

## Hacks ##

### Package Overview ###

The package overview is build by having a special command that is
filtered by the python script `pkglist_filter.py`.

A command has to be of the form `\package_listing{PKG_NAME}`, where
`PKG_NAME` cannot contain a closing `}`.

The command is replaced by the text between the two delimiters
`cgalPkgDescriptionBegin` and `cgalPkgDescriptionEnd` in the file `../PKG_NAME/doc/PKG_NAME/PackageDescription.txt`

If `PKG_NAME` is of the form `A/B` the selected file is
`../A/doc/B/PackageDescription.txt`. This is to support packages like
`TDS_2`, which don't reside in their own packages in the SCM.

### Footnotes ###

A JQuery footnotes plug-in jquery.footnotes is used to handle
footnotes. The special doxygen command `\cgalFootnote` expands to the
appropriate html marker. Some JavaScript in `header.html` is used to
append the `<ol div="autoFootnotes0">` to the current doc-content
div. It is not added to the footer because this would break when tree
views are enabled.

The plug-in code is part of `hacks.js` to minimize the amount of files
that have to be delivered.

### autotoc ###

TOCs in HTML are generated by the some JavaScript. This is necessary
to work around the fact that doxygen does not supported sections that
have no label in a TOC. This command simply becomes a normal toc in
LaTex.

### Reference Manual link in the tree view  ###

This hack fiddles with the internal structures and functions of the
treeview to remove the unnecessary intermediate top-level module part.

It assigns the first element of the module array (found in `module.js`)
to the Reference Manual entry. This makes the tree view link go to
that group directly instead of the intermediate link. It also removes
one level of nesting.

Unfortunately this changes the overall tree structure. To adjust for
that we hijack the `gotoNode` function of `navtree.js` and *augment* it
with an additional check for the specific tree level we borked and
redirect it.

All of it is in `header.html` and `hacks.js`.

# Things that would be nice to have #

## Search ##
The search function could be better:
- member functions could be removed
- global functions could be searchable
- package codenames could be supported

## Function Documentation ##

Automatic grouping of overloads or a switch to document functions in a
style more similar to classes, e.g. with their own page.

## Global Build Version ##

I have no idea how feasible that actually is, but it might be worth a
try.

## Package Overview ##

Build the Package Overview with the help of the Build System.
