#!/bin/bash

log()
{
  LOGFILE=${1}
  shift
  if [ -n "${CONSOLE_OUTPUT}" ]; then
      printf "%s ...\n" "${*}"
  fi
  {
    printf "\n-------------------------------------------------------\n"
    printf "  %s ...\n" "$*"
    printf "\n-------------------------------------------------------\n"
  } >> "${LOGFILE}"
}

log_done()
{
  if [ -n "${CONSOLE_OUTPUT}" ]; then
      printf \
      " done\n-------------------------------------------------------\n"
  fi
  {
    printf "\n-------------------------------------------------------\n"
    printf "  **DONE**\n"
    printf "\n-------------------------------------------------------\n"
  } >> "${1}"
}

