//    SPDX-License-Identifier: LGPL-3.0-or-later
/*
   This file is part of FlexiBLAS, a BLAS/LAPACK interface wrapper library.
   Copyright (C) 2013-2025 Martin Koehler

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 3 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

#ifndef LAPACKE_STRUCTURE_H
#define LAPACKE_STRUCTURE_H

#include <stdint.h>
#include <complex.h>

#define FLEXIBLAS_LAPACK_MAJOR 3
#define FLEXIBLAS_LAPACK_MINOR 10
#define FLEXIBLAS_LAPACK_PATCH 1


#ifdef __cplusplus
extern "C" {
#endif

#include "flexiblas_config.h"
#include "flexiblas_fortran_char_len.h"
#include "flexiblas_fortran_mangle.h"

typedef struct _flexiblas_lapacke_backend {
    void *LAPACKE_cbbcsd;
    void *LAPACKE_cbbcsd_work;
    void *LAPACKE_cbdsqr;
    void *LAPACKE_cbdsqr_work;
    void *LAPACKE_cgbbrd;
    void *LAPACKE_cgbbrd_work;
    void *LAPACKE_cgbcon;
    void *LAPACKE_cgbcon_work;
    void *LAPACKE_cgbequ;
    void *LAPACKE_cgbequ_work;
    void *LAPACKE_cgbequb;
    void *LAPACKE_cgbequb_work;
    void *LAPACKE_cgbrfs;
    void *LAPACKE_cgbrfs_work;
    void *LAPACKE_cgbsv;
    void *LAPACKE_cgbsv_work;
    void *LAPACKE_cgbsvx;
    void *LAPACKE_cgbsvx_work;
    void *LAPACKE_cgbtrf;
    void *LAPACKE_cgbtrf_work;
    void *LAPACKE_cgbtrs;
    void *LAPACKE_cgbtrs_work;
    void *LAPACKE_cgebak;
    void *LAPACKE_cgebak_work;
    void *LAPACKE_cgebal;
    void *LAPACKE_cgebal_work;
    void *LAPACKE_cgebrd;
    void *LAPACKE_cgebrd_work;
    void *LAPACKE_cgecon;
    void *LAPACKE_cgecon_work;
    void *LAPACKE_cgeequ;
    void *LAPACKE_cgeequ_work;
    void *LAPACKE_cgeequb;
    void *LAPACKE_cgeequb_work;
    void *LAPACKE_cgees;
    void *LAPACKE_cgees_work;
    void *LAPACKE_cgeesx;
    void *LAPACKE_cgeesx_work;
    void *LAPACKE_cgeev;
    void *LAPACKE_cgeev_work;
    void *LAPACKE_cgeevx;
    void *LAPACKE_cgeevx_work;
    void *LAPACKE_cgehrd;
    void *LAPACKE_cgehrd_work;
    void *LAPACKE_cgejsv;
    void *LAPACKE_cgejsv_work;
    void *LAPACKE_cgelq;
    void *LAPACKE_cgelq2;
    void *LAPACKE_cgelq2_work;
    void *LAPACKE_cgelq_work;
    void *LAPACKE_cgelqf;
    void *LAPACKE_cgelqf_work;
    void *LAPACKE_cgels;
    void *LAPACKE_cgels_work;
    void *LAPACKE_cgelsd;
    void *LAPACKE_cgelsd_work;
    void *LAPACKE_cgelss;
    void *LAPACKE_cgelss_work;
    void *LAPACKE_cgelsy;
    void *LAPACKE_cgelsy_work;
    void *LAPACKE_cgemlq;
    void *LAPACKE_cgemlq_work;
    void *LAPACKE_cgemqr;
    void *LAPACKE_cgemqr_work;
    void *LAPACKE_cgemqrt;
    void *LAPACKE_cgemqrt_work;
    void *LAPACKE_cgeqlf;
    void *LAPACKE_cgeqlf_work;
    void *LAPACKE_cgeqp3;
    void *LAPACKE_cgeqp3_work;
    void *LAPACKE_cgeqpf;
    void *LAPACKE_cgeqpf_work;
    void *LAPACKE_cgeqr;
    void *LAPACKE_cgeqr2;
    void *LAPACKE_cgeqr2_work;
    void *LAPACKE_cgeqr_work;
    void *LAPACKE_cgeqrf;
    void *LAPACKE_cgeqrf_work;
    void *LAPACKE_cgeqrfp;
    void *LAPACKE_cgeqrfp_work;
    void *LAPACKE_cgeqrt;
    void *LAPACKE_cgeqrt2;
    void *LAPACKE_cgeqrt2_work;
    void *LAPACKE_cgeqrt3;
    void *LAPACKE_cgeqrt3_work;
    void *LAPACKE_cgeqrt_work;
    void *LAPACKE_cgerfs;
    void *LAPACKE_cgerfs_work;
    void *LAPACKE_cgerqf;
    void *LAPACKE_cgerqf_work;
    void *LAPACKE_cgesdd;
    void *LAPACKE_cgesdd_work;
    void *LAPACKE_cgesv;
    void *LAPACKE_cgesv_work;
    void *LAPACKE_cgesvd;
    void *LAPACKE_cgesvd_work;
    void *LAPACKE_cgesvdq;
    void *LAPACKE_cgesvdq_work;
    void *LAPACKE_cgesvdx;
    void *LAPACKE_cgesvdx_work;
    void *LAPACKE_cgesvj;
    void *LAPACKE_cgesvj_work;
    void *LAPACKE_cgesvx;
    void *LAPACKE_cgesvx_work;
    void *LAPACKE_cgetf2;
    void *LAPACKE_cgetf2_work;
    void *LAPACKE_cgetrf;
    void *LAPACKE_cgetrf2;
    void *LAPACKE_cgetrf2_work;
    void *LAPACKE_cgetrf_work;
    void *LAPACKE_cgetri;
    void *LAPACKE_cgetri_work;
    void *LAPACKE_cgetrs;
    void *LAPACKE_cgetrs_work;
    void *LAPACKE_cgetsls;
    void *LAPACKE_cgetsls_work;
    void *LAPACKE_cgetsqrhrt;
    void *LAPACKE_cgetsqrhrt_work;
    void *LAPACKE_cggbak;
    void *LAPACKE_cggbak_work;
    void *LAPACKE_cggbal;
    void *LAPACKE_cggbal_work;
    void *LAPACKE_cgges;
    void *LAPACKE_cgges3;
    void *LAPACKE_cgges3_work;
    void *LAPACKE_cgges_work;
    void *LAPACKE_cggesx;
    void *LAPACKE_cggesx_work;
    void *LAPACKE_cggev;
    void *LAPACKE_cggev3;
    void *LAPACKE_cggev3_work;
    void *LAPACKE_cggev_work;
    void *LAPACKE_cggevx;
    void *LAPACKE_cggevx_work;
    void *LAPACKE_cggglm;
    void *LAPACKE_cggglm_work;
    void *LAPACKE_cgghd3;
    void *LAPACKE_cgghd3_work;
    void *LAPACKE_cgghrd;
    void *LAPACKE_cgghrd_work;
    void *LAPACKE_cgglse;
    void *LAPACKE_cgglse_work;
    void *LAPACKE_cggqrf;
    void *LAPACKE_cggqrf_work;
    void *LAPACKE_cggrqf;
    void *LAPACKE_cggrqf_work;
    void *LAPACKE_cggsvd;
    void *LAPACKE_cggsvd3;
    void *LAPACKE_cggsvd3_work;
    void *LAPACKE_cggsvd_work;
    void *LAPACKE_cggsvp;
    void *LAPACKE_cggsvp3;
    void *LAPACKE_cggsvp3_work;
    void *LAPACKE_cggsvp_work;
    void *LAPACKE_cgtcon;
    void *LAPACKE_cgtcon_work;
    void *LAPACKE_cgtrfs;
    void *LAPACKE_cgtrfs_work;
    void *LAPACKE_cgtsv;
    void *LAPACKE_cgtsv_work;
    void *LAPACKE_cgtsvx;
    void *LAPACKE_cgtsvx_work;
    void *LAPACKE_cgttrf;
    void *LAPACKE_cgttrf_work;
    void *LAPACKE_cgttrs;
    void *LAPACKE_cgttrs_work;
    void *LAPACKE_chbev;
    void *LAPACKE_chbev_2stage;
    void *LAPACKE_chbev_2stage_work;
    void *LAPACKE_chbev_work;
    void *LAPACKE_chbevd;
    void *LAPACKE_chbevd_2stage;
    void *LAPACKE_chbevd_2stage_work;
    void *LAPACKE_chbevd_work;
    void *LAPACKE_chbevx;
    void *LAPACKE_chbevx_2stage;
    void *LAPACKE_chbevx_2stage_work;
    void *LAPACKE_chbevx_work;
    void *LAPACKE_chbgst;
    void *LAPACKE_chbgst_work;
    void *LAPACKE_chbgv;
    void *LAPACKE_chbgv_work;
    void *LAPACKE_chbgvd;
    void *LAPACKE_chbgvd_work;
    void *LAPACKE_chbgvx;
    void *LAPACKE_chbgvx_work;
    void *LAPACKE_chbtrd;
    void *LAPACKE_chbtrd_work;
    void *LAPACKE_checon;
    void *LAPACKE_checon_3;
    void *LAPACKE_checon_3_work;
    void *LAPACKE_checon_work;
    void *LAPACKE_cheequb;
    void *LAPACKE_cheequb_work;
    void *LAPACKE_cheev;
    void *LAPACKE_cheev_2stage;
    void *LAPACKE_cheev_2stage_work;
    void *LAPACKE_cheev_work;
    void *LAPACKE_cheevd;
    void *LAPACKE_cheevd_2stage;
    void *LAPACKE_cheevd_2stage_work;
    void *LAPACKE_cheevd_work;
    void *LAPACKE_cheevr;
    void *LAPACKE_cheevr_2stage;
    void *LAPACKE_cheevr_2stage_work;
    void *LAPACKE_cheevr_work;
    void *LAPACKE_cheevx;
    void *LAPACKE_cheevx_2stage;
    void *LAPACKE_cheevx_2stage_work;
    void *LAPACKE_cheevx_work;
    void *LAPACKE_chegst;
    void *LAPACKE_chegst_work;
    void *LAPACKE_chegv;
    void *LAPACKE_chegv_2stage;
    void *LAPACKE_chegv_2stage_work;
    void *LAPACKE_chegv_work;
    void *LAPACKE_chegvd;
    void *LAPACKE_chegvd_work;
    void *LAPACKE_chegvx;
    void *LAPACKE_chegvx_work;
    void *LAPACKE_cherfs;
    void *LAPACKE_cherfs_work;
    void *LAPACKE_chesv;
    void *LAPACKE_chesv_aa;
    void *LAPACKE_chesv_aa_2stage;
    void *LAPACKE_chesv_aa_2stage_work;
    void *LAPACKE_chesv_aa_work;
    void *LAPACKE_chesv_rk;
    void *LAPACKE_chesv_rk_work;
    void *LAPACKE_chesv_work;
    void *LAPACKE_chesvx;
    void *LAPACKE_chesvx_work;
    void *LAPACKE_cheswapr;
    void *LAPACKE_cheswapr_work;
    void *LAPACKE_chetrd;
    void *LAPACKE_chetrd_work;
    void *LAPACKE_chetrf;
    void *LAPACKE_chetrf_aa;
    void *LAPACKE_chetrf_aa_2stage;
    void *LAPACKE_chetrf_aa_2stage_work;
    void *LAPACKE_chetrf_aa_work;
    void *LAPACKE_chetrf_rk;
    void *LAPACKE_chetrf_rk_work;
    void *LAPACKE_chetrf_rook;
    void *LAPACKE_chetrf_rook_work;
    void *LAPACKE_chetrf_work;
    void *LAPACKE_chetri;
    void *LAPACKE_chetri2;
    void *LAPACKE_chetri2_work;
    void *LAPACKE_chetri2x;
    void *LAPACKE_chetri2x_work;
    void *LAPACKE_chetri_3;
    void *LAPACKE_chetri_3_work;
    void *LAPACKE_chetri_work;
    void *LAPACKE_chetrs;
    void *LAPACKE_chetrs2;
    void *LAPACKE_chetrs2_work;
    void *LAPACKE_chetrs_3;
    void *LAPACKE_chetrs_3_work;
    void *LAPACKE_chetrs_aa;
    void *LAPACKE_chetrs_aa_2stage;
    void *LAPACKE_chetrs_aa_2stage_work;
    void *LAPACKE_chetrs_aa_work;
    void *LAPACKE_chetrs_rook;
    void *LAPACKE_chetrs_rook_work;
    void *LAPACKE_chetrs_work;
    void *LAPACKE_chfrk;
    void *LAPACKE_chfrk_work;
    void *LAPACKE_chgeqz;
    void *LAPACKE_chgeqz_work;
    void *LAPACKE_chpcon;
    void *LAPACKE_chpcon_work;
    void *LAPACKE_chpev;
    void *LAPACKE_chpev_work;
    void *LAPACKE_chpevd;
    void *LAPACKE_chpevd_work;
    void *LAPACKE_chpevx;
    void *LAPACKE_chpevx_work;
    void *LAPACKE_chpgst;
    void *LAPACKE_chpgst_work;
    void *LAPACKE_chpgv;
    void *LAPACKE_chpgv_work;
    void *LAPACKE_chpgvd;
    void *LAPACKE_chpgvd_work;
    void *LAPACKE_chpgvx;
    void *LAPACKE_chpgvx_work;
    void *LAPACKE_chprfs;
    void *LAPACKE_chprfs_work;
    void *LAPACKE_chpsv;
    void *LAPACKE_chpsv_work;
    void *LAPACKE_chpsvx;
    void *LAPACKE_chpsvx_work;
    void *LAPACKE_chptrd;
    void *LAPACKE_chptrd_work;
    void *LAPACKE_chptrf;
    void *LAPACKE_chptrf_work;
    void *LAPACKE_chptri;
    void *LAPACKE_chptri_work;
    void *LAPACKE_chptrs;
    void *LAPACKE_chptrs_work;
    void *LAPACKE_chsein;
    void *LAPACKE_chsein_work;
    void *LAPACKE_chseqr;
    void *LAPACKE_chseqr_work;
    void *LAPACKE_clacgv;
    void *LAPACKE_clacgv_work;
    void *LAPACKE_clacn2;
    void *LAPACKE_clacn2_work;
    void *LAPACKE_clacp2;
    void *LAPACKE_clacp2_work;
    void *LAPACKE_clacpy;
    void *LAPACKE_clacpy_work;
    void *LAPACKE_clacrm;
    void *LAPACKE_clacrm_work;
    void *LAPACKE_clag2z;
    void *LAPACKE_clag2z_work;
    void *LAPACKE_clange;
    void *LAPACKE_clange_work;
    void *LAPACKE_clanhe;
    void *LAPACKE_clanhe_work;
    void *LAPACKE_clansy;
    void *LAPACKE_clansy_work;
    void *LAPACKE_clantr;
    void *LAPACKE_clantr_work;
    void *LAPACKE_clapmr;
    void *LAPACKE_clapmr_work;
    void *LAPACKE_clapmt;
    void *LAPACKE_clapmt_work;
    void *LAPACKE_clarcm;
    void *LAPACKE_clarcm_work;
    void *LAPACKE_clarfb;
    void *LAPACKE_clarfb_work;
    void *LAPACKE_clarfg;
    void *LAPACKE_clarfg_work;
    void *LAPACKE_clarft;
    void *LAPACKE_clarft_work;
    void *LAPACKE_clarfx;
    void *LAPACKE_clarfx_work;
    void *LAPACKE_clarnv;
    void *LAPACKE_clarnv_work;
    void *LAPACKE_clascl;
    void *LAPACKE_clascl_work;
    void *LAPACKE_claset;
    void *LAPACKE_claset_work;
    void *LAPACKE_classq;
    void *LAPACKE_classq_work;
    void *LAPACKE_claswp;
    void *LAPACKE_claswp_work;
    void *LAPACKE_clauum;
    void *LAPACKE_clauum_work;
    void *LAPACKE_cpbcon;
    void *LAPACKE_cpbcon_work;
    void *LAPACKE_cpbequ;
    void *LAPACKE_cpbequ_work;
    void *LAPACKE_cpbrfs;
    void *LAPACKE_cpbrfs_work;
    void *LAPACKE_cpbstf;
    void *LAPACKE_cpbstf_work;
    void *LAPACKE_cpbsv;
    void *LAPACKE_cpbsv_work;
    void *LAPACKE_cpbsvx;
    void *LAPACKE_cpbsvx_work;
    void *LAPACKE_cpbtrf;
    void *LAPACKE_cpbtrf_work;
    void *LAPACKE_cpbtrs;
    void *LAPACKE_cpbtrs_work;
    void *LAPACKE_cpftrf;
    void *LAPACKE_cpftrf_work;
    void *LAPACKE_cpftri;
    void *LAPACKE_cpftri_work;
    void *LAPACKE_cpftrs;
    void *LAPACKE_cpftrs_work;
    void *LAPACKE_cpocon;
    void *LAPACKE_cpocon_work;
    void *LAPACKE_cpoequ;
    void *LAPACKE_cpoequ_work;
    void *LAPACKE_cpoequb;
    void *LAPACKE_cpoequb_work;
    void *LAPACKE_cporfs;
    void *LAPACKE_cporfs_work;
    void *LAPACKE_cposv;
    void *LAPACKE_cposv_work;
    void *LAPACKE_cposvx;
    void *LAPACKE_cposvx_work;
    void *LAPACKE_cpotrf;
    void *LAPACKE_cpotrf2;
    void *LAPACKE_cpotrf2_work;
    void *LAPACKE_cpotrf_work;
    void *LAPACKE_cpotri;
    void *LAPACKE_cpotri_work;
    void *LAPACKE_cpotrs;
    void *LAPACKE_cpotrs_work;
    void *LAPACKE_cppcon;
    void *LAPACKE_cppcon_work;
    void *LAPACKE_cppequ;
    void *LAPACKE_cppequ_work;
    void *LAPACKE_cpprfs;
    void *LAPACKE_cpprfs_work;
    void *LAPACKE_cppsv;
    void *LAPACKE_cppsv_work;
    void *LAPACKE_cppsvx;
    void *LAPACKE_cppsvx_work;
    void *LAPACKE_cpptrf;
    void *LAPACKE_cpptrf_work;
    void *LAPACKE_cpptri;
    void *LAPACKE_cpptri_work;
    void *LAPACKE_cpptrs;
    void *LAPACKE_cpptrs_work;
    void *LAPACKE_cpstrf;
    void *LAPACKE_cpstrf_work;
    void *LAPACKE_cptcon;
    void *LAPACKE_cptcon_work;
    void *LAPACKE_cpteqr;
    void *LAPACKE_cpteqr_work;
    void *LAPACKE_cptrfs;
    void *LAPACKE_cptrfs_work;
    void *LAPACKE_cptsv;
    void *LAPACKE_cptsv_work;
    void *LAPACKE_cptsvx;
    void *LAPACKE_cptsvx_work;
    void *LAPACKE_cpttrf;
    void *LAPACKE_cpttrf_work;
    void *LAPACKE_cpttrs;
    void *LAPACKE_cpttrs_work;
    void *LAPACKE_cspcon;
    void *LAPACKE_cspcon_work;
    void *LAPACKE_csprfs;
    void *LAPACKE_csprfs_work;
    void *LAPACKE_cspsv;
    void *LAPACKE_cspsv_work;
    void *LAPACKE_cspsvx;
    void *LAPACKE_cspsvx_work;
    void *LAPACKE_csptrf;
    void *LAPACKE_csptrf_work;
    void *LAPACKE_csptri;
    void *LAPACKE_csptri_work;
    void *LAPACKE_csptrs;
    void *LAPACKE_csptrs_work;
    void *LAPACKE_cstedc;
    void *LAPACKE_cstedc_work;
    void *LAPACKE_cstegr;
    void *LAPACKE_cstegr_work;
    void *LAPACKE_cstein;
    void *LAPACKE_cstein_work;
    void *LAPACKE_cstemr;
    void *LAPACKE_cstemr_work;
    void *LAPACKE_csteqr;
    void *LAPACKE_csteqr_work;
    void *LAPACKE_csycon;
    void *LAPACKE_csycon_3;
    void *LAPACKE_csycon_3_work;
    void *LAPACKE_csycon_work;
    void *LAPACKE_csyconv;
    void *LAPACKE_csyconv_work;
    void *LAPACKE_csyequb;
    void *LAPACKE_csyequb_work;
    void *LAPACKE_csyr;
    void *LAPACKE_csyr_work;
    void *LAPACKE_csyrfs;
    void *LAPACKE_csyrfs_work;
    void *LAPACKE_csysv;
    void *LAPACKE_csysv_aa;
    void *LAPACKE_csysv_aa_2stage;
    void *LAPACKE_csysv_aa_2stage_work;
    void *LAPACKE_csysv_aa_work;
    void *LAPACKE_csysv_rk;
    void *LAPACKE_csysv_rk_work;
    void *LAPACKE_csysv_rook;
    void *LAPACKE_csysv_rook_work;
    void *LAPACKE_csysv_work;
    void *LAPACKE_csysvx;
    void *LAPACKE_csysvx_work;
    void *LAPACKE_csyswapr;
    void *LAPACKE_csyswapr_work;
    void *LAPACKE_csytrf;
    void *LAPACKE_csytrf_aa;
    void *LAPACKE_csytrf_aa_2stage;
    void *LAPACKE_csytrf_aa_2stage_work;
    void *LAPACKE_csytrf_aa_work;
    void *LAPACKE_csytrf_rk;
    void *LAPACKE_csytrf_rk_work;
    void *LAPACKE_csytrf_rook;
    void *LAPACKE_csytrf_rook_work;
    void *LAPACKE_csytrf_work;
    void *LAPACKE_csytri;
    void *LAPACKE_csytri2;
    void *LAPACKE_csytri2_work;
    void *LAPACKE_csytri2x;
    void *LAPACKE_csytri2x_work;
    void *LAPACKE_csytri_3;
    void *LAPACKE_csytri_3_work;
    void *LAPACKE_csytri_work;
    void *LAPACKE_csytrs;
    void *LAPACKE_csytrs2;
    void *LAPACKE_csytrs2_work;
    void *LAPACKE_csytrs_3;
    void *LAPACKE_csytrs_3_work;
    void *LAPACKE_csytrs_aa;
    void *LAPACKE_csytrs_aa_2stage;
    void *LAPACKE_csytrs_aa_2stage_work;
    void *LAPACKE_csytrs_aa_work;
    void *LAPACKE_csytrs_rook;
    void *LAPACKE_csytrs_rook_work;
    void *LAPACKE_csytrs_work;
    void *LAPACKE_ctbcon;
    void *LAPACKE_ctbcon_work;
    void *LAPACKE_ctbrfs;
    void *LAPACKE_ctbrfs_work;
    void *LAPACKE_ctbtrs;
    void *LAPACKE_ctbtrs_work;
    void *LAPACKE_ctfsm;
    void *LAPACKE_ctfsm_work;
    void *LAPACKE_ctftri;
    void *LAPACKE_ctftri_work;
    void *LAPACKE_ctfttp;
    void *LAPACKE_ctfttp_work;
    void *LAPACKE_ctfttr;
    void *LAPACKE_ctfttr_work;
    void *LAPACKE_ctgevc;
    void *LAPACKE_ctgevc_work;
    void *LAPACKE_ctgexc;
    void *LAPACKE_ctgexc_work;
    void *LAPACKE_ctgsen;
    void *LAPACKE_ctgsen_work;
    void *LAPACKE_ctgsja;
    void *LAPACKE_ctgsja_work;
    void *LAPACKE_ctgsna;
    void *LAPACKE_ctgsna_work;
    void *LAPACKE_ctgsyl;
    void *LAPACKE_ctgsyl_work;
    void *LAPACKE_ctpcon;
    void *LAPACKE_ctpcon_work;
    void *LAPACKE_ctpmqrt;
    void *LAPACKE_ctpmqrt_work;
    void *LAPACKE_ctpqrt;
    void *LAPACKE_ctpqrt2;
    void *LAPACKE_ctpqrt2_work;
    void *LAPACKE_ctpqrt_work;
    void *LAPACKE_ctprfb;
    void *LAPACKE_ctprfb_work;
    void *LAPACKE_ctprfs;
    void *LAPACKE_ctprfs_work;
    void *LAPACKE_ctptri;
    void *LAPACKE_ctptri_work;
    void *LAPACKE_ctptrs;
    void *LAPACKE_ctptrs_work;
    void *LAPACKE_ctpttf;
    void *LAPACKE_ctpttf_work;
    void *LAPACKE_ctpttr;
    void *LAPACKE_ctpttr_work;
    void *LAPACKE_ctrcon;
    void *LAPACKE_ctrcon_work;
    void *LAPACKE_ctrevc;
    void *LAPACKE_ctrevc_work;
    void *LAPACKE_ctrexc;
    void *LAPACKE_ctrexc_work;
    void *LAPACKE_ctrrfs;
    void *LAPACKE_ctrrfs_work;
    void *LAPACKE_ctrsen;
    void *LAPACKE_ctrsen_work;
    void *LAPACKE_ctrsna;
    void *LAPACKE_ctrsna_work;
    void *LAPACKE_ctrsyl;
    void *LAPACKE_ctrsyl_work;
    void *LAPACKE_ctrtri;
    void *LAPACKE_ctrtri_work;
    void *LAPACKE_ctrtrs;
    void *LAPACKE_ctrtrs_work;
    void *LAPACKE_ctrttf;
    void *LAPACKE_ctrttf_work;
    void *LAPACKE_ctrttp;
    void *LAPACKE_ctrttp_work;
    void *LAPACKE_ctzrzf;
    void *LAPACKE_ctzrzf_work;
    void *LAPACKE_cunbdb;
    void *LAPACKE_cunbdb_work;
    void *LAPACKE_cuncsd;
    void *LAPACKE_cuncsd2by1;
    void *LAPACKE_cuncsd2by1_work;
    void *LAPACKE_cuncsd_work;
    void *LAPACKE_cungbr;
    void *LAPACKE_cungbr_work;
    void *LAPACKE_cunghr;
    void *LAPACKE_cunghr_work;
    void *LAPACKE_cunglq;
    void *LAPACKE_cunglq_work;
    void *LAPACKE_cungql;
    void *LAPACKE_cungql_work;
    void *LAPACKE_cungqr;
    void *LAPACKE_cungqr_work;
    void *LAPACKE_cungrq;
    void *LAPACKE_cungrq_work;
    void *LAPACKE_cungtr;
    void *LAPACKE_cungtr_work;
    void *LAPACKE_cungtsqr_row;
    void *LAPACKE_cungtsqr_row_work;
    void *LAPACKE_cunmbr;
    void *LAPACKE_cunmbr_work;
    void *LAPACKE_cunmhr;
    void *LAPACKE_cunmhr_work;
    void *LAPACKE_cunmlq;
    void *LAPACKE_cunmlq_work;
    void *LAPACKE_cunmql;
    void *LAPACKE_cunmql_work;
    void *LAPACKE_cunmqr;
    void *LAPACKE_cunmqr_work;
    void *LAPACKE_cunmrq;
    void *LAPACKE_cunmrq_work;
    void *LAPACKE_cunmrz;
    void *LAPACKE_cunmrz_work;
    void *LAPACKE_cunmtr;
    void *LAPACKE_cunmtr_work;
    void *LAPACKE_cupgtr;
    void *LAPACKE_cupgtr_work;
    void *LAPACKE_cupmtr;
    void *LAPACKE_cupmtr_work;
    void *LAPACKE_dbbcsd;
    void *LAPACKE_dbbcsd_work;
    void *LAPACKE_dbdsdc;
    void *LAPACKE_dbdsdc_work;
    void *LAPACKE_dbdsqr;
    void *LAPACKE_dbdsqr_work;
    void *LAPACKE_dbdsvdx;
    void *LAPACKE_dbdsvdx_work;
    void *LAPACKE_ddisna;
    void *LAPACKE_ddisna_work;
    void *LAPACKE_dgbbrd;
    void *LAPACKE_dgbbrd_work;
    void *LAPACKE_dgbcon;
    void *LAPACKE_dgbcon_work;
    void *LAPACKE_dgbequ;
    void *LAPACKE_dgbequ_work;
    void *LAPACKE_dgbequb;
    void *LAPACKE_dgbequb_work;
    void *LAPACKE_dgbrfs;
    void *LAPACKE_dgbrfs_work;
    void *LAPACKE_dgbsv;
    void *LAPACKE_dgbsv_work;
    void *LAPACKE_dgbsvx;
    void *LAPACKE_dgbsvx_work;
    void *LAPACKE_dgbtrf;
    void *LAPACKE_dgbtrf_work;
    void *LAPACKE_dgbtrs;
    void *LAPACKE_dgbtrs_work;
    void *LAPACKE_dgebak;
    void *LAPACKE_dgebak_work;
    void *LAPACKE_dgebal;
    void *LAPACKE_dgebal_work;
    void *LAPACKE_dgebrd;
    void *LAPACKE_dgebrd_work;
    void *LAPACKE_dgecon;
    void *LAPACKE_dgecon_work;
    void *LAPACKE_dgeequ;
    void *LAPACKE_dgeequ_work;
    void *LAPACKE_dgeequb;
    void *LAPACKE_dgeequb_work;
    void *LAPACKE_dgees;
    void *LAPACKE_dgees_work;
    void *LAPACKE_dgeesx;
    void *LAPACKE_dgeesx_work;
    void *LAPACKE_dgeev;
    void *LAPACKE_dgeev_work;
    void *LAPACKE_dgeevx;
    void *LAPACKE_dgeevx_work;
    void *LAPACKE_dgehrd;
    void *LAPACKE_dgehrd_work;
    void *LAPACKE_dgejsv;
    void *LAPACKE_dgejsv_work;
    void *LAPACKE_dgelq;
    void *LAPACKE_dgelq2;
    void *LAPACKE_dgelq2_work;
    void *LAPACKE_dgelq_work;
    void *LAPACKE_dgelqf;
    void *LAPACKE_dgelqf_work;
    void *LAPACKE_dgels;
    void *LAPACKE_dgels_work;
    void *LAPACKE_dgelsd;
    void *LAPACKE_dgelsd_work;
    void *LAPACKE_dgelss;
    void *LAPACKE_dgelss_work;
    void *LAPACKE_dgelsy;
    void *LAPACKE_dgelsy_work;
    void *LAPACKE_dgemlq;
    void *LAPACKE_dgemlq_work;
    void *LAPACKE_dgemqr;
    void *LAPACKE_dgemqr_work;
    void *LAPACKE_dgemqrt;
    void *LAPACKE_dgemqrt_work;
    void *LAPACKE_dgeqlf;
    void *LAPACKE_dgeqlf_work;
    void *LAPACKE_dgeqp3;
    void *LAPACKE_dgeqp3_work;
    void *LAPACKE_dgeqpf;
    void *LAPACKE_dgeqpf_work;
    void *LAPACKE_dgeqr;
    void *LAPACKE_dgeqr2;
    void *LAPACKE_dgeqr2_work;
    void *LAPACKE_dgeqr_work;
    void *LAPACKE_dgeqrf;
    void *LAPACKE_dgeqrf_work;
    void *LAPACKE_dgeqrfp;
    void *LAPACKE_dgeqrfp_work;
    void *LAPACKE_dgeqrt;
    void *LAPACKE_dgeqrt2;
    void *LAPACKE_dgeqrt2_work;
    void *LAPACKE_dgeqrt3;
    void *LAPACKE_dgeqrt3_work;
    void *LAPACKE_dgeqrt_work;
    void *LAPACKE_dgerfs;
    void *LAPACKE_dgerfs_work;
    void *LAPACKE_dgerqf;
    void *LAPACKE_dgerqf_work;
    void *LAPACKE_dgesdd;
    void *LAPACKE_dgesdd_work;
    void *LAPACKE_dgesv;
    void *LAPACKE_dgesv_work;
    void *LAPACKE_dgesvd;
    void *LAPACKE_dgesvd_work;
    void *LAPACKE_dgesvdq;
    void *LAPACKE_dgesvdq_work;
    void *LAPACKE_dgesvdx;
    void *LAPACKE_dgesvdx_work;
    void *LAPACKE_dgesvj;
    void *LAPACKE_dgesvj_work;
    void *LAPACKE_dgesvx;
    void *LAPACKE_dgesvx_work;
    void *LAPACKE_dgetf2;
    void *LAPACKE_dgetf2_work;
    void *LAPACKE_dgetrf;
    void *LAPACKE_dgetrf2;
    void *LAPACKE_dgetrf2_work;
    void *LAPACKE_dgetrf_work;
    void *LAPACKE_dgetri;
    void *LAPACKE_dgetri_work;
    void *LAPACKE_dgetrs;
    void *LAPACKE_dgetrs_work;
    void *LAPACKE_dgetsls;
    void *LAPACKE_dgetsls_work;
    void *LAPACKE_dgetsqrhrt;
    void *LAPACKE_dgetsqrhrt_work;
    void *LAPACKE_dggbak;
    void *LAPACKE_dggbak_work;
    void *LAPACKE_dggbal;
    void *LAPACKE_dggbal_work;
    void *LAPACKE_dgges;
    void *LAPACKE_dgges3;
    void *LAPACKE_dgges3_work;
    void *LAPACKE_dgges_work;
    void *LAPACKE_dggesx;
    void *LAPACKE_dggesx_work;
    void *LAPACKE_dggev;
    void *LAPACKE_dggev3;
    void *LAPACKE_dggev3_work;
    void *LAPACKE_dggev_work;
    void *LAPACKE_dggevx;
    void *LAPACKE_dggevx_work;
    void *LAPACKE_dggglm;
    void *LAPACKE_dggglm_work;
    void *LAPACKE_dgghd3;
    void *LAPACKE_dgghd3_work;
    void *LAPACKE_dgghrd;
    void *LAPACKE_dgghrd_work;
    void *LAPACKE_dgglse;
    void *LAPACKE_dgglse_work;
    void *LAPACKE_dggqrf;
    void *LAPACKE_dggqrf_work;
    void *LAPACKE_dggrqf;
    void *LAPACKE_dggrqf_work;
    void *LAPACKE_dggsvd;
    void *LAPACKE_dggsvd3;
    void *LAPACKE_dggsvd3_work;
    void *LAPACKE_dggsvd_work;
    void *LAPACKE_dggsvp;
    void *LAPACKE_dggsvp3;
    void *LAPACKE_dggsvp3_work;
    void *LAPACKE_dggsvp_work;
    void *LAPACKE_dgtcon;
    void *LAPACKE_dgtcon_work;
    void *LAPACKE_dgtrfs;
    void *LAPACKE_dgtrfs_work;
    void *LAPACKE_dgtsv;
    void *LAPACKE_dgtsv_work;
    void *LAPACKE_dgtsvx;
    void *LAPACKE_dgtsvx_work;
    void *LAPACKE_dgttrf;
    void *LAPACKE_dgttrf_work;
    void *LAPACKE_dgttrs;
    void *LAPACKE_dgttrs_work;
    void *LAPACKE_dhgeqz;
    void *LAPACKE_dhgeqz_work;
    void *LAPACKE_dhsein;
    void *LAPACKE_dhsein_work;
    void *LAPACKE_dhseqr;
    void *LAPACKE_dhseqr_work;
    void *LAPACKE_dlacn2;
    void *LAPACKE_dlacn2_work;
    void *LAPACKE_dlacpy;
    void *LAPACKE_dlacpy_work;
    void *LAPACKE_dlag2s;
    void *LAPACKE_dlag2s_work;
    void *LAPACKE_dlamch;
    void *LAPACKE_dlamch_work;
    void *LAPACKE_dlange;
    void *LAPACKE_dlange_work;
    void *LAPACKE_dlansy;
    void *LAPACKE_dlansy_work;
    void *LAPACKE_dlantr;
    void *LAPACKE_dlantr_work;
    void *LAPACKE_dlapmr;
    void *LAPACKE_dlapmr_work;
    void *LAPACKE_dlapmt;
    void *LAPACKE_dlapmt_work;
    void *LAPACKE_dlapy2;
    void *LAPACKE_dlapy2_work;
    void *LAPACKE_dlapy3;
    void *LAPACKE_dlapy3_work;
    void *LAPACKE_dlarfb;
    void *LAPACKE_dlarfb_work;
    void *LAPACKE_dlarfg;
    void *LAPACKE_dlarfg_work;
    void *LAPACKE_dlarft;
    void *LAPACKE_dlarft_work;
    void *LAPACKE_dlarfx;
    void *LAPACKE_dlarfx_work;
    void *LAPACKE_dlarnv;
    void *LAPACKE_dlarnv_work;
    void *LAPACKE_dlartgp;
    void *LAPACKE_dlartgp_work;
    void *LAPACKE_dlartgs;
    void *LAPACKE_dlartgs_work;
    void *LAPACKE_dlascl;
    void *LAPACKE_dlascl_work;
    void *LAPACKE_dlaset;
    void *LAPACKE_dlaset_work;
    void *LAPACKE_dlasrt;
    void *LAPACKE_dlasrt_work;
    void *LAPACKE_dlassq;
    void *LAPACKE_dlassq_work;
    void *LAPACKE_dlaswp;
    void *LAPACKE_dlaswp_work;
    void *LAPACKE_dlauum;
    void *LAPACKE_dlauum_work;
    void *LAPACKE_dopgtr;
    void *LAPACKE_dopgtr_work;
    void *LAPACKE_dopmtr;
    void *LAPACKE_dopmtr_work;
    void *LAPACKE_dorbdb;
    void *LAPACKE_dorbdb_work;
    void *LAPACKE_dorcsd;
    void *LAPACKE_dorcsd2by1;
    void *LAPACKE_dorcsd2by1_work;
    void *LAPACKE_dorcsd_work;
    void *LAPACKE_dorgbr;
    void *LAPACKE_dorgbr_work;
    void *LAPACKE_dorghr;
    void *LAPACKE_dorghr_work;
    void *LAPACKE_dorglq;
    void *LAPACKE_dorglq_work;
    void *LAPACKE_dorgql;
    void *LAPACKE_dorgql_work;
    void *LAPACKE_dorgqr;
    void *LAPACKE_dorgqr_work;
    void *LAPACKE_dorgrq;
    void *LAPACKE_dorgrq_work;
    void *LAPACKE_dorgtr;
    void *LAPACKE_dorgtr_work;
    void *LAPACKE_dorgtsqr_row;
    void *LAPACKE_dorgtsqr_row_work;
    void *LAPACKE_dormbr;
    void *LAPACKE_dormbr_work;
    void *LAPACKE_dormhr;
    void *LAPACKE_dormhr_work;
    void *LAPACKE_dormlq;
    void *LAPACKE_dormlq_work;
    void *LAPACKE_dormql;
    void *LAPACKE_dormql_work;
    void *LAPACKE_dormqr;
    void *LAPACKE_dormqr_work;
    void *LAPACKE_dormrq;
    void *LAPACKE_dormrq_work;
    void *LAPACKE_dormrz;
    void *LAPACKE_dormrz_work;
    void *LAPACKE_dormtr;
    void *LAPACKE_dormtr_work;
    void *LAPACKE_dpbcon;
    void *LAPACKE_dpbcon_work;
    void *LAPACKE_dpbequ;
    void *LAPACKE_dpbequ_work;
    void *LAPACKE_dpbrfs;
    void *LAPACKE_dpbrfs_work;
    void *LAPACKE_dpbstf;
    void *LAPACKE_dpbstf_work;
    void *LAPACKE_dpbsv;
    void *LAPACKE_dpbsv_work;
    void *LAPACKE_dpbsvx;
    void *LAPACKE_dpbsvx_work;
    void *LAPACKE_dpbtrf;
    void *LAPACKE_dpbtrf_work;
    void *LAPACKE_dpbtrs;
    void *LAPACKE_dpbtrs_work;
    void *LAPACKE_dpftrf;
    void *LAPACKE_dpftrf_work;
    void *LAPACKE_dpftri;
    void *LAPACKE_dpftri_work;
    void *LAPACKE_dpftrs;
    void *LAPACKE_dpftrs_work;
    void *LAPACKE_dpocon;
    void *LAPACKE_dpocon_work;
    void *LAPACKE_dpoequ;
    void *LAPACKE_dpoequ_work;
    void *LAPACKE_dpoequb;
    void *LAPACKE_dpoequb_work;
    void *LAPACKE_dporfs;
    void *LAPACKE_dporfs_work;
    void *LAPACKE_dposv;
    void *LAPACKE_dposv_work;
    void *LAPACKE_dposvx;
    void *LAPACKE_dposvx_work;
    void *LAPACKE_dpotrf;
    void *LAPACKE_dpotrf2;
    void *LAPACKE_dpotrf2_work;
    void *LAPACKE_dpotrf_work;
    void *LAPACKE_dpotri;
    void *LAPACKE_dpotri_work;
    void *LAPACKE_dpotrs;
    void *LAPACKE_dpotrs_work;
    void *LAPACKE_dppcon;
    void *LAPACKE_dppcon_work;
    void *LAPACKE_dppequ;
    void *LAPACKE_dppequ_work;
    void *LAPACKE_dpprfs;
    void *LAPACKE_dpprfs_work;
    void *LAPACKE_dppsv;
    void *LAPACKE_dppsv_work;
    void *LAPACKE_dppsvx;
    void *LAPACKE_dppsvx_work;
    void *LAPACKE_dpptrf;
    void *LAPACKE_dpptrf_work;
    void *LAPACKE_dpptri;
    void *LAPACKE_dpptri_work;
    void *LAPACKE_dpptrs;
    void *LAPACKE_dpptrs_work;
    void *LAPACKE_dpstrf;
    void *LAPACKE_dpstrf_work;
    void *LAPACKE_dptcon;
    void *LAPACKE_dptcon_work;
    void *LAPACKE_dpteqr;
    void *LAPACKE_dpteqr_work;
    void *LAPACKE_dptrfs;
    void *LAPACKE_dptrfs_work;
    void *LAPACKE_dptsv;
    void *LAPACKE_dptsv_work;
    void *LAPACKE_dptsvx;
    void *LAPACKE_dptsvx_work;
    void *LAPACKE_dpttrf;
    void *LAPACKE_dpttrf_work;
    void *LAPACKE_dpttrs;
    void *LAPACKE_dpttrs_work;
    void *LAPACKE_dsbev;
    void *LAPACKE_dsbev_2stage;
    void *LAPACKE_dsbev_2stage_work;
    void *LAPACKE_dsbev_work;
    void *LAPACKE_dsbevd;
    void *LAPACKE_dsbevd_2stage;
    void *LAPACKE_dsbevd_2stage_work;
    void *LAPACKE_dsbevd_work;
    void *LAPACKE_dsbevx;
    void *LAPACKE_dsbevx_2stage;
    void *LAPACKE_dsbevx_2stage_work;
    void *LAPACKE_dsbevx_work;
    void *LAPACKE_dsbgst;
    void *LAPACKE_dsbgst_work;
    void *LAPACKE_dsbgv;
    void *LAPACKE_dsbgv_work;
    void *LAPACKE_dsbgvd;
    void *LAPACKE_dsbgvd_work;
    void *LAPACKE_dsbgvx;
    void *LAPACKE_dsbgvx_work;
    void *LAPACKE_dsbtrd;
    void *LAPACKE_dsbtrd_work;
    void *LAPACKE_dsfrk;
    void *LAPACKE_dsfrk_work;
    void *LAPACKE_dsgesv;
    void *LAPACKE_dsgesv_work;
    void *LAPACKE_dspcon;
    void *LAPACKE_dspcon_work;
    void *LAPACKE_dspev;
    void *LAPACKE_dspev_work;
    void *LAPACKE_dspevd;
    void *LAPACKE_dspevd_work;
    void *LAPACKE_dspevx;
    void *LAPACKE_dspevx_work;
    void *LAPACKE_dspgst;
    void *LAPACKE_dspgst_work;
    void *LAPACKE_dspgv;
    void *LAPACKE_dspgv_work;
    void *LAPACKE_dspgvd;
    void *LAPACKE_dspgvd_work;
    void *LAPACKE_dspgvx;
    void *LAPACKE_dspgvx_work;
    void *LAPACKE_dsposv;
    void *LAPACKE_dsposv_work;
    void *LAPACKE_dsprfs;
    void *LAPACKE_dsprfs_work;
    void *LAPACKE_dspsv;
    void *LAPACKE_dspsv_work;
    void *LAPACKE_dspsvx;
    void *LAPACKE_dspsvx_work;
    void *LAPACKE_dsptrd;
    void *LAPACKE_dsptrd_work;
    void *LAPACKE_dsptrf;
    void *LAPACKE_dsptrf_work;
    void *LAPACKE_dsptri;
    void *LAPACKE_dsptri_work;
    void *LAPACKE_dsptrs;
    void *LAPACKE_dsptrs_work;
    void *LAPACKE_dstebz;
    void *LAPACKE_dstebz_work;
    void *LAPACKE_dstedc;
    void *LAPACKE_dstedc_work;
    void *LAPACKE_dstegr;
    void *LAPACKE_dstegr_work;
    void *LAPACKE_dstein;
    void *LAPACKE_dstein_work;
    void *LAPACKE_dstemr;
    void *LAPACKE_dstemr_work;
    void *LAPACKE_dsteqr;
    void *LAPACKE_dsteqr_work;
    void *LAPACKE_dsterf;
    void *LAPACKE_dsterf_work;
    void *LAPACKE_dstev;
    void *LAPACKE_dstev_work;
    void *LAPACKE_dstevd;
    void *LAPACKE_dstevd_work;
    void *LAPACKE_dstevr;
    void *LAPACKE_dstevr_work;
    void *LAPACKE_dstevx;
    void *LAPACKE_dstevx_work;
    void *LAPACKE_dsycon;
    void *LAPACKE_dsycon_3;
    void *LAPACKE_dsycon_3_work;
    void *LAPACKE_dsycon_work;
    void *LAPACKE_dsyconv;
    void *LAPACKE_dsyconv_work;
    void *LAPACKE_dsyequb;
    void *LAPACKE_dsyequb_work;
    void *LAPACKE_dsyev;
    void *LAPACKE_dsyev_2stage;
    void *LAPACKE_dsyev_2stage_work;
    void *LAPACKE_dsyev_work;
    void *LAPACKE_dsyevd;
    void *LAPACKE_dsyevd_2stage;
    void *LAPACKE_dsyevd_2stage_work;
    void *LAPACKE_dsyevd_work;
    void *LAPACKE_dsyevr;
    void *LAPACKE_dsyevr_2stage;
    void *LAPACKE_dsyevr_2stage_work;
    void *LAPACKE_dsyevr_work;
    void *LAPACKE_dsyevx;
    void *LAPACKE_dsyevx_2stage;
    void *LAPACKE_dsyevx_2stage_work;
    void *LAPACKE_dsyevx_work;
    void *LAPACKE_dsygst;
    void *LAPACKE_dsygst_work;
    void *LAPACKE_dsygv;
    void *LAPACKE_dsygv_2stage;
    void *LAPACKE_dsygv_2stage_work;
    void *LAPACKE_dsygv_work;
    void *LAPACKE_dsygvd;
    void *LAPACKE_dsygvd_work;
    void *LAPACKE_dsygvx;
    void *LAPACKE_dsygvx_work;
    void *LAPACKE_dsyrfs;
    void *LAPACKE_dsyrfs_work;
    void *LAPACKE_dsysv;
    void *LAPACKE_dsysv_aa;
    void *LAPACKE_dsysv_aa_2stage;
    void *LAPACKE_dsysv_aa_2stage_work;
    void *LAPACKE_dsysv_aa_work;
    void *LAPACKE_dsysv_rk;
    void *LAPACKE_dsysv_rk_work;
    void *LAPACKE_dsysv_rook;
    void *LAPACKE_dsysv_rook_work;
    void *LAPACKE_dsysv_work;
    void *LAPACKE_dsysvx;
    void *LAPACKE_dsysvx_work;
    void *LAPACKE_dsyswapr;
    void *LAPACKE_dsyswapr_work;
    void *LAPACKE_dsytrd;
    void *LAPACKE_dsytrd_work;
    void *LAPACKE_dsytrf;
    void *LAPACKE_dsytrf_aa;
    void *LAPACKE_dsytrf_aa_2stage;
    void *LAPACKE_dsytrf_aa_2stage_work;
    void *LAPACKE_dsytrf_aa_work;
    void *LAPACKE_dsytrf_rk;
    void *LAPACKE_dsytrf_rk_work;
    void *LAPACKE_dsytrf_rook;
    void *LAPACKE_dsytrf_rook_work;
    void *LAPACKE_dsytrf_work;
    void *LAPACKE_dsytri;
    void *LAPACKE_dsytri2;
    void *LAPACKE_dsytri2_work;
    void *LAPACKE_dsytri2x;
    void *LAPACKE_dsytri2x_work;
    void *LAPACKE_dsytri_3;
    void *LAPACKE_dsytri_3_work;
    void *LAPACKE_dsytri_work;
    void *LAPACKE_dsytrs;
    void *LAPACKE_dsytrs2;
    void *LAPACKE_dsytrs2_work;
    void *LAPACKE_dsytrs_3;
    void *LAPACKE_dsytrs_3_work;
    void *LAPACKE_dsytrs_aa;
    void *LAPACKE_dsytrs_aa_2stage;
    void *LAPACKE_dsytrs_aa_2stage_work;
    void *LAPACKE_dsytrs_aa_work;
    void *LAPACKE_dsytrs_rook;
    void *LAPACKE_dsytrs_rook_work;
    void *LAPACKE_dsytrs_work;
    void *LAPACKE_dtbcon;
    void *LAPACKE_dtbcon_work;
    void *LAPACKE_dtbrfs;
    void *LAPACKE_dtbrfs_work;
    void *LAPACKE_dtbtrs;
    void *LAPACKE_dtbtrs_work;
    void *LAPACKE_dtfsm;
    void *LAPACKE_dtfsm_work;
    void *LAPACKE_dtftri;
    void *LAPACKE_dtftri_work;
    void *LAPACKE_dtfttp;
    void *LAPACKE_dtfttp_work;
    void *LAPACKE_dtfttr;
    void *LAPACKE_dtfttr_work;
    void *LAPACKE_dtgevc;
    void *LAPACKE_dtgevc_work;
    void *LAPACKE_dtgexc;
    void *LAPACKE_dtgexc_work;
    void *LAPACKE_dtgsen;
    void *LAPACKE_dtgsen_work;
    void *LAPACKE_dtgsja;
    void *LAPACKE_dtgsja_work;
    void *LAPACKE_dtgsna;
    void *LAPACKE_dtgsna_work;
    void *LAPACKE_dtgsyl;
    void *LAPACKE_dtgsyl_work;
    void *LAPACKE_dtpcon;
    void *LAPACKE_dtpcon_work;
    void *LAPACKE_dtpmqrt;
    void *LAPACKE_dtpmqrt_work;
    void *LAPACKE_dtpqrt;
    void *LAPACKE_dtpqrt2;
    void *LAPACKE_dtpqrt2_work;
    void *LAPACKE_dtpqrt_work;
    void *LAPACKE_dtprfb;
    void *LAPACKE_dtprfb_work;
    void *LAPACKE_dtprfs;
    void *LAPACKE_dtprfs_work;
    void *LAPACKE_dtptri;
    void *LAPACKE_dtptri_work;
    void *LAPACKE_dtptrs;
    void *LAPACKE_dtptrs_work;
    void *LAPACKE_dtpttf;
    void *LAPACKE_dtpttf_work;
    void *LAPACKE_dtpttr;
    void *LAPACKE_dtpttr_work;
    void *LAPACKE_dtrcon;
    void *LAPACKE_dtrcon_work;
    void *LAPACKE_dtrevc;
    void *LAPACKE_dtrevc_work;
    void *LAPACKE_dtrexc;
    void *LAPACKE_dtrexc_work;
    void *LAPACKE_dtrrfs;
    void *LAPACKE_dtrrfs_work;
    void *LAPACKE_dtrsen;
    void *LAPACKE_dtrsen_work;
    void *LAPACKE_dtrsna;
    void *LAPACKE_dtrsna_work;
    void *LAPACKE_dtrsyl;
    void *LAPACKE_dtrsyl_work;
    void *LAPACKE_dtrtri;
    void *LAPACKE_dtrtri_work;
    void *LAPACKE_dtrtrs;
    void *LAPACKE_dtrtrs_work;
    void *LAPACKE_dtrttf;
    void *LAPACKE_dtrttf_work;
    void *LAPACKE_dtrttp;
    void *LAPACKE_dtrttp_work;
    void *LAPACKE_dtzrzf;
    void *LAPACKE_dtzrzf_work;
    void *LAPACKE_get_nancheck;
    void *LAPACKE_ilaver;
    void *LAPACKE_sbbcsd;
    void *LAPACKE_sbbcsd_work;
    void *LAPACKE_sbdsdc;
    void *LAPACKE_sbdsdc_work;
    void *LAPACKE_sbdsqr;
    void *LAPACKE_sbdsqr_work;
    void *LAPACKE_sbdsvdx;
    void *LAPACKE_sbdsvdx_work;
    void *LAPACKE_sdisna;
    void *LAPACKE_sdisna_work;
    void *LAPACKE_set_nancheck;
    void *LAPACKE_sgbbrd;
    void *LAPACKE_sgbbrd_work;
    void *LAPACKE_sgbcon;
    void *LAPACKE_sgbcon_work;
    void *LAPACKE_sgbequ;
    void *LAPACKE_sgbequ_work;
    void *LAPACKE_sgbequb;
    void *LAPACKE_sgbequb_work;
    void *LAPACKE_sgbrfs;
    void *LAPACKE_sgbrfs_work;
    void *LAPACKE_sgbsv;
    void *LAPACKE_sgbsv_work;
    void *LAPACKE_sgbsvx;
    void *LAPACKE_sgbsvx_work;
    void *LAPACKE_sgbtrf;
    void *LAPACKE_sgbtrf_work;
    void *LAPACKE_sgbtrs;
    void *LAPACKE_sgbtrs_work;
    void *LAPACKE_sgebak;
    void *LAPACKE_sgebak_work;
    void *LAPACKE_sgebal;
    void *LAPACKE_sgebal_work;
    void *LAPACKE_sgebrd;
    void *LAPACKE_sgebrd_work;
    void *LAPACKE_sgecon;
    void *LAPACKE_sgecon_work;
    void *LAPACKE_sgeequ;
    void *LAPACKE_sgeequ_work;
    void *LAPACKE_sgeequb;
    void *LAPACKE_sgeequb_work;
    void *LAPACKE_sgees;
    void *LAPACKE_sgees_work;
    void *LAPACKE_sgeesx;
    void *LAPACKE_sgeesx_work;
    void *LAPACKE_sgeev;
    void *LAPACKE_sgeev_work;
    void *LAPACKE_sgeevx;
    void *LAPACKE_sgeevx_work;
    void *LAPACKE_sgehrd;
    void *LAPACKE_sgehrd_work;
    void *LAPACKE_sgejsv;
    void *LAPACKE_sgejsv_work;
    void *LAPACKE_sgelq;
    void *LAPACKE_sgelq2;
    void *LAPACKE_sgelq2_work;
    void *LAPACKE_sgelq_work;
    void *LAPACKE_sgelqf;
    void *LAPACKE_sgelqf_work;
    void *LAPACKE_sgels;
    void *LAPACKE_sgels_work;
    void *LAPACKE_sgelsd;
    void *LAPACKE_sgelsd_work;
    void *LAPACKE_sgelss;
    void *LAPACKE_sgelss_work;
    void *LAPACKE_sgelsy;
    void *LAPACKE_sgelsy_work;
    void *LAPACKE_sgemlq;
    void *LAPACKE_sgemlq_work;
    void *LAPACKE_sgemqr;
    void *LAPACKE_sgemqr_work;
    void *LAPACKE_sgemqrt;
    void *LAPACKE_sgemqrt_work;
    void *LAPACKE_sgeqlf;
    void *LAPACKE_sgeqlf_work;
    void *LAPACKE_sgeqp3;
    void *LAPACKE_sgeqp3_work;
    void *LAPACKE_sgeqpf;
    void *LAPACKE_sgeqpf_work;
    void *LAPACKE_sgeqr;
    void *LAPACKE_sgeqr2;
    void *LAPACKE_sgeqr2_work;
    void *LAPACKE_sgeqr_work;
    void *LAPACKE_sgeqrf;
    void *LAPACKE_sgeqrf_work;
    void *LAPACKE_sgeqrfp;
    void *LAPACKE_sgeqrfp_work;
    void *LAPACKE_sgeqrt;
    void *LAPACKE_sgeqrt2;
    void *LAPACKE_sgeqrt2_work;
    void *LAPACKE_sgeqrt3;
    void *LAPACKE_sgeqrt3_work;
    void *LAPACKE_sgeqrt_work;
    void *LAPACKE_sgerfs;
    void *LAPACKE_sgerfs_work;
    void *LAPACKE_sgerqf;
    void *LAPACKE_sgerqf_work;
    void *LAPACKE_sgesdd;
    void *LAPACKE_sgesdd_work;
    void *LAPACKE_sgesv;
    void *LAPACKE_sgesv_work;
    void *LAPACKE_sgesvd;
    void *LAPACKE_sgesvd_work;
    void *LAPACKE_sgesvdq;
    void *LAPACKE_sgesvdq_work;
    void *LAPACKE_sgesvdx;
    void *LAPACKE_sgesvdx_work;
    void *LAPACKE_sgesvj;
    void *LAPACKE_sgesvj_work;
    void *LAPACKE_sgesvx;
    void *LAPACKE_sgesvx_work;
    void *LAPACKE_sgetf2;
    void *LAPACKE_sgetf2_work;
    void *LAPACKE_sgetrf;
    void *LAPACKE_sgetrf2;
    void *LAPACKE_sgetrf2_work;
    void *LAPACKE_sgetrf_work;
    void *LAPACKE_sgetri;
    void *LAPACKE_sgetri_work;
    void *LAPACKE_sgetrs;
    void *LAPACKE_sgetrs_work;
    void *LAPACKE_sgetsls;
    void *LAPACKE_sgetsls_work;
    void *LAPACKE_sgetsqrhrt;
    void *LAPACKE_sgetsqrhrt_work;
    void *LAPACKE_sggbak;
    void *LAPACKE_sggbak_work;
    void *LAPACKE_sggbal;
    void *LAPACKE_sggbal_work;
    void *LAPACKE_sgges;
    void *LAPACKE_sgges3;
    void *LAPACKE_sgges3_work;
    void *LAPACKE_sgges_work;
    void *LAPACKE_sggesx;
    void *LAPACKE_sggesx_work;
    void *LAPACKE_sggev;
    void *LAPACKE_sggev3;
    void *LAPACKE_sggev3_work;
    void *LAPACKE_sggev_work;
    void *LAPACKE_sggevx;
    void *LAPACKE_sggevx_work;
    void *LAPACKE_sggglm;
    void *LAPACKE_sggglm_work;
    void *LAPACKE_sgghd3;
    void *LAPACKE_sgghd3_work;
    void *LAPACKE_sgghrd;
    void *LAPACKE_sgghrd_work;
    void *LAPACKE_sgglse;
    void *LAPACKE_sgglse_work;
    void *LAPACKE_sggqrf;
    void *LAPACKE_sggqrf_work;
    void *LAPACKE_sggrqf;
    void *LAPACKE_sggrqf_work;
    void *LAPACKE_sggsvd;
    void *LAPACKE_sggsvd3;
    void *LAPACKE_sggsvd3_work;
    void *LAPACKE_sggsvd_work;
    void *LAPACKE_sggsvp;
    void *LAPACKE_sggsvp3;
    void *LAPACKE_sggsvp3_work;
    void *LAPACKE_sggsvp_work;
    void *LAPACKE_sgtcon;
    void *LAPACKE_sgtcon_work;
    void *LAPACKE_sgtrfs;
    void *LAPACKE_sgtrfs_work;
    void *LAPACKE_sgtsv;
    void *LAPACKE_sgtsv_work;
    void *LAPACKE_sgtsvx;
    void *LAPACKE_sgtsvx_work;
    void *LAPACKE_sgttrf;
    void *LAPACKE_sgttrf_work;
    void *LAPACKE_sgttrs;
    void *LAPACKE_sgttrs_work;
    void *LAPACKE_shgeqz;
    void *LAPACKE_shgeqz_work;
    void *LAPACKE_shsein;
    void *LAPACKE_shsein_work;
    void *LAPACKE_shseqr;
    void *LAPACKE_shseqr_work;
    void *LAPACKE_slacn2;
    void *LAPACKE_slacn2_work;
    void *LAPACKE_slacpy;
    void *LAPACKE_slacpy_work;
    void *LAPACKE_slag2d;
    void *LAPACKE_slag2d_work;
    void *LAPACKE_slamch;
    void *LAPACKE_slamch_work;
    void *LAPACKE_slange;
    void *LAPACKE_slange_work;
    void *LAPACKE_slansy;
    void *LAPACKE_slansy_work;
    void *LAPACKE_slantr;
    void *LAPACKE_slantr_work;
    void *LAPACKE_slapmr;
    void *LAPACKE_slapmr_work;
    void *LAPACKE_slapmt;
    void *LAPACKE_slapmt_work;
    void *LAPACKE_slapy2;
    void *LAPACKE_slapy2_work;
    void *LAPACKE_slapy3;
    void *LAPACKE_slapy3_work;
    void *LAPACKE_slarfb;
    void *LAPACKE_slarfb_work;
    void *LAPACKE_slarfg;
    void *LAPACKE_slarfg_work;
    void *LAPACKE_slarft;
    void *LAPACKE_slarft_work;
    void *LAPACKE_slarfx;
    void *LAPACKE_slarfx_work;
    void *LAPACKE_slarnv;
    void *LAPACKE_slarnv_work;
    void *LAPACKE_slartgp;
    void *LAPACKE_slartgp_work;
    void *LAPACKE_slartgs;
    void *LAPACKE_slartgs_work;
    void *LAPACKE_slascl;
    void *LAPACKE_slascl_work;
    void *LAPACKE_slaset;
    void *LAPACKE_slaset_work;
    void *LAPACKE_slasrt;
    void *LAPACKE_slasrt_work;
    void *LAPACKE_slassq;
    void *LAPACKE_slassq_work;
    void *LAPACKE_slaswp;
    void *LAPACKE_slaswp_work;
    void *LAPACKE_slauum;
    void *LAPACKE_slauum_work;
    void *LAPACKE_sopgtr;
    void *LAPACKE_sopgtr_work;
    void *LAPACKE_sopmtr;
    void *LAPACKE_sopmtr_work;
    void *LAPACKE_sorbdb;
    void *LAPACKE_sorbdb_work;
    void *LAPACKE_sorcsd;
    void *LAPACKE_sorcsd2by1;
    void *LAPACKE_sorcsd2by1_work;
    void *LAPACKE_sorcsd_work;
    void *LAPACKE_sorgbr;
    void *LAPACKE_sorgbr_work;
    void *LAPACKE_sorghr;
    void *LAPACKE_sorghr_work;
    void *LAPACKE_sorglq;
    void *LAPACKE_sorglq_work;
    void *LAPACKE_sorgql;
    void *LAPACKE_sorgql_work;
    void *LAPACKE_sorgqr;
    void *LAPACKE_sorgqr_work;
    void *LAPACKE_sorgrq;
    void *LAPACKE_sorgrq_work;
    void *LAPACKE_sorgtr;
    void *LAPACKE_sorgtr_work;
    void *LAPACKE_sorgtsqr_row;
    void *LAPACKE_sorgtsqr_row_work;
    void *LAPACKE_sormbr;
    void *LAPACKE_sormbr_work;
    void *LAPACKE_sormhr;
    void *LAPACKE_sormhr_work;
    void *LAPACKE_sormlq;
    void *LAPACKE_sormlq_work;
    void *LAPACKE_sormql;
    void *LAPACKE_sormql_work;
    void *LAPACKE_sormqr;
    void *LAPACKE_sormqr_work;
    void *LAPACKE_sormrq;
    void *LAPACKE_sormrq_work;
    void *LAPACKE_sormrz;
    void *LAPACKE_sormrz_work;
    void *LAPACKE_sormtr;
    void *LAPACKE_sormtr_work;
    void *LAPACKE_spbcon;
    void *LAPACKE_spbcon_work;
    void *LAPACKE_spbequ;
    void *LAPACKE_spbequ_work;
    void *LAPACKE_spbrfs;
    void *LAPACKE_spbrfs_work;
    void *LAPACKE_spbstf;
    void *LAPACKE_spbstf_work;
    void *LAPACKE_spbsv;
    void *LAPACKE_spbsv_work;
    void *LAPACKE_spbsvx;
    void *LAPACKE_spbsvx_work;
    void *LAPACKE_spbtrf;
    void *LAPACKE_spbtrf_work;
    void *LAPACKE_spbtrs;
    void *LAPACKE_spbtrs_work;
    void *LAPACKE_spftrf;
    void *LAPACKE_spftrf_work;
    void *LAPACKE_spftri;
    void *LAPACKE_spftri_work;
    void *LAPACKE_spftrs;
    void *LAPACKE_spftrs_work;
    void *LAPACKE_spocon;
    void *LAPACKE_spocon_work;
    void *LAPACKE_spoequ;
    void *LAPACKE_spoequ_work;
    void *LAPACKE_spoequb;
    void *LAPACKE_spoequb_work;
    void *LAPACKE_sporfs;
    void *LAPACKE_sporfs_work;
    void *LAPACKE_sposv;
    void *LAPACKE_sposv_work;
    void *LAPACKE_sposvx;
    void *LAPACKE_sposvx_work;
    void *LAPACKE_spotrf;
    void *LAPACKE_spotrf2;
    void *LAPACKE_spotrf2_work;
    void *LAPACKE_spotrf_work;
    void *LAPACKE_spotri;
    void *LAPACKE_spotri_work;
    void *LAPACKE_spotrs;
    void *LAPACKE_spotrs_work;
    void *LAPACKE_sppcon;
    void *LAPACKE_sppcon_work;
    void *LAPACKE_sppequ;
    void *LAPACKE_sppequ_work;
    void *LAPACKE_spprfs;
    void *LAPACKE_spprfs_work;
    void *LAPACKE_sppsv;
    void *LAPACKE_sppsv_work;
    void *LAPACKE_sppsvx;
    void *LAPACKE_sppsvx_work;
    void *LAPACKE_spptrf;
    void *LAPACKE_spptrf_work;
    void *LAPACKE_spptri;
    void *LAPACKE_spptri_work;
    void *LAPACKE_spptrs;
    void *LAPACKE_spptrs_work;
    void *LAPACKE_spstrf;
    void *LAPACKE_spstrf_work;
    void *LAPACKE_sptcon;
    void *LAPACKE_sptcon_work;
    void *LAPACKE_spteqr;
    void *LAPACKE_spteqr_work;
    void *LAPACKE_sptrfs;
    void *LAPACKE_sptrfs_work;
    void *LAPACKE_sptsv;
    void *LAPACKE_sptsv_work;
    void *LAPACKE_sptsvx;
    void *LAPACKE_sptsvx_work;
    void *LAPACKE_spttrf;
    void *LAPACKE_spttrf_work;
    void *LAPACKE_spttrs;
    void *LAPACKE_spttrs_work;
    void *LAPACKE_ssbev;
    void *LAPACKE_ssbev_2stage;
    void *LAPACKE_ssbev_2stage_work;
    void *LAPACKE_ssbev_work;
    void *LAPACKE_ssbevd;
    void *LAPACKE_ssbevd_2stage;
    void *LAPACKE_ssbevd_2stage_work;
    void *LAPACKE_ssbevd_work;
    void *LAPACKE_ssbevx;
    void *LAPACKE_ssbevx_2stage;
    void *LAPACKE_ssbevx_2stage_work;
    void *LAPACKE_ssbevx_work;
    void *LAPACKE_ssbgst;
    void *LAPACKE_ssbgst_work;
    void *LAPACKE_ssbgv;
    void *LAPACKE_ssbgv_work;
    void *LAPACKE_ssbgvd;
    void *LAPACKE_ssbgvd_work;
    void *LAPACKE_ssbgvx;
    void *LAPACKE_ssbgvx_work;
    void *LAPACKE_ssbtrd;
    void *LAPACKE_ssbtrd_work;
    void *LAPACKE_ssfrk;
    void *LAPACKE_ssfrk_work;
    void *LAPACKE_sspcon;
    void *LAPACKE_sspcon_work;
    void *LAPACKE_sspev;
    void *LAPACKE_sspev_work;
    void *LAPACKE_sspevd;
    void *LAPACKE_sspevd_work;
    void *LAPACKE_sspevx;
    void *LAPACKE_sspevx_work;
    void *LAPACKE_sspgst;
    void *LAPACKE_sspgst_work;
    void *LAPACKE_sspgv;
    void *LAPACKE_sspgv_work;
    void *LAPACKE_sspgvd;
    void *LAPACKE_sspgvd_work;
    void *LAPACKE_sspgvx;
    void *LAPACKE_sspgvx_work;
    void *LAPACKE_ssprfs;
    void *LAPACKE_ssprfs_work;
    void *LAPACKE_sspsv;
    void *LAPACKE_sspsv_work;
    void *LAPACKE_sspsvx;
    void *LAPACKE_sspsvx_work;
    void *LAPACKE_ssptrd;
    void *LAPACKE_ssptrd_work;
    void *LAPACKE_ssptrf;
    void *LAPACKE_ssptrf_work;
    void *LAPACKE_ssptri;
    void *LAPACKE_ssptri_work;
    void *LAPACKE_ssptrs;
    void *LAPACKE_ssptrs_work;
    void *LAPACKE_sstebz;
    void *LAPACKE_sstebz_work;
    void *LAPACKE_sstedc;
    void *LAPACKE_sstedc_work;
    void *LAPACKE_sstegr;
    void *LAPACKE_sstegr_work;
    void *LAPACKE_sstein;
    void *LAPACKE_sstein_work;
    void *LAPACKE_sstemr;
    void *LAPACKE_sstemr_work;
    void *LAPACKE_ssteqr;
    void *LAPACKE_ssteqr_work;
    void *LAPACKE_ssterf;
    void *LAPACKE_ssterf_work;
    void *LAPACKE_sstev;
    void *LAPACKE_sstev_work;
    void *LAPACKE_sstevd;
    void *LAPACKE_sstevd_work;
    void *LAPACKE_sstevr;
    void *LAPACKE_sstevr_work;
    void *LAPACKE_sstevx;
    void *LAPACKE_sstevx_work;
    void *LAPACKE_ssycon;
    void *LAPACKE_ssycon_3;
    void *LAPACKE_ssycon_3_work;
    void *LAPACKE_ssycon_work;
    void *LAPACKE_ssyconv;
    void *LAPACKE_ssyconv_work;
    void *LAPACKE_ssyequb;
    void *LAPACKE_ssyequb_work;
    void *LAPACKE_ssyev;
    void *LAPACKE_ssyev_2stage;
    void *LAPACKE_ssyev_2stage_work;
    void *LAPACKE_ssyev_work;
    void *LAPACKE_ssyevd;
    void *LAPACKE_ssyevd_2stage;
    void *LAPACKE_ssyevd_2stage_work;
    void *LAPACKE_ssyevd_work;
    void *LAPACKE_ssyevr;
    void *LAPACKE_ssyevr_2stage;
    void *LAPACKE_ssyevr_2stage_work;
    void *LAPACKE_ssyevr_work;
    void *LAPACKE_ssyevx;
    void *LAPACKE_ssyevx_2stage;
    void *LAPACKE_ssyevx_2stage_work;
    void *LAPACKE_ssyevx_work;
    void *LAPACKE_ssygst;
    void *LAPACKE_ssygst_work;
    void *LAPACKE_ssygv;
    void *LAPACKE_ssygv_2stage;
    void *LAPACKE_ssygv_2stage_work;
    void *LAPACKE_ssygv_work;
    void *LAPACKE_ssygvd;
    void *LAPACKE_ssygvd_work;
    void *LAPACKE_ssygvx;
    void *LAPACKE_ssygvx_work;
    void *LAPACKE_ssyrfs;
    void *LAPACKE_ssyrfs_work;
    void *LAPACKE_ssysv;
    void *LAPACKE_ssysv_aa;
    void *LAPACKE_ssysv_aa_2stage;
    void *LAPACKE_ssysv_aa_2stage_work;
    void *LAPACKE_ssysv_aa_work;
    void *LAPACKE_ssysv_rk;
    void *LAPACKE_ssysv_rk_work;
    void *LAPACKE_ssysv_rook;
    void *LAPACKE_ssysv_rook_work;
    void *LAPACKE_ssysv_work;
    void *LAPACKE_ssysvx;
    void *LAPACKE_ssysvx_work;
    void *LAPACKE_ssyswapr;
    void *LAPACKE_ssyswapr_work;
    void *LAPACKE_ssytrd;
    void *LAPACKE_ssytrd_work;
    void *LAPACKE_ssytrf;
    void *LAPACKE_ssytrf_aa;
    void *LAPACKE_ssytrf_aa_2stage;
    void *LAPACKE_ssytrf_aa_2stage_work;
    void *LAPACKE_ssytrf_aa_work;
    void *LAPACKE_ssytrf_rk;
    void *LAPACKE_ssytrf_rk_work;
    void *LAPACKE_ssytrf_rook;
    void *LAPACKE_ssytrf_rook_work;
    void *LAPACKE_ssytrf_work;
    void *LAPACKE_ssytri;
    void *LAPACKE_ssytri2;
    void *LAPACKE_ssytri2_work;
    void *LAPACKE_ssytri2x;
    void *LAPACKE_ssytri2x_work;
    void *LAPACKE_ssytri_3;
    void *LAPACKE_ssytri_3_work;
    void *LAPACKE_ssytri_work;
    void *LAPACKE_ssytrs;
    void *LAPACKE_ssytrs2;
    void *LAPACKE_ssytrs2_work;
    void *LAPACKE_ssytrs_3;
    void *LAPACKE_ssytrs_3_work;
    void *LAPACKE_ssytrs_aa;
    void *LAPACKE_ssytrs_aa_2stage;
    void *LAPACKE_ssytrs_aa_2stage_work;
    void *LAPACKE_ssytrs_aa_work;
    void *LAPACKE_ssytrs_rook;
    void *LAPACKE_ssytrs_rook_work;
    void *LAPACKE_ssytrs_work;
    void *LAPACKE_stbcon;
    void *LAPACKE_stbcon_work;
    void *LAPACKE_stbrfs;
    void *LAPACKE_stbrfs_work;
    void *LAPACKE_stbtrs;
    void *LAPACKE_stbtrs_work;
    void *LAPACKE_stfsm;
    void *LAPACKE_stfsm_work;
    void *LAPACKE_stftri;
    void *LAPACKE_stftri_work;
    void *LAPACKE_stfttp;
    void *LAPACKE_stfttp_work;
    void *LAPACKE_stfttr;
    void *LAPACKE_stfttr_work;
    void *LAPACKE_stgevc;
    void *LAPACKE_stgevc_work;
    void *LAPACKE_stgexc;
    void *LAPACKE_stgexc_work;
    void *LAPACKE_stgsen;
    void *LAPACKE_stgsen_work;
    void *LAPACKE_stgsja;
    void *LAPACKE_stgsja_work;
    void *LAPACKE_stgsna;
    void *LAPACKE_stgsna_work;
    void *LAPACKE_stgsyl;
    void *LAPACKE_stgsyl_work;
    void *LAPACKE_stpcon;
    void *LAPACKE_stpcon_work;
    void *LAPACKE_stpmqrt;
    void *LAPACKE_stpmqrt_work;
    void *LAPACKE_stpqrt;
    void *LAPACKE_stpqrt2;
    void *LAPACKE_stpqrt2_work;
    void *LAPACKE_stpqrt_work;
    void *LAPACKE_stprfb;
    void *LAPACKE_stprfb_work;
    void *LAPACKE_stprfs;
    void *LAPACKE_stprfs_work;
    void *LAPACKE_stptri;
    void *LAPACKE_stptri_work;
    void *LAPACKE_stptrs;
    void *LAPACKE_stptrs_work;
    void *LAPACKE_stpttf;
    void *LAPACKE_stpttf_work;
    void *LAPACKE_stpttr;
    void *LAPACKE_stpttr_work;
    void *LAPACKE_strcon;
    void *LAPACKE_strcon_work;
    void *LAPACKE_strevc;
    void *LAPACKE_strevc_work;
    void *LAPACKE_strexc;
    void *LAPACKE_strexc_work;
    void *LAPACKE_strrfs;
    void *LAPACKE_strrfs_work;
    void *LAPACKE_strsen;
    void *LAPACKE_strsen_work;
    void *LAPACKE_strsna;
    void *LAPACKE_strsna_work;
    void *LAPACKE_strsyl;
    void *LAPACKE_strsyl_work;
    void *LAPACKE_strtri;
    void *LAPACKE_strtri_work;
    void *LAPACKE_strtrs;
    void *LAPACKE_strtrs_work;
    void *LAPACKE_strttf;
    void *LAPACKE_strttf_work;
    void *LAPACKE_strttp;
    void *LAPACKE_strttp_work;
    void *LAPACKE_stzrzf;
    void *LAPACKE_stzrzf_work;
    void *LAPACKE_zbbcsd;
    void *LAPACKE_zbbcsd_work;
    void *LAPACKE_zbdsqr;
    void *LAPACKE_zbdsqr_work;
    void *LAPACKE_zcgesv;
    void *LAPACKE_zcgesv_work;
    void *LAPACKE_zcposv;
    void *LAPACKE_zcposv_work;
    void *LAPACKE_zgbbrd;
    void *LAPACKE_zgbbrd_work;
    void *LAPACKE_zgbcon;
    void *LAPACKE_zgbcon_work;
    void *LAPACKE_zgbequ;
    void *LAPACKE_zgbequ_work;
    void *LAPACKE_zgbequb;
    void *LAPACKE_zgbequb_work;
    void *LAPACKE_zgbrfs;
    void *LAPACKE_zgbrfs_work;
    void *LAPACKE_zgbsv;
    void *LAPACKE_zgbsv_work;
    void *LAPACKE_zgbsvx;
    void *LAPACKE_zgbsvx_work;
    void *LAPACKE_zgbtrf;
    void *LAPACKE_zgbtrf_work;
    void *LAPACKE_zgbtrs;
    void *LAPACKE_zgbtrs_work;
    void *LAPACKE_zgebak;
    void *LAPACKE_zgebak_work;
    void *LAPACKE_zgebal;
    void *LAPACKE_zgebal_work;
    void *LAPACKE_zgebrd;
    void *LAPACKE_zgebrd_work;
    void *LAPACKE_zgecon;
    void *LAPACKE_zgecon_work;
    void *LAPACKE_zgeequ;
    void *LAPACKE_zgeequ_work;
    void *LAPACKE_zgeequb;
    void *LAPACKE_zgeequb_work;
    void *LAPACKE_zgees;
    void *LAPACKE_zgees_work;
    void *LAPACKE_zgeesx;
    void *LAPACKE_zgeesx_work;
    void *LAPACKE_zgeev;
    void *LAPACKE_zgeev_work;
    void *LAPACKE_zgeevx;
    void *LAPACKE_zgeevx_work;
    void *LAPACKE_zgehrd;
    void *LAPACKE_zgehrd_work;
    void *LAPACKE_zgejsv;
    void *LAPACKE_zgejsv_work;
    void *LAPACKE_zgelq;
    void *LAPACKE_zgelq2;
    void *LAPACKE_zgelq2_work;
    void *LAPACKE_zgelq_work;
    void *LAPACKE_zgelqf;
    void *LAPACKE_zgelqf_work;
    void *LAPACKE_zgels;
    void *LAPACKE_zgels_work;
    void *LAPACKE_zgelsd;
    void *LAPACKE_zgelsd_work;
    void *LAPACKE_zgelss;
    void *LAPACKE_zgelss_work;
    void *LAPACKE_zgelsy;
    void *LAPACKE_zgelsy_work;
    void *LAPACKE_zgemlq;
    void *LAPACKE_zgemlq_work;
    void *LAPACKE_zgemqr;
    void *LAPACKE_zgemqr_work;
    void *LAPACKE_zgemqrt;
    void *LAPACKE_zgemqrt_work;
    void *LAPACKE_zgeqlf;
    void *LAPACKE_zgeqlf_work;
    void *LAPACKE_zgeqp3;
    void *LAPACKE_zgeqp3_work;
    void *LAPACKE_zgeqpf;
    void *LAPACKE_zgeqpf_work;
    void *LAPACKE_zgeqr;
    void *LAPACKE_zgeqr2;
    void *LAPACKE_zgeqr2_work;
    void *LAPACKE_zgeqr_work;
    void *LAPACKE_zgeqrf;
    void *LAPACKE_zgeqrf_work;
    void *LAPACKE_zgeqrfp;
    void *LAPACKE_zgeqrfp_work;
    void *LAPACKE_zgeqrt;
    void *LAPACKE_zgeqrt2;
    void *LAPACKE_zgeqrt2_work;
    void *LAPACKE_zgeqrt3;
    void *LAPACKE_zgeqrt3_work;
    void *LAPACKE_zgeqrt_work;
    void *LAPACKE_zgerfs;
    void *LAPACKE_zgerfs_work;
    void *LAPACKE_zgerqf;
    void *LAPACKE_zgerqf_work;
    void *LAPACKE_zgesdd;
    void *LAPACKE_zgesdd_work;
    void *LAPACKE_zgesv;
    void *LAPACKE_zgesv_work;
    void *LAPACKE_zgesvd;
    void *LAPACKE_zgesvd_work;
    void *LAPACKE_zgesvdq;
    void *LAPACKE_zgesvdq_work;
    void *LAPACKE_zgesvdx;
    void *LAPACKE_zgesvdx_work;
    void *LAPACKE_zgesvj;
    void *LAPACKE_zgesvj_work;
    void *LAPACKE_zgesvx;
    void *LAPACKE_zgesvx_work;
    void *LAPACKE_zgetf2;
    void *LAPACKE_zgetf2_work;
    void *LAPACKE_zgetrf;
    void *LAPACKE_zgetrf2;
    void *LAPACKE_zgetrf2_work;
    void *LAPACKE_zgetrf_work;
    void *LAPACKE_zgetri;
    void *LAPACKE_zgetri_work;
    void *LAPACKE_zgetrs;
    void *LAPACKE_zgetrs_work;
    void *LAPACKE_zgetsls;
    void *LAPACKE_zgetsls_work;
    void *LAPACKE_zgetsqrhrt;
    void *LAPACKE_zgetsqrhrt_work;
    void *LAPACKE_zggbak;
    void *LAPACKE_zggbak_work;
    void *LAPACKE_zggbal;
    void *LAPACKE_zggbal_work;
    void *LAPACKE_zgges;
    void *LAPACKE_zgges3;
    void *LAPACKE_zgges3_work;
    void *LAPACKE_zgges_work;
    void *LAPACKE_zggesx;
    void *LAPACKE_zggesx_work;
    void *LAPACKE_zggev;
    void *LAPACKE_zggev3;
    void *LAPACKE_zggev3_work;
    void *LAPACKE_zggev_work;
    void *LAPACKE_zggevx;
    void *LAPACKE_zggevx_work;
    void *LAPACKE_zggglm;
    void *LAPACKE_zggglm_work;
    void *LAPACKE_zgghd3;
    void *LAPACKE_zgghd3_work;
    void *LAPACKE_zgghrd;
    void *LAPACKE_zgghrd_work;
    void *LAPACKE_zgglse;
    void *LAPACKE_zgglse_work;
    void *LAPACKE_zggqrf;
    void *LAPACKE_zggqrf_work;
    void *LAPACKE_zggrqf;
    void *LAPACKE_zggrqf_work;
    void *LAPACKE_zggsvd;
    void *LAPACKE_zggsvd3;
    void *LAPACKE_zggsvd3_work;
    void *LAPACKE_zggsvd_work;
    void *LAPACKE_zggsvp;
    void *LAPACKE_zggsvp3;
    void *LAPACKE_zggsvp3_work;
    void *LAPACKE_zggsvp_work;
    void *LAPACKE_zgtcon;
    void *LAPACKE_zgtcon_work;
    void *LAPACKE_zgtrfs;
    void *LAPACKE_zgtrfs_work;
    void *LAPACKE_zgtsv;
    void *LAPACKE_zgtsv_work;
    void *LAPACKE_zgtsvx;
    void *LAPACKE_zgtsvx_work;
    void *LAPACKE_zgttrf;
    void *LAPACKE_zgttrf_work;
    void *LAPACKE_zgttrs;
    void *LAPACKE_zgttrs_work;
    void *LAPACKE_zhbev;
    void *LAPACKE_zhbev_2stage;
    void *LAPACKE_zhbev_2stage_work;
    void *LAPACKE_zhbev_work;
    void *LAPACKE_zhbevd;
    void *LAPACKE_zhbevd_2stage;
    void *LAPACKE_zhbevd_2stage_work;
    void *LAPACKE_zhbevd_work;
    void *LAPACKE_zhbevx;
    void *LAPACKE_zhbevx_2stage;
    void *LAPACKE_zhbevx_2stage_work;
    void *LAPACKE_zhbevx_work;
    void *LAPACKE_zhbgst;
    void *LAPACKE_zhbgst_work;
    void *LAPACKE_zhbgv;
    void *LAPACKE_zhbgv_work;
    void *LAPACKE_zhbgvd;
    void *LAPACKE_zhbgvd_work;
    void *LAPACKE_zhbgvx;
    void *LAPACKE_zhbgvx_work;
    void *LAPACKE_zhbtrd;
    void *LAPACKE_zhbtrd_work;
    void *LAPACKE_zhecon;
    void *LAPACKE_zhecon_3;
    void *LAPACKE_zhecon_3_work;
    void *LAPACKE_zhecon_work;
    void *LAPACKE_zheequb;
    void *LAPACKE_zheequb_work;
    void *LAPACKE_zheev;
    void *LAPACKE_zheev_2stage;
    void *LAPACKE_zheev_2stage_work;
    void *LAPACKE_zheev_work;
    void *LAPACKE_zheevd;
    void *LAPACKE_zheevd_2stage;
    void *LAPACKE_zheevd_2stage_work;
    void *LAPACKE_zheevd_work;
    void *LAPACKE_zheevr;
    void *LAPACKE_zheevr_2stage;
    void *LAPACKE_zheevr_2stage_work;
    void *LAPACKE_zheevr_work;
    void *LAPACKE_zheevx;
    void *LAPACKE_zheevx_2stage;
    void *LAPACKE_zheevx_2stage_work;
    void *LAPACKE_zheevx_work;
    void *LAPACKE_zhegst;
    void *LAPACKE_zhegst_work;
    void *LAPACKE_zhegv;
    void *LAPACKE_zhegv_2stage;
    void *LAPACKE_zhegv_2stage_work;
    void *LAPACKE_zhegv_work;
    void *LAPACKE_zhegvd;
    void *LAPACKE_zhegvd_work;
    void *LAPACKE_zhegvx;
    void *LAPACKE_zhegvx_work;
    void *LAPACKE_zherfs;
    void *LAPACKE_zherfs_work;
    void *LAPACKE_zhesv;
    void *LAPACKE_zhesv_aa;
    void *LAPACKE_zhesv_aa_2stage;
    void *LAPACKE_zhesv_aa_2stage_work;
    void *LAPACKE_zhesv_aa_work;
    void *LAPACKE_zhesv_rk;
    void *LAPACKE_zhesv_rk_work;
    void *LAPACKE_zhesv_work;
    void *LAPACKE_zhesvx;
    void *LAPACKE_zhesvx_work;
    void *LAPACKE_zheswapr;
    void *LAPACKE_zheswapr_work;
    void *LAPACKE_zhetrd;
    void *LAPACKE_zhetrd_work;
    void *LAPACKE_zhetrf;
    void *LAPACKE_zhetrf_aa;
    void *LAPACKE_zhetrf_aa_2stage;
    void *LAPACKE_zhetrf_aa_2stage_work;
    void *LAPACKE_zhetrf_aa_work;
    void *LAPACKE_zhetrf_rk;
    void *LAPACKE_zhetrf_rk_work;
    void *LAPACKE_zhetrf_rook;
    void *LAPACKE_zhetrf_rook_work;
    void *LAPACKE_zhetrf_work;
    void *LAPACKE_zhetri;
    void *LAPACKE_zhetri2;
    void *LAPACKE_zhetri2_work;
    void *LAPACKE_zhetri2x;
    void *LAPACKE_zhetri2x_work;
    void *LAPACKE_zhetri_3;
    void *LAPACKE_zhetri_3_work;
    void *LAPACKE_zhetri_work;
    void *LAPACKE_zhetrs;
    void *LAPACKE_zhetrs2;
    void *LAPACKE_zhetrs2_work;
    void *LAPACKE_zhetrs_3;
    void *LAPACKE_zhetrs_3_work;
    void *LAPACKE_zhetrs_aa;
    void *LAPACKE_zhetrs_aa_2stage;
    void *LAPACKE_zhetrs_aa_2stage_work;
    void *LAPACKE_zhetrs_aa_work;
    void *LAPACKE_zhetrs_rook;
    void *LAPACKE_zhetrs_rook_work;
    void *LAPACKE_zhetrs_work;
    void *LAPACKE_zhfrk;
    void *LAPACKE_zhfrk_work;
    void *LAPACKE_zhgeqz;
    void *LAPACKE_zhgeqz_work;
    void *LAPACKE_zhpcon;
    void *LAPACKE_zhpcon_work;
    void *LAPACKE_zhpev;
    void *LAPACKE_zhpev_work;
    void *LAPACKE_zhpevd;
    void *LAPACKE_zhpevd_work;
    void *LAPACKE_zhpevx;
    void *LAPACKE_zhpevx_work;
    void *LAPACKE_zhpgst;
    void *LAPACKE_zhpgst_work;
    void *LAPACKE_zhpgv;
    void *LAPACKE_zhpgv_work;
    void *LAPACKE_zhpgvd;
    void *LAPACKE_zhpgvd_work;
    void *LAPACKE_zhpgvx;
    void *LAPACKE_zhpgvx_work;
    void *LAPACKE_zhprfs;
    void *LAPACKE_zhprfs_work;
    void *LAPACKE_zhpsv;
    void *LAPACKE_zhpsv_work;
    void *LAPACKE_zhpsvx;
    void *LAPACKE_zhpsvx_work;
    void *LAPACKE_zhptrd;
    void *LAPACKE_zhptrd_work;
    void *LAPACKE_zhptrf;
    void *LAPACKE_zhptrf_work;
    void *LAPACKE_zhptri;
    void *LAPACKE_zhptri_work;
    void *LAPACKE_zhptrs;
    void *LAPACKE_zhptrs_work;
    void *LAPACKE_zhsein;
    void *LAPACKE_zhsein_work;
    void *LAPACKE_zhseqr;
    void *LAPACKE_zhseqr_work;
    void *LAPACKE_zlacgv;
    void *LAPACKE_zlacgv_work;
    void *LAPACKE_zlacn2;
    void *LAPACKE_zlacn2_work;
    void *LAPACKE_zlacp2;
    void *LAPACKE_zlacp2_work;
    void *LAPACKE_zlacpy;
    void *LAPACKE_zlacpy_work;
    void *LAPACKE_zlacrm;
    void *LAPACKE_zlacrm_work;
    void *LAPACKE_zlag2c;
    void *LAPACKE_zlag2c_work;
    void *LAPACKE_zlange;
    void *LAPACKE_zlange_work;
    void *LAPACKE_zlanhe;
    void *LAPACKE_zlanhe_work;
    void *LAPACKE_zlansy;
    void *LAPACKE_zlansy_work;
    void *LAPACKE_zlantr;
    void *LAPACKE_zlantr_work;
    void *LAPACKE_zlapmr;
    void *LAPACKE_zlapmr_work;
    void *LAPACKE_zlapmt;
    void *LAPACKE_zlapmt_work;
    void *LAPACKE_zlarcm;
    void *LAPACKE_zlarcm_work;
    void *LAPACKE_zlarfb;
    void *LAPACKE_zlarfb_work;
    void *LAPACKE_zlarfg;
    void *LAPACKE_zlarfg_work;
    void *LAPACKE_zlarft;
    void *LAPACKE_zlarft_work;
    void *LAPACKE_zlarfx;
    void *LAPACKE_zlarfx_work;
    void *LAPACKE_zlarnv;
    void *LAPACKE_zlarnv_work;
    void *LAPACKE_zlascl;
    void *LAPACKE_zlascl_work;
    void *LAPACKE_zlaset;
    void *LAPACKE_zlaset_work;
    void *LAPACKE_zlassq;
    void *LAPACKE_zlassq_work;
    void *LAPACKE_zlaswp;
    void *LAPACKE_zlaswp_work;
    void *LAPACKE_zlauum;
    void *LAPACKE_zlauum_work;
    void *LAPACKE_zpbcon;
    void *LAPACKE_zpbcon_work;
    void *LAPACKE_zpbequ;
    void *LAPACKE_zpbequ_work;
    void *LAPACKE_zpbrfs;
    void *LAPACKE_zpbrfs_work;
    void *LAPACKE_zpbstf;
    void *LAPACKE_zpbstf_work;
    void *LAPACKE_zpbsv;
    void *LAPACKE_zpbsv_work;
    void *LAPACKE_zpbsvx;
    void *LAPACKE_zpbsvx_work;
    void *LAPACKE_zpbtrf;
    void *LAPACKE_zpbtrf_work;
    void *LAPACKE_zpbtrs;
    void *LAPACKE_zpbtrs_work;
    void *LAPACKE_zpftrf;
    void *LAPACKE_zpftrf_work;
    void *LAPACKE_zpftri;
    void *LAPACKE_zpftri_work;
    void *LAPACKE_zpftrs;
    void *LAPACKE_zpftrs_work;
    void *LAPACKE_zpocon;
    void *LAPACKE_zpocon_work;
    void *LAPACKE_zpoequ;
    void *LAPACKE_zpoequ_work;
    void *LAPACKE_zpoequb;
    void *LAPACKE_zpoequb_work;
    void *LAPACKE_zporfs;
    void *LAPACKE_zporfs_work;
    void *LAPACKE_zposv;
    void *LAPACKE_zposv_work;
    void *LAPACKE_zposvx;
    void *LAPACKE_zposvx_work;
    void *LAPACKE_zpotrf;
    void *LAPACKE_zpotrf2;
    void *LAPACKE_zpotrf2_work;
    void *LAPACKE_zpotrf_work;
    void *LAPACKE_zpotri;
    void *LAPACKE_zpotri_work;
    void *LAPACKE_zpotrs;
    void *LAPACKE_zpotrs_work;
    void *LAPACKE_zppcon;
    void *LAPACKE_zppcon_work;
    void *LAPACKE_zppequ;
    void *LAPACKE_zppequ_work;
    void *LAPACKE_zpprfs;
    void *LAPACKE_zpprfs_work;
    void *LAPACKE_zppsv;
    void *LAPACKE_zppsv_work;
    void *LAPACKE_zppsvx;
    void *LAPACKE_zppsvx_work;
    void *LAPACKE_zpptrf;
    void *LAPACKE_zpptrf_work;
    void *LAPACKE_zpptri;
    void *LAPACKE_zpptri_work;
    void *LAPACKE_zpptrs;
    void *LAPACKE_zpptrs_work;
    void *LAPACKE_zpstrf;
    void *LAPACKE_zpstrf_work;
    void *LAPACKE_zptcon;
    void *LAPACKE_zptcon_work;
    void *LAPACKE_zpteqr;
    void *LAPACKE_zpteqr_work;
    void *LAPACKE_zptrfs;
    void *LAPACKE_zptrfs_work;
    void *LAPACKE_zptsv;
    void *LAPACKE_zptsv_work;
    void *LAPACKE_zptsvx;
    void *LAPACKE_zptsvx_work;
    void *LAPACKE_zpttrf;
    void *LAPACKE_zpttrf_work;
    void *LAPACKE_zpttrs;
    void *LAPACKE_zpttrs_work;
    void *LAPACKE_zspcon;
    void *LAPACKE_zspcon_work;
    void *LAPACKE_zsprfs;
    void *LAPACKE_zsprfs_work;
    void *LAPACKE_zspsv;
    void *LAPACKE_zspsv_work;
    void *LAPACKE_zspsvx;
    void *LAPACKE_zspsvx_work;
    void *LAPACKE_zsptrf;
    void *LAPACKE_zsptrf_work;
    void *LAPACKE_zsptri;
    void *LAPACKE_zsptri_work;
    void *LAPACKE_zsptrs;
    void *LAPACKE_zsptrs_work;
    void *LAPACKE_zstedc;
    void *LAPACKE_zstedc_work;
    void *LAPACKE_zstegr;
    void *LAPACKE_zstegr_work;
    void *LAPACKE_zstein;
    void *LAPACKE_zstein_work;
    void *LAPACKE_zstemr;
    void *LAPACKE_zstemr_work;
    void *LAPACKE_zsteqr;
    void *LAPACKE_zsteqr_work;
    void *LAPACKE_zsycon;
    void *LAPACKE_zsycon_3;
    void *LAPACKE_zsycon_3_work;
    void *LAPACKE_zsycon_work;
    void *LAPACKE_zsyconv;
    void *LAPACKE_zsyconv_work;
    void *LAPACKE_zsyequb;
    void *LAPACKE_zsyequb_work;
    void *LAPACKE_zsyr;
    void *LAPACKE_zsyr_work;
    void *LAPACKE_zsyrfs;
    void *LAPACKE_zsyrfs_work;
    void *LAPACKE_zsysv;
    void *LAPACKE_zsysv_aa;
    void *LAPACKE_zsysv_aa_2stage;
    void *LAPACKE_zsysv_aa_2stage_work;
    void *LAPACKE_zsysv_aa_work;
    void *LAPACKE_zsysv_rk;
    void *LAPACKE_zsysv_rk_work;
    void *LAPACKE_zsysv_rook;
    void *LAPACKE_zsysv_rook_work;
    void *LAPACKE_zsysv_work;
    void *LAPACKE_zsysvx;
    void *LAPACKE_zsysvx_work;
    void *LAPACKE_zsyswapr;
    void *LAPACKE_zsyswapr_work;
    void *LAPACKE_zsytrf;
    void *LAPACKE_zsytrf_aa;
    void *LAPACKE_zsytrf_aa_2stage;
    void *LAPACKE_zsytrf_aa_2stage_work;
    void *LAPACKE_zsytrf_aa_work;
    void *LAPACKE_zsytrf_rk;
    void *LAPACKE_zsytrf_rk_work;
    void *LAPACKE_zsytrf_rook;
    void *LAPACKE_zsytrf_rook_work;
    void *LAPACKE_zsytrf_work;
    void *LAPACKE_zsytri;
    void *LAPACKE_zsytri2;
    void *LAPACKE_zsytri2_work;
    void *LAPACKE_zsytri2x;
    void *LAPACKE_zsytri2x_work;
    void *LAPACKE_zsytri_3;
    void *LAPACKE_zsytri_3_work;
    void *LAPACKE_zsytri_work;
    void *LAPACKE_zsytrs;
    void *LAPACKE_zsytrs2;
    void *LAPACKE_zsytrs2_work;
    void *LAPACKE_zsytrs_3;
    void *LAPACKE_zsytrs_3_work;
    void *LAPACKE_zsytrs_aa;
    void *LAPACKE_zsytrs_aa_2stage;
    void *LAPACKE_zsytrs_aa_2stage_work;
    void *LAPACKE_zsytrs_aa_work;
    void *LAPACKE_zsytrs_rook;
    void *LAPACKE_zsytrs_rook_work;
    void *LAPACKE_zsytrs_work;
    void *LAPACKE_ztbcon;
    void *LAPACKE_ztbcon_work;
    void *LAPACKE_ztbrfs;
    void *LAPACKE_ztbrfs_work;
    void *LAPACKE_ztbtrs;
    void *LAPACKE_ztbtrs_work;
    void *LAPACKE_ztfsm;
    void *LAPACKE_ztfsm_work;
    void *LAPACKE_ztftri;
    void *LAPACKE_ztftri_work;
    void *LAPACKE_ztfttp;
    void *LAPACKE_ztfttp_work;
    void *LAPACKE_ztfttr;
    void *LAPACKE_ztfttr_work;
    void *LAPACKE_ztgevc;
    void *LAPACKE_ztgevc_work;
    void *LAPACKE_ztgexc;
    void *LAPACKE_ztgexc_work;
    void *LAPACKE_ztgsen;
    void *LAPACKE_ztgsen_work;
    void *LAPACKE_ztgsja;
    void *LAPACKE_ztgsja_work;
    void *LAPACKE_ztgsna;
    void *LAPACKE_ztgsna_work;
    void *LAPACKE_ztgsyl;
    void *LAPACKE_ztgsyl_work;
    void *LAPACKE_ztpcon;
    void *LAPACKE_ztpcon_work;
    void *LAPACKE_ztpmqrt;
    void *LAPACKE_ztpmqrt_work;
    void *LAPACKE_ztpqrt;
    void *LAPACKE_ztpqrt2;
    void *LAPACKE_ztpqrt2_work;
    void *LAPACKE_ztpqrt_work;
    void *LAPACKE_ztprfb;
    void *LAPACKE_ztprfb_work;
    void *LAPACKE_ztprfs;
    void *LAPACKE_ztprfs_work;
    void *LAPACKE_ztptri;
    void *LAPACKE_ztptri_work;
    void *LAPACKE_ztptrs;
    void *LAPACKE_ztptrs_work;
    void *LAPACKE_ztpttf;
    void *LAPACKE_ztpttf_work;
    void *LAPACKE_ztpttr;
    void *LAPACKE_ztpttr_work;
    void *LAPACKE_ztrcon;
    void *LAPACKE_ztrcon_work;
    void *LAPACKE_ztrevc;
    void *LAPACKE_ztrevc_work;
    void *LAPACKE_ztrexc;
    void *LAPACKE_ztrexc_work;
    void *LAPACKE_ztrrfs;
    void *LAPACKE_ztrrfs_work;
    void *LAPACKE_ztrsen;
    void *LAPACKE_ztrsen_work;
    void *LAPACKE_ztrsna;
    void *LAPACKE_ztrsna_work;
    void *LAPACKE_ztrsyl;
    void *LAPACKE_ztrsyl_work;
    void *LAPACKE_ztrtri;
    void *LAPACKE_ztrtri_work;
    void *LAPACKE_ztrtrs;
    void *LAPACKE_ztrtrs_work;
    void *LAPACKE_ztrttf;
    void *LAPACKE_ztrttf_work;
    void *LAPACKE_ztrttp;
    void *LAPACKE_ztrttp_work;
    void *LAPACKE_ztzrzf;
    void *LAPACKE_ztzrzf_work;
    void *LAPACKE_zunbdb;
    void *LAPACKE_zunbdb_work;
    void *LAPACKE_zuncsd;
    void *LAPACKE_zuncsd2by1;
    void *LAPACKE_zuncsd2by1_work;
    void *LAPACKE_zuncsd_work;
    void *LAPACKE_zungbr;
    void *LAPACKE_zungbr_work;
    void *LAPACKE_zunghr;
    void *LAPACKE_zunghr_work;
    void *LAPACKE_zunglq;
    void *LAPACKE_zunglq_work;
    void *LAPACKE_zungql;
    void *LAPACKE_zungql_work;
    void *LAPACKE_zungqr;
    void *LAPACKE_zungqr_work;
    void *LAPACKE_zungrq;
    void *LAPACKE_zungrq_work;
    void *LAPACKE_zungtr;
    void *LAPACKE_zungtr_work;
    void *LAPACKE_zungtsqr_row;
    void *LAPACKE_zungtsqr_row_work;
    void *LAPACKE_zunmbr;
    void *LAPACKE_zunmbr_work;
    void *LAPACKE_zunmhr;
    void *LAPACKE_zunmhr_work;
    void *LAPACKE_zunmlq;
    void *LAPACKE_zunmlq_work;
    void *LAPACKE_zunmql;
    void *LAPACKE_zunmql_work;
    void *LAPACKE_zunmqr;
    void *LAPACKE_zunmqr_work;
    void *LAPACKE_zunmrq;
    void *LAPACKE_zunmrq_work;
    void *LAPACKE_zunmrz;
    void *LAPACKE_zunmrz_work;
    void *LAPACKE_zunmtr;
    void *LAPACKE_zunmtr_work;
    void *LAPACKE_zupgtr;
    void *LAPACKE_zupgtr_work;
    void *LAPACKE_zupmtr;
    void *LAPACKE_zupmtr_work;

} flexiblas_lapacke_backend_t;

#ifdef __cplusplus
}
#endif

#endif

