// Copyright 2009 Intel Corporation
// SPDX-License-Identifier: Apache-2.0

#pragma once

#include "sg/Node.h"

namespace ospray {
namespace sg {

struct OSPSG_INTERFACE Camera : public OSPNode<cpp::Camera, NodeType::CAMERA>
{
  Camera(const std::string &type);
  virtual ~Camera() override = default;

  NodeType type() const override;

  virtual void preCommit() override;

  // cameraToWorld is set for scene cameras(for eg: GLTF cameras) only in RenderScene
  affine3f cameraToWorld{one};
  affine3f cameraToWorldEnd{one};
};

} // namespace sg
} // namespace ospray
