#include <stdio.h>

/* ka10_dd_font.c: Font data for Data Disc 6600 Television Display System.

   Copyright (c) 2022-2023, Lars Brinkhoff

   Process this with a C compiler supporting the binary 0b prefix
   to generate the ka10_dd_font.h file included in the emulator.

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   LARS BRINKHOFF BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

   Except as contained in this notice, the name of Lars Brinkhoff shall not be
   used in advertising or otherwise to promote the sale, use or other dealings
   in this Software without prior written authorization from Lars Brinkhoff.
*/

/* Font from http://www.bitsavers.org/pdf/dataDisc/Television_Display_System_Reference_Manual_Jul69.pdf */
static unsigned int tds_font[128][12] = {
  { 0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000 }, // 000
  { 0b00000,
    0b00000,
    0b00000,
    0b00100,
    0b00100,
    0b00100,
    0b00100,
    0b10101,
    0b01110,
    0b00100,
    0b00000,
    0b00000 }, // 001 down arrow
  { 0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000 }, // 002 alpha
  { 0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000 }, // 003 beta
  { 0b00000,
    0b00000,
    0b00000,
    0b00100,
    0b01010,
    0b01010,
    0b10001,
    0b10001,
    0b10001,
    0b10001,
    0b00000,
    0b00000 }, // 004 AND
  { 0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000 }, // 005 NOT
  { 0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b01111,
    0b10001,
    0b01110,
    0b10000,
    0b01111,
    0b00000,
    0b00000 }, // 006 epsilon
  { 0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b11111,
    0b01010,
    0b01010,
    0b01010,
    0b01010,
    0b00000,
    0b00000 }, // 007 pi
  { 0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000 }, // 010 lambda
  { 0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000 }, // 011
  { 0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000 }, // 012
  { 0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000 }, // 013
  { 0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000 }, // 014
  { 0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000 }, // 015
  { 0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b01010,
    0b10101,
    0b10101,
    0b01010,
    0b00000,
    0b00000,
    0b00000 }, // 016 infinity
  { 0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000 }, // 017 partial differential
  { 0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b11110,
    0b00001,
    0b00001,
    0b11110,
    0b00000,
    0b00000,
    0b00000 }, // 020 subset
  { 0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b01111,
    0b10000,
    0b10000,
    0b01111,
    0b00000,
    0b00000,
    0b00000 }, // 021 superset
  { 0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000 }, // 022 intersection
  { 0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000 }, // 023 union
  { 0b00000,
    0b00000,
    0b00000,
    0b10001,
    0b10001,
    0b11111,
    0b10001,
    0b01010,
    0b01010,
    0b00100,
    0b00000,
    0b00000 }, // 024 for all
  { 0b00000,
    0b00000,
    0b00000,
    0b11111,
    0b00001,
    0b00001,
    0b01111,
    0b00001,
    0b00001,
    0b11111,
    0b00000,
    0b00000 }, // 025 there exists
  { 0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b01110,
    0b11011,
    0b10101,
    0b11011,
    0b01110,
    0b00000,
    0b00000,
    0b00000 }, // 026 circled times
  { 0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b01010,
    0b11111,
    0b01010,
    0b00000,
    0b00000,
    0b00000,
    0b00000 }, // 027 double arrow
  { 0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b11111,
    0b00000,
    0b00000 }, // 030 underscore
  { 0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00100,
    0b00010,
    0b11111,
    0b00010,
    0b00100,
    0b00000,
    0b00000,
    0b00000 }, // 031 right arrow
  { 0b00000,
    0b00000,
    0b00000,
    0b01010,
    0b10100,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000 }, // 032 tilde
  { 0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00010,
    0b11111,
    0b00100,
    0b11111,
    0b01000,
    0b00000,
    0b00000 }, // 033 not equal
  { 0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000 }, // 034 less than or equal
  { 0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000 }, // 035 greater than or equal
  { 0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b11111,
    0b00000,
    0b11111,
    0b00000,
    0b11111,
    0b00000,
    0b00000,
    0b00000 }, // 036 equivalence
  { 0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000 }, // 037 OR
  { 0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000 }, // 040 SPC
  { 0b00000,
    0b00000,
    0b00000,
    0b00100,
    0b00100,
    0b00100,
    0b00100,
    0b00100,
    0b00000,
    0b00100,
    0b00000,
    0b00000 }, // 041 !
  { 0b00000,
    0b00000,
    0b00000,
    0b01010,
    0b01010,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000 }, // 042 "
  { 0b00000,
    0b00000,
    0b00000,
    0b01010,
    0b01010,
    0b11111,
    0b01010,
    0b11111,
    0b01010,
    0b01010,
    0b00000,
    0b00000 }, // 043 #
  { 0b00000,
    0b00000,
    0b00000,
    0b01110,
    0b10101,
    0b10100,
    0b01110,
    0b00101,
    0b10101,
    0b01110,
    0b00000,
    0b00000 }, // 044 $
  { 0b00000,
    0b00000,
    0b00000,
    0b11001,
    0b11001,
    0b00010,
    0b00100,
    0b01000,
    0b10011,
    0b10011,
    0b00000,
    0b00000 }, // 045 %
  { 0b00000,
    0b00000,
    0b00000,
    0b01000,
    0b10100,
    0b10100,
    0b01000,
    0b10101,
    0b10010,
    0b01101,
    0b00000,
    0b00000 }, // 046 &
  { 0b00000,
    0b00000,
    0b00000,
    0b01000,
    0b00100,
    0b00100,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000 }, // 047 '
  { 0b00000,
    0b00000,
    0b00000,
    0b00100,
    0b01000,
    0b10000,
    0b10000,
    0b10000,
    0b01000,
    0b00100,
    0b00000,
    0b00000 }, // 050 (
  { 0b00000,
    0b00000,
    0b00000,
    0b00100,
    0b00010,
    0b00001,
    0b00001,
    0b00001,
    0b00010,
    0b00100,
    0b00000,
    0b00000 }, // 051 )
  { 0b00000,
    0b00000,
    0b00000,
    0b00100,
    0b10101,
    0b01110,
    0b11111,
    0b01110,
    0b10101,
    0b00100,
    0b00000,
    0b00000 }, // 052 *
  { 0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00100,
    0b00100,
    0b11111,
    0b00100,
    0b00100,
    0b00000,
    0b00000,
    0b00000 }, // 053 +
  { 0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b01000,
    0b00100,
    0b00100,
    0b00000 }, // 054 ,
  { 0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b11111,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000 }, // 055 -
  { 0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b01100,
    0b01100,
    0b00000,
    0b00000 }, // 056 .
  { 0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00001,
    0b00010,
    0b00100,
    0b01000,
    0b10000,
    0b00000,
    0b00000,
    0b00000 }, // 057 /
  { 0b00000,
    0b00000,
    0b00000,
    0b01110,
    0b10001,
    0b10001,
    0b10101,
    0b10001,
    0b10001,
    0b01110,
    0b00000,
    0b00000 }, // 060 0
  { 0b00000,
    0b00000,
    0b00000,
    0b00100,
    0b01100,
    0b00100,
    0b00100,
    0b00100,
    0b00100,
    0b01110,
    0b00000,
    0b00000 }, // 061 1
  { 0b00000,
    0b00000,
    0b00000,
    0b01110,
    0b10001,
    0b00001,
    0b00010,
    0b00100,
    0b01000,
    0b11111,
    0b00000,
    0b00000 }, // 062
  { 0b00000,
    0b00000,
    0b00000,
    0b01110,
    0b00001,
    0b00001,
    0b00110,
    0b00001,
    0b10001,
    0b01110,
    0b00000,
    0b00000 }, // 063
  { 0b00000,
    0b00000,
    0b00000,
    0b00010,
    0b00110,
    0b01010,
    0b10010,
    0b11111,
    0b00010,
    0b00010,
    0b00000,
    0b00000 }, // 064
  { 0b00000,
    0b00000,
    0b00000,
    0b01111,
    0b01000,
    0b01000,
    0b01110,
    0b00001,
    0b10001,
    0b01110,
    0b00000,
    0b00000 }, // 065
  { 0b00000,
    0b00000,
    0b00000,
    0b00110,
    0b01000,
    0b10000,
    0b11110,
    0b10001,
    0b10001,
    0b01110,
    0b00000,
    0b00000 }, // 066
  { 0b00000,
    0b00000,
    0b00000,
    0b11111,
    0b00001,
    0b00010,
    0b00100,
    0b00100,
    0b01000,
    0b01000,
    0b00000,
    0b00000 }, // 067
  { 0b00000,
    0b00000,
    0b00000,
    0b01110,
    0b10001,
    0b10001,
    0b01110,
    0b10001,
    0b10001,
    0b01110,
    0b00000,
    0b00000 }, // 070
  { 0b00000,
    0b00000,
    0b00000,
    0b01110,
    0b10001,
    0b10001,
    0b01111,
    0b00001,
    0b00001,
    0b00001,
    0b00000,
    0b00000 }, // 071 9
  { 0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00100,
    0b00000,
    0b00100,
    0b00000,
    0b00000,
    0b00000,
    0b00000 }, // 072 :
  { 0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00100,
    0b00000,
    0b00100,
    0b00100,
    0b01000,
    0b00000 }, // 073 ;
  { 0b00000,
    0b00000,
    0b00000,
    0b00010,
    0b00100,
    0b01000,
    0b10000,
    0b01000,
    0b00100,
    0b00010,
    0b00000,
    0b00000 }, // 074 <
  { 0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b11111,
    0b00000,
    0b11111,
    0b00000,
    0b00000,
    0b00000,
    0b00000 }, // 075 =
  { 0b00000,
    0b00000,
    0b00000,
    0b01000,
    0b00100,
    0b00010,
    0b00001,
    0b00010,
    0b00100,
    0b01000,
    0b00000,
    0b00000 }, // 076 >
  { 0b00000,
    0b00000,
    0b00000,
    0b01110,
    0b10001,
    0b00001,
    0b00010,
    0b00100,
    0b00100,
    0b00000,
    0b00100,
    0b00000 }, // 077 ?
  { 0b00000,
    0b00000,
    0b00000,
    0b01110,
    0b10001,
    0b10111,
    0b10101,
    0b10111,
    0b10000,
    0b10000,
    0b01110,
    0b00000 }, // 100 @
  { 0b00000,
    0b00000,
    0b00000,
    0b01110,
    0b10001,
    0b10001,
    0b11111,
    0b10001,
    0b10001,
    0b10001,
    0b00000,
    0b00000 }, // 101 A
  { 0b00000,
    0b00000,
    0b00000,
    0b11110,
    0b10001,
    0b10001,
    0b11110,
    0b10001,
    0b10001,
    0b11110,
    0b00000,
    0b00000 }, // 102 B
  { 0b00000,
    0b00000,
    0b00000,
    0b01110,
    0b10001,
    0b10000,
    0b10000,
    0b10000,
    0b10001,
    0b01110,
    0b00000,
    0b00000 }, // 103 C
  { 0b00000,
    0b00000,
    0b00000,
    0b11110,
    0b01001,
    0b01001,
    0b01001,
    0b01001,
    0b01001,
    0b11110,
    0b00000,
    0b00000 }, // 104 D
  { 0b00000,
    0b00000,
    0b00000,
    0b11111,
    0b10000,
    0b10000,
    0b11110,
    0b10000,
    0b10000,
    0b11111,
    0b00000,
    0b00000 }, // 105 E
  { 0b00000,
    0b00000,
    0b00000,
    0b11111,
    0b10000,
    0b10000,
    0b11110,
    0b10000,
    0b10000,
    0b10000,
    0b00000,
    0b00000 }, // 106 F
  { 0b00000,
    0b00000,
    0b00000,
    0b01110,
    0b10001,
    0b10000,
    0b10000,
    0b10111,
    0b10001,
    0b01110,
    0b00000,
    0b00000 }, // 107 G
  { 0b00000,
    0b00000,
    0b00000,
    0b10001,
    0b10001,
    0b10001,
    0b11111,
    0b10001,
    0b10001,
    0b10001,
    0b00000,
    0b00000 }, // 110 H
  { 0b00000,
    0b00000,
    0b00000,
    0b01110,
    0b00100,
    0b00100,
    0b00100,
    0b00100,
    0b00100,
    0b01110,
    0b00000,
    0b00000 }, // 111 I
  { 0b00000,
    0b00000,
    0b00000,
    0b00001,
    0b00001,
    0b00001,
    0b00001,
    0b00001,
    0b10001,
    0b01110,
    0b00000,
    0b00000 }, // 112 J
  { 0b00000,
    0b00000,
    0b00000,
    0b10001,
    0b10010,
    0b10100,
    0b11000,
    0b10100,
    0b10010,
    0b10001,
    0b00000,
    0b00000 }, // 113 K
  { 0b00000,
    0b00000,
    0b00000,
    0b10000,
    0b10000,
    0b10000,
    0b10000,
    0b10000,
    0b10000,
    0b11111,
    0b00000,
    0b00000 }, // 114 L
  { 0b00000,
    0b00000,
    0b00000,
    0b10001,
    0b11011,
    0b10101,
    0b10001,
    0b10001,
    0b10001,
    0b10001,
    0b00000,
    0b00000 }, // 115 M
  { 0b00000,
    0b00000,
    0b00000,
    0b10001,
    0b11001,
    0b11101,
    0b10111,
    0b10011,
    0b10001,
    0b10001,
    0b00000,
    0b00000 }, // 116 N
  { 0b00000,
    0b00000,
    0b00000,
    0b01110,
    0b10001,
    0b10001,
    0b10001,
    0b10001,
    0b10001,
    0b01110,
    0b00000,
    0b00000 }, // 117 O
  { 0b00000,
    0b00000,
    0b00000,
    0b11110,
    0b10001,
    0b10001,
    0b11110,
    0b10000,
    0b10000,
    0b10000,
    0b00000,
    0b00000 }, // 120 P
  { 0b00000,
    0b00000,
    0b00000,
    0b01110,
    0b10001,
    0b10001,
    0b10001,
    0b10101,
    0b10010,
    0b01101,
    0b00000,
    0b00000 }, // 121 Q
  { 0b00000,
    0b00000,
    0b00000,
    0b11110,
    0b10001,
    0b10001,
    0b11110,
    0b10100,
    0b10010,
    0b10001,
    0b00000,
    0b00000 }, // 122 R
  { 0b00000,
    0b00000,
    0b00000,
    0b01110,
    0b10000,
    0b10000,
    0b01110,
    0b00001,
    0b10001,
    0b01110,
    0b00000,
    0b00000 }, // 123 S
  { 0b00000,
    0b00000,
    0b00000,
    0b11111,
    0b00100,
    0b00100,
    0b00100,
    0b00100,
    0b00100,
    0b00100,
    0b00000,
    0b00000 }, // 124 T
  { 0b00000,
    0b00000,
    0b00000,
    0b10001,
    0b10001,
    0b10001,
    0b10001,
    0b10001,
    0b10001,
    0b01110,
    0b00000,
    0b00000 }, // 125 U
  { 0b00000,
    0b00000,
    0b00000,
    0b10001,
    0b10001,
    0b10001,
    0b10001,
    0b01010,
    0b01010,
    0b00100,
    0b00000,
    0b00000 }, // 126 V
  { 0b00000,
    0b00000,
    0b00000,
    0b10001,
    0b10001,
    0b10001,
    0b10001,
    0b10101,
    0b11011,
    0b10001,
    0b00000,
    0b00000 }, // 127 W
  { 0b00000,
    0b00000,
    0b00000,
    0b10001,
    0b10001,
    0b01010,
    0b00100,
    0b01010,
    0b10001,
    0b10001,
    0b00000,
    0b00000 }, // 130 X
  { 0b00000,
    0b00000,
    0b00000,
    0b10001,
    0b10001,
    0b01010,
    0b00100,
    0b00100,
    0b00100,
    0b00100,
    0b00000,
    0b00000 }, // 131 Y
  { 0b00000,
    0b00000,
    0b00000,
    0b11111,
    0b00001,
    0b00010,
    0b00100,
    0b01000,
    0b10000,
    0b11111,
    0b00000,
    0b00000 }, // 132 Z
  { 0b00000,
    0b00000,
    0b00000,
    0b11110,
    0b10000,
    0b10000,
    0b10000,
    0b10000,
    0b10000,
    0b11110,
    0b00000,
    0b00000 }, // 133 [
  { 0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b10000,
    0b01000,
    0b00100,
    0b00010,
    0b00001,
    0b00000,
    0b00000,
    0b00000 }, // 134 backslash
  { 0b00000,
    0b00000,
    0b00000,
    0b01111,
    0b00001,
    0b00001,
    0b00001,
    0b00001,
    0b00001,
    0b01111,
    0b00000,
    0b00000 }, // 135 ]
  { 0b00000,
    0b00000,
    0b00000,
    0b00100,
    0b01110,
    0b10101,
    0b00100,
    0b00100,
    0b00100,
    0b00100,
    0b00000,
    0b00000 }, // 136 up arrow
  { 0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00100,
    0b01000,
    0b11111,
    0b01000,
    0b00100,
    0b00000,
    0b00000,
    0b00000 }, // 137 left arrow
  { 0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000 }, // 140
  { 0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b01110,
    0b00001,
    0b01111,
    0b10001,
    0b01111,
    0b00000,
    0b00000 }, // 141 a
  { 0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000 }, // 142
  { 0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000 }, // 143
  { 0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000 }, // 144
  { 0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b01110,
    0b10001,
    0b11111,
    0b10000,
    0b01111,
    0b00000,
    0b00000 }, // 145 e
  { 0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000 }, // 146
  { 0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000 }, // 147
  { 0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000 }, // 150
  { 0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000 }, // 151
  { 0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000 }, // 152
  { 0b00000,
    0b00000,
    0b00000,
    0b10000,
    0b10000,
    0b10010,
    0b10100,
    0b11000,
    0b10100,
    0b10010,
    0b00000,
    0b00000 }, // 153 k
  { 0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000 }, // 154
  { 0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b11010,
    0b10101,
    0b10101,
    0b10101,
    0b10101,
    0b00000,
    0b00000 }, // 155 m
  { 0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000 }, // 156
  { 0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b01110,
    0b10001,
    0b10001,
    0b10001,
    0b01110,
    0b00000,
    0b00000 }, // 157 o
  { 0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000 }, // 160
  { 0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000 }, // 161
  { 0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b10110,
    0b11001,
    0b10000,
    0b10000,
    0b10000,
    0b00000,
    0b00000 }, // 162 r
  { 0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b01111,
    0b10000,
    0b01110,
    0b00001,
    0b11110,
    0b00000,
    0b00000 }, // 163 s
  { 0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000 }, // 164
  { 0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b10001,
    0b10001,
    0b10001,
    0b10011,
    0b01101,
    0b00000,
    0b00000 }, // 165 u
  { 0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000 }, // 166
  { 0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000 }, // 167
  { 0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000 }, // 170
  { 0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000 }, // 171
  { 0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000 }, // 172
  { 0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000 }, // 173 {
  { 0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000 }, // 174 |
  { 0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000 }, // 175
  { 0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000 }, // 176 }
  { 0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000,
    0b00000 }, // 177
};

/* Font from Knight TV. */
static unsigned int knight_font[128][12] = {
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 }
};

/* SAIL7 font. */
static unsigned int sail7_font[128][12] = {
  { 0, 0x00, 0x1F, 0x11, 0x15, 0x11, 0x1F, 0x00, 0x00, 0, 0, 0 }, // 000
  { 0, 0x04, 0x04, 0x04, 0x15, 0x0E, 0x04, 0x00, 0x00, 0, 0, 0 }, // 001 down arrow
  { 0, 0x00, 0x00, 0x0D, 0x12, 0x12, 0x0D, 0x00, 0x00, 0, 0, 0 }, // 002 alpha
  { 0, 0x06, 0x09, 0x0E, 0x09, 0x09, 0x0E, 0x08, 0x00, 0, 0, 0 }, // 003 beta
  { 0, 0x00, 0x04, 0x0A, 0x11, 0x00, 0x00, 0x00, 0x00, 0, 0, 0 }, // 004 AND
  { 0, 0x00, 0x00, 0x1F, 0x01, 0x01, 0x00, 0x00, 0x00, 0, 0, 0 }, // 005 NOT
  { 0, 0x00, 0x07, 0x08, 0x0E, 0x08, 0x07, 0x00, 0x00, 0, 0, 0 }, // 006 epsilon
  { 0, 0x00, 0x1F, 0x0A, 0x0A, 0x0A, 0x09, 0x00, 0x00, 0, 0, 0 }, // 007 pi
  { 0, 0x10, 0x08, 0x04, 0x0A, 0x11, 0x11, 0x00, 0x00, 0, 0, 0 }, // 010 lambda
  { 0, 0x1C, 0x08, 0x0E, 0x0D, 0x06, 0x05, 0x06, 0x00, 0, 0, 0 }, // 011 TB
  { 0, 0x10, 0x10, 0x17, 0x1C, 0x07, 0x04, 0x04, 0x00, 0, 0, 0 }, // 012 LF
  { 0, 0x0A, 0x0A, 0x04, 0x07, 0x02, 0x02, 0x02, 0x00, 0, 0, 0 }, // 013 VT
  { 0, 0x1C, 0x10, 0x1F, 0x14, 0x16, 0x04, 0x04, 0x00, 0, 0, 0 }, // 014 FF
  { 0, 0x0E, 0x10, 0x16, 0x15, 0x0E, 0x05, 0x05, 0x00, 0, 0, 0 }, // 015 CR
  { 0, 0x00, 0x0A, 0x15, 0x15, 0x15, 0x0A, 0x00, 0x00, 0, 0, 0 }, // 016 infinity
  { 0, 0x0C, 0x02, 0x07, 0x09, 0x09, 0x06, 0x00, 0x00, 0, 0, 0 }, // 017 partial differential
  { 0, 0x00, 0x0F, 0x10, 0x10, 0x0F, 0x00, 0x00, 0x00, 0, 0, 0 }, // 020 subset
  { 0, 0x00, 0x1E, 0x01, 0x01, 0x1E, 0x00, 0x00, 0x00, 0, 0, 0 }, // 021 superset
  { 0, 0x06, 0x09, 0x09, 0x09, 0x09, 0x09, 0x00, 0x00, 0, 0, 0 }, // 022 intersection
  { 0, 0x09, 0x09, 0x09, 0x09, 0x09, 0x06, 0x00, 0x00, 0, 0, 0 }, // 023 union
  { 0, 0x11, 0x11, 0x1F, 0x11, 0x0A, 0x04, 0x00, 0x00, 0, 0, 0 }, // 024 for all
  { 0, 0x1F, 0x01, 0x07, 0x01, 0x01, 0x1F, 0x00, 0x00, 0, 0, 0 }, // 025 there exists
  { 0, 0x00, 0x0E, 0x15, 0x1B, 0x15, 0x0E, 0x00, 0x00, 0, 0, 0 }, // 026 circled times
  { 0, 0x00, 0x00, 0x0A, 0x1F, 0x0A, 0x00, 0x00, 0x00, 0, 0, 0 }, // 027 double arrow
  { 0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0, 0, 0 }, // 030 underscore
  { 0, 0x00, 0x04, 0x02, 0x1F, 0x02, 0x04, 0x00, 0x00, 0, 0, 0 }, // 031 right arrow
  { 0, 0x00, 0x08, 0x15, 0x02, 0x00, 0x00, 0x00, 0x00, 0, 0, 0 }, // 032 tilde
  { 0, 0x01, 0x02, 0x1F, 0x04, 0x1F, 0x08, 0x10, 0x00, 0, 0, 0 }, // 033 not equal
  { 0, 0x00, 0x02, 0x04, 0x08, 0x04, 0x02, 0x0F, 0x00, 0, 0, 0 }, // 034 less than or equal
  { 0, 0x00, 0x08, 0x04, 0x02, 0x04, 0x08, 0x1E, 0x00, 0, 0, 0 }, // 035 greater than or equal
  { 0, 0x00, 0x1F, 0x00, 0x1F, 0x00, 0x1F, 0x00, 0x00, 0, 0, 0 }, // 036 equivalence
  { 0, 0x00, 0x11, 0x0A, 0x04, 0x00, 0x00, 0x00, 0x00, 0, 0, 0 }, // 037 OR
  { 0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0, 0, 0 }, // 040 SPC
  { 0, 0x06, 0x06, 0x06, 0x06, 0x00, 0x06, 0x00, 0x00, 0, 0, 0 }, // 041 !
  { 0, 0x0A, 0x0A, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0, 0, 0 }, // 042 "
  { 0, 0x0A, 0x1F, 0x0A, 0x0A, 0x1F, 0x0A, 0x00, 0x00, 0, 0, 0 }, // 043 #
  { 0, 0x04, 0x0F, 0x14, 0x0E, 0x05, 0x1E, 0x04, 0x00, 0, 0, 0 }, // 044 $
  { 0, 0x1F, 0x19, 0x02, 0x04, 0x0B, 0x13, 0x00, 0x00, 0, 0, 0 }, // 045 %
  { 0, 0x0C, 0x14, 0x08, 0x15, 0x12, 0x1D, 0x00, 0x00, 0, 0, 0 }, // 046 &
  { 0, 0x06, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0, 0, 0 }, // 047 '
  { 0, 0x02, 0x04, 0x08, 0x08, 0x08, 0x04, 0x02, 0x00, 0, 0, 0 }, // 050 (
  { 0, 0x08, 0x04, 0x02, 0x02, 0x02, 0x04, 0x08, 0x00, 0, 0, 0 }, // 051 )
  { 0, 0x00, 0x15, 0x0E, 0x1B, 0x0E, 0x15, 0x00, 0x00, 0, 0, 0 }, // 052 *
  { 0, 0x00, 0x04, 0x04, 0x1F, 0x04, 0x04, 0x00, 0x00, 0, 0, 0 }, // 053 +
  { 0, 0x00, 0x00, 0x00, 0x00, 0x06, 0x02, 0x04, 0x00, 0, 0, 0 }, // 054 ,
  { 0, 0x00, 0x00, 0x00, 0x3F, 0x00, 0x00, 0x00, 0x00, 0, 0, 0 }, // 055 -
  { 0, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0, 0, 0 }, // 056 .
  { 0, 0x01, 0x02, 0x02, 0x04, 0x04, 0x08, 0x00, 0x00, 0, 0, 0 }, // 057 /
  { 0, 0x06, 0x09, 0x0B, 0x0D, 0x09, 0x06, 0x00, 0x00, 0, 0, 0 }, // 060 0
  { 0, 0x02, 0x06, 0x02, 0x02, 0x02, 0x07, 0x00, 0x00, 0, 0, 0 }, // 061 1
  { 0, 0x0E, 0x11, 0x01, 0x0E, 0x10, 0x1F, 0x00, 0x00, 0, 0, 0 }, // 062 2
  { 0, 0x0E, 0x11, 0x06, 0x01, 0x11, 0x0E, 0x00, 0x00, 0, 0, 0 }, // 063 3
  { 0, 0x02, 0x06, 0x0A, 0x1F, 0x02, 0x02, 0x00, 0x00, 0, 0, 0 }, // 064 4
  { 0, 0x1F, 0x10, 0x1E, 0x01, 0x11, 0x0E, 0x00, 0x00, 0, 0, 0 }, // 065 5
  { 0, 0x0E, 0x10, 0x1E, 0x11, 0x11, 0x0E, 0x00, 0x00, 0, 0, 0 }, // 066 6
  { 0, 0x1F, 0x01, 0x02, 0x02, 0x04, 0x04, 0x00, 0x00, 0, 0, 0 }, // 067 7
  { 0, 0x0E, 0x11, 0x0E, 0x11, 0x11, 0x0E, 0x00, 0x00, 0, 0, 0 }, // 070 8
  { 0, 0x0E, 0x11, 0x11, 0x0F, 0x01, 0x0E, 0x00, 0x00, 0, 0, 0 }, // 071 9
  { 0, 0x00, 0x04, 0x04, 0x00, 0x04, 0x04, 0x00, 0x00, 0, 0, 0 }, // 072 :
  { 0, 0x00, 0x04, 0x04, 0x00, 0x06, 0x02, 0x04, 0x00, 0, 0, 0 }, // 073 ;
  { 0, 0x00, 0x02, 0x04, 0x08, 0x04, 0x02, 0x00, 0x00, 0, 0, 0 }, // 074 <
  { 0, 0x00, 0x00, 0x1F, 0x00, 0x1F, 0x00, 0x00, 0x00, 0, 0, 0 }, // 075 =
  { 0, 0x00, 0x08, 0x04, 0x02, 0x04, 0x08, 0x00, 0x00, 0, 0, 0 }, // 076 >
  { 0, 0x0E, 0x11, 0x01, 0x06, 0x00, 0x04, 0x00, 0x00, 0, 0, 0 }, // 077 ?
  { 0, 0x0E, 0x11, 0x17, 0x17, 0x10, 0x0E, 0x00, 0x00, 0, 0, 0 }, // 100 @
  { 0, 0x0E, 0x11, 0x1F, 0x11, 0x11, 0x11, 0x00, 0x00, 0, 0, 0 }, // 101 A
  { 0, 0x1E, 0x11, 0x1E, 0x11, 0x11, 0x1E, 0x00, 0x00, 0, 0, 0 }, // 102 B
  { 0, 0x0E, 0x11, 0x10, 0x10, 0x11, 0x0E, 0x00, 0x00, 0, 0, 0 }, // 103 C
  { 0, 0x1E, 0x11, 0x11, 0x11, 0x11, 0x1E, 0x00, 0x00, 0, 0, 0 }, // 104 D
  { 0, 0x1F, 0x10, 0x1E, 0x10, 0x10, 0x1F, 0x00, 0x00, 0, 0, 0 }, // 105 E
  { 0, 0x1F, 0x10, 0x1E, 0x10, 0x10, 0x10, 0x00, 0x00, 0, 0, 0 }, // 106 F
  { 0, 0x0E, 0x11, 0x10, 0x13, 0x11, 0x0E, 0x00, 0x00, 0, 0, 0 }, // 107 G
  { 0, 0x11, 0x11, 0x1F, 0x11, 0x11, 0x11, 0x00, 0x00, 0, 0, 0 }, // 110 H
  { 0, 0x0E, 0x04, 0x04, 0x04, 0x04, 0x0E, 0x00, 0x00, 0, 0, 0 }, // 111 I
  { 0, 0x01, 0x01, 0x01, 0x01, 0x11, 0x0E, 0x00, 0x00, 0, 0, 0 }, // 112 J
  { 0, 0x11, 0x12, 0x14, 0x1C, 0x12, 0x11, 0x00, 0x00, 0, 0, 0 }, // 113 K
  { 0, 0x10, 0x10, 0x10, 0x10, 0x10, 0x1F, 0x00, 0x00, 0, 0, 0 }, // 114 L
  { 0, 0x11, 0x1B, 0x15, 0x15, 0x11, 0x11, 0x00, 0x00, 0, 0, 0 }, // 115 M
  { 0, 0x11, 0x19, 0x15, 0x13, 0x11, 0x11, 0x00, 0x00, 0, 0, 0 }, // 116 N
  { 0, 0x0E, 0x11, 0x11, 0x11, 0x11, 0x0E, 0x00, 0x00, 0, 0, 0 }, // 117 O
  { 0, 0x1E, 0x11, 0x1E, 0x10, 0x10, 0x10, 0x00, 0x00, 0, 0, 0 }, // 120 P
  { 0, 0x0E, 0x11, 0x11, 0x15, 0x13, 0x0E, 0x01, 0x00, 0, 0, 0 }, // 121 Q
  { 0, 0x1E, 0x11, 0x1E, 0x14, 0x12, 0x11, 0x00, 0x00, 0, 0, 0 }, // 122 R
  { 0, 0x0E, 0x11, 0x0C, 0x02, 0x11, 0x0E, 0x00, 0x00, 0, 0, 0 }, // 123 S
  { 0, 0x1F, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00, 0, 0, 0 }, // 124 T
  { 0, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0E, 0x00, 0x00, 0, 0, 0 }, // 125 U
  { 0, 0x11, 0x11, 0x11, 0x0A, 0x0A, 0x04, 0x00, 0x00, 0, 0, 0 }, // 126 V
  { 0, 0x11, 0x11, 0x15, 0x15, 0x1B, 0x11, 0x00, 0x00, 0, 0, 0 }, // 127 W
  { 0, 0x11, 0x0A, 0x04, 0x0A, 0x11, 0x11, 0x00, 0x00, 0, 0, 0 }, // 130 X
  { 0, 0x11, 0x11, 0x0E, 0x04, 0x04, 0x04, 0x00, 0x00, 0, 0, 0 }, // 131 Y
  { 0, 0x1F, 0x01, 0x02, 0x08, 0x10, 0x1F, 0x00, 0x00, 0, 0, 0 }, // 132 Z
  { 0, 0x0E, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0E, 0x00, 0, 0, 0 }, // 133 [
  { 0, 0x10, 0x08, 0x04, 0x04, 0x02, 0x01, 0x00, 0x00, 0, 0, 0 }, // 134 backslash
  { 0, 0x0E, 0x02, 0x02, 0x02, 0x02, 0x02, 0x0E, 0x00, 0, 0, 0 }, // 135 ]
  { 0, 0x04, 0x0E, 0x15, 0x04, 0x04, 0x04, 0x00, 0x00, 0, 0, 0 }, // 136 ^
  { 0, 0x00, 0x04, 0x08, 0x1F, 0x08, 0x04, 0x00, 0x00, 0, 0, 0 }, // 137 _
  { 0, 0x06, 0x04, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0, 0, 0 }, // 140 `
  { 0, 0x00, 0x0E, 0x01, 0x0F, 0x11, 0x0D, 0x00, 0x00, 0, 0, 0 }, // 141 a
  { 0, 0x10, 0x16, 0x19, 0x11, 0x11, 0x16, 0x00, 0x00, 0, 0, 0 }, // 142 b
  { 0, 0x00, 0x0E, 0x10, 0x10, 0x10, 0x0E, 0x00, 0x00, 0, 0, 0 }, // 143 c
  { 0, 0x01, 0x0D, 0x13, 0x11, 0x11, 0x0D, 0x00, 0x00, 0, 0, 0 }, // 144 d
  { 0, 0x00, 0x0E, 0x11, 0x1F, 0x10, 0x0E, 0x00, 0x00, 0, 0, 0 }, // 145 e
  { 0, 0x07, 0x08, 0x1E, 0x08, 0x08, 0x08, 0x00, 0x00, 0, 0, 0 }, // 146 f
  { 0, 0x00, 0x0F, 0x11, 0x11, 0x0E, 0x01, 0x1E, 0x00, 0, 0, 0 }, // 147 g
  { 0, 0x10, 0x16, 0x19, 0x11, 0x11, 0x11, 0x00, 0x00, 0, 0, 0 }, // 150 h
  { 0, 0x04, 0x00, 0x0C, 0x04, 0x04, 0x04, 0x00, 0x00, 0, 0, 0 }, // 151 i
  { 0, 0x02, 0x00, 0x06, 0x02, 0x02, 0x02, 0x0C, 0x00, 0, 0, 0 }, // 152 j
  { 0, 0x08, 0x09, 0x0A, 0x0C, 0x0A, 0x09, 0x00, 0x00, 0, 0, 0 }, // 153 k
  { 0, 0x0C, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00, 0, 0, 0 }, // 154 l
  { 0, 0x00, 0x1A, 0x15, 0x15, 0x15, 0x15, 0x00, 0x00, 0, 0, 0 }, // 155 m
  { 0, 0x00, 0x16, 0x19, 0x11, 0x11, 0x11, 0x00, 0x00, 0, 0, 0 }, // 156 n
  { 0, 0x00, 0x0E, 0x11, 0x11, 0x11, 0x0E, 0x00, 0x00, 0, 0, 0 }, // 157 o
  { 0, 0x00, 0x16, 0x19, 0x11, 0x11, 0x16, 0x10, 0x00, 0, 0, 0 }, // 160 p
  { 0, 0x00, 0x0D, 0x13, 0x11, 0x11, 0x0D, 0x01, 0x00, 0, 0, 0 }, // 161 q
  { 0, 0x00, 0x16, 0x19, 0x10, 0x10, 0x10, 0x00, 0x00, 0, 0, 0 }, // 162 r
  { 0, 0x00, 0x0F, 0x10, 0x0E, 0x01, 0x1E, 0x00, 0x00, 0, 0, 0 }, // 163 s
  { 0, 0x08, 0x1F, 0x08, 0x08, 0x08, 0x06, 0x00, 0x00, 0, 0, 0 }, // 164 t
  { 0, 0x00, 0x11, 0x11, 0x11, 0x11, 0x0D, 0x00, 0x00, 0, 0, 0 }, // 165 u
  { 0, 0x00, 0x11, 0x11, 0x0A, 0x0A, 0x04, 0x00, 0x00, 0, 0, 0 }, // 166 v
  { 0, 0x00, 0x11, 0x11, 0x15, 0x15, 0x0A, 0x00, 0x00, 0, 0, 0 }, // 167 w
  { 0, 0x00, 0x11, 0x0A, 0x04, 0x0A, 0x11, 0x00, 0x00, 0, 0, 0 }, // 170 x
  { 0, 0x00, 0x11, 0x11, 0x11, 0x0F, 0x01, 0x0E, 0x00, 0, 0, 0 }, // 171 y
  { 0, 0x00, 0x1F, 0x02, 0x04, 0x08, 0x1F, 0x00, 0x00, 0, 0, 0 }, // 172 z
  { 0, 0x03, 0x04, 0x04, 0x08, 0x04, 0x04, 0x03, 0x00, 0, 0, 0 }, // 173 {
  { 0, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0, 0, 0 }, // 174 |
  { 0, 0x00, 0x04, 0x0A, 0x11, 0x0A, 0x04, 0x00, 0x00, 0, 0, 0 }, // 175 altmode
  { 0, 0x18, 0x04, 0x04, 0x02, 0x04, 0x04, 0x18, 0x00, 0, 0, 0 }, // 176 }
  { 0, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0, 0, 0 }, // 177
};

int main (void)
{
  unsigned int *font;
  unsigned int i;

  FILE *f = fopen ("ka10_dd_font.h", "w");
  if (f == NULL)
    return 1;

  fprintf (f, "static uint8 font[128][12] = {\n");
  
  for (i = 0; i < 128; i++) {
    font = sail7_font[i];
    fprintf (f, "  { %03o, %03o, %03o, %03o, %03o, %03o, ",
             font[0], font[1], font[2], font[3], font[4], font[5]);
    fprintf (f, "%03o, %03o, %03o, %03o, %03o, %03o }, // %03o\n",
             font[6], font[7], font[8], font[9], font[10], font[11], i);
  }

  fprintf (f, "};\n");
  fclose (f);
  return 0;
}
