/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.api.unix;

import com.ejt.internal.util.CommonStringUtil;
import com.install4j.api.Util;
import com.install4j.runtime.installer.helper.FileAttributesHelper;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.platform.unix.Execution;
import com.install4j.runtime.installer.platform.unix.LegacyUnixFileSystem;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermissions;
import java.nio.file.attribute.UserPrincipal;
import java.nio.file.attribute.UserPrincipalLookupService;

public class UnixFileSystem {
    public static boolean setMode(int intMode, File destFile) {
        if (!Util.isWindows()) {
            try {
                UnixFileSystem.setPosixFilePermissionsInternal(destFile, CommonStringUtil.toJavaTypeMode(intMode));
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    public static boolean setMode(String mode, File destFile) {
        if (!Util.isWindows()) {
            try {
                if (mode != null && !mode.isEmpty()) {
                    UnixFileSystem.setPosixFilePermissionsInternal(destFile, FileAttributesHelper.translateMode(mode, destFile));
                }
            }
            catch (Exception e) {
                Logger.getInstance().log(null, "set permissions: " + e, false);
                return false;
            }
        }
        return true;
    }

    private static void setPosixFilePermissionsInternal(File file, String mode) throws IOException {
        try {
            Path path = file.toPath();
            try {
                Files.setPosixFilePermissions(path, PosixFilePermissions.fromString(mode));
            }
            catch (IOException e) {
                if (!Files.isSymbolicLink(path)) {
                    throw e;
                }
            }
        }
        catch (InvalidPathException e) {
            throw new IOException(e);
        }
    }

    public static boolean createLink(String destFileName, File linkFile) {
        if (!Util.isWindows()) {
            linkFile.delete();
            try {
                Files.createSymbolicLink(linkFile.toPath(), Paths.get(destFileName, new String[0]), new FileAttribute[0]);
                return true;
            }
            catch (Throwable e) {
                Logger.getInstance().log(null, "could not create symbolic link: " + e.getMessage(), false);
            }
        }
        return false;
    }

    public static boolean setOwner(String owner, File file) {
        try {
            String user;
            int colonPos = owner.indexOf(58);
            String group = "";
            if (colonPos > -1) {
                user = owner.substring(0, colonPos);
                group = owner.substring(colonPos + 1);
            } else {
                user = owner;
            }
            PosixFileAttributeView posixFileAttributeView = Files.getFileAttributeView(file.toPath(), PosixFileAttributeView.class, LinkOption.NOFOLLOW_LINKS);
            UserPrincipalLookupService principalLookupService = FileSystems.getDefault().getUserPrincipalLookupService();
            if (!user.isEmpty()) {
                UserPrincipal userPrincipal = principalLookupService.lookupPrincipalByName(user);
                posixFileAttributeView.setOwner(userPrincipal);
            }
            if (!group.isEmpty()) {
                GroupPrincipal groupPrincipal = principalLookupService.lookupPrincipalByGroupName(group);
                posixFileAttributeView.setGroup(groupPrincipal);
            }
        }
        catch (Exception e) {
            Logger.getInstance().log(null, "set owner: " + e, false);
            return false;
        }
        return true;
    }

    public static FileInformation getFileInformation(File file) {
        try {
            PosixFileAttributes attributes = FileAttributesHelper.getFileAttributes(file);
            int mode = LegacyUnixFileSystem.fromJavaTypeMode(PosixFilePermissions.toString(attributes.permissions()));
            String ownerInfo = attributes.owner().getName() + ":" + attributes.group().getName();
            String linkTarget = null;
            if (attributes.isSymbolicLink()) {
                linkTarget = Files.readSymbolicLink(file.toPath()).toString();
            }
            return new LegacyUnixFileSystem.FileInformationImpl(mode, ownerInfo, attributes.isSymbolicLink(), linkTarget);
        }
        catch (Exception e) {
            Logger.getInstance().log(e);
            return null;
        }
    }

    public static File findExecutableInPath(String executable) {
        StringBuffer output = new StringBuffer();
        try {
            if (!Execution.executeAndWait(new String[]{UnixFileSystem.getShell(), "-c", "command -v " + executable}, output) || output.length() == 0) {
                return null;
            }
            return new File(UnixFileSystem.toFirstNewLine(output.toString()));
        }
        catch (Exception e) {
            Logger.getInstance().log(e);
            return null;
        }
    }

    public static String getShell() {
        String shell = System.getenv("SHELL");
        if (shell != null) {
            return shell;
        }
        return "/bin/sh";
    }

    private static String toFirstNewLine(String pathname) {
        int newLineIndex = pathname.indexOf(10);
        if (newLineIndex > -1) {
            return pathname.substring(0, newLineIndex);
        }
        return pathname;
    }

    public static interface FileInformation {
        public int getMode();

        public String getOwnerInfo();

        public boolean isLink();

        public String getLinkTarget();
    }
}

