/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.content;

import com.install4j.api.Util;
import com.install4j.api.beans.ErrorHandlingCallback;
import com.install4j.api.beans.ErrorHandlingMode;
import com.install4j.api.context.Context;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.ContextInt;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.content.HttpAuthenticator;
import com.install4j.runtime.installer.helper.content.HttpConnection;
import com.install4j.runtime.installer.helper.content.JavaHttpConnection;
import com.install4j.runtime.installer.helper.content.ProxyHelper;
import com.install4j.runtime.installer.helper.content.WinInetCallWrapper;
import com.install4j.runtime.installer.helper.versionspecific.VersionSpecificHelper;
import com.install4j.runtime.launcher.Launcher;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.Proxy;
import java.net.URL;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLHandshakeException;
import org.jetbrains.annotations.Nullable;

public abstract class HttpRequestHandler
implements Closeable {
    public static final int MODE_GUI = 1;
    public static final int MODE_CONSOLE = 2;
    public static final int MODE_UNATTENDED = 3;
    public static final String USER_AGENT_HEADER = "User-Agent";
    public static final String DEFAULT_USER_AGENT = System.getProperty("install4j.userAgent", "Mozilla/5.0 (Windows NT 6.1; WOW64)");
    public static final String SYSPROP_SHOW_CONNECT_ERROR = "install4j.showConnectError";
    private static final String SYSPROP_NO_PROXY = "install4j.noProxy";
    private static final String SYSPROP_CONNECT_TIMEOUT = "install4j.connectTimeout";
    private static final String SYSPROP_INSTALL4J_READ_TIMEOUT = "install4j.readTimeout";
    private Context context;
    private ErrorHandlingCallback errorHandlingCallback;
    private boolean acceptAllCertificates = false;
    private HttpConnection connection;
    private HttpConnection connectingConnection;
    private int mode;
    private Map<String, List<String>> requestHeaders = new LinkedHashMap<String, List<String>>();
    private int connectTimeout = 10000;
    private int readTimeout = 10000;
    private boolean readResponse = true;
    private boolean readErrors = false;
    private volatile boolean canceled;

    protected HttpRequestHandler(Context context) {
        this(context, InstallerUtil.isUnattendedWithoutAlerts() ? 3 : (context.isConsole() ? 2 : 1));
    }

    protected HttpRequestHandler(Context context, int mode) {
        this.context = context;
        this.mode = mode;
    }

    public void cancel() {
        this.canceled = true;
    }

    @Nullable
    public URL getLastUrl() {
        HttpConnection connection = this.connectingConnection;
        if (connection != null) {
            return connection.getURL();
        }
        return null;
    }

    public HttpConnection getConnection() {
        return this.connection;
    }

    public void setErrorHandlingCallback(ErrorHandlingCallback errorHandlingCallback) {
        this.errorHandlingCallback = errorHandlingCallback;
    }

    public void setRequestHeaders(Map<String, List<String>> requestHeaders) {
        this.requestHeaders = requestHeaders;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setAcceptAllCertificates(boolean acceptAllCertificates) {
        this.acceptAllCertificates = acceptAllCertificates;
    }

    public void setReadResponse(boolean readResponse) {
        this.readResponse = readResponse;
    }

    protected boolean isReadResponse() {
        return this.readResponse;
    }

    public boolean isReadErrors() {
        return this.readErrors;
    }

    public void setReadErrors(boolean readErrors) {
        this.readErrors = readErrors;
    }

    protected Context getContext() {
        return this.context;
    }

    public HttpRequestHandler connect(String urlString) throws IOException, UserCanceledException {
        return this.connect(urlString, null);
    }

    public HttpRequestHandler connect(String urlString, ConnectionPreparer connectionPreparer) throws IOException, UserCanceledException {
        if (Boolean.getBoolean("install4j.printUrlConnection")) {
            System.err.println(urlString);
        }
        try {
            this.close();
            URL url = new URL(urlString);
            String protocol = url.getProtocol().toLowerCase(Locale.ROOT);
            if (Util.isWindows() && !Boolean.getBoolean("install4j.noWinInetConnection") && !Boolean.getBoolean("install4j.fromService") && !Launcher.isService() && (this.isProtocolWithoutExternalProxyProperty(protocol, "http") || this.isProtocolWithoutExternalProxyProperty(protocol, "https"))) {
                this.createWindowsConnection(url, connectionPreparer);
            } else {
                this.createJavaConnection(url, connectionPreparer);
            }
        }
        catch (IOException | RuntimeException e) {
            Set throwables = Collections.newSetFromMap(new IdentityHashMap());
            for (Throwable cause = e.getCause(); cause != null && throwables.add(cause); cause = cause.getCause()) {
                if (!(cause instanceof UserCanceledException)) continue;
                throw (UserCanceledException)cause;
            }
            throw e;
        }
        return this;
    }

    private boolean isProtocolWithoutExternalProxyProperty(String protocol, String target) {
        return protocol.equals(target) && System.getProperty(target + ".proxyHost") == null;
    }

    protected void createWindowsConnection(URL url, ConnectionPreparer connectionPreparer) throws IOException, UserCanceledException {
        WinInetCallWrapper connection = new WinInetCallWrapper(url, this.acceptAllCertificates, this.mode);
        this.connectingConnection = connection;
        this.prepareConnection(connection, connectionPreparer);
        connection.connect();
        this.connectionInitialized(connection);
        this.connection = connection;
    }

    private void createJavaConnection(URL url, ConnectionPreparer connectionPreparer) throws IOException, UserCanceledException {
        JavaHttpConnection javaHttpConnection = this.getURLConnection(url, connectionPreparer);
        this.connection = javaHttpConnection;
        this.connectionInitialized(this.connection);
        if (this.isReadResponse()) {
            try {
                this.getUsedInputStream();
            }
            catch (IOException e) {
                Proxy proxy = javaHttpConnection.getProxy();
                String message = "Used proxy " + proxy;
                if (this.context != null) {
                    ContextInt contextInt = ContextImpl.getContextInt(this.context);
                    if (contextInt != null) {
                        Logger.getInstance().info(contextInt.getEventSource(), message);
                    }
                } else if (Boolean.getBoolean(SYSPROP_SHOW_CONNECT_ERROR)) {
                    System.err.println(message);
                }
                throw e;
            }
        }
    }

    protected InputStream getUsedInputStream() throws IOException {
        if (this.readErrors) {
            return this.connection.getErrorStream();
        }
        return this.connection.getInputStream();
    }

    protected void connectionInitialized(HttpConnection connection) {
    }

    public void disconnect() throws IOException {
        this.getUsedInputStream().close();
    }

    protected boolean isCancelled() {
        return this.context != null && this.context.isCancelling() || this.canceled;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private JavaHttpConnection getURLConnection(URL url, ConnectionPreparer connectionPreparer) throws IOException, UserCanceledException {
        Proxy proxy = Boolean.getBoolean(SYSPROP_NO_PROXY) ? Proxy.NO_PROXY : ProxyHelper.getProxyHostInfo(url);
        HttpAuthenticator.setRequestHandler(this);
        if (Boolean.getBoolean("install4j.debugProxy")) {
            System.err.println("used proxy = " + proxy);
        }
        int redirectCount = 0;
        while (true) {
            if (this.context != null && this.context.isCancelling()) {
                throw new UserCanceledException();
            }
            try {
                JavaHttpConnection connection = VersionSpecificHelper.createHttpConnection(url, proxy, this.acceptAllCertificates);
                this.connectingConnection = connection;
                this.prepareConnection(connection, connectionPreparer);
                connection.connect();
                int responseCode = connection.getResponseCode();
                if (responseCode == 302 || responseCode == 301) {
                    if (redirectCount++ < 5) {
                        String location = connection.getHeaderField("Location");
                        if (location == null) {
                            throw new IOException("Location header missing for response code " + responseCode);
                        }
                        url = new URL(location);
                        continue;
                    }
                    System.err.println("Too many redirects");
                }
                if (!Boolean.getBoolean(SYSPROP_SHOW_CONNECT_ERROR)) return connection;
                System.err.println("response code = " + connection.getResponseCode());
                System.err.println("header fields = " + connection.getHeaderFields());
                return connection;
            }
            catch (FileNotFoundException | SSLHandshakeException e) {
                throw e;
            }
            catch (IOException | IllegalArgumentException e) {
                if (!this.handleFailure(e)) throw e;
                continue;
            }
            break;
        }
    }

    private void prepareConnection(HttpConnection connection, ConnectionPreparer connectionPreparer) throws IOException {
        if (!Boolean.getBoolean("install4j.noClientHttpProperty")) {
            connection.addRequestProperty("X-Client-Application", "install4j");
        }
        connection.setConnectTimeout(Integer.getInteger(SYSPROP_CONNECT_TIMEOUT, this.connectTimeout));
        connection.setReadTimeout(Integer.getInteger(SYSPROP_INSTALL4J_READ_TIMEOUT, this.readTimeout));
        for (Map.Entry<String, List<String>> entry : this.requestHeaders.entrySet()) {
            String key = entry.getKey();
            List<String> values = entry.getValue();
            if (key.isEmpty()) continue;
            for (String value : values) {
                if (value.isEmpty()) continue;
                connection.addRequestProperty(key, value);
            }
        }
        String cookies = HelperCommunication.getUnelevatedProperty("install4j.cookies");
        if (cookies != null && !this.requestHeaders.containsKey("Cookie")) {
            connection.setRequestProperty("Cookie", cookies);
        }
        connection.addRequestProperty(USER_AGENT_HEADER, DEFAULT_USER_AGENT);
        if (connectionPreparer != null) {
            connectionPreparer.prepare(connection);
        }
    }

    private boolean handleFailure(Exception e) throws IOException, UserCanceledException {
        ErrorHandlingMode errorHandlingMode;
        if (this.errorHandlingCallback != null && (errorHandlingMode = this.errorHandlingCallback.errorOccurred(e)) != null) {
            switch (errorHandlingMode) {
                case CANCEL: {
                    return false;
                }
                case RETRY: {
                    return true;
                }
            }
        }
        return false;
    }

    public int getMode() {
        return this.mode;
    }

    @Override
    public void close() {
        HttpConnection connection = this.connection;
        if (connection != null) {
            connection.close();
        }
    }

    public static interface ConnectionPreparer {
        public void prepare(HttpConnection var1) throws IOException;
    }
}

