/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.lookup;

import javax.script.ScriptEngineManager;
import org.apache.commons.text.lookup.ScriptStringLookup;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ScriptStringLookupTest {
    private static final String JS_NAME = "JavaScript";

    @Test
    public void testBadEngineName() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ScriptStringLookup.INSTANCE.lookup("BAD_ENGINE_NAME:\"Hello World!\""));
    }

    @Test
    public void testBadScript() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ScriptStringLookup.INSTANCE.lookup("JavaScript:X"));
    }

    @Test
    public void testNoScript() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ScriptStringLookup.INSTANCE.lookup("ENGINE_NAME:"));
    }

    @Test
    public void testNull() {
        Assertions.assertNull((Object)ScriptStringLookup.INSTANCE.lookup(null));
    }

    @Test
    public void testOne() {
        Assertions.assertEquals((Object)"Hello World!", (Object)ScriptStringLookup.INSTANCE.lookup("JavaScript:\"Hello World!\""));
    }

    @Test
    public void testSanityCheck() {
        Assertions.assertNotNull((Object)new ScriptEngineManager().getEngineByName(JS_NAME), (String)JS_NAME);
    }

    @Test
    public void testScriptMissingColon() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ScriptStringLookup.INSTANCE.lookup("JavaScript=\"test\""));
    }

    @Test
    public void testScriptUsingMultipleColons() {
        Assertions.assertEquals((Object)"It Works", (Object)ScriptStringLookup.INSTANCE.lookup("JavaScript:true ? \"It Works\" : \"It Does Not Work\" "));
    }

    @Test
    public void testToString() {
        Assertions.assertFalse((boolean)ScriptStringLookup.INSTANCE.toString().isEmpty());
    }
}

