/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.actions;

import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.Utils;
import org.apache.directory.studio.ldapbrowser.common.dialogs.DnDialog;
import org.apache.directory.studio.ldapbrowser.core.BrowserCorePlugin;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.ui.BrowserUIPlugin;
import org.apache.directory.studio.ldapbrowser.ui.actions.LocateInDitAction;
import org.apache.directory.studio.ldapbrowser.ui.actions.Messages;
import org.apache.directory.studio.ldapbrowser.ui.views.connection.ConnectionView;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class GotoDnNavigateMenuAction
extends LocateInDitAction {
    public String getText() {
        return Messages.getString("GotoDnAction.GotoDN");
    }

    public ImageDescriptor getImageDescriptor() {
        return BrowserUIPlugin.getDefault().getImageDescriptor("resources/icons/locate_dn_in_dit.gif");
    }

    @Override
    public boolean isEnabled() {
        return this.getSelectedConnection() != null;
    }

    @Override
    protected LocateInDitAction.ConnectionAndDn getConnectionAndDn() {
        Connection selectedConnection = this.getSelectedConnection();
        if (selectedConnection != null) {
            IBrowserConnection connection = BrowserCorePlugin.getDefault().getConnectionManager().getBrowserConnection(selectedConnection);
            Dn dn = Utils.getLdapDn((String)this.getStringFromClipboard());
            DnDialog dialog = new DnDialog(this.getShell(), Messages.getString("GotoDnAction.GotoDNAction"), Messages.getString("GotoDnAction.EnterDNAction"), connection, dn);
            if (dialog.open() == 0 && dialog.getDn() != null) {
                dn = dialog.getDn();
                return new LocateInDitAction.ConnectionAndDn(this, connection, dn);
            }
        }
        return null;
    }

    private Connection getSelectedConnection() {
        Object selectedObject;
        StructuredSelection selection;
        ConnectionView connectionView = (ConnectionView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView(ConnectionView.getId());
        if (connectionView != null && (selection = (StructuredSelection)connectionView.getMainWidget().getViewer().getSelection()).size() == 1 && (selectedObject = selection.getFirstElement()) instanceof Connection) {
            return (Connection)selectedObject;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getStringFromClipboard() {
        Clipboard clipboard = null;
        try {
            clipboard = new Clipboard(Display.getCurrent());
            Object contents = clipboard.getContents((Transfer)TextTransfer.getInstance());
            if (contents != null && contents instanceof String) {
                String string = (String)contents;
                return string;
            }
        }
        finally {
            if (clipboard != null) {
                clipboard.dispose();
            }
        }
        return null;
    }
}

