/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.wizards;

import org.apache.directory.studio.connection.core.jobs.StudioConnectionRunnableWithProgress;
import org.apache.directory.studio.ldapbrowser.core.jobs.ExportOdfRunnable;
import org.apache.directory.studio.ldapbrowser.core.jobs.StudioBrowserJob;
import org.apache.directory.studio.ldapbrowser.ui.BrowserUIConstants;
import org.apache.directory.studio.ldapbrowser.ui.wizards.ExportBaseWizard;
import org.apache.directory.studio.ldapbrowser.ui.wizards.ExportOdfFromWizardPage;
import org.apache.directory.studio.ldapbrowser.ui.wizards.ExportOdfToWizardPage;
import org.apache.directory.studio.ldapbrowser.ui.wizards.Messages;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;

public class ExportOdfWizard
extends ExportBaseWizard {
    private ExportOdfFromWizardPage fromPage;
    private ExportOdfToWizardPage toPage;

    public ExportOdfWizard() {
        super(Messages.getString("ExportOdfWizard.OdfExport"));
    }

    public static String getId() {
        return BrowserUIConstants.WIZARD_EXPORT_ODF;
    }

    public void addPages() {
        this.fromPage = new ExportOdfFromWizardPage(ExportOdfFromWizardPage.class.getName(), this);
        this.addPage((IWizardPage)this.fromPage);
        this.toPage = new ExportOdfToWizardPage(ExportOdfToWizardPage.class.getName(), this);
        this.addPage((IWizardPage)this.toPage);
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.fromPage.getControl(), BrowserUIConstants.PLUGIN_ID + "." + "tools_odfexport_wizard");
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.toPage.getControl(), BrowserUIConstants.PLUGIN_ID + "." + "tools_odfexport_wizard");
    }

    public boolean performFinish() {
        this.fromPage.saveDialogSettings();
        this.toPage.saveDialogSettings();
        boolean exportDn = this.fromPage.isExportDn();
        new StudioBrowserJob(new StudioConnectionRunnableWithProgress[]{new ExportOdfRunnable(this.exportFilename, this.search.getBrowserConnection(), this.search.getSearchParameter(), exportDn)}).execute();
        return true;
    }
}

