/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldifparser;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;

public class LdifUtils {
    public static byte[] utf8encode(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return s.getBytes();
        }
    }

    public static String urlEncode(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return s;
        }
    }

    public static String base64encode(byte[] b) {
        return LdifUtils.utf8decode(Base64.encodeBase64((byte[])b));
    }

    public static String hexEncode(byte[] data) {
        if (data == null) {
            return null;
        }
        char[] c = Hex.encodeHex((byte[])data);
        String s = new String(c);
        return s;
    }

    public static String utf8decode(byte[] b) {
        try {
            return new String(b, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return new String(b);
        }
    }

    public static byte[] base64decodeToByteArray(String s) {
        return Base64.decodeBase64((byte[])LdifUtils.utf8encode(s));
    }

    public static boolean mustEncodeDN(String dn) {
        return LdifUtils.mustEncode(dn);
    }

    public static boolean mustEncode(String value) {
        if (value == null || value.length() < 1) {
            return false;
        }
        if (value.startsWith(" ") || value.startsWith(":") || value.startsWith("<")) {
            return true;
        }
        if (value.endsWith(" ")) {
            return true;
        }
        for (int i = 0; i < value.length(); ++i) {
            if (value.charAt(i) != '\r' && value.charAt(i) != '\n' && value.charAt(i) != '\u0000' && value.charAt(i) <= '\u007f') continue;
            return true;
        }
        return false;
    }
}

