/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldifparser.model.lines;

import org.apache.directory.studio.ldifparser.LdifParserConstants;
import org.apache.directory.studio.ldifparser.LdifUtils;
import org.apache.directory.studio.ldifparser.model.lines.LdifValueLineBase;

public class LdifNewsuperiorLine
extends LdifValueLineBase {
    private static final long serialVersionUID = -8614298286815271694L;

    protected LdifNewsuperiorLine() {
    }

    public LdifNewsuperiorLine(int offset, String rawNewSuperiorSpec, String rawValueType, String rawNewSuperiorDn, String rawNewLine) {
        super(offset, rawNewSuperiorSpec, rawValueType, rawNewSuperiorDn, rawNewLine);
    }

    public String getRawNewSuperiorSpec() {
        return super.getRawLineStart();
    }

    public String getUnfoldedNewSuperiorSpec() {
        return super.getUnfoldedLineStart();
    }

    public String getRawNewSuperiorDn() {
        return super.getRawValue();
    }

    public String getUnfoldedNewSuperiorDn() {
        return super.getUnfoldedValue();
    }

    @Override
    public String toRawString() {
        return super.toRawString();
    }

    @Override
    public boolean isValid() {
        return super.isValid();
    }

    @Override
    public String getInvalidString() {
        if (this.getUnfoldedNewSuperiorSpec().length() == 0) {
            return "Missing new superior spec 'newsuperior'";
        }
        if (this.getUnfoldedNewSuperiorDn().length() == 0) {
            return "Missing new superior Dn";
        }
        return super.getInvalidString();
    }

    public static LdifNewsuperiorLine create(String newsuperior) {
        if (LdifUtils.mustEncode(newsuperior)) {
            return new LdifNewsuperiorLine(0, "newsuperior", "::", LdifUtils.base64encode(LdifUtils.utf8encode(newsuperior)), LdifParserConstants.LINE_SEPARATOR);
        }
        return new LdifNewsuperiorLine(0, "newsuperior", ":", newsuperior, LdifParserConstants.LINE_SEPARATOR);
    }
}

