/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.apacheds.configuration.editor.v155;

import java.util.ArrayList;
import java.util.List;
import org.apache.directory.studio.apacheds.configuration.ApacheDSConfigurationPlugin;
import org.apache.directory.studio.apacheds.configuration.editor.ServerConfigurationEditor;
import org.apache.directory.studio.apacheds.configuration.editor.v155.Messages;
import org.apache.directory.studio.apacheds.configuration.editor.v155.PartitionDetailsPage;
import org.apache.directory.studio.apacheds.configuration.model.v155.IndexedAttribute;
import org.apache.directory.studio.apacheds.configuration.model.v155.Partition;
import org.apache.directory.studio.apacheds.configuration.model.v155.ServerConfigurationV155;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.forms.DetailsPart;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.MasterDetailsBlock;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class PartitionsMasterDetailsBlock
extends MasterDetailsBlock {
    private FormPage page;
    private ServerConfigurationV155 serverConfiguration;
    private List<Partition> partitions;
    private PartitionDetailsPage detailsPage;
    private static final String NEW_ID = Messages.getString("PartitionsMasterDetailsBlock.NewPartition");
    private TableViewer viewer;
    private Button addButton;
    private Button deleteButton;

    public PartitionsMasterDetailsBlock(FormPage page) {
        this.page = page;
        this.serverConfiguration = (ServerConfigurationV155)((ServerConfigurationEditor)page.getEditor()).getServerConfiguration();
        this.partitions = this.serverConfiguration.getPartitions();
    }

    protected void createMasterPart(final IManagedForm managedForm, Composite parent) {
        FormToolkit toolkit = managedForm.getToolkit();
        Section section = toolkit.createSection(parent, 256);
        section.setText(Messages.getString("PartitionsMasterDetailsBlock.AllPartitions"));
        section.marginWidth = 10;
        section.marginHeight = 5;
        Composite client = toolkit.createComposite((Composite)section, 64);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        client.setLayout((Layout)layout);
        toolkit.paintBordersFor(client);
        section.setClient((Control)client);
        Table table = toolkit.createTable(client, 0);
        GridData gd = new GridData(4, 4, true, true, 1, 2);
        gd.heightHint = 20;
        gd.widthHint = 100;
        table.setLayoutData((Object)gd);
        final SectionPart spart = new SectionPart(section);
        managedForm.addPart((IFormPart)spart);
        this.viewer = new TableViewer(table);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                managedForm.fireSelectionChanged((IFormPart)spart, event.getSelection());
            }
        });
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                return ApacheDSConfigurationPlugin.getDefault().getImage(((Partition)element).isSystemPartition() ? "resources/icons/partition_system.gif" : "resources/icons/partition.gif");
            }
        });
        this.addButton = toolkit.createButton(client, Messages.getString("PartitionsMasterDetailsBlock.Add"), 8);
        this.addButton.setLayoutData((Object)new GridData(4, 1, false, false));
        this.deleteButton = toolkit.createButton(client, Messages.getString("PartitionsMasterDetailsBlock.Delete"), 8);
        this.deleteButton.setEnabled(false);
        this.deleteButton.setLayoutData((Object)new GridData(4, 1, false, false));
        this.initFromInput();
        this.addListeners();
    }

    private void initFromInput() {
        this.viewer.setInput(this.partitions);
    }

    private void addListeners() {
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Partition partition;
                PartitionsMasterDetailsBlock.this.viewer.refresh();
                PartitionsMasterDetailsBlock.this.deleteButton.setEnabled(!event.getSelection().isEmpty());
                StructuredSelection selection = (StructuredSelection)PartitionsMasterDetailsBlock.this.viewer.getSelection();
                if (!selection.isEmpty() && (partition = (Partition)selection.getFirstElement()).isSystemPartition()) {
                    PartitionsMasterDetailsBlock.this.deleteButton.setEnabled(false);
                }
            }
        });
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Partition newPartition = new Partition(PartitionsMasterDetailsBlock.this.getNewId());
                newPartition.setCacheSize(100);
                newPartition.setEnableOptimizer(true);
                newPartition.setSynchronizationOnWrite(true);
                ArrayList<IndexedAttribute> indexedAttributes = new ArrayList<IndexedAttribute>();
                indexedAttributes.add(new IndexedAttribute("1.3.6.1.4.1.18060.0.4.1.2.1", 100));
                indexedAttributes.add(new IndexedAttribute("1.3.6.1.4.1.18060.0.4.1.2.2", 100));
                indexedAttributes.add(new IndexedAttribute("1.3.6.1.4.1.18060.0.4.1.2.3", 100));
                indexedAttributes.add(new IndexedAttribute("1.3.6.1.4.1.18060.0.4.1.2.4", 100));
                indexedAttributes.add(new IndexedAttribute("1.3.6.1.4.1.18060.0.4.1.2.5", 10));
                indexedAttributes.add(new IndexedAttribute("1.3.6.1.4.1.18060.0.4.1.2.6", 10));
                indexedAttributes.add(new IndexedAttribute("1.3.6.1.4.1.18060.0.4.1.2.7", 10));
                indexedAttributes.add(new IndexedAttribute("dc", 100));
                indexedAttributes.add(new IndexedAttribute("ou", 100));
                indexedAttributes.add(new IndexedAttribute("krb5PrincipalName", 100));
                indexedAttributes.add(new IndexedAttribute("uid", 100));
                indexedAttributes.add(new IndexedAttribute("objectClass", 100));
                newPartition.setIndexedAttributes(indexedAttributes);
                PartitionsMasterDetailsBlock.this.partitions.add(newPartition);
                PartitionsMasterDetailsBlock.this.viewer.refresh();
                PartitionsMasterDetailsBlock.this.viewer.setSelection((ISelection)new StructuredSelection((Object)newPartition));
                PartitionsMasterDetailsBlock.this.setEditorDirty();
            }
        });
        this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Partition partition;
                StructuredSelection selection = (StructuredSelection)PartitionsMasterDetailsBlock.this.viewer.getSelection();
                if (!selection.isEmpty() && !(partition = (Partition)selection.getFirstElement()).isSystemPartition()) {
                    PartitionsMasterDetailsBlock.this.partitions.remove(partition);
                    PartitionsMasterDetailsBlock.this.viewer.refresh();
                    PartitionsMasterDetailsBlock.this.setEditorDirty();
                }
            }
        });
    }

    private String getNewId() {
        int counter = 1;
        String name = NEW_ID;
        boolean ok = false;
        while (!ok) {
            ok = true;
            name = NEW_ID + counter;
            for (Partition partition : this.partitions) {
                if (!partition.getId().equalsIgnoreCase(name)) continue;
                ok = false;
            }
            ++counter;
        }
        return name;
    }

    protected void createToolBarActions(IManagedForm managedForm) {
        final ScrolledForm form = managedForm.getForm();
        Action horizontalAction = new Action("Horizontal layout", 8){

            public void run() {
                PartitionsMasterDetailsBlock.this.sashForm.setOrientation(256);
                form.reflow(true);
            }
        };
        horizontalAction.setChecked(true);
        horizontalAction.setToolTipText("Horizontal Orientation");
        horizontalAction.setImageDescriptor(ApacheDSConfigurationPlugin.getDefault().getImageDescriptor("resources/icons/horizontal_orientation.gif"));
        Action verticalAction = new Action("Vertical Orientation", 8){

            public void run() {
                PartitionsMasterDetailsBlock.this.sashForm.setOrientation(512);
                form.reflow(true);
            }
        };
        verticalAction.setChecked(false);
        verticalAction.setToolTipText("Vertical Orientation");
        verticalAction.setImageDescriptor(ApacheDSConfigurationPlugin.getDefault().getImageDescriptor("resources/icons/vertical_orientation.gif"));
        form.getToolBarManager().add((IAction)horizontalAction);
        form.getToolBarManager().add((IAction)verticalAction);
    }

    protected void registerPages(DetailsPart detailsPart) {
        this.detailsPage = new PartitionDetailsPage(this);
        detailsPart.registerPage(Partition.class, (IDetailsPage)this.detailsPage);
    }

    public void setEditorDirty() {
        ((ServerConfigurationEditor)this.page.getEditor()).setDirty(true);
    }

    public void save() {
        this.detailsPage.commit(true);
        this.viewer.setInput(this.partitions);
    }
}

