/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.core;

import java.util.List;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.ConnectionServerType;

public class DetectedConnectionProperties {
    public static final String CONNECTION_PARAMETER_VENDOR_NAME = "detectedProperties.vendorName";
    public static final String CONNECTION_PARAMETER_VENDOR_VERSION = "detectedProperties.vendorVersion";
    public static final String CONNECTION_PARAMETER_SERVER_TYPE = "detectedProperties.serverType";
    public static final String CONNECTION_PARAMETER_SUPPORTED_LDAP_VERSIONS = "detectedProperties.supportedLdapVersions";
    public static final String CONNECTION_PARAMETER_SUPPORTED_SASL_MECHANISMS = "detectedProperties.supportedSaslMechanisms";
    public static final String CONNECTION_PARAMETER_SUPPORTED_CONTROLS = "detectedProperties.supportedControls";
    public static final String CONNECTION_PARAMETER_SUPPORTED_EXTENSIONS = "detectedProperties.supportedExtensions";
    public static final String CONNECTION_PARAMETER_SUPPORTED_FEATURES = "detectedProperties.supportedFeatures";
    public Connection connection;

    public DetectedConnectionProperties(Connection connection) {
        this.connection = connection;
    }

    public ConnectionServerType getServerType() {
        try {
            String serverType = this.connection.getConnectionParameter().getExtendedProperty(CONNECTION_PARAMETER_SERVER_TYPE);
            if (serverType != null) {
                return ConnectionServerType.valueOf(serverType);
            }
            return ConnectionServerType.UNKNOWN;
        }
        catch (IllegalArgumentException e) {
            return ConnectionServerType.UNKNOWN;
        }
    }

    public List<String> getSupportedControls() {
        return this.connection.getConnectionParameter().getExtendedListStringProperty(CONNECTION_PARAMETER_SUPPORTED_CONTROLS);
    }

    public List<String> getSupportedExtensions() {
        return this.connection.getConnectionParameter().getExtendedListStringProperty(CONNECTION_PARAMETER_SUPPORTED_EXTENSIONS);
    }

    public List<String> getSupportedFeatures() {
        return this.connection.getConnectionParameter().getExtendedListStringProperty(CONNECTION_PARAMETER_SUPPORTED_FEATURES);
    }

    public List<String> getSupportedLdapVersions() {
        return this.connection.getConnectionParameter().getExtendedListStringProperty(CONNECTION_PARAMETER_SUPPORTED_LDAP_VERSIONS);
    }

    public List<String> getSupportedSaslMechanisms() {
        return this.connection.getConnectionParameter().getExtendedListStringProperty(CONNECTION_PARAMETER_SUPPORTED_SASL_MECHANISMS);
    }

    public String getVendorName() {
        return this.connection.getConnectionParameter().getExtendedProperty(CONNECTION_PARAMETER_VENDOR_NAME);
    }

    public String getVendorVersion() {
        return this.connection.getConnectionParameter().getExtendedProperty(CONNECTION_PARAMETER_VENDOR_VERSION);
    }

    public void setServerType(Object serverType) {
        this.connection.getConnectionParameter().setExtendedProperty(CONNECTION_PARAMETER_SERVER_TYPE, serverType.toString());
    }

    public void setSupportedControls(List<String> supportedControls) {
        this.connection.getConnectionParameter().setExtendedListStringProperty(CONNECTION_PARAMETER_SUPPORTED_CONTROLS, supportedControls);
    }

    public void setSupportedExtensions(List<String> supportedExtensions) {
        this.connection.getConnectionParameter().setExtendedListStringProperty(CONNECTION_PARAMETER_SUPPORTED_EXTENSIONS, supportedExtensions);
    }

    public void setSupportedFeatures(List<String> supportedFeatures) {
        this.connection.getConnectionParameter().setExtendedListStringProperty(CONNECTION_PARAMETER_SUPPORTED_FEATURES, supportedFeatures);
    }

    public void setSupportedLdapVersions(List<String> supportedLdapVersions) {
        this.connection.getConnectionParameter().setExtendedListStringProperty(CONNECTION_PARAMETER_SUPPORTED_LDAP_VERSIONS, supportedLdapVersions);
    }

    public void setSupportedSaslMechanisms(List<String> supportedSaslMechanisms) {
        this.connection.getConnectionParameter().setExtendedListStringProperty(CONNECTION_PARAMETER_SUPPORTED_SASL_MECHANISMS, supportedSaslMechanisms);
    }

    public void setVendorName(String vendorName) {
        this.connection.getConnectionParameter().setExtendedProperty(CONNECTION_PARAMETER_VENDOR_NAME, vendorName);
    }

    public void setVendorVersion(String vendorVersion) {
        this.connection.getConnectionParameter().setExtendedProperty(CONNECTION_PARAMETER_VENDOR_VERSION, vendorVersion);
    }
}

