/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.directory.studio.connection.core.ConnectionCorePlugin;
import org.apache.directory.studio.connection.core.Messages;

public class StudioKeyStoreManager {
    private Type type;
    private String filename;
    private String password;
    private KeyStore memoryKeyStore;

    public static StudioKeyStoreManager createFileKeyStoreManager(String filename, String password) {
        StudioKeyStoreManager manager = new StudioKeyStoreManager(Type.File, filename, password);
        manager.filename = filename;
        manager.password = password;
        return manager;
    }

    public static StudioKeyStoreManager createMemoryKeyStoreManager() {
        StudioKeyStoreManager manager = new StudioKeyStoreManager(Type.Memory, null, null);
        return manager;
    }

    private StudioKeyStoreManager(Type type, String filename, String password) {
        this.type = type;
        this.filename = filename;
        this.password = password;
    }

    public synchronized KeyStore getKeyStore() throws CertificateException {
        if (this.type == Type.File) {
            return this.getFileKeyStore();
        }
        return this.getMemoryKeyStore();
    }

    private KeyStore getMemoryKeyStore() throws CertificateException {
        if (this.memoryKeyStore == null) {
            try {
                this.memoryKeyStore = KeyStore.getInstance("JKS");
                this.memoryKeyStore.load(null, null);
            }
            catch (Exception e) {
                throw new CertificateException(Messages.StudioKeyStoreManager_CantReadTrustStore, e);
            }
        }
        return this.memoryKeyStore;
    }

    private KeyStore getFileKeyStore() throws CertificateException {
        try {
            KeyStore fileKeyStore = KeyStore.getInstance("JKS");
            File file = ConnectionCorePlugin.getDefault().getStateLocation().append(this.filename).toFile();
            if (file.exists() && file.isFile() && file.canRead()) {
                fileKeyStore.load(new FileInputStream(file), this.password.toCharArray());
            } else {
                fileKeyStore.load(null, null);
            }
            return fileKeyStore;
        }
        catch (Exception e) {
            throw new CertificateException(Messages.StudioKeyStoreManager_CantReadTrustStore, e);
        }
    }

    public synchronized void addCertificate(X509Certificate certificate) throws CertificateException {
        if (this.type == Type.File) {
            this.addToFileKeyStore(certificate);
        } else {
            this.addToMemoryKeyStore(certificate);
        }
    }

    private void addToMemoryKeyStore(X509Certificate certificate) throws CertificateException {
        try {
            KeyStore memoryKeyStore = this.getMemoryKeyStore();
            this.addToKeyStore(certificate, memoryKeyStore);
        }
        catch (Exception e) {
            throw new CertificateException(Messages.StudioKeyStoreManager_CantAddCertificateToTrustStore, e);
        }
    }

    private void addToFileKeyStore(X509Certificate certificate) throws CertificateException {
        try {
            KeyStore fileKeyStore = this.getFileKeyStore();
            this.addToKeyStore(certificate, fileKeyStore);
            File file = ConnectionCorePlugin.getDefault().getStateLocation().append(this.filename).toFile();
            fileKeyStore.store(new FileOutputStream(file), this.password.toCharArray());
        }
        catch (Exception e) {
            throw new CertificateException(Messages.StudioKeyStoreManager_CantAddCertificateToTrustStore, e);
        }
    }

    private void addToKeyStore(X509Certificate certificate, KeyStore keyStore) throws Exception {
        byte[] encoded = certificate.getEncoded();
        String shaHex = DigestUtils.shaHex((byte[])encoded);
        keyStore.setCertificateEntry(shaHex, certificate);
    }

    public X509Certificate[] getCertificates() throws CertificateException {
        try {
            ArrayList<X509Certificate> certificateList = new ArrayList<X509Certificate>();
            KeyStore keyStore = this.getKeyStore();
            Enumeration<String> aliases = keyStore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                Certificate certificate = keyStore.getCertificate(alias);
                if (!(certificate instanceof X509Certificate)) continue;
                certificateList.add((X509Certificate)certificate);
            }
            return certificateList.toArray(new X509Certificate[0]);
        }
        catch (KeyStoreException e) {
            throw new CertificateException(Messages.StudioKeyStoreManager_CantReadTrustStore, e);
        }
    }

    public synchronized void removeCertificate(X509Certificate certificate) throws CertificateException {
        if (this.type == Type.File) {
            this.removeFromFileKeyStore(certificate);
        } else {
            this.removeFromMemoryKeyStore(certificate);
        }
    }

    private void removeFromMemoryKeyStore(X509Certificate certificate) throws CertificateException {
        try {
            KeyStore memoryKeyStore = this.getMemoryKeyStore();
            this.removeFromKeyStore(certificate, memoryKeyStore);
        }
        catch (Exception e) {
            throw new CertificateException(Messages.StudioKeyStoreManager_CantRemoveCertificateFromTrustStore, e);
        }
    }

    private void removeFromFileKeyStore(X509Certificate certificate) throws CertificateException {
        try {
            KeyStore fileKeyStore = this.getFileKeyStore();
            this.removeFromKeyStore(certificate, fileKeyStore);
            File file = ConnectionCorePlugin.getDefault().getStateLocation().append(this.filename).toFile();
            fileKeyStore.store(new FileOutputStream(file), this.password.toCharArray());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CertificateException(Messages.StudioKeyStoreManager_CantRemoveCertificateFromTrustStore, e);
        }
    }

    private void removeFromKeyStore(X509Certificate certificate, KeyStore keyStore) throws Exception {
        String alias = keyStore.getCertificateAlias(certificate);
        if (alias != null) {
            keyStore.deleteEntry(alias);
        }
    }

    public static enum Type {
        File,
        Memory;

    }
}

