/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.core.jobs;

import org.apache.directory.studio.common.core.jobs.StudioJob;
import org.apache.directory.studio.common.core.jobs.StudioProgressMonitor;
import org.apache.directory.studio.common.core.jobs.StudioRunnableWithProgress;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.ConnectionCorePlugin;
import org.apache.directory.studio.connection.core.IConnectionListener;
import org.apache.directory.studio.connection.core.Messages;
import org.apache.directory.studio.connection.core.event.ConnectionEventRegistry;
import org.apache.directory.studio.connection.core.jobs.StudioConnectionBulkRunnableWithProgress;
import org.apache.directory.studio.connection.core.jobs.StudioConnectionRunnableWithProgress;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class StudioConnectionJob
extends StudioJob<StudioConnectionRunnableWithProgress> {
    public StudioConnectionJob(StudioConnectionRunnableWithProgress ... runnables) {
        super((StudioRunnableWithProgress[])runnables);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus run(IProgressMonitor ipm) {
        StudioProgressMonitor monitor = new StudioProgressMonitor(ipm);
        for (StudioConnectionRunnableWithProgress runnable : (StudioConnectionRunnableWithProgress[])this.runnables) {
            Connection[] connections = runnable.getConnections();
            if (connections == null) continue;
            for (Connection connection : connections) {
                if (connection == null || connection.getConnectionWrapper().isConnected()) continue;
                monitor.setTaskName(Messages.bind((String)Messages.jobs__open_connections_task, (Object[])new String[]{connection.getName()}));
                monitor.worked(1);
                connection.getConnectionWrapper().connect(monitor);
                if (connection.getConnectionWrapper().isConnected()) {
                    connection.getConnectionWrapper().bind(monitor);
                }
                if (!connection.getConnectionWrapper().isConnected()) continue;
                for (IConnectionListener listener : ConnectionCorePlugin.getDefault().getConnectionListeners()) {
                    listener.connectionOpened(connection, monitor);
                }
                ConnectionEventRegistry.fireConnectionOpened(connection, (Object)this);
            }
        }
        if (!monitor.errorsReported()) {
            try {
                for (StudioConnectionRunnableWithProgress runnable : (StudioConnectionRunnableWithProgress[])this.runnables) {
                    if (runnable instanceof StudioConnectionBulkRunnableWithProgress) {
                        StudioConnectionBulkRunnableWithProgress bulkRunnable = (StudioConnectionBulkRunnableWithProgress)runnable;
                        this.suspendEventFiringInCurrentThread();
                        try {
                            bulkRunnable.run(monitor);
                        }
                        finally {
                            this.resumeEventFiringInCurrentThread();
                        }
                        bulkRunnable.runNotification(monitor);
                        continue;
                    }
                    runnable.run(monitor);
                }
            }
            catch (Exception e) {
                monitor.reportError(e);
            }
        }
        monitor.done();
        ipm.done();
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        if (monitor.errorsReported()) {
            return monitor.getErrorStatus(((StudioConnectionRunnableWithProgress[])this.runnables)[0].getErrorMessage());
        }
        return Status.OK_STATUS;
    }

    protected void suspendEventFiringInCurrentThread() {
        ConnectionEventRegistry.suspendEventFiringInCurrentThread();
    }

    protected void resumeEventFiringInCurrentThread() {
        ConnectionEventRegistry.resumeEventFiringInCurrentThread();
    }

    public boolean shouldSchedule() {
        for (StudioConnectionRunnableWithProgress runnable : (StudioConnectionRunnableWithProgress[])this.runnables) {
            Object[] myLockedObjects = runnable.getLockedObjects();
            String[] myLockedObjectsIdentifiers = this.getLockIdentifiers(myLockedObjects);
            Job[] jobs = StudioConnectionJob.getJobManager().find(null);
            for (int i = 0; i < jobs.length; ++i) {
                Job job = jobs[i];
                if (!(job instanceof StudioConnectionJob)) continue;
                StudioConnectionJob otherJob = (StudioConnectionJob)job;
                for (StudioConnectionRunnableWithProgress otherRunnable : (StudioConnectionRunnableWithProgress[])otherJob.runnables) {
                    if (runnable.getClass() != otherRunnable.getClass() || runnable == otherRunnable) continue;
                    Object[] otherLockedObjects = otherRunnable.getLockedObjects();
                    String[] otherLockedObjectIdentifiers = this.getLockIdentifiers(otherLockedObjects);
                    for (int j = 0; j < otherLockedObjectIdentifiers.length; ++j) {
                        String other = otherLockedObjectIdentifiers[j];
                        for (int k = 0; k < myLockedObjectsIdentifiers.length; ++k) {
                            String my = myLockedObjectsIdentifiers[k];
                            if (!other.startsWith(my) && !my.startsWith(other)) continue;
                            return false;
                        }
                    }
                }
            }
        }
        return super.shouldSchedule();
    }

    protected String[] getLockIdentifiers(Object[] objects) {
        String[] identifiers = new String[objects.length];
        for (int i = 0; i < identifiers.length; ++i) {
            Object o = objects[i];
            identifiers[i] = o instanceof Connection ? this.getLockIdentifier((Connection)o) : this.getLockIdentifier(objects[i]);
        }
        return identifiers;
    }

    private String getLockIdentifier(Connection connection) {
        return connection.getHost() + ':' + connection.getPort();
    }

    private String getLockIdentifier(Object object) {
        String s = object != null ? object.toString() : "null";
        s = '-' + s;
        return s;
    }
}

