/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.apacheds.configuration.v2;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.ldif.LdifEntry;
import org.apache.directory.api.ldap.model.ldif.LdifReader;
import org.apache.directory.api.ldap.model.name.Dn;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.ITextContentDescriber;

public class ApacheDS2ConfigurationContentDescriber
implements ITextContentDescriber {
    private static final int MAX_NUMBER_ENTRIES_SEARCH = 10;
    private Dn configEntryDn;
    private Dn directoryServiceDn;

    public ApacheDS2ConfigurationContentDescriber() {
        try {
            this.configEntryDn = new Dn(new String[]{"ou=config"});
            this.directoryServiceDn = new Dn(new String[]{"ads-directoryServiceId=default,ou=config"});
        }
        catch (LdapInvalidDnException ldapInvalidDnException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int describe(Reader contents, IContentDescription description) throws IOException {
        LdifReader reader = null;
        try {
            reader = new LdifReader(contents);
            int n = this.isValid(reader);
            return n;
        }
        catch (LdapException e) {
            int n = 0;
            return n;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int describe(InputStream contents, IContentDescription description) throws IOException {
        LdifReader reader = null;
        try {
            reader = new LdifReader(contents);
            int n = this.isValid(reader);
            return n;
        }
        catch (LdapException e) {
            int n = 0;
            return n;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    public QualifiedName[] getSupportedOptions() {
        return new QualifiedName[0];
    }

    private int isValid(LdifReader reader) {
        boolean configEntryFound = false;
        boolean directoryServiceEntryFound = false;
        for (int checkedEntries = 0; !(!reader.hasNext() || checkedEntries >= 10 || configEntryFound && directoryServiceEntryFound); ++checkedEntries) {
            LdifEntry entry = reader.next();
            if (configEntryFound || !this.configEntryDn.getName().equalsIgnoreCase(entry.getDn().getNormName())) continue;
            configEntryFound = true;
        }
        if (configEntryFound && directoryServiceEntryFound) {
            return 2;
        }
        return 0;
    }
}

