/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.apacheds.configuration.v2.dialogs;

import org.apache.directory.studio.apacheds.configuration.v2.dialogs.Messages;
import org.apache.directory.studio.common.ui.widgets.BaseWidgetUtils;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class AttributeDialog
extends Dialog {
    private String[] attributeTypesAndOids;
    private String attribute;
    private Combo typeOrOidCombo;
    private Button okButton;

    public AttributeDialog(Shell parentShell, String attribute, String[] attributeNamesAndOids) {
        super(parentShell);
        this.attribute = attribute;
        this.attributeTypesAndOids = attributeNamesAndOids;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.getString("AttributeDialog.SelectAttributeTypeOrOID"));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.validate();
    }

    protected void okPressed() {
        this.attribute = this.typeOrOidCombo.getText();
        super.okPressed();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite c = BaseWidgetUtils.createColumnContainer((Composite)composite, (int)2, (int)1);
        BaseWidgetUtils.createLabel((Composite)c, (String)Messages.getString("AttributeDialog.AttributeTypeOrOID"), (int)1);
        this.typeOrOidCombo = BaseWidgetUtils.createCombo((Composite)c, (String[])this.attributeTypesAndOids, (int)-1, (int)1);
        if (this.attribute != null) {
            this.typeOrOidCombo.setText(this.attribute);
        }
        this.typeOrOidCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AttributeDialog.this.validate();
            }
        });
        return composite;
    }

    private void validate() {
        this.okButton.setEnabled(!"".equals(this.typeOrOidCombo.getText()));
    }

    public String getAttribute() {
        return this.attribute;
    }
}

