/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.apacheds.configuration.v2.dialogs;

import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.server.config.beans.JdbmIndexBean;
import org.apache.directory.studio.apacheds.configuration.v2.dialogs.Messages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class IndexDialog
extends Dialog {
    private JdbmIndexBean<String, Entry> index;
    private boolean dirty = false;
    private Text attributeIdText;
    private Text cacheSizeText;

    public IndexDialog(JdbmIndexBean<String, Entry> index) {
        super(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        this.index = index;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.getString("IndexDialog.IndexedAttributeDialog"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Label attributeIdLabel = new Label(composite, 0);
        attributeIdLabel.setText(Messages.getString("IndexDialog.AttributeID"));
        this.attributeIdText = new Text(composite, 2048);
        this.attributeIdText.setLayoutData((Object)new GridData(4, 0, true, false));
        Label cacheSizeLabel = new Label(composite, 0);
        cacheSizeLabel.setText(Messages.getString("IndexDialog.CacheSize"));
        this.cacheSizeText = new Text(composite, 2048);
        this.cacheSizeText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (!e.text.matches("[0-9]*")) {
                    e.doit = false;
                }
            }
        });
        this.cacheSizeText.setLayoutData((Object)new GridData(4, 0, true, false));
        this.initFromInput();
        this.addListeners();
        return composite;
    }

    private void initFromInput() {
        String attributeId = this.index.getIndexAttributeId();
        this.attributeIdText.setText(attributeId == null ? "" : attributeId);
        this.cacheSizeText.setText("" + this.index.getIndexCacheSize());
    }

    private void addListeners() {
        this.attributeIdText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                IndexDialog.this.dirty = true;
            }
        });
        this.cacheSizeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                IndexDialog.this.dirty = true;
            }
        });
    }

    protected void okPressed() {
        this.index.setIndexAttributeId(this.attributeIdText.getText());
        try {
            this.index.setIndexCacheSize(Integer.parseInt(this.cacheSizeText.getText()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        super.okPressed();
    }

    public JdbmIndexBean<String, Entry> getIndex() {
        return this.index;
    }

    public boolean isDirty() {
        return this.dirty;
    }
}

