/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.apacheds.configuration.v2.editor;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.DefaultAttribute;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.ldif.LdifEntry;
import org.apache.directory.api.ldap.model.ldif.LdifReader;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.server.config.beans.IndexBean;
import org.apache.directory.server.config.beans.JdbmIndexBean;
import org.apache.directory.server.config.beans.JdbmPartitionBean;
import org.apache.directory.server.config.beans.PartitionBean;
import org.apache.directory.studio.apacheds.configuration.v2.ApacheDS2ConfigurationPlugin;
import org.apache.directory.studio.apacheds.configuration.v2.dialogs.AttributeValueDialog;
import org.apache.directory.studio.apacheds.configuration.v2.dialogs.IndexDialog;
import org.apache.directory.studio.apacheds.configuration.v2.editor.AttributeValueObject;
import org.apache.directory.studio.apacheds.configuration.v2.editor.Messages;
import org.apache.directory.studio.apacheds.configuration.v2.editor.PartitionsMasterDetailsBlock;
import org.apache.directory.studio.apacheds.configuration.v2.editor.PartitionsPage;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class PartitionDetailsPage
implements IDetailsPage {
    private PartitionsMasterDetailsBlock masterDetailsBlock;
    private IManagedForm mform;
    private JdbmPartitionBean input;
    private Entry contextEntry;
    private List<IndexBean> indexesList;
    private Text idText;
    private Text cacheSizeText;
    private Text suffixText;
    private Button enableOptimizerCheckbox;
    private Button synchOnWriteCheckbox;
    private Button autoGenerateContextEntryCheckbox;
    private TableViewer contextEntryTableViewer;
    private Button contextEntryAddButton;
    private Button contextEntryEditButton;
    private Button contextEntryDeleteButton;
    private TableViewer indexesTableViewer;
    private Button indexesAddButton;
    private Button indexesEditButton;
    private Button indexesDeleteButton;
    private ModifyListener textModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            PartitionDetailsPage.this.commit(true);
            PartitionDetailsPage.this.masterDetailsBlock.setEditorDirty();
        }
    };
    private ModifyListener suffixTextModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            PartitionDetailsPage.this.autoGenerateContextEntry();
        }
    };
    private SelectionListener checkboxSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            PartitionDetailsPage.this.commit(true);
            PartitionDetailsPage.this.masterDetailsBlock.setEditorDirty();
        }
    };
    private SelectionListener autoGenerateContextEntryCheckboxSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            PartitionDetailsPage.this.autoGenerateContextEntry();
            PartitionDetailsPage.this.updateContextEntryEnableState();
        }
    };
    private ISelectionChangedListener contextEntryTableViewerSelectionListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            PartitionDetailsPage.this.updateContextEntryEnableState();
        }
    };
    private IDoubleClickListener contextEntryTableViewerDoubleClickListener = new IDoubleClickListener(){

        public void doubleClick(DoubleClickEvent event) {
            PartitionDetailsPage.this.editSelectedContextEntry();
        }
    };
    private SelectionListener contextEntryAddButtonListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            AttributeValueDialog dialog = new AttributeValueDialog(new AttributeValueObject("", ""));
            if (0 == dialog.open() && dialog.isDirty()) {
                AttributeValueObject newAttributeValueObject = dialog.getAttributeValueObject();
                Attribute attribute = PartitionDetailsPage.this.contextEntry.get(newAttributeValueObject.getAttribute());
                if (attribute != null) {
                    try {
                        attribute.add(new String[]{newAttributeValueObject.getValue()});
                    }
                    catch (LdapInvalidAttributeValueException liave) {}
                } else {
                    try {
                        PartitionDetailsPage.this.contextEntry.put(new Attribute[]{new DefaultAttribute(newAttributeValueObject.getAttribute(), new String[]{newAttributeValueObject.getValue()})});
                    }
                    catch (LdapException e1) {
                        // empty catch block
                    }
                }
                PartitionDetailsPage.this.contextEntryTableViewer.refresh();
                PartitionDetailsPage.this.resizeContextEntryTableColumnsToFit();
                PartitionDetailsPage.this.masterDetailsBlock.setEditorDirty();
                PartitionDetailsPage.this.commit(true);
            }
        }
    };
    private SelectionListener contextEntryEditButtonListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            PartitionDetailsPage.this.editSelectedContextEntry();
        }
    };
    private SelectionListener contextEntryDeleteButtonListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            StructuredSelection selection = (StructuredSelection)PartitionDetailsPage.this.contextEntryTableViewer.getSelection();
            if (!selection.isEmpty()) {
                AttributeValueObject attributeValueObject = (AttributeValueObject)selection.getFirstElement();
                Attribute attribute = PartitionDetailsPage.this.contextEntry.get(attributeValueObject.getAttribute());
                if (attribute != null) {
                    attribute.remove(new String[]{attributeValueObject.getValue()});
                    PartitionDetailsPage.this.contextEntryTableViewer.refresh();
                    PartitionDetailsPage.this.resizeContextEntryTableColumnsToFit();
                    PartitionDetailsPage.this.masterDetailsBlock.setEditorDirty();
                    PartitionDetailsPage.this.commit(true);
                }
            }
        }
    };
    private ISelectionChangedListener indexedAttributesTableViewerListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            PartitionDetailsPage.this.indexesEditButton.setEnabled(!event.getSelection().isEmpty());
            PartitionDetailsPage.this.indexesDeleteButton.setEnabled(!event.getSelection().isEmpty());
        }
    };
    private IDoubleClickListener indexedAttributesTableViewerDoubleClickListener = new IDoubleClickListener(){

        public void doubleClick(DoubleClickEvent event) {
            PartitionDetailsPage.this.editSelectedIndex();
        }
    };
    private SelectionListener indexedAttributeAddButtonListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            PartitionDetailsPage.this.addNewIndex();
        }
    };
    private SelectionListener indexedAttributeEditButtonListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            PartitionDetailsPage.this.editSelectedIndex();
        }
    };
    private SelectionListener indexedAttributeDeleteButtonListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            PartitionDetailsPage.this.deleteSelectedIndex();
        }
    };

    public PartitionDetailsPage(PartitionsMasterDetailsBlock pmdb) {
        this.masterDetailsBlock = pmdb;
    }

    public void createContents(Composite parent) {
        FormToolkit toolkit = this.mform.getToolkit();
        TableWrapLayout layout = new TableWrapLayout();
        layout.topMargin = 5;
        layout.leftMargin = 5;
        layout.rightMargin = 2;
        layout.bottomMargin = 2;
        parent.setLayout((Layout)layout);
        this.createDetailsSection(parent, toolkit);
        this.createContextEntrySection(parent, toolkit);
        this.createIndexesSection(parent, toolkit);
    }

    private void createDetailsSection(Composite parent, FormToolkit toolkit) {
        Section section = toolkit.createSection(parent, 384);
        section.marginWidth = 10;
        section.setText(Messages.getString("PartitionDetailsPage.PartitionsDetails"));
        section.setDescription(Messages.getString("PartitionDetailsPage.SetPropertiesOfPartition"));
        TableWrapData td = new TableWrapData(128, 16);
        td.grabHorizontal = true;
        section.setLayoutData((Object)td);
        Composite client = toolkit.createComposite((Composite)section);
        toolkit.paintBordersFor(client);
        GridLayout glayout = new GridLayout(3, false);
        client.setLayout((Layout)glayout);
        section.setClient((Control)client);
        toolkit.createLabel(client, Messages.getString("PartitionDetailsPage.Id"));
        this.idText = toolkit.createText(client, "");
        this.idText.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        toolkit.createLabel(client, Messages.getString("PartitionDetailsPage.CacheSize"));
        this.cacheSizeText = toolkit.createText(client, "");
        this.cacheSizeText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (!e.text.matches("[0-9]*")) {
                    e.doit = false;
                }
            }
        });
        this.cacheSizeText.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        toolkit.createLabel(client, "Suffix:");
        this.suffixText = toolkit.createText(client, "");
        this.suffixText.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        this.enableOptimizerCheckbox = toolkit.createButton(client, Messages.getString("PartitionDetailsPage.EnableOptimzer"), 32);
        this.enableOptimizerCheckbox.setLayoutData((Object)new GridData(4, 0, true, false, 3, 1));
        this.synchOnWriteCheckbox = toolkit.createButton(client, Messages.getString("PartitionDetailsPage.SynchronizationOnWrite"), 32);
        this.synchOnWriteCheckbox.setLayoutData((Object)new GridData(4, 0, true, false, 3, 1));
    }

    private void createContextEntrySection(Composite parent, FormToolkit toolkit) {
        Section section = toolkit.createSection(parent, 384);
        section.marginWidth = 10;
        section.setText("Context Entry");
        section.setDescription("Set the attribute/value pairs for the Context Entry of the partition.");
        section.setLayoutData((Object)new TableWrapData(128));
        Composite client = toolkit.createComposite((Composite)section);
        toolkit.paintBordersFor(client);
        client.setLayout((Layout)new GridLayout(2, false));
        section.setClient((Control)client);
        this.autoGenerateContextEntryCheckbox = toolkit.createButton(client, Messages.getString("PartitionDetailsPage.AutoGenerateContextEntryFromSuffixDn"), 32);
        this.autoGenerateContextEntryCheckbox.setLayoutData((Object)new GridData(4, 0, true, false, 3, 1));
        Table contextEntryTable = toolkit.createTable(client, 0);
        GridData gd = new GridData(4, 0, true, false, 1, 3);
        gd.heightHint = 62;
        gd.widthHint = 50;
        contextEntryTable.setLayoutData((Object)gd);
        TableColumn idColumn = new TableColumn(contextEntryTable, 16384, 0);
        idColumn.setText(Messages.getString("PartitionDetailsPage.Attribute"));
        idColumn.setWidth(100);
        TableColumn valueColumn = new TableColumn(contextEntryTable, 16384, 1);
        valueColumn.setText(Messages.getString("PartitionDetailsPage.Value"));
        valueColumn.setWidth(100);
        contextEntryTable.setHeaderVisible(true);
        this.contextEntryTableViewer = new TableViewer(contextEntryTable);
        this.contextEntryTableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                ArrayList<AttributeValueObject> elements = new ArrayList<AttributeValueObject>();
                Entry entry = (Entry)inputElement;
                for (Attribute attribute : entry) {
                    for (Value value : attribute) {
                        elements.add(new AttributeValueObject(attribute.getId(), value.getString()));
                    }
                }
                return elements.toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.contextEntryTableViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public String getColumnText(Object element, int columnIndex) {
                if (element != null) {
                    switch (columnIndex) {
                        case 0: {
                            return ((AttributeValueObject)element).getAttribute();
                        }
                        case 1: {
                            return ((AttributeValueObject)element).getValue().toString();
                        }
                    }
                }
                return null;
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        GridData buttonsGD = new GridData(4, 1, false, false);
        buttonsGD.widthHint = 61;
        this.contextEntryAddButton = toolkit.createButton(client, Messages.getString("PartitionDetailsPage.Add"), 8);
        this.contextEntryAddButton.setLayoutData((Object)buttonsGD);
        this.contextEntryEditButton = toolkit.createButton(client, Messages.getString("PartitionDetailsPage.Edit"), 8);
        this.contextEntryEditButton.setEnabled(false);
        this.contextEntryEditButton.setLayoutData((Object)buttonsGD);
        this.contextEntryDeleteButton = toolkit.createButton(client, Messages.getString("PartitionDetailsPage.Delete"), 8);
        this.contextEntryDeleteButton.setEnabled(false);
        this.contextEntryDeleteButton.setLayoutData((Object)buttonsGD);
    }

    private void updateContextEntryEnableState() {
        this.contextEntryTableViewer.getTable().setEnabled(!this.autoGenerateContextEntryCheckbox.getSelection());
        this.contextEntryAddButton.setEnabled(!this.autoGenerateContextEntryCheckbox.getSelection());
        this.contextEntryEditButton.setEnabled(!this.autoGenerateContextEntryCheckbox.getSelection() && !this.contextEntryTableViewer.getSelection().isEmpty());
        this.contextEntryDeleteButton.setEnabled(!this.autoGenerateContextEntryCheckbox.getSelection() && !this.contextEntryTableViewer.getSelection().isEmpty());
    }

    private void createIndexesSection(Composite parent, FormToolkit toolkit) {
        Section indexedAttributesSection = toolkit.createSection(parent, 384);
        indexedAttributesSection.marginWidth = 10;
        indexedAttributesSection.setText(Messages.getString("PartitionDetailsPage.IndexedAttributes"));
        indexedAttributesSection.setDescription(Messages.getString("PartitionDetailsPage.SetIndexedAttributesOfPartition"));
        indexedAttributesSection.setLayoutData((Object)new TableWrapData(128));
        Composite indexedAttributesClient = toolkit.createComposite((Composite)indexedAttributesSection);
        toolkit.paintBordersFor(indexedAttributesClient);
        indexedAttributesClient.setLayout((Layout)new GridLayout(2, false));
        indexedAttributesSection.setClient((Control)indexedAttributesClient);
        Table indexedAttributesTable = toolkit.createTable(indexedAttributesClient, 0);
        GridData gd = new GridData(4, 0, true, false, 1, 3);
        gd.heightHint = 80;
        indexedAttributesTable.setLayoutData((Object)gd);
        this.indexesTableViewer = new TableViewer(indexedAttributesTable);
        this.indexesTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.indexesTableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof JdbmIndexBean) {
                    JdbmIndexBean jdbmIndexBean = (JdbmIndexBean)element;
                    return NLS.bind((String)Messages.getString("PartitionDetailsPage.IndexAttributeIdAndCacheSize"), (Object)jdbmIndexBean.getIndexAttributeId(), (Object)jdbmIndexBean.getIndexCacheSize());
                }
                return super.getText(element);
            }

            public Image getImage(Object element) {
                if (element instanceof JdbmIndexBean) {
                    return ApacheDS2ConfigurationPlugin.getDefault().getImage("resources/icons/index.png");
                }
                return super.getImage(element);
            }
        });
        this.indexesAddButton = toolkit.createButton(indexedAttributesClient, Messages.getString("PartitionDetailsPage.Add"), 8);
        this.indexesAddButton.setLayoutData((Object)this.createNewButtonGridData());
        this.indexesEditButton = toolkit.createButton(indexedAttributesClient, Messages.getString("PartitionDetailsPage.Edit"), 8);
        this.indexesEditButton.setEnabled(false);
        this.indexesEditButton.setLayoutData((Object)this.createNewButtonGridData());
        this.indexesDeleteButton = toolkit.createButton(indexedAttributesClient, Messages.getString("PartitionDetailsPage.Delete"), 8);
        this.indexesDeleteButton.setEnabled(false);
        this.indexesDeleteButton.setLayoutData((Object)this.createNewButtonGridData());
    }

    private GridData createNewButtonGridData() {
        GridData gd = new GridData(4, 1, false, false);
        gd.widthHint = 61;
        return gd;
    }

    private void addListeners() {
        this.idText.addModifyListener(this.textModifyListener);
        this.cacheSizeText.addModifyListener(this.textModifyListener);
        this.suffixText.addModifyListener(this.textModifyListener);
        this.suffixText.addModifyListener(this.suffixTextModifyListener);
        this.enableOptimizerCheckbox.addSelectionListener(this.checkboxSelectionListener);
        this.synchOnWriteCheckbox.addSelectionListener(this.checkboxSelectionListener);
        this.autoGenerateContextEntryCheckbox.addSelectionListener(this.autoGenerateContextEntryCheckboxSelectionListener);
        this.contextEntryTableViewer.addDoubleClickListener(this.contextEntryTableViewerDoubleClickListener);
        this.contextEntryTableViewer.addSelectionChangedListener(this.contextEntryTableViewerSelectionListener);
        this.contextEntryAddButton.addSelectionListener(this.contextEntryAddButtonListener);
        this.contextEntryEditButton.addSelectionListener(this.contextEntryEditButtonListener);
        this.contextEntryDeleteButton.addSelectionListener(this.contextEntryDeleteButtonListener);
        this.indexesTableViewer.addSelectionChangedListener(this.indexedAttributesTableViewerListener);
        this.indexesTableViewer.addDoubleClickListener(this.indexedAttributesTableViewerDoubleClickListener);
        this.indexesAddButton.addSelectionListener(this.indexedAttributeAddButtonListener);
        this.indexesEditButton.addSelectionListener(this.indexedAttributeEditButtonListener);
        this.indexesDeleteButton.addSelectionListener(this.indexedAttributeDeleteButtonListener);
    }

    private void removeListeners() {
        this.idText.removeModifyListener(this.textModifyListener);
        this.cacheSizeText.removeModifyListener(this.textModifyListener);
        this.suffixText.removeModifyListener(this.textModifyListener);
        this.suffixText.removeModifyListener(this.suffixTextModifyListener);
        this.enableOptimizerCheckbox.removeSelectionListener(this.checkboxSelectionListener);
        this.synchOnWriteCheckbox.removeSelectionListener(this.checkboxSelectionListener);
        this.autoGenerateContextEntryCheckbox.removeSelectionListener(this.autoGenerateContextEntryCheckboxSelectionListener);
        this.contextEntryTableViewer.removeDoubleClickListener(this.contextEntryTableViewerDoubleClickListener);
        this.contextEntryTableViewer.removeSelectionChangedListener(this.contextEntryTableViewerSelectionListener);
        this.contextEntryAddButton.removeSelectionListener(this.contextEntryAddButtonListener);
        this.contextEntryEditButton.removeSelectionListener(this.contextEntryEditButtonListener);
        this.contextEntryDeleteButton.removeSelectionListener(this.contextEntryDeleteButtonListener);
        this.indexesTableViewer.removeSelectionChangedListener(this.indexedAttributesTableViewerListener);
        this.indexesTableViewer.removeDoubleClickListener(this.indexedAttributesTableViewerDoubleClickListener);
        this.indexesAddButton.removeSelectionListener(this.indexedAttributeAddButtonListener);
        this.indexesEditButton.removeSelectionListener(this.indexedAttributeEditButtonListener);
        this.indexesDeleteButton.removeSelectionListener(this.indexedAttributeDeleteButtonListener);
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        IStructuredSelection ssel = (IStructuredSelection)selection;
        this.input = ssel.size() == 1 ? (JdbmPartitionBean)ssel.getFirstElement() : null;
        this.refresh();
    }

    public void commit(boolean onSave) {
        if (this.input != null) {
            this.input.setPartitionId(this.idText.getText());
            this.input.setPartitionCacheSize(Integer.parseInt(this.cacheSizeText.getText()));
            try {
                this.input.setPartitionSuffix(new Dn(new String[]{this.suffixText.getText()}));
            }
            catch (LdapInvalidDnException e) {
                // empty catch block
            }
            this.input.setJdbmPartitionOptimizerEnabled(this.enableOptimizerCheckbox.getSelection());
            this.input.setPartitionSyncOnWrite(this.synchOnWriteCheckbox.getSelection());
            if (this.contextEntry.size() > 0) {
                LdifEntry ldifEntry = new LdifEntry(this.contextEntry);
                ldifEntry.setDn(this.input.getPartitionSuffix());
                this.input.setContextEntry(ldifEntry.toString());
            } else {
                this.input.setContextEntry(null);
            }
        }
    }

    public void dispose() {
    }

    public void initialize(IManagedForm form) {
        this.mform = form;
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isStale() {
        return false;
    }

    public void refresh() {
        this.removeListeners();
        boolean isSystemPartition = PartitionsPage.isSystemPartition((PartitionBean)this.input);
        String id = this.input.getPartitionId();
        this.idText.setText(id == null ? "" : id);
        this.idText.setEnabled(!isSystemPartition);
        this.cacheSizeText.setText("" + this.input.getPartitionCacheSize());
        Dn suffix = this.input.getPartitionSuffix();
        this.suffixText.setText(suffix == null ? "" : suffix.toString());
        this.suffixText.setEnabled(!isSystemPartition);
        this.enableOptimizerCheckbox.setSelection(this.input.isJdbmPartitionOptimizerEnabled());
        this.synchOnWriteCheckbox.setSelection(this.input.isPartitionSyncOnWrite());
        this.autoGenerateContextEntryCheckbox.setSelection(true);
        this.refreshContextEntry();
        this.indexesList = this.input.getIndexes();
        this.indexesTableViewer.setInput(this.indexesList);
        this.addListeners();
    }

    private void refreshContextEntry() {
        String contextEntryString = this.input.getContextEntry();
        if (contextEntryString != null && !"".equals(contextEntryString)) {
            try {
                contextEntryString = contextEntryString.replaceAll("\\\\n", "\n");
                LdifReader reader = new LdifReader((Reader)new StringReader(contextEntryString));
                this.contextEntry = reader.next().getEntry();
                reader.close();
            }
            catch (Exception e) {
                this.contextEntry = new DefaultEntry();
            }
        } else {
            this.contextEntry = new DefaultEntry();
        }
        this.contextEntryTableViewer.setInput((Object)this.contextEntry);
        this.resizeContextEntryTableColumnsToFit();
        boolean enabled = !this.autoGenerateContextEntryCheckbox.getSelection();
        this.contextEntryTableViewer.getTable().setEnabled(enabled);
        this.contextEntryAddButton.setEnabled(enabled);
        this.contextEntryEditButton.setEnabled(enabled);
        this.contextEntryDeleteButton.setEnabled(enabled);
    }

    private void autoGenerateContextEntry() {
        if (this.autoGenerateContextEntryCheckbox.getSelection()) {
            try {
                Dn suffixDn = new Dn(new String[]{this.suffixText.getText()});
                this.input.setContextEntry(PartitionsMasterDetailsBlock.getContextEntryLdif(suffixDn));
                this.refreshContextEntry();
            }
            catch (LdapInvalidDnException ldapInvalidDnException) {
                // empty catch block
            }
        }
    }

    private void resizeContextEntryTableColumnsToFit() {
        this.contextEntryTableViewer.getTable().getColumn(0).pack();
        this.contextEntryTableViewer.getTable().getColumn(0).setWidth(this.contextEntryTableViewer.getTable().getColumn(0).getWidth() + 5);
        this.contextEntryTableViewer.getTable().getColumn(1).pack();
    }

    public void setFocus() {
        this.idText.setFocus();
    }

    public boolean setFormInput(Object input) {
        return false;
    }

    private void editSelectedIndex() {
        JdbmIndexBean index;
        IndexDialog dialog;
        StructuredSelection selection = (StructuredSelection)this.indexesTableViewer.getSelection();
        if (!selection.isEmpty() && 0 == (dialog = new IndexDialog((JdbmIndexBean<String, Entry>)(index = (JdbmIndexBean)selection.getFirstElement()))).open() && dialog.isDirty()) {
            this.indexesTableViewer.refresh();
            this.masterDetailsBlock.setEditorDirty();
        }
    }

    private void addNewIndex() {
        JdbmIndexBean newIndex = new JdbmIndexBean();
        newIndex.setIndexAttributeId("");
        newIndex.setIndexCacheSize(100);
        IndexDialog dialog = new IndexDialog((JdbmIndexBean<String, Entry>)newIndex);
        if (0 == dialog.open()) {
            this.indexesList.add((IndexBean)dialog.getIndex());
            this.indexesTableViewer.refresh();
            this.indexesTableViewer.setSelection((ISelection)new StructuredSelection(dialog.getIndex()));
            this.masterDetailsBlock.setEditorDirty();
        }
    }

    private void deleteSelectedIndex() {
        StructuredSelection selection = (StructuredSelection)this.indexesTableViewer.getSelection();
        if (!selection.isEmpty()) {
            JdbmIndexBean selectedIndex = (JdbmIndexBean)selection.getFirstElement();
            if (MessageDialog.openConfirm((Shell)this.mform.getForm().getShell(), (String)Messages.getString("PartitionDetailsPage.ConfirmDelete"), (String)NLS.bind((String)Messages.getString("PartitionDetailsPage.AreYouSureDeleteIndex"), (Object)selectedIndex.getIndexAttributeId()))) {
                this.indexesList.remove(selectedIndex);
                this.indexesTableViewer.refresh();
                this.masterDetailsBlock.setEditorDirty();
            }
        }
    }

    private void editSelectedContextEntry() {
        StructuredSelection selection = (StructuredSelection)this.contextEntryTableViewer.getSelection();
        if (!selection.isEmpty()) {
            AttributeValueObject attributeValueObject = (AttributeValueObject)selection.getFirstElement();
            String oldId = attributeValueObject.getAttribute();
            String oldValue = attributeValueObject.getValue();
            AttributeValueDialog dialog = new AttributeValueDialog(attributeValueObject);
            if (0 == dialog.open() && dialog.isDirty()) {
                AttributeValueObject newAttributeValueObject;
                Attribute attribute = this.contextEntry.get(oldId);
                if (attribute != null) {
                    attribute.remove(new String[]{oldValue});
                }
                if ((attribute = this.contextEntry.get((newAttributeValueObject = dialog.getAttributeValueObject()).getAttribute())) != null) {
                    try {
                        attribute.add(new String[]{newAttributeValueObject.getValue()});
                    }
                    catch (LdapInvalidAttributeValueException liave) {}
                } else {
                    try {
                        this.contextEntry.put(new Attribute[]{new DefaultAttribute(newAttributeValueObject.getAttribute(), new String[]{newAttributeValueObject.getValue()})});
                    }
                    catch (LdapException e) {
                        // empty catch block
                    }
                }
                this.contextEntryTableViewer.refresh();
                this.resizeContextEntryTableColumnsToFit();
                this.masterDetailsBlock.setEditorDirty();
                this.commit(true);
            }
        }
    }
}

