/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.apacheds.configuration.v2.jobs;

import org.apache.directory.studio.apacheds.configuration.v2.editor.ConnectionServerConfigurationInput;
import org.apache.directory.studio.apacheds.configuration.v2.editor.NewServerConfigurationInput;
import org.apache.directory.studio.apacheds.configuration.v2.editor.ServerConfigurationEditor;
import org.apache.directory.studio.apacheds.configuration.v2.editor.ServerConfigurationEditorUtils;
import org.apache.directory.studio.apacheds.configuration.v2.jobs.Messages;
import org.apache.directory.studio.common.core.jobs.StudioProgressMonitor;
import org.apache.directory.studio.common.core.jobs.StudioRunnableWithProgress;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.part.FileEditorInput;

public class SaveConfigurationRunnable
implements StudioRunnableWithProgress {
    private ServerConfigurationEditor editor;

    public SaveConfigurationRunnable(ServerConfigurationEditor editor) {
        this.editor = editor;
    }

    public String getErrorMessage() {
        return Messages.getString("SaveConfigurationRunnable.UnableToSaveConfiguration");
    }

    public Object[] getLockedObjects() {
        return new Object[0];
    }

    public String getName() {
        return Messages.getString("SaveConfigurationRunnable.SaveConfiguration");
    }

    public void run(StudioProgressMonitor monitor) {
        try {
            if (this.editor.isDirty()) {
                monitor.beginTask(Messages.getString("SaveConfigurationRunnable.SavingServerConfiguration"), -1);
                IEditorInput input = this.editor.getEditorInput();
                String inputClassName = input.getClass().getName();
                boolean success = false;
                if (input instanceof FileEditorInput) {
                    ServerConfigurationEditorUtils.saveConfiguration((FileEditorInput)input, this.editor.getConfigWriter(), (IProgressMonitor)monitor);
                    success = true;
                }
                if (input instanceof ConnectionServerConfigurationInput) {
                    ServerConfigurationEditorUtils.saveConfiguration((ConnectionServerConfigurationInput)input, this.editor.getConfigWriter(), (IProgressMonitor)monitor);
                    success = true;
                } else if (input instanceof IPathEditorInput) {
                    ServerConfigurationEditorUtils.saveConfiguration(((IPathEditorInput)input).getPath().toFile(), this.editor.getConfigWriter());
                    success = true;
                } else if (inputClassName.equals("org.eclipse.ui.internal.editors.text.JavaFileEditorInput") || inputClassName.equals("org.eclipse.ui.ide.FileStoreEditorInput")) {
                    ServerConfigurationEditorUtils.saveConfiguration(input.getToolTipText(), this.editor.getConfigWriter());
                    success = true;
                } else if (input instanceof NewServerConfigurationInput) {
                    success = this.editor.doSaveAs((IProgressMonitor)monitor);
                }
                this.editor.setDirty(!success);
            }
        }
        catch (Exception e) {
            monitor.reportError(e);
        }
    }
}

