/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldifeditor.editor.reconciler;

import java.util.ArrayList;
import org.apache.directory.studio.ldifeditor.editor.ILdifEditor;
import org.apache.directory.studio.ldifparser.model.LdifFile;
import org.apache.directory.studio.ldifparser.model.LdifPart;
import org.apache.directory.studio.ldifparser.model.container.LdifContainer;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.ISourceViewer;

class LdifAnnotationUpdater {
    private static final String ERROR_ANNOTATION_TYPE = "org.eclipse.ui.workbench.texteditor.error";
    private ILdifEditor editor;

    public LdifAnnotationUpdater(ILdifEditor editor) {
        this.editor = editor;
    }

    public void dispose() {
    }

    public void updateAnnotations(LdifContainer[] containers) {
    }

    public void updateAnnotations() {
        LdifFile model = this.editor.getLdifModel();
        ISourceViewer viewer = (ISourceViewer)this.editor.getAdapter(ISourceViewer.class);
        if (viewer == null) {
            return;
        }
        IDocument document = viewer.getDocument();
        IAnnotationModel annotationModel = viewer.getAnnotationModel();
        if (document == null || annotationModel == null || model == null) {
            return;
        }
        if (annotationModel instanceof IAnnotationModelExtension) {
            ((IAnnotationModelExtension)annotationModel).removeAllAnnotations();
            ArrayList<Position> positionList = new ArrayList<Position>();
            LdifContainer[] containers = model.getContainers();
            for (int i = 0; i < containers.length; ++i) {
                LdifContainer container = containers[i];
                int errorOffset = -1;
                int errorLength = -1;
                StringBuffer errorText = null;
                LdifPart[] parts = container.getParts();
                for (int k = 0; k < parts.length; ++k) {
                    LdifPart part = parts[k];
                    if (part.isValid()) continue;
                    if (errorOffset == -1) {
                        errorOffset = part.getOffset();
                        errorLength = part.getLength();
                        errorText = new StringBuffer();
                        errorText.append(part.toRawString());
                        continue;
                    }
                    errorLength += part.getLength();
                    errorText.append(part.toRawString());
                }
                if (errorOffset == -1 && !container.isValid()) {
                    errorOffset = container.getOffset();
                    errorLength = container.getLength();
                    errorText = new StringBuffer();
                    errorText.append(container.toRawString());
                }
                if (errorOffset <= -1) continue;
                Annotation annotation = new Annotation(ERROR_ANNOTATION_TYPE, true, errorText.toString());
                Position position = new Position(errorOffset, errorLength);
                positionList.add(position);
                viewer.getAnnotationModel().addAnnotation(annotation, position);
            }
        }
    }
}

