/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.widgets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.directory.studio.common.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.connection.ui.widgets.ExtendedContentAssistCommandAdapter;
import org.apache.directory.studio.ldapbrowser.common.widgets.BrowserWidget;
import org.apache.directory.studio.ldapbrowser.common.widgets.ListContentProposalProvider;
import org.apache.directory.studio.ldapbrowser.core.BrowserCoreConstants;
import org.apache.directory.studio.ldapbrowser.core.model.schema.Schema;
import org.apache.directory.studio.ldapbrowser.core.model.schema.SchemaUtils;
import org.eclipse.jface.fieldassist.ComboContentAdapter;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ModWidget
extends BrowserWidget {
    private ScrolledComposite scrolledComposite;
    private Composite composite;
    private ArrayList<ModSpec> modSpecList = new ArrayList();
    private ListContentProposalProvider listContentProposalProvider;
    private String ldif;
    private ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            ModWidget.this.validate(true);
        }
    };

    public ModWidget(Schema schema) {
        Object[] attributeDescriptions = SchemaUtils.getNamesAsArray((Collection)schema.getAttributeTypeDescriptions());
        Arrays.sort(attributeDescriptions);
        this.listContentProposalProvider = new ListContentProposalProvider((String[])attributeDescriptions);
    }

    public void dispose() {
    }

    public String getLdif() {
        return this.ldif;
    }

    public Composite createContents(Composite parent) {
        this.scrolledComposite = new ScrolledComposite(parent, 768);
        this.scrolledComposite.setLayout((Layout)new GridLayout());
        this.scrolledComposite.setExpandHorizontal(true);
        this.scrolledComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.composite = BaseWidgetUtils.createColumnContainer((Composite)this.scrolledComposite, (int)3, (int)1);
        this.composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.scrolledComposite.setContent((Control)this.composite);
        this.addInitialModSpec();
        this.validate(false);
        return this.scrolledComposite;
    }

    public void validate(boolean notifyListeners) {
        for (int i = 0; i < this.modSpecList.size(); ++i) {
            ModSpec modSpec = this.modSpecList.get(i);
            if (this.modSpecList.size() > 1) {
                modSpec.modDeleteButton.setEnabled(true);
            } else {
                modSpec.modDeleteButton.setEnabled(false);
            }
            for (int k = 0; k < modSpec.valueLineList.size(); ++k) {
                ValueLine valueLine = (ValueLine)modSpec.valueLineList.get(k);
                if (modSpec.valueLineList.size() > 1) {
                    valueLine.valueDeleteButton.setEnabled(true);
                    continue;
                }
                valueLine.valueDeleteButton.setEnabled(false);
            }
        }
        if (notifyListeners) {
            this.notifyListeners();
        }
    }

    private void addInitialModSpec() {
        this.addModSpec(0);
    }

    private void addModSpec(int index) {
        ModSpec[] modSpecs = this.modSpecList.toArray(new ModSpec[this.modSpecList.size()]);
        ModSpec newModSpec = this.createModSpec(true);
        this.modSpecList.add(newModSpec);
        if (modSpecs.length > 0) {
            for (int i = index; i < modSpecs.length; ++i) {
                ModSpec modSpec = modSpecs[i];
                modSpec.modGroup.setParent((Composite)this.scrolledComposite);
                modSpec.modAddButton.setParent((Composite)this.scrolledComposite);
                modSpec.modDeleteButton.setParent((Composite)this.scrolledComposite);
                modSpec.modGroup.setParent(this.composite);
                modSpec.modAddButton.setParent(this.composite);
                modSpec.modDeleteButton.setParent(this.composite);
                this.modSpecList.remove(modSpec);
                this.modSpecList.add(modSpec);
            }
        }
        this.composite.setSize(this.composite.computeSize(-1, -1));
    }

    private ModSpec createModSpec(boolean addFirstValueLine) {
        ModSpec modSpec = new ModSpec();
        modSpec.modGroup = BaseWidgetUtils.createGroup((Composite)this.composite, (String)"", (int)1);
        modSpec.modGroup.setLayoutData((Object)new GridData(4, 0, true, false));
        Composite modSpecComposite = BaseWidgetUtils.createColumnContainer((Composite)modSpec.modGroup, (int)2, (int)1);
        modSpec.modType = BaseWidgetUtils.createReadonlyCombo((Composite)modSpecComposite, (String[])new String[]{"add", "replace", "delete"}, (int)0, (int)1);
        modSpec.modType.setLayoutData((Object)new GridData());
        modSpec.modType.addModifyListener(this.modifyListener);
        modSpec.modAttributeCombo = BaseWidgetUtils.createCombo((Composite)modSpecComposite, (String[])new String[0], (int)-1, (int)1);
        new ExtendedContentAssistCommandAdapter((Control)modSpec.modAttributeCombo, (IControlContentAdapter)new ComboContentAdapter(), (IContentProposalProvider)this.listContentProposalProvider, null, null, true);
        modSpec.modAttributeCombo.addModifyListener(this.modifyListener);
        modSpec.modAddButton = new Button(this.composite, 8);
        modSpec.modAddButton.setText("  +   ");
        modSpec.modAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = ModWidget.this.modSpecList.size();
                for (int i = 0; i < ModWidget.this.modSpecList.size(); ++i) {
                    ModSpec modSpec = (ModSpec)ModWidget.this.modSpecList.get(i);
                    if (modSpec.modAddButton != e.widget) continue;
                    index = i + 1;
                }
                ModWidget.this.addModSpec(index);
                ModWidget.this.validate(true);
            }
        });
        modSpec.modDeleteButton = new Button(this.composite, 8);
        modSpec.modDeleteButton.setText("  \u2212  ");
        modSpec.modDeleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = 0;
                for (int i = 0; i < ModWidget.this.modSpecList.size(); ++i) {
                    ModSpec modSpec = (ModSpec)ModWidget.this.modSpecList.get(i);
                    if (modSpec.modDeleteButton != e.widget) continue;
                    index = i;
                }
                ModWidget.this.deleteModSpec(index);
                ModWidget.this.validate(true);
            }
        });
        if (addFirstValueLine) {
            this.addValueLine(modSpec, 0, false);
        }
        return modSpec;
    }

    private void deleteModSpec(int index) {
        ModSpec modSpec = this.modSpecList.remove(index);
        if (modSpec != null) {
            modSpec.modGroup.dispose();
            modSpec.modAddButton.dispose();
            modSpec.modDeleteButton.dispose();
            this.composite.setSize(this.composite.computeSize(-1, -1));
        }
    }

    private void addValueLine(ModSpec modSpec, int index, boolean updateSize) {
        ValueLine[] valueLines = modSpec.valueLineList.toArray(new ValueLine[modSpec.valueLineList.size()]);
        ValueLine newValueLine = this.createValueLine(modSpec);
        modSpec.valueLineList.add(newValueLine);
        if (valueLines.length > 0) {
            for (int i = index; i < valueLines.length; ++i) {
                ValueLine valueLine = valueLines[i];
                Composite parentComposite = valueLine.valueComposite.getParent();
                valueLine.valueComposite.setParent((Composite)this.scrolledComposite);
                valueLine.valueComposite.setParent(parentComposite);
                modSpec.valueLineList.remove(valueLine);
                modSpec.valueLineList.add(valueLine);
            }
        }
        if (updateSize) {
            this.composite.setSize(this.composite.computeSize(-1, -1));
        }
    }

    private ValueLine createValueLine(final ModSpec modSpec) {
        ValueLine valueLine = new ValueLine();
        valueLine.valueComposite = BaseWidgetUtils.createColumnContainer((Composite)modSpec.modGroup, (int)3, (int)1);
        valueLine.valueText = BaseWidgetUtils.createText((Composite)valueLine.valueComposite, (String)"", (int)1);
        valueLine.valueText.addModifyListener(this.modifyListener);
        valueLine.valueAddButton = new Button(valueLine.valueComposite, 8);
        valueLine.valueAddButton.setText("  +   ");
        valueLine.valueAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = modSpec.valueLineList.size();
                for (int i = 0; i < modSpec.valueLineList.size(); ++i) {
                    ValueLine valueLine = (ValueLine)modSpec.valueLineList.get(i);
                    if (valueLine.valueAddButton != e.widget) continue;
                    index = i + 1;
                }
                ModWidget.this.addValueLine(modSpec, index, true);
                ModWidget.this.validate(true);
            }
        });
        valueLine.valueDeleteButton = new Button(valueLine.valueComposite, 8);
        valueLine.valueDeleteButton.setText("  \u2212  ");
        valueLine.valueDeleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = 0;
                for (int i = 0; i < modSpec.valueLineList.size(); ++i) {
                    ValueLine valueLine = (ValueLine)modSpec.valueLineList.get(i);
                    if (valueLine.valueDeleteButton != e.widget) continue;
                    index = i;
                }
                ModWidget.this.deleteValueLine(modSpec, index);
                ModWidget.this.validate(true);
            }
        });
        return valueLine;
    }

    private void deleteValueLine(ModSpec modSpec, int index) {
        ValueLine valueLine = (ValueLine)modSpec.valueLineList.remove(index);
        if (valueLine != null) {
            valueLine.valueComposite.dispose();
            this.composite.setSize(this.composite.computeSize(-1, -1));
        }
    }

    public String getLdifFragment() {
        StringBuffer sb = new StringBuffer();
        sb.append("changetype: modify").append(BrowserCoreConstants.LINE_SEPARATOR);
        ModSpec[] modSpecs = this.modSpecList.toArray(new ModSpec[this.modSpecList.size()]);
        if (modSpecs.length > 0) {
            for (int i = 0; i < modSpecs.length; ++i) {
                int k;
                ModSpec modSpec = modSpecs[i];
                String type = modSpec.modType.getText();
                String attribute = modSpec.modAttributeCombo.getText();
                String[] values = new String[modSpec.valueLineList.size()];
                for (k = 0; k < values.length; ++k) {
                    values[k] = ((ValueLine)modSpec.valueLineList.get(k)).valueText.getText();
                }
                sb.append(type).append(": ").append(attribute).append(BrowserCoreConstants.LINE_SEPARATOR);
                for (k = 0; k < values.length; ++k) {
                    if (values[k].length() <= 0) continue;
                    sb.append(attribute).append(": ").append(values[k]).append(BrowserCoreConstants.LINE_SEPARATOR);
                }
                sb.append("-").append(BrowserCoreConstants.LINE_SEPARATOR);
            }
        }
        return sb.toString();
    }

    private class ValueLine {
        private Composite valueComposite;
        private Text valueText;
        private Button valueAddButton;
        private Button valueDeleteButton;

        private ValueLine() {
        }
    }

    private class ModSpec {
        private Group modGroup;
        private Combo modType;
        private Combo modAttributeCombo;
        private Button modAddButton;
        private Button modDeleteButton;
        private ArrayList<ValueLine> valueLineList = new ArrayList();

        private ModSpec() {
        }
    }
}

