/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor;

import java.util.Arrays;
import org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor.AbstractOpenEditorAction;
import org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor.EntryEditorWidgetActionGroup;
import org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor.EntryEditorWidgetTableMetadata;
import org.apache.directory.studio.valueeditors.IValueEditor;
import org.apache.directory.studio.valueeditors.ValueEditorManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.TreeViewer;

public class OpenEditorAction
extends AbstractOpenEditorAction {
    private IValueEditor valueEditor;

    public OpenEditorAction(TreeViewer viewer, ValueEditorManager valueEditorManager, IValueEditor valueEditor, EntryEditorWidgetActionGroup actionGroup) {
        super(viewer, valueEditorManager, actionGroup);
        this.cellEditor = valueEditor.getCellEditor();
        this.valueEditor = valueEditor;
    }

    public IValueEditor getValueEditor() {
        return this.valueEditor;
    }

    @Override
    public void run() {
        this.valueEditorManager.setUserSelectedValueEditor(this.valueEditor);
        super.run();
    }

    @Override
    public void dispose() {
        this.valueEditor = null;
        super.dispose();
    }

    @Override
    public String getCommandId() {
        return null;
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return this.valueEditor.getValueEditorImageDescriptor();
    }

    @Override
    public String getText() {
        return this.valueEditor.getValueEditorName();
    }

    @Override
    public boolean isEnabled() {
        if (this.getSelectedValues().length == 1 && this.getSelectedAttributes().length == 0 && this.viewer.getCellModifier().canModify((Object)this.getSelectedValues()[0], EntryEditorWidgetTableMetadata.VALUE_COLUMN_NAME)) {
            IValueEditor[] alternativeVps = this.valueEditorManager.getAlternativeValueEditors(this.getSelectedValues()[0]);
            return Arrays.asList(alternativeVps).contains(this.valueEditor) && this.valueEditor.getRawValue(this.getSelectedValues()[0]) != null;
        }
        return false;
    }
}

