/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.widgets.search;

import org.apache.directory.studio.common.ui.HistoryUtils;
import org.apache.directory.studio.common.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.connection.ui.widgets.ExtendedContentAssistCommandAdapter;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonActivator;
import org.apache.directory.studio.ldapbrowser.common.dialogs.FilterDialog;
import org.apache.directory.studio.ldapbrowser.common.filtereditor.FilterContentAssistProcessor;
import org.apache.directory.studio.ldapbrowser.common.widgets.BrowserWidget;
import org.apache.directory.studio.ldapbrowser.common.widgets.search.FilterWidgetAutoEditStrategyAdapter;
import org.apache.directory.studio.ldapbrowser.common.widgets.search.Messages;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.filter.parser.LdapFilterParser;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.fieldassist.ComboContentAdapter;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class FilterWidget
extends BrowserWidget {
    private Combo filterCombo;
    private ExtendedContentAssistCommandAdapter filterCPA;
    private Button filterEditorButton;
    private FilterContentAssistProcessor contentAssistProcessor;
    private IBrowserConnection browserConnection;
    private String initalFilter;
    private LdapFilterParser parser;

    public FilterWidget(String initalFilter) {
        this.initalFilter = initalFilter;
    }

    public FilterWidget() {
        this.browserConnection = null;
        this.initalFilter = null;
    }

    public void createWidget(final Composite parent) {
        Composite composite = BaseWidgetUtils.createColumnContainer((Composite)parent, (int)1, (int)1);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 1;
        gd.widthHint = 30;
        composite.setLayoutData((Object)gd);
        this.filterCombo = BaseWidgetUtils.createCombo((Composite)composite, (String[])new String[0], (int)-1, (int)1);
        this.filterCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FilterWidget.this.notifyListeners();
            }
        });
        this.filterCombo.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (!FilterWidget.this.filterCombo.getText().equals(e.text) && e.character == '\u0000' && e.start == e.end) {
                    FilterWidget.this.filterCPA.closeProposalPopup();
                }
                if (!FilterWidget.this.filterCombo.getText().equals(e.text) && e.stateMask == SWT.MOD1 && e.start == e.end) {
                    FilterWidget.this.filterCPA.closeProposalPopup();
                }
            }
        });
        this.parser = new LdapFilterParser();
        this.contentAssistProcessor = new FilterContentAssistProcessor(this.parser);
        this.filterCPA = new ExtendedContentAssistCommandAdapter((Control)this.filterCombo, (IControlContentAdapter)new ComboContentAdapter(), (IContentProposalProvider)this.contentAssistProcessor, null, null, true);
        new FilterWidgetAutoEditStrategyAdapter(this.filterCombo, this.parser);
        this.filterEditorButton = BaseWidgetUtils.createButton((Composite)parent, (String)Messages.getString("FilterWidget.FilterEditorButton"), (int)1);
        this.filterEditorButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (FilterWidget.this.browserConnection != null) {
                    FilterDialog dialog = new FilterDialog(parent.getShell(), Messages.getString("FilterWidget.FilterEditor"), FilterWidget.this.filterCombo.getText(), FilterWidget.this.browserConnection);
                    dialog.open();
                    String filter = dialog.getFilter();
                    if (filter != null) {
                        FilterWidget.this.filterCombo.setText(filter);
                    }
                }
            }
        });
        String[] history = HistoryUtils.load((IDialogSettings)BrowserCommonActivator.getDefault().getDialogSettings(), (String)"searchFilterHistory");
        this.filterCombo.setItems(history);
        this.filterCombo.setText(this.initalFilter == null ? "(objectClass=*)" : this.initalFilter);
    }

    public String getFilter() {
        if ("".equals(this.filterCombo.getText())) {
            return "";
        }
        this.parser.parse(this.filterCombo.getText());
        return this.parser.getModel().isValid() ? this.filterCombo.getText() : null;
    }

    public void setFilter(String filter) {
        if (this.filterCombo == null) {
            this.initalFilter = filter;
        } else {
            this.filterCombo.setText(filter);
        }
    }

    public void setBrowserConnection(IBrowserConnection browserConnection) {
        if (this.browserConnection != browserConnection) {
            this.browserConnection = browserConnection;
            if (this.filterCombo != null) {
                this.contentAssistProcessor.setSchema(browserConnection == null ? null : browserConnection.getSchema());
                this.filterCPA.setAutoActivationCharacters(this.contentAssistProcessor.getCompletionProposalAutoActivationCharacters());
            }
        }
    }

    public void saveDialogSettings() {
        HistoryUtils.save((IDialogSettings)BrowserCommonActivator.getDefault().getDialogSettings(), (String)"searchFilterHistory", (String)this.filterCombo.getText());
    }

    public void setFocus() {
    }

    public void setEnabled(boolean b) {
        this.filterCombo.setEnabled(b);
        this.filterEditorButton.setEnabled(b);
    }
}

