/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapservers;

import java.util.HashMap;
import java.util.Map;
import org.apache.directory.studio.ldapservers.Messages;
import org.apache.directory.studio.ldapservers.model.LdapServer;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.MessageConsole;

public class ConsolesManager {
    private static ConsolesManager instance;
    private Map<LdapServer, MessageConsole> consolesMap = new HashMap<LdapServer, MessageConsole>();

    private ConsolesManager() {
    }

    public static ConsolesManager getDefault() {
        if (instance == null) {
            instance = new ConsolesManager();
        }
        return instance;
    }

    public MessageConsole getMessageConsole(LdapServer server) {
        if (this.consolesMap.containsKey(server)) {
            return this.consolesMap.get(server);
        }
        MessageConsole messageConsole = new MessageConsole(server.getName() + " " + Messages.getString("ConsolesManager.LdapServer"), null);
        this.consolesMap.put(server, messageConsole);
        ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{messageConsole});
        return messageConsole;
    }
}

