/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapservers.jobs;

import java.io.File;
import org.apache.directory.studio.common.core.jobs.StudioProgressMonitor;
import org.apache.directory.studio.common.core.jobs.StudioRunnableWithProgress;
import org.apache.directory.studio.ldapservers.LdapServersManager;
import org.apache.directory.studio.ldapservers.jobs.Messages;
import org.apache.directory.studio.ldapservers.jobs.StopLdapServerRunnable;
import org.apache.directory.studio.ldapservers.jobs.StudioLdapServerJob;
import org.apache.directory.studio.ldapservers.model.LdapServer;
import org.apache.directory.studio.ldapservers.model.LdapServerAdapter;
import org.apache.directory.studio.ldapservers.model.LdapServerStatus;
import org.eclipse.osgi.util.NLS;

public class DeleteLdapServerRunnable
implements StudioRunnableWithProgress {
    private LdapServer server;

    public DeleteLdapServerRunnable(LdapServer server) {
        this.server = server;
    }

    public String getErrorMessage() {
        return NLS.bind((String)Messages.getString("DeleteLdapServerRunnable.UnableToDeleteServer"), (Object[])new String[]{this.server.getName()});
    }

    public Object[] getLockedObjects() {
        return new Object[]{this.server};
    }

    public String getName() {
        return NLS.bind((String)Messages.getString("DeleteLdapServerRunnable.DeleteServer"), (Object[])new String[]{this.server.getName()});
    }

    public void run(StudioProgressMonitor monitor) {
        boolean serverStarted = this.server.getStatus() == LdapServerStatus.STARTED;
        try {
            if (serverStarted) {
                StudioLdapServerJob job = new StudioLdapServerJob(new StopLdapServerRunnable(this.server));
                job.schedule();
                job.join();
            }
            LdapServersManager.getDefault().removeServer(this.server);
            this.deleteDirectory(LdapServersManager.getServerFolder(this.server).toFile());
            LdapServerAdapter ldapServerAdapter = this.server.getLdapServerAdapterExtension().getInstance();
            if (ldapServerAdapter != null) {
                ldapServerAdapter.delete(this.server, monitor);
            }
        }
        catch (InterruptedException e) {
        }
        catch (Exception e) {
            if (serverStarted) {
                this.server.setStatus(LdapServerStatus.STARTED);
            } else {
                this.server.setStatus(LdapServerStatus.STOPPED);
            }
            monitor.reportError(e);
        }
    }

    private boolean deleteDirectory(File path) {
        if (path.exists()) {
            File[] files = path.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    this.deleteDirectory(files[i]);
                    continue;
                }
                files[i].delete();
            }
        }
        return path.delete();
    }
}

