/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.core.jobs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.studio.common.core.jobs.StudioProgressMonitor;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.ConnectionCorePlugin;
import org.apache.directory.studio.connection.core.DetectedConnectionProperties;
import org.apache.directory.studio.connection.core.jobs.StudioConnectionBulkRunnableWithProgress;
import org.apache.directory.studio.ldapbrowser.core.BrowserCoreMessages;
import org.apache.directory.studio.ldapbrowser.core.events.AttributesInitializedEvent;
import org.apache.directory.studio.ldapbrowser.core.events.EventRegistry;
import org.apache.directory.studio.ldapbrowser.core.jobs.InitializeChildrenRunnable;
import org.apache.directory.studio.ldapbrowser.core.jobs.SearchRunnable;
import org.apache.directory.studio.ldapbrowser.core.jobs.ServerTypeDetector;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.IRootDSE;
import org.apache.directory.studio.ldapbrowser.core.model.ISearch;
import org.apache.directory.studio.ldapbrowser.core.model.ISearchResult;
import org.apache.directory.studio.ldapbrowser.core.model.impl.BaseDNEntry;
import org.apache.directory.studio.ldapbrowser.core.model.impl.DirectoryMetadataEntry;
import org.apache.directory.studio.ldapbrowser.core.model.impl.Search;
import org.eclipse.core.runtime.IProgressMonitor;

public class InitializeRootDSERunnable
implements StudioConnectionBulkRunnableWithProgress {
    public static final String[] ROOT_DSE_ATTRIBUTES = new String[]{"namingContexts", "subschemaSubentry", "supportedLDAPVersion", "supportedSASLMechanisms", "supportedExtension", "supportedControl", "supportedFeatures", "vendorName", "vendorVersion", "+"};
    private IRootDSE rootDSE;

    private InitializeRootDSERunnable(IRootDSE rootDSE) {
        this.rootDSE = rootDSE;
    }

    public Connection[] getConnections() {
        return new Connection[]{this.rootDSE.getBrowserConnection().getConnection()};
    }

    public String getName() {
        return BrowserCoreMessages.jobs__init_entries_title_attonly;
    }

    public Object[] getLockedObjects() {
        return new IEntry[]{this.rootDSE};
    }

    public String getErrorMessage() {
        return BrowserCoreMessages.jobs__init_entries_error_1;
    }

    public void run(StudioProgressMonitor monitor) {
        monitor.beginTask(" ", 3);
        monitor.reportProgress(" ");
        monitor.setTaskName(BrowserCoreMessages.bind((String)BrowserCoreMessages.jobs__init_entries_task, (Object[])new String[]{this.rootDSE.getDn().getName()}));
        monitor.worked(1);
        monitor.reportProgress(BrowserCoreMessages.bind((String)BrowserCoreMessages.jobs__init_entries_progress_att, (Object[])new String[]{this.rootDSE.getDn().getName()}));
        InitializeRootDSERunnable.loadRootDSE(this.rootDSE.getBrowserConnection(), monitor);
    }

    public void runNotification(StudioProgressMonitor monitor) {
        EventRegistry.fireEntryUpdated(new AttributesInitializedEvent(this.rootDSE), this);
    }

    public static synchronized void loadRootDSE(IBrowserConnection browserConnection, StudioProgressMonitor monitor) {
        IAttribute supportedFeaturesAttribute;
        IAttribute supportedExtensionAttribute;
        IAttribute supportedControlAttribute;
        IAttribute vendorVersionAttribute;
        IEntry[] schemaEntries;
        InitializeChildrenRunnable.clearCaches(browserConnection.getRootDSE(), true);
        IAttribute[] oldAttributes = browserConnection.getRootDSE().getAttributes();
        if (oldAttributes != null) {
            for (IAttribute oldAttribute : oldAttributes) {
                browserConnection.getRootDSE().deleteAttribute(oldAttribute);
            }
        }
        Search search = new Search(null, browserConnection, Dn.EMPTY_DN, "(objectClass=*)", ROOT_DSE_ATTRIBUTES, SearchScope.OBJECT, 0, 0, Connection.AliasDereferencingMethod.NEVER, Connection.ReferralHandlingMethod.IGNORE, false, null);
        SearchRunnable.searchAndUpdateModel(browserConnection, search, monitor);
        search = new Search(null, browserConnection, Dn.EMPTY_DN, "(objectClass=*)", new String[]{"*"}, SearchScope.OBJECT, 0, 0, Connection.AliasDereferencingMethod.NEVER, Connection.ReferralHandlingMethod.IGNORE, false, null);
        SearchRunnable.searchAndUpdateModel(browserConnection, search, monitor);
        HashMap<Dn, IEntry> rootDseEntries = new HashMap<Dn, IEntry>();
        if (!browserConnection.isFetchBaseDNs() && browserConnection.getBaseDN() != null && !"".equals(browserConnection.getBaseDN().toString())) {
            Dn dn = browserConnection.getBaseDN();
            IEntry entry = browserConnection.getEntryFromCache(dn);
            if (entry == null) {
                entry = new BaseDNEntry(dn, browserConnection);
                browserConnection.cacheEntry(entry);
            }
            rootDseEntries.put(dn, entry);
        } else {
            HashSet<String> namingContextSet = new HashSet<String>();
            IAttribute attribute = browserConnection.getRootDSE().getAttribute("namingContexts");
            if (attribute != null) {
                String[] values = attribute.getStringValues();
                for (int i = 0; i < values.length; ++i) {
                    namingContextSet.add(values[i]);
                }
            }
            if (!namingContextSet.isEmpty()) {
                for (String namingContext : namingContextSet) {
                    if (namingContext.length() > 0 && namingContext.charAt(namingContext.length() - 1) == '\u0000') {
                        namingContext = namingContext.substring(0, namingContext.length() - 1);
                    }
                    if (!"".equals(namingContext)) {
                        try {
                            Dn dn = new Dn(new String[]{namingContext});
                            IEntry entry = browserConnection.getEntryFromCache(dn);
                            if (entry == null) {
                                entry = new BaseDNEntry(dn, browserConnection);
                                browserConnection.cacheEntry(entry);
                            }
                            rootDseEntries.put(dn, entry);
                        }
                        catch (LdapInvalidDnException e) {
                            monitor.reportError(BrowserCoreMessages.model__error_setting_base_dn, (Exception)((Object)e));
                        }
                        continue;
                    }
                    InitializeRootDSERunnable.searchRootDseEntries(browserConnection, rootDseEntries, monitor);
                }
            } else {
                InitializeRootDSERunnable.searchRootDseEntries(browserConnection, rootDseEntries, monitor);
            }
        }
        for (IEntry entry : schemaEntries = InitializeRootDSERunnable.getDirectoryMetadataEntries(browserConnection, "subschemaSubentry")) {
            if (entry instanceof DirectoryMetadataEntry) {
                ((DirectoryMetadataEntry)entry).setSchemaEntry(true);
            }
            rootDseEntries.put(entry.getDn(), entry);
        }
        IAttribute[] rootDseAttributes = browserConnection.getRootDSE().getAttributes();
        if (rootDseAttributes != null) {
            for (IAttribute attribute : rootDseAttributes) {
                IEntry[] metadataEntries;
                for (IEntry entry : metadataEntries = InitializeRootDSERunnable.getDirectoryMetadataEntries(browserConnection, attribute.getDescription())) {
                    rootDseEntries.put(entry.getDn(), entry);
                }
            }
        }
        StudioProgressMonitor dummyMonitor = new StudioProgressMonitor((IProgressMonitor)monitor);
        for (IEntry entry : rootDseEntries.values()) {
            InitializeRootDSERunnable.initBaseEntry(entry, dummyMonitor);
        }
        browserConnection.getRootDSE().setHasMoreChildren(false);
        browserConnection.getRootDSE().setAttributesInitialized(true);
        browserConnection.getRootDSE().setInitOperationalAttributes(true);
        browserConnection.getRootDSE().setChildrenInitialized(true);
        browserConnection.getRootDSE().setHasChildrenHint(true);
        browserConnection.getRootDSE().setDirectoryEntry(true);
        DetectedConnectionProperties detectedConnectionProperties = browserConnection.getConnection().getDetectedConnectionProperties();
        IAttribute vendorNameAttribute = browserConnection.getRootDSE().getAttribute("vendorName");
        if (vendorNameAttribute != null && vendorNameAttribute.getValueSize() > 0) {
            detectedConnectionProperties.setVendorName(vendorNameAttribute.getStringValue());
        }
        if ((vendorVersionAttribute = browserConnection.getRootDSE().getAttribute("vendorVersion")) != null && vendorVersionAttribute.getValueSize() > 0) {
            detectedConnectionProperties.setVendorVersion(vendorVersionAttribute.getStringValue());
        }
        if ((supportedControlAttribute = browserConnection.getRootDSE().getAttribute("supportedControl")) != null && supportedControlAttribute.getValueSize() > 0) {
            detectedConnectionProperties.setSupportedControls(Arrays.asList(supportedControlAttribute.getStringValues()));
        }
        if ((supportedExtensionAttribute = browserConnection.getRootDSE().getAttribute("supportedExtension")) != null && supportedExtensionAttribute.getValueSize() > 0) {
            detectedConnectionProperties.setSupportedExtensions(Arrays.asList(supportedExtensionAttribute.getStringValues()));
        }
        if ((supportedFeaturesAttribute = browserConnection.getRootDSE().getAttribute("supportedFeatures")) != null && supportedFeaturesAttribute.getValueSize() > 0) {
            detectedConnectionProperties.setSupportedFeatures(Arrays.asList(supportedFeaturesAttribute.getStringValues()));
        }
        detectedConnectionProperties.setServerType((Object)ServerTypeDetector.detectServerType(browserConnection.getRootDSE()));
        ConnectionCorePlugin.getDefault().getConnectionManager().connectionUpdated(browserConnection.getConnection());
    }

    private static void initBaseEntry(IEntry entry, StudioProgressMonitor monitor) {
        IBrowserConnection browserConnection = entry.getBrowserConnection();
        Dn dn = entry.getDn();
        Connection.AliasDereferencingMethod derefAliasMethod = browserConnection.getAliasesDereferencingMethod();
        Connection.ReferralHandlingMethod handleReferralsMethod = browserConnection.getReferralsHandlingMethod();
        Search search = new Search(null, browserConnection, dn, "(objectClass=*)", ISearch.NO_ATTRIBUTES, SearchScope.OBJECT, 1, 0, derefAliasMethod, handleReferralsMethod, true, null);
        SearchRunnable.searchAndUpdateModel(browserConnection, search, monitor);
        ISearchResult[] results = search.getSearchResults();
        if (results != null && results.length == 1) {
            ISearchResult result = results[0];
            entry = result.getEntry();
            browserConnection.getRootDSE().addChild(entry);
        } else {
            browserConnection.uncacheEntryRecursive(entry);
        }
    }

    private static IEntry[] getDirectoryMetadataEntries(IBrowserConnection browserConnection, String metadataAttributeName) {
        ArrayList<Dn> metadataEntryDnList = new ArrayList<Dn>();
        IAttribute attribute = browserConnection.getRootDSE().getAttribute(metadataAttributeName);
        if (attribute != null) {
            String[] values;
            for (String dn : values = attribute.getStringValues()) {
                if (dn == null || "".equals(dn)) continue;
                try {
                    metadataEntryDnList.add(new Dn(new String[]{dn}));
                }
                catch (LdapInvalidDnException e) {
                    // empty catch block
                }
            }
        }
        IEntry[] metadataEntries = new IEntry[metadataEntryDnList.size()];
        for (int i = 0; i < metadataEntryDnList.size(); ++i) {
            Dn dn = (Dn)metadataEntryDnList.get(i);
            metadataEntries[i] = browserConnection.getEntryFromCache(dn);
            if (metadataEntries[i] != null) continue;
            metadataEntries[i] = new DirectoryMetadataEntry(dn, browserConnection);
            metadataEntries[i].setDirectoryEntry(true);
            browserConnection.cacheEntry(metadataEntries[i]);
        }
        return metadataEntries;
    }

    private static void searchRootDseEntries(IBrowserConnection browserConnection, Map<Dn, IEntry> rootDseEntries, StudioProgressMonitor monitor) {
        Search search = new Search(null, browserConnection, Dn.EMPTY_DN, "(objectClass=*)", ISearch.NO_ATTRIBUTES, SearchScope.ONELEVEL, 0, 0, Connection.AliasDereferencingMethod.NEVER, Connection.ReferralHandlingMethod.IGNORE, false, null);
        SearchRunnable.searchAndUpdateModel(browserConnection, search, monitor);
        ISearchResult[] results = search.getSearchResults();
        if (results != null) {
            for (ISearchResult searchResult : results) {
                IEntry entry = searchResult.getEntry();
                rootDseEntries.put(entry.getDn(), entry);
            }
        }
    }
}

