/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.core.jobs;

import org.apache.directory.studio.connection.core.ConnectionServerType;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IRootDSE;

public class ServerTypeDetector {
    public static ConnectionServerType detectServerType(IRootDSE rootDSE) {
        ConnectionServerType serverType = ConnectionServerType.UNKNOWN;
        IAttribute vnAttribute = rootDSE.getAttribute("vendorName");
        IAttribute vvAttribute = rootDSE.getAttribute("vendorVersion");
        if (vnAttribute != null && vnAttribute.getStringValues().length > 0 && vvAttribute != null && vvAttribute.getStringValues().length > 0) {
            String vendorName = vnAttribute.getStringValues()[0];
            String vendorVersion = vvAttribute.getStringValues()[0];
            serverType = ServerTypeDetector.detectApacheDS(vendorName);
            if (!ConnectionServerType.UNKNOWN.equals((Object)serverType)) {
                return serverType;
            }
            serverType = ServerTypeDetector.detectIbm(vendorName, vendorVersion);
            if (!ConnectionServerType.UNKNOWN.equals((Object)serverType)) {
                return serverType;
            }
            serverType = ServerTypeDetector.detectNetscape(vendorName, vendorVersion);
            if (!ConnectionServerType.UNKNOWN.equals((Object)serverType)) {
                return serverType;
            }
            serverType = ServerTypeDetector.detectNovell(vendorName, vendorVersion);
            if (!ConnectionServerType.UNKNOWN.equals((Object)serverType)) {
                return serverType;
            }
            serverType = ServerTypeDetector.detectSun(vendorName, vendorVersion);
            if (!ConnectionServerType.UNKNOWN.equals((Object)serverType)) {
                return serverType;
            }
        }
        if (!ConnectionServerType.UNKNOWN.equals((Object)(serverType = ServerTypeDetector.detectMicrosoft(rootDSE)))) {
            return serverType;
        }
        serverType = ServerTypeDetector.detectOpenLdap(rootDSE);
        if (!ConnectionServerType.UNKNOWN.equals((Object)serverType)) {
            return serverType;
        }
        serverType = ServerTypeDetector.detectSiemens(rootDSE);
        if (!ConnectionServerType.UNKNOWN.equals((Object)serverType)) {
            return serverType;
        }
        return ConnectionServerType.UNKNOWN;
    }

    private static ConnectionServerType detectApacheDS(String vendorName) {
        if (vendorName.indexOf("Apache Software Foundation") > -1) {
            return ConnectionServerType.APACHEDS;
        }
        return ConnectionServerType.UNKNOWN;
    }

    private static ConnectionServerType detectIbm(String vendorName, String vendorVersion) {
        if (vendorName.indexOf("International Business Machines") > -1) {
            String[] tdsVersions;
            String[] idsVersions;
            String[] iswVersions;
            for (String version : iswVersions = new String[]{"3.2", "3.2.1", "3.2.2"}) {
                if (vendorVersion.indexOf(version) <= -1) continue;
                return ConnectionServerType.IBM_SECUREWAY_DIRECTORY;
            }
            for (String version : idsVersions = new String[]{"4.1", "5.1"}) {
                if (vendorVersion.indexOf(version) <= -1) continue;
                return ConnectionServerType.IBM_DIRECTORY_SERVER;
            }
            for (String version : tdsVersions = new String[]{"5.2", "6.0", "6.1", "6.2"}) {
                if (vendorVersion.indexOf(version) <= -1) continue;
                return ConnectionServerType.IBM_TIVOLI_DIRECTORY_SERVER;
            }
        }
        return ConnectionServerType.UNKNOWN;
    }

    private static ConnectionServerType detectMicrosoft(IRootDSE rootDSE) {
        IAttribute rdncAttribute = rootDSE.getAttribute("rootDomainNamingContext");
        if (rdncAttribute != null) {
            IAttribute ffAttribute = rootDSE.getAttribute("forestFunctionality");
            if (ffAttribute != null) {
                return ConnectionServerType.MICROSOFT_ACTIVE_DIRECTORY_2003;
            }
            return ConnectionServerType.MICROSOFT_ACTIVE_DIRECTORY_2000;
        }
        return ConnectionServerType.UNKNOWN;
    }

    private static ConnectionServerType detectNetscape(String vendorName, String vendorVersion) {
        if (vendorName.indexOf("Netscape") > -1 || vendorVersion.indexOf("Netscape") > -1) {
            return ConnectionServerType.NETSCAPE;
        }
        return ConnectionServerType.UNKNOWN;
    }

    private static ConnectionServerType detectNovell(String vendorName, String vendorVersion) {
        if (vendorName.indexOf("Novell") > -1 || vendorVersion.indexOf("eDirectory") > -1) {
            return ConnectionServerType.NOVELL;
        }
        return ConnectionServerType.UNKNOWN;
    }

    private static ConnectionServerType detectOpenLdap(IRootDSE rootDSE) {
        IAttribute ocAttribute = rootDSE.getAttribute("objectClass");
        if (ocAttribute != null) {
            for (int i = 0; i < ocAttribute.getStringValues().length; ++i) {
                IAttribute sfAttribute;
                IAttribute seAttribute;
                if (!"OpenLDAProotDSE".equals(ocAttribute.getStringValues()[i])) continue;
                IAttribute ccAttribute = rootDSE.getAttribute("configContext");
                if (ccAttribute != null) {
                    return ConnectionServerType.OPENLDAP_2_3;
                }
                IAttribute scAttribute = rootDSE.getAttribute("supportedControl");
                if (scAttribute != null) {
                    for (int sci = 0; sci < scAttribute.getStringValues().length; ++sci) {
                        if (!"2.16.840.1.113730.3.4.18".equals(scAttribute.getStringValues()[sci])) continue;
                        return ConnectionServerType.OPENLDAP_2_2;
                    }
                }
                if ((seAttribute = rootDSE.getAttribute("supportedExtension")) != null) {
                    for (int sei = 0; sei < seAttribute.getStringValues().length; ++sei) {
                        if (!"1.3.6.1.4.1.4203.1.11.3".equals(seAttribute.getStringValues()[sei])) continue;
                        return ConnectionServerType.OPENLDAP_2_1;
                    }
                }
                if ((sfAttribute = rootDSE.getAttribute("supportedFeatures")) != null) {
                    for (int sfi = 0; sfi < sfAttribute.getStringValues().length; ++sfi) {
                        if (!"1.3.6.1.4.1.4203.1.5.4".equals(sfAttribute.getStringValues()[sfi])) continue;
                        return ConnectionServerType.OPENLDAP_2_0;
                    }
                }
                return ConnectionServerType.OPENLDAP;
            }
        }
        return ConnectionServerType.UNKNOWN;
    }

    private static ConnectionServerType detectSiemens(IRootDSE rootDSE) {
        IAttribute ssseAttribute = rootDSE.getAttribute("subSchemaSubentry");
        if (ssseAttribute != null) {
            for (int i = 0; i < ssseAttribute.getStringValues().length; ++i) {
                if (!"cn=LDAPGlobalSchemaSubentry".equals(ssseAttribute.getStringValues()[i])) continue;
                return ConnectionServerType.SIEMENS_DIRX;
            }
        }
        return ConnectionServerType.UNKNOWN;
    }

    private static ConnectionServerType detectSun(String vendorName, String vendorVersion) {
        if (vendorName.indexOf("Sun") > -1 || vendorVersion.indexOf("Sun") > -1) {
            return ConnectionServerType.SUN_DIRECTORY_SERVER;
        }
        return ConnectionServerType.UNKNOWN;
    }
}

