/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.core.model;

import java.util.Arrays;
import java.util.Iterator;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;

public class AttributeHierarchy
implements Iterable<IAttribute> {
    private IEntry entry;
    private String attributeDescription;
    private IAttribute[] attributes;

    public AttributeHierarchy(IEntry entry, String attributeDescription, IAttribute[] attributes) {
        if (entry == null || attributeDescription == null || attributes == null || attributes.length < 1 || attributes[0] == null) {
            throw new IllegalArgumentException("Empty AttributeHierachie");
        }
        this.entry = entry;
        this.attributeDescription = attributeDescription;
        this.attributes = attributes;
    }

    public IAttribute[] getAttributes() {
        return this.attributes;
    }

    public boolean contains(IAttribute attribute) {
        return Arrays.asList(this.attributes).contains(attribute);
    }

    @Override
    public Iterator<IAttribute> iterator() {
        return Arrays.asList(this.attributes).iterator();
    }

    public IAttribute getAttribute() {
        return this.attributes[0];
    }

    public int size() {
        return this.attributes.length;
    }

    public int getValueSize() {
        int size = 0;
        for (IAttribute attribute : this.attributes) {
            size += attribute.getValueSize();
        }
        return size;
    }

    public String getAttributeDescription() {
        return this.attributeDescription;
    }

    public IEntry getEntry() {
        return this.entry;
    }
}

