/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.core.utils;

import java.util.ArrayList;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.ModificationItem;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.studio.connection.core.StudioControl;
import org.apache.directory.studio.ldapbrowser.core.events.EventRegistry;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.apache.directory.studio.ldapbrowser.core.model.impl.Attribute;
import org.apache.directory.studio.ldapbrowser.core.model.impl.DummyEntry;
import org.apache.directory.studio.ldapbrowser.core.model.impl.Value;
import org.apache.directory.studio.ldifparser.LdifUtils;
import org.apache.directory.studio.ldifparser.model.LdifPart;
import org.apache.directory.studio.ldifparser.model.container.LdifChangeAddRecord;
import org.apache.directory.studio.ldifparser.model.container.LdifChangeRecord;
import org.apache.directory.studio.ldifparser.model.container.LdifContentRecord;
import org.apache.directory.studio.ldifparser.model.container.LdifRecord;
import org.apache.directory.studio.ldifparser.model.lines.LdifAttrValLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifChangeTypeLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifCommentLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifControlLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifDnLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifSepLine;

public class ModelConverter {
    public static DummyEntry ldifContentRecordToEntry(LdifContentRecord ldifContentRecord, IBrowserConnection connection) throws LdapInvalidDnException {
        return ModelConverter.createIntern((LdifRecord)ldifContentRecord, connection);
    }

    public static DummyEntry ldifChangeAddRecordToEntry(LdifChangeAddRecord ldifChangeAddRecord, IBrowserConnection connection) throws LdapInvalidDnException {
        return ModelConverter.createIntern((LdifRecord)ldifChangeAddRecord, connection);
    }

    private static DummyEntry createIntern(LdifRecord ldifRecord, IBrowserConnection connection) throws LdapInvalidDnException {
        LdifPart[] parts = ldifRecord.getParts();
        EventRegistry.suspendEventFiringInCurrentThread();
        DummyEntry entry = new DummyEntry(new Dn(new String[]{ldifRecord.getDnLine().getValueAsString()}), connection);
        for (int i = 0; i < parts.length; ++i) {
            if (parts[i] instanceof LdifAttrValLine) {
                LdifAttrValLine line = (LdifAttrValLine)parts[i];
                String attributeName = line.getUnfoldedAttributeDescription();
                Object value = line.getValueAsObject();
                IAttribute attribute = entry.getAttribute(attributeName);
                if (attribute == null) {
                    attribute = new Attribute(entry, attributeName);
                    entry.addAttribute(attribute);
                }
                attribute.addValue(new Value(attribute, value));
                continue;
            }
            if (parts[i] instanceof LdifDnLine || parts[i] instanceof LdifSepLine) continue;
            String name = parts[i].toRawString();
            name = name.replaceAll("\n", "");
            name = name.replaceAll("\r", "");
            Attribute attribute = new Attribute(entry, name);
            attribute.addValue(new Value(attribute, parts[i]));
            entry.addAttribute(attribute);
        }
        EventRegistry.resumeEventFiringInCurrentThread();
        return entry;
    }

    public static LdifChangeAddRecord entryToLdifChangeAddRecord(IEntry entry) {
        boolean mustCreateChangeTypeLine = true;
        for (IAttribute attribute : entry.getAttributes()) {
            for (IValue value : attribute.getValues()) {
                if (!(value.getRawValue() instanceof LdifPart)) continue;
                mustCreateChangeTypeLine = false;
            }
        }
        LdifChangeAddRecord record = new LdifChangeAddRecord(LdifDnLine.create((String)entry.getDn().getName()));
        if (mustCreateChangeTypeLine) {
            ModelConverter.addControls((LdifChangeRecord)record, entry);
            record.setChangeType(LdifChangeTypeLine.createAdd());
        }
        for (IAttribute attribute : entry.getAttributes()) {
            String name = attribute.getDescription();
            for (IValue value : attribute.getValues()) {
                if (value.isEmpty()) continue;
                if (value.getRawValue() instanceof LdifPart) {
                    LdifPart part = (LdifPart)value.getRawValue();
                    if (part instanceof LdifChangeTypeLine) {
                        record.setChangeType((LdifChangeTypeLine)part);
                        continue;
                    }
                    if (part instanceof LdifCommentLine) {
                        record.addComment((LdifCommentLine)part);
                        continue;
                    }
                    if (!(part instanceof LdifControlLine)) continue;
                    record.addControl((LdifControlLine)part);
                    continue;
                }
                if (value.isString()) {
                    record.addAttrVal(LdifAttrValLine.create((String)name, (String)value.getStringValue()));
                    continue;
                }
                record.addAttrVal(LdifAttrValLine.create((String)name, (byte[])value.getBinaryValue()));
            }
        }
        record.finish(LdifSepLine.create());
        return record;
    }

    public static LdifContentRecord entryToLdifContentRecord(IEntry entry) {
        LdifContentRecord record = LdifContentRecord.create((String)entry.getDn().getName());
        if (entry.getAttributes() != null) {
            for (IAttribute attribute : entry.getAttributes()) {
                String name = attribute.getDescription();
                for (IValue value : attribute.getValues()) {
                    if (value.isEmpty()) continue;
                    if (value.getRawValue() instanceof LdifPart) {
                        LdifPart part = (LdifPart)value.getRawValue();
                        if (!(part instanceof LdifCommentLine)) continue;
                        record.addComment((LdifCommentLine)part);
                        continue;
                    }
                    if (value.isString()) {
                        record.addAttrVal(LdifAttrValLine.create((String)name, (String)value.getStringValue()));
                        continue;
                    }
                    record.addAttrVal(LdifAttrValLine.create((String)name, (byte[])value.getBinaryValue()));
                }
            }
        }
        record.finish(LdifSepLine.create());
        return record;
    }

    public static LdifAttrValLine valueToLdifAttrValLine(IValue value) {
        LdifAttrValLine line = value.isString() ? LdifAttrValLine.create((String)value.getAttribute().getDescription(), (String)value.getStringValue()) : LdifAttrValLine.create((String)value.getAttribute().getDescription(), (byte[])value.getBinaryValue());
        return line;
    }

    public static IValue ldifAttrValLineToValue(LdifAttrValLine line, IEntry entry) {
        try {
            Attribute attribute = new Attribute(entry, line.getUnfoldedAttributeDescription());
            Value value = new Value(attribute, line.getValueAsObject());
            return value;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static LdifDnLine dnToLdifDnLine(Dn dn) {
        LdifDnLine line = LdifDnLine.create((String)dn.getName());
        return line;
    }

    public static void addControls(LdifChangeRecord cr, IEntry entry) {
        if (entry.isReferral()) {
            cr.addControl(LdifControlLine.create((String)StudioControl.MANAGEDSAIT_CONTROL.getOid(), (boolean)StudioControl.MANAGEDSAIT_CONTROL.isCritical(), (byte[])StudioControl.MANAGEDSAIT_CONTROL.getControlValue()));
        }
    }

    public static String getStringValue(IValue value, int binaryEncoding) {
        String s = value.getStringValue();
        if (value.isBinary() && LdifUtils.mustEncode((String)s)) {
            byte[] binary = value.getBinaryValue();
            s = binaryEncoding == 1 ? LdifUtils.base64encode((byte[])binary) : (binaryEncoding == 2 ? LdifUtils.hexEncode((byte[])binary) : "BINARY");
        }
        return s;
    }

    public static ModificationItem[] entryToReplaceModificationItems(IEntry entry) {
        ArrayList<ModificationItem> mis = new ArrayList<ModificationItem>();
        for (IAttribute attribute : entry.getAttributes()) {
            BasicAttribute jndiAttribute = new BasicAttribute(attribute.getDescription());
            boolean isLdifPart = false;
            for (IValue value : attribute.getValues()) {
                if (value.getRawValue() instanceof LdifPart) {
                    isLdifPart = true;
                    break;
                }
                jndiAttribute.add(value.getRawValue());
            }
            if (isLdifPart) continue;
            ModificationItem mi = new ModificationItem(2, jndiAttribute);
            mis.add(mi);
        }
        return mis.toArray(new ModificationItem[mis.size()]);
    }
}

