/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.actions;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.directory.studio.Messages;
import org.apache.directory.studio.PluginConstants;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.update.search.BackLevelFilter;
import org.eclipse.update.search.EnvironmentFilter;
import org.eclipse.update.search.IUpdateSearchFilter;
import org.eclipse.update.search.UpdateSearchRequest;
import org.eclipse.update.search.UpdateSearchScope;
import org.eclipse.update.ui.UpdateJob;
import org.eclipse.update.ui.UpdateManagerUI;

public class AddExtensionAction
extends Action
implements IAction {
    private IWorkbenchWindow window;

    public AddExtensionAction(IWorkbenchWindow window) {
        this.window = window;
        this.setId(PluginConstants.ACTION_ADD_EXTENSION_ID);
        this.setText(Messages.getString("AddExtensionAction.Add_Extensions"));
        this.setToolTipText(Messages.getString("AddExtensionAction.Search_for_new_extensions"));
    }

    public void run() {
        BusyIndicator.showWhile((Display)this.window.getShell().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                UpdateJob job = new UpdateJob(Messages.getString("AddExtensionAction.Searching_new_extensions"), this.getSearchRequest());
                UpdateManagerUI.openInstaller((Shell)AddExtensionAction.this.window.getShell(), (UpdateJob)job);
            }

            private UpdateSearchRequest getSearchRequest() {
                UpdateSearchRequest result = new UpdateSearchRequest(UpdateSearchRequest.createDefaultSiteSearchCategory(), new UpdateSearchScope());
                result.addFilter((IUpdateSearchFilter)new BackLevelFilter());
                result.addFilter((IUpdateSearchFilter)new EnvironmentFilter());
                UpdateSearchScope scope = new UpdateSearchScope();
                try {
                    String homeBase = System.getProperty("studio.homebase", Messages.getString("AddExtensionAction.Apache_Directory_Studio_Home_Base"));
                    URL url = new URL(homeBase);
                    scope.addSearchSite(Messages.getString("AddExtensionAction.Apache_Directory_Studio_Site"), url, null);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
                result.setScope(scope);
                return result;
            }
        });
    }
}

