/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.ui.dialogs;

import java.security.cert.X509Certificate;
import java.util.List;
import org.apache.directory.studio.common.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.connection.core.ICertificateHandler;
import org.apache.directory.studio.connection.ui.dialogs.CertificateInfoDialog;
import org.apache.directory.studio.connection.ui.dialogs.Messages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class CertificateTrustDialog
extends Dialog {
    private String title;
    private ICertificateHandler.TrustLevel trustLevel;
    private String host;
    private X509Certificate[] certificateChain;
    private List<ICertificateHandler.FailCause> failCauses;
    private Button trustNotButton;
    private Button trustSessionButton;
    private Button trustPermanentButton;

    public CertificateTrustDialog(Shell parentShell, String host, X509Certificate[] certificateChain, List<ICertificateHandler.FailCause> failCauses) {
        super(parentShell);
        super.setShellStyle(super.getShellStyle() | 0x10);
        this.title = Messages.getString("CertificateTrustDialog.CertificateTrust");
        this.host = host;
        this.certificateChain = certificateChain;
        this.failCauses = failCauses;
        this.trustLevel = null;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.title);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 13, Messages.getString("CertificateTrustDialog.ViewCertificate"), false);
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 13) {
            new CertificateInfoDialog(this.getShell(), this.certificateChain).open();
        }
        super.buttonPressed(buttonId);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridData gd = new GridData(1808);
        gd.widthHint = this.convertHorizontalDLUsToPixels(300);
        gd.heightHint = this.convertHorizontalDLUsToPixels(150);
        composite.setLayoutData((Object)gd);
        BaseWidgetUtils.createWrappedLabel((Composite)composite, (String)NLS.bind((String)Messages.getString("CertificateTrustDialog.InvalidCertificate"), (Object)this.host), (int)1);
        Composite failedCauseContainer = BaseWidgetUtils.createColumnContainer((Composite)composite, (int)1, (int)1);
        for (ICertificateHandler.FailCause failCause : this.failCauses) {
            switch (failCause) {
                case SelfSignedCertificate: {
                    BaseWidgetUtils.createWrappedLabel((Composite)failedCauseContainer, (String)Messages.getString("CertificateTrustDialog.SelfSignedCertificate"), (int)1);
                    break;
                }
                case CertificateExpired: {
                    BaseWidgetUtils.createWrappedLabel((Composite)failedCauseContainer, (String)Messages.getString("CertificateTrustDialog.CertificateExpired"), (int)1);
                    break;
                }
                case CertificateNotYetValid: {
                    BaseWidgetUtils.createWrappedLabel((Composite)failedCauseContainer, (String)Messages.getString("CertificateTrustDialog.CertificateNotYetValid"), (int)1);
                    break;
                }
                case NoValidCertificationPath: {
                    BaseWidgetUtils.createWrappedLabel((Composite)failedCauseContainer, (String)Messages.getString("CertificateTrustDialog.NoValidCertificationPath"), (int)1);
                    break;
                }
                case HostnameVerificationFailed: {
                    BaseWidgetUtils.createWrappedLabel((Composite)failedCauseContainer, (String)Messages.getString("CertificateTrustDialog.HostnameVerificationFailed"), (int)1);
                }
            }
        }
        BaseWidgetUtils.createSpacer((Composite)composite, (int)1);
        BaseWidgetUtils.createSpacer((Composite)composite, (int)1);
        BaseWidgetUtils.createWrappedLabel((Composite)composite, (String)NLS.bind((String)Messages.getString("CertificateTrustDialog.ChooseTrustLevel"), (Object)this.host), (int)1);
        this.trustNotButton = BaseWidgetUtils.createRadiobutton((Composite)composite, (String)Messages.getString("CertificateTrustDialog.DoNotTrust"), (int)1);
        this.trustNotButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CertificateTrustDialog.this.trustLevel = ICertificateHandler.TrustLevel.Not;
            }
        });
        this.trustSessionButton = BaseWidgetUtils.createRadiobutton((Composite)composite, (String)Messages.getString("CertificateTrustDialog.TrustForThisSession"), (int)1);
        this.trustSessionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CertificateTrustDialog.this.trustLevel = ICertificateHandler.TrustLevel.Session;
            }
        });
        this.trustPermanentButton = BaseWidgetUtils.createRadiobutton((Composite)composite, (String)Messages.getString("CertificateTrustDialog.AlwaysTrust"), (int)1);
        this.trustPermanentButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CertificateTrustDialog.this.trustLevel = ICertificateHandler.TrustLevel.Permanent;
            }
        });
        this.trustNotButton.setSelection(true);
        this.trustLevel = ICertificateHandler.TrustLevel.Not;
        return composite;
    }

    public ICertificateHandler.TrustLevel getTrustLevel() {
        return this.trustLevel;
    }
}

