/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.ui.dialogs;

import org.apache.directory.studio.common.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.connection.ui.dialogs.Messages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PasswordDialog
extends Dialog {
    private String title;
    private String message;
    private String value = "";
    private Text passwordText;
    private Button showPasswordCheckbox;

    public PasswordDialog(Shell parentShell, String title, String message, String initialValue) {
        super(parentShell);
        this.title = title;
        this.message = message;
        this.value = initialValue == null ? "" : initialValue;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected void buttonPressed(int buttonId) {
        this.value = buttonId == 0 ? this.passwordText.getText() : null;
        super.buttonPressed(buttonId);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        GridData compositeGridData = new GridData(4, 4, true, true);
        compositeGridData.widthHint = this.convertHorizontalDLUsToPixels(300);
        composite.setLayoutData((Object)compositeGridData);
        if (this.message != null) {
            Label messageLabel = BaseWidgetUtils.createWrappedLabel((Composite)composite, (String)this.message, (int)1);
            GridData messageLabelGridData = new GridData(4, 0x1000000, true, true);
            messageLabelGridData.widthHint = this.convertHorizontalDLUsToPixels(300);
            messageLabel.setLayoutData((Object)messageLabelGridData);
        }
        this.passwordText = BaseWidgetUtils.createText((Composite)composite, (String)this.value, (int)1);
        this.passwordText.setEchoChar('\u2022');
        this.showPasswordCheckbox = BaseWidgetUtils.createCheckbox((Composite)composite, (String)Messages.getString("PasswordDialog.ShowPassword"), (int)1);
        this.showPasswordCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PasswordDialog.this.showPasswordCheckbox.getSelection()) {
                    PasswordDialog.this.passwordText.setEchoChar('\u0000');
                } else {
                    PasswordDialog.this.passwordText.setEchoChar('\u2022');
                }
            }
        });
        this.passwordText.setFocus();
        PasswordDialog.applyDialogFont((Control)composite);
        return composite;
    }

    public String getPassword() {
        return this.value;
    }
}

