/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.ui.properties;

import org.apache.directory.studio.common.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.ConnectionCorePlugin;
import org.apache.directory.studio.connection.core.ConnectionParameter;
import org.apache.directory.studio.connection.core.PasswordsKeyStoreManager;
import org.apache.directory.studio.connection.core.Utils;
import org.apache.directory.studio.connection.core.jobs.CloseConnectionsRunnable;
import org.apache.directory.studio.connection.core.jobs.StudioConnectionJob;
import org.apache.directory.studio.connection.core.jobs.StudioConnectionRunnableWithProgress;
import org.apache.directory.studio.connection.ui.ConnectionParameterPage;
import org.apache.directory.studio.connection.ui.ConnectionParameterPageManager;
import org.apache.directory.studio.connection.ui.ConnectionParameterPageModifyListener;
import org.apache.directory.studio.connection.ui.ConnectionUIConstants;
import org.apache.directory.studio.connection.ui.PasswordsKeyStoreManagerUtils;
import org.apache.directory.studio.connection.ui.properties.Messages;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;

public class ConnectionPropertyPage
extends PropertyPage
implements ConnectionParameterPageModifyListener {
    private TabFolder tabFolder;
    private TabItem[] tabs;
    private ConnectionParameterPage[] pages;

    @Override
    public void connectionParameterPageModified() {
        this.validate();
    }

    @Override
    public ConnectionParameter getTestConnectionParameters() {
        ConnectionParameter connectionParameter = new ConnectionParameter();
        for (int i = 0; i < this.pages.length; ++i) {
            this.pages[i].saveParameters(connectionParameter);
        }
        return connectionParameter;
    }

    public void setMessage(String message) {
        super.setMessage(message, 2);
    }

    public void setErrorMessage(String errorMessage) {
        super.setErrorMessage(errorMessage);
    }

    private void validate() {
        ConnectionParameterPage page;
        int index = this.tabFolder.getSelectionIndex();
        ConnectionParameterPage connectionParameterPage = page = index >= 0 ? this.pages[this.tabFolder.getSelectionIndex()] : null;
        if (page != null && (page.getMessage() != null || page.getInfoMessage() != null || page.getErrorMessage() != null)) {
            if (page.getMessage() != null) {
                this.setMessage(page.getMessage());
            } else if (page.getInfoMessage() != null) {
                this.setMessage(page.getInfoMessage());
            } else {
                this.setMessage(null);
            }
            this.setErrorMessage(page.getErrorMessage());
            this.setValid(page.isValid());
        } else {
            for (int i = 0; i < this.pages.length; ++i) {
                if (this.pages[i].getMessage() == null && this.pages[i].getInfoMessage() == null && this.pages[i].getErrorMessage() == null) continue;
                if (page.getMessage() != null) {
                    this.setMessage(page.getMessage());
                } else if (page.getInfoMessage() != null) {
                    this.setMessage(page.getInfoMessage());
                } else {
                    this.setMessage(null);
                }
                this.setErrorMessage(this.pages[i].getErrorMessage());
                this.setValid(this.pages[i].isValid());
                return;
            }
            this.setMessage(null);
            this.setErrorMessage(null);
            this.setValid(true);
        }
    }

    static Connection getConnection(Object element) {
        Connection connection = null;
        if (element instanceof IAdaptable) {
            connection = (Connection)((IAdaptable)element).getAdapter(Connection.class);
        }
        return connection;
    }

    protected Control createContents(Composite parent) {
        PasswordsKeyStoreManager passwordsKeyStoreManager;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, ConnectionUIConstants.PLUGIN_ID + "." + "tools_connection_properties");
        if (PasswordsKeyStoreManagerUtils.isPasswordsKeystoreEnabled() && !(passwordsKeyStoreManager = ConnectionCorePlugin.getDefault().getPasswordsKeyStoreManager()).isLoaded() && !PasswordsKeyStoreManagerUtils.askUserToLoadKeystore()) {
            Label label = BaseWidgetUtils.createLabel((Composite)parent, (String)Messages.getString("ConnectionPropertyPage.AccessToPasswordsKeystoreRequiredToViewProperties"), (int)1);
            return label;
        }
        Connection connection = ConnectionPropertyPage.getConnection(this.getElement());
        if (connection != null) {
            super.setMessage(Messages.getString("ConnectionPropertyPage.Connection") + Utils.shorten((String)connection.getName(), (int)30));
            this.pages = ConnectionParameterPageManager.getConnectionParameterPages();
            this.tabFolder = new TabFolder(parent, 128);
            this.tabs = new TabItem[this.pages.length];
            for (int i = 0; i < this.pages.length; ++i) {
                Composite composite = new Composite((Composite)this.tabFolder, 0);
                GridLayout gl = new GridLayout(1, false);
                composite.setLayout((Layout)gl);
                this.pages[i].init(composite, this, connection.getConnectionParameter());
                this.tabs[i] = new TabItem(this.tabFolder, 0);
                this.tabs[i].setText(this.pages[i].getPageName());
                this.tabs[i].setControl((Control)composite);
            }
            return this.tabFolder;
        }
        Label label = BaseWidgetUtils.createLabel((Composite)parent, (String)Messages.getString("ConnectionPropertyPage.NoConnection"), (int)1);
        return label;
    }

    public boolean performOk() {
        if (PasswordsKeyStoreManagerUtils.isPasswordsKeystoreEnabled() && !ConnectionCorePlugin.getDefault().getPasswordsKeyStoreManager().isLoaded()) {
            return true;
        }
        Connection connection = ConnectionPropertyPage.getConnection(this.getElement());
        boolean parametersModified = false;
        boolean reconnectionRequired = false;
        ConnectionParameter connectionParameter = new ConnectionParameter();
        connectionParameter.setId(connection.getConnectionParameter().getId());
        for (int i = 0; i < this.pages.length; ++i) {
            this.pages[i].saveParameters(connectionParameter);
            this.pages[i].saveDialogSettings();
            parametersModified |= this.pages[i].areParametersModifed();
            reconnectionRequired |= this.pages[i].isReconnectionRequired();
        }
        if (parametersModified) {
            connection.setConnectionParameter(connectionParameter);
            if (reconnectionRequired) {
                new StudioConnectionJob(new StudioConnectionRunnableWithProgress[]{new CloseConnectionsRunnable(connection)}).execute();
            }
        }
        return true;
    }
}

