/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.LdapSyntax;
import org.apache.directory.api.ldap.model.schema.MatchingRule;
import org.apache.directory.api.ldap.model.schema.MutableObjectClass;
import org.apache.directory.api.ldap.model.schema.ObjectClass;
import org.apache.directory.api.ldap.model.schema.registries.DefaultSchema;
import org.apache.directory.studio.schemaeditor.model.Project;

public class Schema
extends DefaultSchema {
    private Project project;
    private List<AttributeType> attributeTypes = new ArrayList<AttributeType>();
    private List<MutableObjectClass> objectClasses = new ArrayList<MutableObjectClass>();
    private List<MatchingRule> matchingRules = new ArrayList<MatchingRule>();
    private List<LdapSyntax> syntaxes = new ArrayList<LdapSyntax>();

    public Schema(String name) {
        super(name);
    }

    public boolean addAttributeType(AttributeType at) {
        return this.attributeTypes.add(at);
    }

    public boolean addMatchingRule(MatchingRule mr) {
        return this.matchingRules.add(mr);
    }

    public boolean addObjectClass(MutableObjectClass oc) {
        return this.objectClasses.add(oc);
    }

    public boolean addSyntax(LdapSyntax syntax) {
        return this.syntaxes.add(syntax);
    }

    public AttributeType getAttributeType(String id) {
        for (AttributeType at : this.attributeTypes) {
            List aliases = at.getNames();
            if (aliases != null) {
                for (String alias : aliases) {
                    if (!alias.equalsIgnoreCase(id)) continue;
                    return at;
                }
            }
            if (!at.getOid().equalsIgnoreCase(id)) continue;
            return at;
        }
        return null;
    }

    public List<AttributeType> getAttributeTypes() {
        return this.attributeTypes;
    }

    public MatchingRule getMatchingRule(String id) {
        for (MatchingRule mr : this.matchingRules) {
            List aliases = mr.getNames();
            if (aliases != null) {
                for (String alias : aliases) {
                    if (!alias.equalsIgnoreCase(id)) continue;
                    return mr;
                }
            }
            if (!mr.getOid().equalsIgnoreCase(id)) continue;
            return mr;
        }
        return null;
    }

    public List<MatchingRule> getMatchingRules() {
        return this.matchingRules;
    }

    public Project getProject() {
        return this.project;
    }

    public ObjectClass getObjectClass(String id) {
        for (ObjectClass objectClass : this.objectClasses) {
            List aliases = objectClass.getNames();
            if (aliases != null) {
                for (String alias : aliases) {
                    if (!alias.equalsIgnoreCase(id)) continue;
                    return objectClass;
                }
            }
            if (!objectClass.getOid().equalsIgnoreCase(id)) continue;
            return objectClass;
        }
        return null;
    }

    public List<MutableObjectClass> getObjectClasses() {
        return this.objectClasses;
    }

    public LdapSyntax getSyntax(String id) {
        for (LdapSyntax syntax : this.syntaxes) {
            List aliases = syntax.getNames();
            if (aliases != null) {
                for (String alias : aliases) {
                    if (!alias.equalsIgnoreCase(id)) continue;
                    return syntax;
                }
            }
            if (!syntax.getOid().equalsIgnoreCase(id)) continue;
            return syntax;
        }
        return null;
    }

    public List<LdapSyntax> getSyntaxes() {
        return this.syntaxes;
    }

    public boolean removeAttributeType(AttributeType at) {
        return this.attributeTypes.remove(at);
    }

    public boolean removeMatchingRule(MatchingRule mr) {
        return this.matchingRules.remove(mr);
    }

    public boolean removeObjectClass(ObjectClass oc) {
        return this.objectClasses.remove(oc);
    }

    public boolean removeSyntax(LdapSyntax syntax) {
        return this.syntaxes.remove(syntax);
    }

    public void setSchemaName(String schemaName) {
        this.name = schemaName;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public String toString() {
        return this.getSchemaName();
    }
}

