/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.model.alias;

import org.apache.directory.studio.schemaeditor.model.alias.AliasesStringToken;

public class AliasesStringScanner {
    private static final char CHAR_COMMA = ',';
    private static final char CHAR_EOF = '\u0000';
    private String aliases = "";
    private int pos;
    private int lastTokenType;

    public void reset(String aliases) {
        this.aliases = aliases;
        this.pos = -1;
        this.lastTokenType = Integer.MIN_VALUE;
    }

    private char currentChar() {
        return 0 <= this.pos && this.pos < this.aliases.length() ? this.aliases.charAt(this.pos) : (char)'\u0000';
    }

    private char nextChar() {
        ++this.pos;
        return this.currentChar();
    }

    private char prevChar() {
        --this.pos;
        return this.currentChar();
    }

    public AliasesStringToken nextToken() {
        char c = this.nextChar();
        if (c == '\u0000') {
            this.lastTokenType = -1;
            return new AliasesStringToken(this.lastTokenType, "", this.pos);
        }
        this.prevChar();
        c = this.nextChar();
        if (this.lastTokenType == 4 || this.lastTokenType == 3) {
            StringBuffer sb = new StringBuffer();
            while (c != ',' && c != '\u0000') {
                sb.append(c);
                c = this.nextChar();
            }
            this.lastTokenType = 5;
            return new AliasesStringToken(this.lastTokenType, sb.toString(), this.pos - sb.length() + 1);
        }
        this.prevChar();
        c = this.nextChar();
        if (Character.isWhitespace(c)) {
            StringBuffer sb = new StringBuffer();
            while (Character.isWhitespace(c)) {
                sb.append(c);
                c = this.nextChar();
            }
            this.prevChar();
            this.lastTokenType = 0;
            return new AliasesStringToken(this.lastTokenType, sb.toString(), this.pos - sb.length() + 1);
        }
        this.prevChar();
        c = this.nextChar();
        if (c == ',') {
            this.lastTokenType = 1;
            return new AliasesStringToken(this.lastTokenType, ",", this.pos);
        }
        this.prevChar();
        c = this.nextChar();
        if (this.isAliasSafeCharStart(c)) {
            StringBuffer sb = new StringBuffer();
            boolean hasError = false;
            sb.append(c);
            c = this.nextChar();
            while (c != ',' && c != '\u0000') {
                sb.append(c);
                if (!this.isAliasSafeCharPart(c)) {
                    hasError = true;
                    break;
                }
                c = this.nextChar();
            }
            if (hasError) {
                this.lastTokenType = 4;
                return new AliasesStringToken(this.lastTokenType, sb.toString(), this.pos - sb.length() + 1);
            }
            this.prevChar();
            this.lastTokenType = 2;
            return new AliasesStringToken(this.lastTokenType, sb.toString(), this.pos - sb.length() + 1);
        }
        this.lastTokenType = 3;
        return new AliasesStringToken(this.lastTokenType, c + "", this.pos);
    }

    private boolean isAliasSafeCharStart(char c) {
        return c == 'a' || c == 'b' || c == 'c' || c == 'd' || c == 'e' || c == 'f' || c == 'g' || c == 'h' || c == 'i' || c == 'j' || c == 'k' || c == 'l' || c == 'm' || c == 'n' || c == 'o' || c == 'p' || c == 'q' || c == 'r' || c == 's' || c == 't' || c == 'u' || c == 'v' || c == 'w' || c == 'x' || c == 'y' || c == 'z' || c == 'A' || c == 'B' || c == 'C' || c == 'D' || c == 'E' || c == 'F' || c == 'G' || c == 'H' || c == 'I' || c == 'J' || c == 'K' || c == 'L' || c == 'M' || c == 'N' || c == 'O' || c == 'P' || c == 'Q' || c == 'R' || c == 'S' || c == 'T' || c == 'U' || c == 'V' || c == 'W' || c == 'X' || c == 'Y' || c == 'Z';
    }

    private boolean isAliasSafeCharPart(char c) {
        return c == 'a' || c == 'b' || c == 'c' || c == 'd' || c == 'e' || c == 'f' || c == 'g' || c == 'h' || c == 'i' || c == 'j' || c == 'k' || c == 'l' || c == 'm' || c == 'n' || c == 'o' || c == 'p' || c == 'q' || c == 'r' || c == 's' || c == 't' || c == 'u' || c == 'v' || c == 'w' || c == 'x' || c == 'y' || c == 'z' || c == 'A' || c == 'B' || c == 'C' || c == 'D' || c == 'E' || c == 'F' || c == 'G' || c == 'H' || c == 'I' || c == 'J' || c == 'K' || c == 'L' || c == 'M' || c == 'N' || c == 'O' || c == 'P' || c == 'Q' || c == 'R' || c == 'S' || c == 'T' || c == 'U' || c == 'V' || c == 'W' || c == 'X' || c == 'Y' || c == 'Z' || c == '0' || c == '1' || c == '2' || c == '3' || c == '4' || c == '5' || c == '6' || c == '7' || c == '8' || c == '9' || c == '-';
    }
}

