/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.editors.attributetype;

import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.MutableAttributeType;
import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.PluginConstants;
import org.apache.directory.studio.schemaeditor.PluginUtils;
import org.apache.directory.studio.schemaeditor.controller.SchemaHandler;
import org.apache.directory.studio.schemaeditor.controller.SchemaHandlerAdapter;
import org.apache.directory.studio.schemaeditor.controller.SchemaHandlerListener;
import org.apache.directory.studio.schemaeditor.model.Schema;
import org.apache.directory.studio.schemaeditor.view.editors.attributetype.AttributeTypeEditorInput;
import org.apache.directory.studio.schemaeditor.view.editors.attributetype.AttributeTypeEditorOverviewPage;
import org.apache.directory.studio.schemaeditor.view.editors.attributetype.AttributeTypeEditorSourceCodePage;
import org.apache.directory.studio.schemaeditor.view.editors.attributetype.AttributeTypeEditorUsedByPage;
import org.apache.directory.studio.schemaeditor.view.editors.attributetype.Messages;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;

public class AttributeTypeEditor
extends FormEditor {
    private static Logger logger = Logger.getLogger(AttributeTypeEditor.class);
    public static final String ID = PluginConstants.EDITOR_ATTRIBUTE_TYPE_ID;
    private AttributeTypeEditor instance;
    private boolean dirty = false;
    private AttributeTypeEditorOverviewPage overviewPage;
    private AttributeTypeEditorSourceCodePage sourceCodePage;
    private AttributeTypeEditorUsedByPage usedByPage;
    private MutableAttributeType originalAttributeType;
    private MutableAttributeType modifiedAttributeType;
    private Schema originalSchema;
    private IPageChangedListener pageChangedListener = new IPageChangedListener(){

        public void pageChanged(PageChangedEvent event) {
            Object selectedPage = event.getSelectedPage();
            if (selectedPage instanceof AttributeTypeEditorOverviewPage) {
                if (!AttributeTypeEditor.this.sourceCodePage.canLeaveThePage()) {
                    AttributeTypeEditor.this.notifyError(Messages.getString("AttributeTypeEditor.CodeErrors"));
                    return;
                }
                AttributeTypeEditor.this.overviewPage.refreshUI();
            } else if (selectedPage instanceof AttributeTypeEditorSourceCodePage && AttributeTypeEditor.this.sourceCodePage.canLeaveThePage()) {
                AttributeTypeEditor.this.sourceCodePage.refreshUI();
            }
        }
    };
    private SchemaHandlerListener schemaHandlerListener = new SchemaHandlerAdapter(){

        @Override
        public void attributeTypeModified(AttributeType at) {
            if (at.equals((Object)AttributeTypeEditor.this.originalAttributeType)) {
                AttributeTypeEditor.this.modifiedAttributeType = PluginUtils.getClone((AttributeType)AttributeTypeEditor.this.originalAttributeType);
                AttributeTypeEditor.this.overviewPage.refreshUI();
                AttributeTypeEditor.this.sourceCodePage.refreshUI();
                AttributeTypeEditor.this.usedByPage.refreshUI();
                AttributeTypeEditor.this.setPartName(AttributeTypeEditor.this.getEditorInput().getName());
            }
        }

        @Override
        public void attributeTypeRemoved(AttributeType at) {
            if (at.equals((Object)AttributeTypeEditor.this.originalAttributeType)) {
                AttributeTypeEditor.this.getEditorSite().getPage().closeEditor((IEditorPart)AttributeTypeEditor.this.instance, false);
            }
        }

        @Override
        public void schemaRemoved(Schema schema) {
            if (((Object)((Object)schema)).equals((Object)AttributeTypeEditor.this.originalSchema)) {
                AttributeTypeEditor.this.getEditorSite().getPage().closeEditor((IEditorPart)AttributeTypeEditor.this.instance, false);
            }
        }

        @Override
        public void schemaRenamed(Schema schema) {
            if (((Object)((Object)schema)).equals((Object)AttributeTypeEditor.this.originalSchema)) {
                AttributeTypeEditor.this.modifiedAttributeType = PluginUtils.getClone((AttributeType)AttributeTypeEditor.this.originalAttributeType);
                AttributeTypeEditor.this.overviewPage.refreshUI();
                AttributeTypeEditor.this.sourceCodePage.refreshUI();
                AttributeTypeEditor.this.usedByPage.refreshUI();
            }
        }
    };

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.instance = this;
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.setPartName(input.getName());
        this.originalAttributeType = (MutableAttributeType)((AttributeTypeEditorInput)this.getEditorInput()).getAttributeType();
        this.modifiedAttributeType = PluginUtils.getClone((AttributeType)this.originalAttributeType);
        SchemaHandler schemaHandler = Activator.getDefault().getSchemaHandler();
        this.originalSchema = schemaHandler.getSchema(this.originalAttributeType.getSchemaName());
        schemaHandler.addListener(this.schemaHandlerListener);
        this.addPageChangedListener(this.pageChangedListener);
    }

    public void dispose() {
        SchemaHandler schemaHandler = Activator.getDefault().getSchemaHandler();
        schemaHandler.removeListener(this.schemaHandlerListener);
        super.dispose();
    }

    protected void addPages() {
        try {
            this.overviewPage = new AttributeTypeEditorOverviewPage(this);
            this.addPage((IFormPage)this.overviewPage);
            this.sourceCodePage = new AttributeTypeEditorSourceCodePage(this);
            this.addPage((IFormPage)this.sourceCodePage);
            this.usedByPage = new AttributeTypeEditorUsedByPage(this);
            this.addPage((IFormPage)this.usedByPage);
        }
        catch (PartInitException e) {
            logger.debug((Object)"error when adding pages");
        }
    }

    public void doSave(IProgressMonitor monitor) {
        if (!this.sourceCodePage.canLeaveThePage()) {
            this.notifyError(Messages.getString("AttributeTypeEditor.AttributeErrors"));
            monitor.setCanceled(true);
            return;
        }
        Activator.getDefault().getSchemaHandler().modifyAttributeType(this.originalAttributeType, this.modifiedAttributeType);
        this.setPartName(this.getEditorInput().getName());
        if (!monitor.isCanceled()) {
            this.setDirty(false);
        }
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
        this.editorDirtyStateChanged();
    }

    public AttributeType getOriginalAttributeType() {
        return this.originalAttributeType;
    }

    public MutableAttributeType getModifiedAttributeType() {
        return this.modifiedAttributeType;
    }

    public void setModifiedAttributeType(MutableAttributeType modifiedAttributeType) {
        this.modifiedAttributeType = modifiedAttributeType;
    }

    private void notifyError(String message) {
        MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.getString("AttributeTypeEditor.Error"), (String)message);
    }
}

