/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.wizards;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.PluginConstants;
import org.apache.directory.studio.schemaeditor.controller.SchemaHandler;
import org.apache.directory.studio.schemaeditor.model.Schema;
import org.apache.directory.studio.schemaeditor.view.wizards.AbstractWizardPage;
import org.apache.directory.studio.schemaeditor.view.wizards.Messages;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ExportSchemasAsOpenLdapWizardPage
extends AbstractWizardPage {
    private Schema[] selectedSchemas = new Schema[0];
    private SchemaHandler schemaHandler;
    private CheckboxTableViewer schemasTableViewer;
    private Button schemasTableSelectAllButton;
    private Button schemasTableDeselectAllButton;
    private Label exportDirectoryLabel;
    private Text exportDirectoryText;
    private Button exportDirectoryButton;

    protected ExportSchemasAsOpenLdapWizardPage() {
        super("ExportSchemasAsOpenLdapWizardPage");
        this.setTitle(Messages.getString("ExportSchemasAsOpenLdapWizardPage.ExportSchemaAsOpenLDAP"));
        this.setDescription(Messages.getString("ExportSchemasAsOpenLdapWizardPage.PleaseSelectSchemaExportOpenLDAP"));
        this.setImageDescriptor(Activator.getDefault().getImageDescriptor("resources/icons/schemas_export_wizard.png"));
        this.schemaHandler = Activator.getDefault().getSchemaHandler();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        Group schemasGroup = new Group(composite, 0);
        schemasGroup.setText(Messages.getString("ExportSchemasAsOpenLdapWizardPage.Schemas"));
        schemasGroup.setLayout((Layout)new GridLayout(2, false));
        schemasGroup.setLayoutData((Object)new GridData(4, 0, true, false));
        Label schemasLabel = new Label((Composite)schemasGroup, 0);
        schemasLabel.setText(Messages.getString("ExportSchemasAsOpenLdapWizardPage.SelectSchemasToExport"));
        schemasLabel.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        this.schemasTableViewer = new CheckboxTableViewer(new Table((Composite)schemasGroup, 67616));
        GridData schemasTableViewerGridData = new GridData(4, 0, true, false, 1, 2);
        schemasTableViewerGridData.heightHint = 125;
        this.schemasTableViewer.getTable().setLayoutData((Object)schemasTableViewerGridData);
        this.schemasTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.schemasTableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof Schema) {
                    return ((Schema)((Object)element)).getSchemaName();
                }
                return super.getText(element);
            }

            public Image getImage(Object element) {
                if (element instanceof Schema) {
                    return Activator.getDefault().getImage("resources/icons/schema.gif");
                }
                return super.getImage(element);
            }
        });
        this.schemasTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ExportSchemasAsOpenLdapWizardPage.this.dialogChanged();
            }
        });
        this.schemasTableSelectAllButton = new Button((Composite)schemasGroup, 8);
        this.schemasTableSelectAllButton.setText(Messages.getString("ExportSchemasAsOpenLdapWizardPage.SelectAll"));
        this.schemasTableSelectAllButton.setLayoutData((Object)new GridData(4, 1, false, false));
        this.schemasTableSelectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportSchemasAsOpenLdapWizardPage.this.schemasTableViewer.setAllChecked(true);
                ExportSchemasAsOpenLdapWizardPage.this.dialogChanged();
            }
        });
        this.schemasTableDeselectAllButton = new Button((Composite)schemasGroup, 8);
        this.schemasTableDeselectAllButton.setText(Messages.getString("ExportSchemasAsOpenLdapWizardPage.DeselectAll"));
        this.schemasTableDeselectAllButton.setLayoutData((Object)new GridData(4, 1, false, false));
        this.schemasTableDeselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportSchemasAsOpenLdapWizardPage.this.schemasTableViewer.setAllChecked(false);
                ExportSchemasAsOpenLdapWizardPage.this.dialogChanged();
            }
        });
        Group exportDestinationGroup = new Group(composite, 0);
        exportDestinationGroup.setText(Messages.getString("ExportSchemasAsOpenLdapWizardPage.ExportDestination"));
        exportDestinationGroup.setLayout((Layout)new GridLayout(3, false));
        exportDestinationGroup.setLayoutData((Object)new GridData(4, 0, true, false));
        this.exportDirectoryLabel = new Label((Composite)exportDestinationGroup, 0);
        this.exportDirectoryLabel.setText(Messages.getString("ExportSchemasAsOpenLdapWizardPage.Directory"));
        this.exportDirectoryText = new Text((Composite)exportDestinationGroup, 2048);
        this.exportDirectoryText.setLayoutData((Object)new GridData(4, 0, true, false));
        this.exportDirectoryText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExportSchemasAsOpenLdapWizardPage.this.dialogChanged();
            }
        });
        this.exportDirectoryButton = new Button((Composite)exportDestinationGroup, 8);
        this.exportDirectoryButton.setText(Messages.getString("ExportSchemasAsOpenLdapWizardPage.Browse"));
        this.exportDirectoryButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportSchemasAsOpenLdapWizardPage.this.chooseExportDirectory();
                ExportSchemasAsOpenLdapWizardPage.this.dialogChanged();
            }
        });
        this.initFields();
        this.dialogChanged();
        this.setControl((Control)composite);
    }

    private void initFields() {
        if (this.schemaHandler != null) {
            ArrayList<Schema> schemas = new ArrayList<Schema>();
            schemas.addAll(this.schemaHandler.getSchemas());
            Collections.sort(schemas, new Comparator<Schema>(){

                @Override
                public int compare(Schema o1, Schema o2) {
                    return o1.getSchemaName().compareToIgnoreCase(o2.getSchemaName());
                }
            });
            this.schemasTableViewer.setInput(schemas);
            this.schemasTableViewer.setCheckedElements((Object[])this.selectedSchemas);
        }
        this.displayErrorMessage(null);
        this.setPageComplete(false);
    }

    private void chooseExportDirectory() {
        DirectoryDialog dialog = new DirectoryDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        dialog.setText(Messages.getString("ExportSchemasAsOpenLdapWizardPage.ChooseFolder"));
        dialog.setMessage(Messages.getString("ExportSchemasAsOpenLdapWizardPage.SelectFolderToExport"));
        if ("".equals(this.exportDirectoryText.getText())) {
            dialog.setFilterPath(Activator.getDefault().getPreferenceStore().getString(PluginConstants.FILE_DIALOG_EXPORT_SCHEMAS_OPENLDAP));
        } else {
            dialog.setFilterPath(this.exportDirectoryText.getText());
        }
        String selectedDirectory = dialog.open();
        if (selectedDirectory != null) {
            this.exportDirectoryText.setText(selectedDirectory);
        }
    }

    private void dialogChanged() {
        if (this.schemaHandler == null) {
            this.displayErrorMessage(Messages.getString("ExportSchemasAsOpenLdapWizardPage.ErrorNoOpenSchemaProject"));
            return;
        }
        if (this.schemasTableViewer.getCheckedElements().length == 0) {
            this.displayErrorMessage(Messages.getString("ExportSchemasAsOpenLdapWizardPage.ErrorNoSchemaSelected"));
            return;
        }
        String directory = this.exportDirectoryText.getText();
        if (directory == null || directory.equals("")) {
            this.displayErrorMessage(Messages.getString("ExportSchemasAsOpenLdapWizardPage.ErrorNotDirectorySelected"));
            return;
        }
        File directoryFile = new File(directory);
        if (!directoryFile.exists()) {
            this.displayErrorMessage(Messages.getString("ExportSchemasAsOpenLdapWizardPage.ErrorSelectedDirectoryNotExists"));
            return;
        }
        if (!directoryFile.isDirectory()) {
            this.displayErrorMessage(Messages.getString("ExportSchemasAsOpenLdapWizardPage.ErrorSelectedDirectoryNotDirectory"));
            return;
        }
        if (!directoryFile.canWrite()) {
            this.displayErrorMessage(Messages.getString("ExportSchemasAsOpenLdapWizardPage.ErrorSelectedDirectoryNotWritable"));
            return;
        }
        this.displayErrorMessage(null);
    }

    public Schema[] getSelectedSchemas() {
        Object[] selectedSchemas = this.schemasTableViewer.getCheckedElements();
        ArrayList<Schema> schemas = new ArrayList<Schema>();
        for (Object schema : selectedSchemas) {
            schemas.add((Schema)((Object)schema));
        }
        return schemas.toArray(new Schema[0]);
    }

    public void setSelectedSchemas(Schema[] schemas) {
        this.selectedSchemas = schemas;
    }

    public String getExportDirectory() {
        return this.exportDirectoryText.getText();
    }

    public void saveDialogSettings() {
        Activator.getDefault().getPreferenceStore().putValue(PluginConstants.FILE_DIALOG_EXPORT_SCHEMAS_OPENLDAP, this.exportDirectoryText.getText());
    }
}

