/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.aciitemeditor.widgets;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.directory.api.ldap.aci.GrantAndDenial;
import org.apache.directory.studio.aciitemeditor.Activator;
import org.apache.directory.studio.aciitemeditor.widgets.Messages;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

public class ACIItemGrantsAndDenialsComposite
extends Composite {
    private Label label = null;
    private Tree tree = null;
    private TreeViewer treeViewer = null;
    private Composite buttonComposite = null;
    private Button grantAllButton = null;
    private Button denyAllButton = null;
    private Button deselectAllButton = null;
    private Button undoButton = null;
    private Button redoButton = null;
    private static String PERMISSION = Messages.getString("ACIItemGrantsAndDenialsComposite.column1.header");
    private static String STATE = Messages.getString("ACIItemGrantsAndDenialsComposite.column2.header");
    private static String[] COLUMNS = new String[]{PERMISSION, STATE};
    private static final int MAX_STACK_SIZE = 25;
    private GrantAndDenialCategory[] grantAndDenialCategories = new GrantAndDenialCategory[]{new GrantAndDenialCategory(Messages.getString("ACIItemGrantsAndDenialsComposite.category.read"), true, new GrantAndDenialWrapper[]{new GrantAndDenialWrapper(GrantAndDenial.GRANT_BROWSE, GrantAndDenial.DENY_BROWSE), new GrantAndDenialWrapper(GrantAndDenial.GRANT_READ, GrantAndDenial.DENY_READ), new GrantAndDenialWrapper(GrantAndDenial.GRANT_COMPARE, GrantAndDenial.DENY_COMPARE), new GrantAndDenialWrapper(GrantAndDenial.GRANT_FILTER_MATCH, GrantAndDenial.DENY_FILTER_MATCH), new GrantAndDenialWrapper(GrantAndDenial.GRANT_RETURN_DN, GrantAndDenial.DENY_RETURN_DN)}), new GrantAndDenialCategory(Messages.getString("ACIItemGrantsAndDenialsComposite.category.modify"), true, new GrantAndDenialWrapper[]{new GrantAndDenialWrapper(GrantAndDenial.GRANT_ADD, GrantAndDenial.DENY_ADD), new GrantAndDenialWrapper(GrantAndDenial.GRANT_MODIFY, GrantAndDenial.DENY_MODIFY), new GrantAndDenialWrapper(GrantAndDenial.GRANT_REMOVE, GrantAndDenial.DENY_REMOVE), new GrantAndDenialWrapper(GrantAndDenial.GRANT_RENAME, GrantAndDenial.DENY_RENAME)}), new GrantAndDenialCategory(Messages.getString("ACIItemGrantsAndDenialsComposite.category.advanced"), false, new GrantAndDenialWrapper[]{new GrantAndDenialWrapper(GrantAndDenial.GRANT_EXPORT, GrantAndDenial.DENY_EXPORT), new GrantAndDenialWrapper(GrantAndDenial.GRANT_IMPORT, GrantAndDenial.DENY_IMPORT), new GrantAndDenialWrapper(GrantAndDenial.GRANT_INVOKE, GrantAndDenial.DENY_INVOKE), new GrantAndDenialWrapper(GrantAndDenial.GRANT_DISCLOSE_ON_ERROR, GrantAndDenial.DENY_DISCLOSE_ON_ERROR)})};

    public ACIItemGrantsAndDenialsComposite(Composite parent, int style) {
        super(parent, style);
        GridLayout layout = new GridLayout();
        layout.makeColumnsEqualWidth = false;
        layout.numColumns = 2;
        this.setLayout((Layout)layout);
        GridData layoutData = new GridData();
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.grabExcessVerticalSpace = true;
        layoutData.horizontalAlignment = 4;
        layoutData.verticalAlignment = 4;
        this.setLayoutData(layoutData);
        GridData labelGridData = new GridData();
        labelGridData.horizontalSpan = 2;
        labelGridData.verticalAlignment = 2;
        labelGridData.grabExcessHorizontalSpace = true;
        labelGridData.horizontalAlignment = 4;
        this.label = new Label((Composite)this, 0);
        this.label.setText(Messages.getString("ACIItemGrantsAndDenialsComposite.description"));
        this.label.setLayoutData((Object)labelGridData);
        this.createTree();
        this.createButtonComposite();
    }

    private void createTree() {
        GridData tableGridData = new GridData(1808);
        tableGridData.grabExcessHorizontalSpace = true;
        tableGridData.grabExcessVerticalSpace = true;
        tableGridData.verticalAlignment = 4;
        tableGridData.horizontalAlignment = 4;
        this.tree = new Tree((Composite)this, 101124);
        this.tree.setHeaderVisible(true);
        this.tree.setLayoutData((Object)tableGridData);
        this.tree.setLinesVisible(true);
        TreeColumn c1 = new TreeColumn(this.tree, 16384, 0);
        c1.setText(COLUMNS[0]);
        c1.setWidth(160);
        TreeColumn c2 = new TreeColumn(this.tree, 16384, 1);
        c2.setText(COLUMNS[1]);
        c2.setWidth(80);
        this.treeViewer = new TreeViewer(this.tree);
        this.treeViewer.setUseHashlookup(true);
        this.treeViewer.setColumnProperties(COLUMNS);
        GrantsAndDenialsCellModifier cellModifier = new GrantsAndDenialsCellModifier();
        this.treeViewer.setCellModifier((ICellModifier)cellModifier);
        CellEditor[] cellEditors = new CellEditor[]{null, new CheckboxCellEditor((Composite)this.tree), null};
        this.treeViewer.setCellEditors(cellEditors);
        this.treeViewer.setContentProvider((IContentProvider)new GrantsAndDenialsContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new GrantsAndDenialsLabelProvider());
        this.treeViewer.setInput((Object)this.grantAndDenialCategories);
        ArrayList<GrantAndDenialCategory> expandedList = new ArrayList<GrantAndDenialCategory>();
        for (GrantAndDenialCategory grantAndDenialCategory : this.grantAndDenialCategories) {
            if (!grantAndDenialCategory.expanded) continue;
            expandedList.add(grantAndDenialCategory);
        }
        this.treeViewer.setExpandedElements(expandedList.toArray());
    }

    private void createButtonComposite() {
        GridData deselectAllButtonGridData = new GridData();
        deselectAllButtonGridData.horizontalAlignment = 4;
        deselectAllButtonGridData.grabExcessHorizontalSpace = false;
        deselectAllButtonGridData.verticalAlignment = 1;
        deselectAllButtonGridData.widthHint = Activator.getButtonWidth((Control)this);
        GridData denyAllButtonGridData = new GridData();
        denyAllButtonGridData.horizontalAlignment = 4;
        denyAllButtonGridData.grabExcessHorizontalSpace = false;
        denyAllButtonGridData.verticalAlignment = 1;
        denyAllButtonGridData.widthHint = Activator.getButtonWidth((Control)this);
        GridData grantAllButtonGridData = new GridData();
        grantAllButtonGridData.horizontalAlignment = 4;
        grantAllButtonGridData.grabExcessHorizontalSpace = false;
        grantAllButtonGridData.verticalAlignment = 1;
        grantAllButtonGridData.widthHint = Activator.getButtonWidth((Control)this);
        GridData undoButtonGridData = new GridData();
        undoButtonGridData.horizontalAlignment = 4;
        undoButtonGridData.grabExcessHorizontalSpace = false;
        undoButtonGridData.verticalAlignment = 1;
        undoButtonGridData.widthHint = Activator.getButtonWidth((Control)this);
        GridData redoButtonGridData = new GridData();
        redoButtonGridData.horizontalAlignment = 4;
        redoButtonGridData.grabExcessHorizontalSpace = false;
        redoButtonGridData.verticalAlignment = 1;
        redoButtonGridData.widthHint = Activator.getButtonWidth((Control)this);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 2;
        gridData.grabExcessHorizontalSpace = false;
        gridData.grabExcessVerticalSpace = false;
        gridData.verticalAlignment = 4;
        this.buttonComposite = new Composite((Composite)this, 0);
        this.buttonComposite.setLayoutData((Object)gridData);
        this.buttonComposite.setLayout((Layout)gridLayout);
        this.grantAllButton = new Button(this.buttonComposite, 0);
        this.grantAllButton.setText(Messages.getString("ACIItemGrantsAndDenialsComposite.grantAll.button"));
        this.grantAllButton.setLayoutData((Object)grantAllButtonGridData);
        this.grantAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ACIItemGrantsAndDenialsComposite.this.backup();
                for (GrantAndDenialCategory grantAndDenialCategory : ACIItemGrantsAndDenialsComposite.this.grantAndDenialCategories) {
                    for (GrantAndDenialWrapper grantAndDenialWrapper : grantAndDenialCategory.grantAndDenialWrappers) {
                        grantAndDenialWrapper.activeGrantAndDenial = grantAndDenialWrapper.grant;
                    }
                }
                ACIItemGrantsAndDenialsComposite.this.treeViewer.refresh();
            }
        });
        this.denyAllButton = new Button(this.buttonComposite, 0);
        this.denyAllButton.setText(Messages.getString("ACIItemGrantsAndDenialsComposite.denyAll.button"));
        this.denyAllButton.setLayoutData((Object)denyAllButtonGridData);
        this.denyAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ACIItemGrantsAndDenialsComposite.this.backup();
                for (GrantAndDenialCategory grantAndDenialCategory : ACIItemGrantsAndDenialsComposite.this.grantAndDenialCategories) {
                    for (GrantAndDenialWrapper grantAndDenialWrapper : grantAndDenialCategory.grantAndDenialWrappers) {
                        grantAndDenialWrapper.activeGrantAndDenial = grantAndDenialWrapper.denial;
                    }
                }
                ACIItemGrantsAndDenialsComposite.this.treeViewer.refresh();
            }
        });
        this.deselectAllButton = new Button(this.buttonComposite, 0);
        this.deselectAllButton.setText(Messages.getString("ACIItemGrantsAndDenialsComposite.deselectAll.button"));
        this.deselectAllButton.setLayoutData((Object)deselectAllButtonGridData);
        this.deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ACIItemGrantsAndDenialsComposite.this.backup();
                for (GrantAndDenialCategory grantAndDenialCategory : ACIItemGrantsAndDenialsComposite.this.grantAndDenialCategories) {
                    for (GrantAndDenialWrapper grantAndDenialWrapper : grantAndDenialCategory.grantAndDenialWrappers) {
                        grantAndDenialWrapper.activeGrantAndDenial = null;
                    }
                }
                ACIItemGrantsAndDenialsComposite.this.treeViewer.refresh();
            }
        });
        this.undoButton = new Button(this.buttonComposite, 0);
        this.undoButton.setText(Messages.getString("ACIItemGrantsAndDenialsComposite.undo.button"));
        this.undoButton.setLayoutData((Object)undoButtonGridData);
        this.undoButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ACIItemGrantsAndDenialsComposite.this.undo();
                ACIItemGrantsAndDenialsComposite.this.treeViewer.refresh();
            }
        });
        this.undoButton.setEnabled(false);
        this.redoButton = new Button(this.buttonComposite, 0);
        this.redoButton.setText(Messages.getString("ACIItemGrantsAndDenialsComposite.redo.button"));
        this.redoButton.setLayoutData((Object)redoButtonGridData);
        this.redoButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ACIItemGrantsAndDenialsComposite.this.redo();
                ACIItemGrantsAndDenialsComposite.this.treeViewer.refresh();
            }
        });
        this.redoButton.setEnabled(false);
    }

    public void setGrantsAndDenials(Collection<GrantAndDenial> grantsAndDenials) {
        for (GrantAndDenial grantAndDenial : grantsAndDenials) {
            for (GrantAndDenialCategory grantAndDenialCategory : this.grantAndDenialCategories) {
                for (GrantAndDenialWrapper grantAndDenialWrapper : grantAndDenialCategory.grantAndDenialWrappers) {
                    if (grantAndDenialWrapper.grant == grantAndDenial) {
                        grantAndDenialWrapper.activeGrantAndDenial = grantAndDenialWrapper.grant;
                        continue;
                    }
                    if (grantAndDenialWrapper.denial != grantAndDenial) continue;
                    grantAndDenialWrapper.activeGrantAndDenial = grantAndDenialWrapper.denial;
                }
            }
        }
        this.treeViewer.refresh();
    }

    public Collection<GrantAndDenial> getGrantsAndDenials() throws ParseException {
        ArrayList<GrantAndDenial> grantsAndDenials = new ArrayList<GrantAndDenial>();
        for (GrantAndDenialCategory grantAndDenialCategory : this.grantAndDenialCategories) {
            for (GrantAndDenialWrapper grantAndDenialWrapper : grantAndDenialCategory.grantAndDenialWrappers) {
                if (grantAndDenialWrapper.activeGrantAndDenial == null) continue;
                grantsAndDenials.add(grantAndDenialWrapper.activeGrantAndDenial);
            }
        }
        return grantsAndDenials;
    }

    private void undo() {
        for (GrantAndDenialCategory grantAndDenialCategory : this.grantAndDenialCategories) {
            for (GrantAndDenialWrapper grantAndDenialWrapper : grantAndDenialCategory.grantAndDenialWrappers) {
                if (grantAndDenialWrapper.undoStack.size() > 0) {
                    grantAndDenialWrapper.redoStack.add(0, grantAndDenialWrapper.activeGrantAndDenial);
                    grantAndDenialWrapper.activeGrantAndDenial = (GrantAndDenial)grantAndDenialWrapper.undoStack.remove(0);
                }
                this.undoButton.setEnabled(!grantAndDenialWrapper.undoStack.isEmpty());
                this.redoButton.setEnabled(!grantAndDenialWrapper.redoStack.isEmpty());
            }
        }
    }

    private void redo() {
        for (GrantAndDenialCategory grantAndDenialCategory : this.grantAndDenialCategories) {
            for (GrantAndDenialWrapper grantAndDenialWrapper : grantAndDenialCategory.grantAndDenialWrappers) {
                if (grantAndDenialWrapper.redoStack.size() > 0) {
                    grantAndDenialWrapper.undoStack.add(0, grantAndDenialWrapper.activeGrantAndDenial);
                    grantAndDenialWrapper.activeGrantAndDenial = (GrantAndDenial)grantAndDenialWrapper.redoStack.remove(0);
                }
                this.undoButton.setEnabled(!grantAndDenialWrapper.undoStack.isEmpty());
                this.redoButton.setEnabled(!grantAndDenialWrapper.redoStack.isEmpty());
            }
        }
    }

    private void backup() {
        for (GrantAndDenialCategory grantAndDenialCategory : this.grantAndDenialCategories) {
            for (GrantAndDenialWrapper grantAndDenialWrapper : grantAndDenialCategory.grantAndDenialWrappers) {
                if (grantAndDenialWrapper.undoStack.size() == 25) {
                    grantAndDenialWrapper.undoStack.remove(grantAndDenialWrapper.undoStack.size() - 1);
                }
                grantAndDenialWrapper.undoStack.add(0, grantAndDenialWrapper.activeGrantAndDenial);
                grantAndDenialWrapper.redoStack.clear();
                this.undoButton.setEnabled(!grantAndDenialWrapper.undoStack.isEmpty());
                this.redoButton.setEnabled(!grantAndDenialWrapper.redoStack.isEmpty());
            }
        }
    }

    private class GrantsAndDenialsLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private GrantsAndDenialsLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (element instanceof GrantAndDenialWrapper) {
                GrantAndDenialWrapper grantAndDenialWrapper = (GrantAndDenialWrapper)element;
                switch (columnIndex) {
                    case 0: {
                        return null;
                    }
                    case 1: {
                        if (grantAndDenialWrapper.activeGrantAndDenial == null) {
                            return Activator.getDefault().getImage(Messages.getString("ACIItemGrantsAndDenialsComposite.unspecified.icon"));
                        }
                        if (grantAndDenialWrapper.activeGrantAndDenial == grantAndDenialWrapper.grant) {
                            return Activator.getDefault().getImage(Messages.getString("ACIItemGrantsAndDenialsComposite.grant.icon"));
                        }
                        if (grantAndDenialWrapper.activeGrantAndDenial == grantAndDenialWrapper.denial) {
                            return Activator.getDefault().getImage(Messages.getString("ACIItemGrantsAndDenialsComposite.deny.icon"));
                        }
                    }
                    case 2: {
                        return null;
                    }
                }
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof GrantAndDenialCategory) {
                if (columnIndex == 0) {
                    GrantAndDenialCategory cat = (GrantAndDenialCategory)element;
                    return cat.name;
                }
            } else if (element instanceof GrantAndDenialWrapper && columnIndex == 0) {
                GrantAndDenialWrapper wrapper = (GrantAndDenialWrapper)element;
                return wrapper.grant.getMicroOperation().getName();
            }
            return "";
        }
    }

    private class GrantsAndDenialsContentProvider
    extends ArrayContentProvider
    implements ITreeContentProvider {
        private GrantsAndDenialsContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof GrantAndDenialCategory) {
                GrantAndDenialCategory cat = (GrantAndDenialCategory)parentElement;
                return cat.grantAndDenialWrappers;
            }
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof GrantAndDenialCategory;
        }
    }

    private class GrantsAndDenialsCellModifier
    implements ICellModifier {
        private GrantsAndDenialsCellModifier() {
        }

        public boolean canModify(Object element, String property) {
            if (element instanceof GrantAndDenialWrapper) {
                return property.equals(STATE);
            }
            return false;
        }

        public Object getValue(Object element, String property) {
            if (element instanceof GrantAndDenialWrapper && property.equals(STATE)) {
                return new Boolean(true);
            }
            return null;
        }

        public void modify(Object element, String property, Object value) {
            if (element != null && element instanceof Item) {
                element = ((Item)element).getData();
            }
            if (element instanceof GrantAndDenialWrapper) {
                GrantAndDenialWrapper grantAndDenialWrapper = (GrantAndDenialWrapper)element;
                if (property.equals(STATE)) {
                    ACIItemGrantsAndDenialsComposite.this.backup();
                    if (grantAndDenialWrapper.activeGrantAndDenial == null) {
                        grantAndDenialWrapper.activeGrantAndDenial = grantAndDenialWrapper.grant;
                    } else if (grantAndDenialWrapper.activeGrantAndDenial == grantAndDenialWrapper.grant) {
                        grantAndDenialWrapper.activeGrantAndDenial = grantAndDenialWrapper.denial;
                    } else if (grantAndDenialWrapper.activeGrantAndDenial == grantAndDenialWrapper.denial) {
                        grantAndDenialWrapper.activeGrantAndDenial = null;
                    }
                }
            }
            ACIItemGrantsAndDenialsComposite.this.treeViewer.refresh();
        }
    }

    private class GrantAndDenialWrapper {
        private GrantAndDenial grant;
        private GrantAndDenial denial;
        private GrantAndDenial activeGrantAndDenial;
        private List<GrantAndDenial> undoStack;
        private List<GrantAndDenial> redoStack;

        private GrantAndDenialWrapper(GrantAndDenial grant, GrantAndDenial denial) {
            this.grant = grant;
            this.denial = denial;
            this.activeGrantAndDenial = null;
            this.undoStack = new LinkedList<GrantAndDenial>();
            this.redoStack = new LinkedList<GrantAndDenial>();
        }
    }

    private class GrantAndDenialCategory {
        private String name;
        private boolean expanded;
        private GrantAndDenialWrapper[] grantAndDenialWrappers;

        private GrantAndDenialCategory(String name, boolean expanded, GrantAndDenialWrapper[] grantAndDenialWrappers) {
            this.name = name;
            this.expanded = expanded;
            this.grantAndDenialWrappers = grantAndDenialWrappers;
        }
    }
}

