/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.cursor;

import java.io.IOException;
import org.apache.directory.api.ldap.model.constants.Loggers;
import org.apache.directory.api.ldap.model.cursor.Cursor;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.cursor.InvalidCursorPositionException;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.AbstractIndexCursor;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.server.xdbm.search.cursor.AllEntriesCursor;
import org.apache.directory.server.xdbm.search.evaluator.PresenceEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PresenceCursor
extends AbstractIndexCursor<String> {
    private static final Logger LOG_CURSOR = LoggerFactory.getLogger((String)Loggers.CURSOR_LOG.getName());
    private static final boolean IS_DEBUG = LOG_CURSOR.isDebugEnabled();
    private static final String UNSUPPORTED_MSG = I18n.err((I18n)I18n.ERR_724, (Object[])new Object[0]);
    private final Cursor<IndexEntry<String, String>> uuidCursor;
    private final Cursor<IndexEntry<String, String>> presenceCursor;
    private final PresenceEvaluator presenceEvaluator;
    private IndexEntry<String, String> prefetched;

    public PresenceCursor(Store store, PresenceEvaluator presenceEvaluator) throws Exception {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Creating PresenceCursor {}", (Object)this);
        }
        this.presenceEvaluator = presenceEvaluator;
        AttributeType type = presenceEvaluator.getAttributeType();
        if (store.hasUserIndexOn(type)) {
            this.presenceCursor = store.getPresenceIndex().forwardCursor(type.getOid());
            this.uuidCursor = null;
        } else {
            this.presenceCursor = null;
            this.uuidCursor = new AllEntriesCursor(store);
        }
    }

    @Override
    protected String getUnsupportedMessage() {
        return UNSUPPORTED_MSG;
    }

    @Override
    public boolean available() {
        if (this.presenceCursor != null) {
            return this.presenceCursor.available();
        }
        return super.available();
    }

    @Override
    public void before(IndexEntry<String, String> element) throws LdapException, CursorException, IOException {
        this.checkNotClosed("before()");
        if (this.presenceCursor != null) {
            this.presenceCursor.before(element);
            return;
        }
        super.before(element);
    }

    @Override
    public void after(IndexEntry<String, String> element) throws LdapException, CursorException, IOException {
        this.checkNotClosed("after()");
        if (this.presenceCursor != null) {
            this.presenceCursor.after(element);
            return;
        }
        super.after(element);
    }

    public void beforeFirst() throws LdapException, CursorException, IOException {
        this.checkNotClosed("beforeFirst()");
        if (this.presenceCursor != null) {
            this.presenceCursor.beforeFirst();
            return;
        }
        this.uuidCursor.beforeFirst();
        this.setAvailable(false);
    }

    public void afterLast() throws LdapException, CursorException, IOException {
        this.checkNotClosed("afterLast()");
        if (this.presenceCursor != null) {
            this.presenceCursor.afterLast();
            return;
        }
        this.uuidCursor.afterLast();
        this.setAvailable(false);
    }

    public boolean first() throws LdapException, CursorException, IOException {
        this.checkNotClosed("first()");
        if (this.presenceCursor != null) {
            return this.presenceCursor.first();
        }
        this.beforeFirst();
        return this.next();
    }

    public boolean last() throws LdapException, CursorException, IOException {
        this.checkNotClosed("last()");
        if (this.presenceCursor != null) {
            return this.presenceCursor.last();
        }
        this.afterLast();
        return this.previous();
    }

    public boolean previous() throws LdapException, CursorException, IOException {
        this.checkNotClosed("previous()");
        if (this.presenceCursor != null) {
            return this.presenceCursor.previous();
        }
        while (this.uuidCursor.previous()) {
            this.checkNotClosed("previous()");
            IndexEntry candidate = (IndexEntry)this.uuidCursor.get();
            if (!this.presenceEvaluator.evaluate(candidate)) continue;
            return this.setAvailable(true);
        }
        return this.setAvailable(false);
    }

    public boolean next() throws LdapException, CursorException, IOException {
        this.checkNotClosed("next()");
        if (this.presenceCursor != null) {
            return this.presenceCursor.next();
        }
        while (this.uuidCursor.next()) {
            this.checkNotClosed("next()");
            IndexEntry candidate = (IndexEntry)this.uuidCursor.get();
            if (!this.presenceEvaluator.evaluate(candidate)) continue;
            this.prefetched = candidate;
            return this.setAvailable(true);
        }
        return this.setAvailable(false);
    }

    public IndexEntry<String, String> get() throws CursorException, IOException {
        this.checkNotClosed("get()");
        if (this.presenceCursor != null) {
            if (this.presenceCursor.available()) {
                return (IndexEntry)this.presenceCursor.get();
            }
            throw new InvalidCursorPositionException(I18n.err((I18n)I18n.ERR_708, (Object[])new Object[0]));
        }
        if (this.available()) {
            if (this.prefetched == null) {
                this.prefetched = (IndexEntry)this.uuidCursor.get();
            }
            this.prefetched.setKey(this.presenceEvaluator.getAttributeType().getOid());
            return this.prefetched;
        }
        throw new InvalidCursorPositionException(I18n.err((I18n)I18n.ERR_708, (Object[])new Object[0]));
    }

    public void close() {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing PresenceCursor {}", (Object)this);
        }
        super.close();
        if (this.presenceCursor != null) {
            this.presenceCursor.close();
        } else {
            this.uuidCursor.close();
        }
    }

    public void close(Exception cause) {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing PresenceCursor {}", (Object)this);
        }
        super.close(cause);
        if (this.presenceCursor != null) {
            this.presenceCursor.close(cause);
        } else {
            this.uuidCursor.close(cause);
        }
    }

    public String toString(String tabs) {
        StringBuilder sb = new StringBuilder();
        sb.append(tabs).append("PresenceCursor (");
        if (this.available()) {
            sb.append("available)");
        } else {
            sb.append("absent)");
        }
        sb.append(" :\n");
        sb.append(tabs + "  >>").append(this.presenceEvaluator).append('\n');
        if (this.presenceCursor != null) {
            sb.append(tabs + "  <presence>\n");
            sb.append(this.presenceCursor.toString(tabs + "    "));
        }
        if (this.uuidCursor != null) {
            sb.append(tabs + "  <uuid>\n");
            sb.append(this.uuidCursor.toString(tabs + "  "));
        }
        return sb.toString();
    }

    public String toString() {
        return this.toString("");
    }
}

