/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.valueeditors.time;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import org.apache.directory.api.util.GeneralizedTime;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.apache.directory.studio.valueeditors.AbstractDialogStringValueEditor;
import org.apache.directory.studio.valueeditors.time.GeneralizedTimeValueDialog;
import org.apache.directory.studio.valueeditors.time.Messages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class GeneralizedTimeValueEditor
extends AbstractDialogStringValueEditor {
    public String getDisplayValue(IValue value) {
        String displayValue = super.getDisplayValue(value);
        if (!this.showRawValues()) {
            DateFormat targetFormat = DateFormat.getDateTimeInstance(2, 1);
            try {
                GeneralizedTime generalizedTime = new GeneralizedTime(displayValue);
                Date date = generalizedTime.getCalendar().getTime();
                displayValue = targetFormat.format(date) + " (" + displayValue + ")";
            }
            catch (ParseException pe) {
                // empty catch block
            }
        }
        return displayValue;
    }

    protected boolean openDialog(Shell shell) {
        Object value = this.getValue();
        if (value != null && value instanceof String) {
            String s = (String)value;
            GeneralizedTime generalizedTime = null;
            try {
                generalizedTime = "".equals(s) ? null : new GeneralizedTime(s);
            }
            catch (ParseException pe) {
                if (MessageDialog.openConfirm((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.getString("GeneralizedTimeValueEditor.BogusDateAndTimeValue"), (String)NLS.bind((String)Messages.getString("GeneralizedTimeValueEditor.TheValueIsBogus"), (Object[])new String[]{s}))) {
                    generalizedTime = new GeneralizedTime(Calendar.getInstance());
                }
                return false;
            }
            GeneralizedTimeValueDialog dialog = new GeneralizedTimeValueDialog(shell, generalizedTime);
            if (dialog.open() == 0) {
                GeneralizedTime newGeneralizedTime = dialog.getGeneralizedTime();
                if (newGeneralizedTime.getFraction() == 0) {
                    this.setValue(newGeneralizedTime.toGeneralizedTimeWithoutFraction());
                } else {
                    this.setValue(newGeneralizedTime.toGeneralizedTime());
                }
                return true;
            }
        }
        return false;
    }
}

