/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.editors.attributetype;

import java.util.ArrayList;
import java.util.List;
import org.apache.directory.api.asn1.util.Oid;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.LdapSyntax;
import org.apache.directory.api.ldap.model.schema.MatchingRule;
import org.apache.directory.api.ldap.model.schema.MutableAttributeType;
import org.apache.directory.api.ldap.model.schema.ObjectClass;
import org.apache.directory.api.ldap.model.schema.UsageEnum;
import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.PluginConstants;
import org.apache.directory.studio.schemaeditor.controller.SchemaHandler;
import org.apache.directory.studio.schemaeditor.controller.SchemaHandlerListener;
import org.apache.directory.studio.schemaeditor.model.Schema;
import org.apache.directory.studio.schemaeditor.model.alias.Alias;
import org.apache.directory.studio.schemaeditor.model.alias.AliasWithError;
import org.apache.directory.studio.schemaeditor.model.alias.AliasesStringParser;
import org.apache.directory.studio.schemaeditor.view.ViewUtils;
import org.apache.directory.studio.schemaeditor.view.dialogs.EditAttributeTypeAliasesDialog;
import org.apache.directory.studio.schemaeditor.view.editors.NonExistingAttributeType;
import org.apache.directory.studio.schemaeditor.view.editors.NonExistingMatchingRule;
import org.apache.directory.studio.schemaeditor.view.editors.NonExistingSyntax;
import org.apache.directory.studio.schemaeditor.view.editors.attributetype.ATEMatchingRulesComboContentProvider;
import org.apache.directory.studio.schemaeditor.view.editors.attributetype.ATEMatchingRulesComboInput;
import org.apache.directory.studio.schemaeditor.view.editors.attributetype.ATEMatchingRulesComboLabelProvider;
import org.apache.directory.studio.schemaeditor.view.editors.attributetype.ATESuperiorComboContentProvider;
import org.apache.directory.studio.schemaeditor.view.editors.attributetype.ATESuperiorComboInput;
import org.apache.directory.studio.schemaeditor.view.editors.attributetype.ATESuperiorComboLabelProvider;
import org.apache.directory.studio.schemaeditor.view.editors.attributetype.ATESyntaxComboContentProvider;
import org.apache.directory.studio.schemaeditor.view.editors.attributetype.ATESyntaxComboInput;
import org.apache.directory.studio.schemaeditor.view.editors.attributetype.ATESyntaxComboLabelProvider;
import org.apache.directory.studio.schemaeditor.view.editors.attributetype.AbstractAttributeTypeEditorPage;
import org.apache.directory.studio.schemaeditor.view.editors.attributetype.AttributeTypeEditor;
import org.apache.directory.studio.schemaeditor.view.editors.attributetype.AttributeTypeEditorInput;
import org.apache.directory.studio.schemaeditor.view.editors.attributetype.Messages;
import org.apache.directory.studio.schemaeditor.view.editors.schema.SchemaEditor;
import org.apache.directory.studio.schemaeditor.view.editors.schema.SchemaEditorInput;
import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class AttributeTypeEditorOverviewPage
extends AbstractAttributeTypeEditorPage {
    public static final String ID = AttributeTypeEditor.ID + ".overviewPage";
    private Schema originalSchema;
    private SchemaHandler schemaHandler;
    private SchemaHandlerListener schemaHandlerListener = new SchemaHandlerListener(){

        @Override
        public void attributeTypeAdded(AttributeType at) {
            AttributeTypeEditorOverviewPage.this.refreshUI();
        }

        @Override
        public void attributeTypeModified(AttributeType at) {
            AttributeTypeEditorOverviewPage.this.refreshUI();
        }

        @Override
        public void attributeTypeRemoved(AttributeType at) {
            if (!at.equals((Object)AttributeTypeEditorOverviewPage.this.getOriginalAttributeType())) {
                AttributeTypeEditorOverviewPage.this.refreshUI();
            }
        }

        @Override
        public void matchingRuleAdded(MatchingRule mr) {
            AttributeTypeEditorOverviewPage.this.refreshUI();
        }

        @Override
        public void matchingRuleModified(MatchingRule mr) {
            AttributeTypeEditorOverviewPage.this.refreshUI();
        }

        @Override
        public void matchingRuleRemoved(MatchingRule mr) {
            AttributeTypeEditorOverviewPage.this.refreshUI();
        }

        @Override
        public void objectClassAdded(ObjectClass oc) {
            AttributeTypeEditorOverviewPage.this.refreshUI();
        }

        @Override
        public void objectClassModified(ObjectClass oc) {
            AttributeTypeEditorOverviewPage.this.refreshUI();
        }

        @Override
        public void objectClassRemoved(ObjectClass oc) {
            AttributeTypeEditorOverviewPage.this.refreshUI();
        }

        @Override
        public void schemaAdded(Schema schema) {
            AttributeTypeEditorOverviewPage.this.refreshUI();
        }

        @Override
        public void schemaRemoved(Schema schema) {
            if (!((Object)((Object)schema)).equals((Object)AttributeTypeEditorOverviewPage.this.originalSchema)) {
                AttributeTypeEditorOverviewPage.this.refreshUI();
            }
        }

        @Override
        public void schemaRenamed(Schema schema) {
            AttributeTypeEditorOverviewPage.this.refreshUI();
        }

        @Override
        public void syntaxAdded(LdapSyntax syntax) {
            AttributeTypeEditorOverviewPage.this.refreshUI();
        }

        @Override
        public void syntaxModified(LdapSyntax syntax) {
            AttributeTypeEditorOverviewPage.this.refreshUI();
        }

        @Override
        public void syntaxRemoved(LdapSyntax syntax) {
            AttributeTypeEditorOverviewPage.this.refreshUI();
        }
    };
    private Text aliasesText;
    private Button aliasesButton;
    private Text oidText;
    private Hyperlink schemaLink;
    private Label schemaLabel;
    private Text descriptionText;
    private Hyperlink supLabel;
    private Combo supCombo;
    private ComboViewer supComboViewer;
    private Combo usageCombo;
    private Combo syntaxCombo;
    private ComboViewer syntaxComboViewer;
    private Text syntaxLengthText;
    private Button obsoleteCheckbox;
    private Button singleValueCheckbox;
    private Button collectiveCheckbox;
    private Button noUserModificationCheckbox;
    private Combo equalityCombo;
    private ComboViewer equalityComboViewer;
    private Combo orderingCombo;
    private ComboViewer orderingComboViewer;
    private Combo substringCombo;
    private ComboViewer substringComboViewer;
    private ModifyListener aliasesTextModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            MutableAttributeType modifiedAttributeType = AttributeTypeEditorOverviewPage.this.getModifiedAttributeType();
            AliasesStringParser parser = new AliasesStringParser();
            parser.parse(AttributeTypeEditorOverviewPage.this.aliasesText.getText());
            List<Alias> parsedAliases = parser.getAliases();
            modifiedAttributeType.setNames(new String[0]);
            ArrayList<String> aliasesList = new ArrayList<String>();
            for (Alias parsedAlias : parsedAliases) {
                if (parsedAlias instanceof AliasWithError) continue;
                aliasesList.add(parsedAlias.getAlias());
            }
            modifiedAttributeType.setNames(aliasesList.toArray(new String[0]));
            AttributeTypeEditorOverviewPage.this.setEditorDirty();
        }
    };
    private SelectionAdapter aliasesButtonListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            MutableAttributeType modifiedAttributeType = AttributeTypeEditorOverviewPage.this.getModifiedAttributeType();
            EditAttributeTypeAliasesDialog dialog = new EditAttributeTypeAliasesDialog(modifiedAttributeType.getNames());
            if (dialog.open() == 0) {
                modifiedAttributeType.setNames(dialog.getAliases());
                if (modifiedAttributeType.getNames() != null && modifiedAttributeType.getNames().size() != 0) {
                    AttributeTypeEditorOverviewPage.this.aliasesText.setText(ViewUtils.concateAliases(modifiedAttributeType.getNames()));
                } else {
                    AttributeTypeEditorOverviewPage.this.aliasesText.setText("");
                }
                AttributeTypeEditorOverviewPage.this.setEditorDirty();
            }
        }
    };
    private ModifyListener oidTextModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            AttributeTypeEditorOverviewPage.this.oidText.setForeground(ViewUtils.COLOR_BLACK);
            AttributeTypeEditorOverviewPage.this.oidText.setToolTipText("");
            String oid = AttributeTypeEditorOverviewPage.this.oidText.getText();
            if (Oid.isOid((String)oid)) {
                if (AttributeTypeEditorOverviewPage.this.getOriginalAttributeType().getOid().equals(oid) || !AttributeTypeEditorOverviewPage.this.schemaHandler.isOidAlreadyTaken(oid)) {
                    AttributeTypeEditorOverviewPage.this.getModifiedAttributeType().setOid(oid);
                    AttributeTypeEditorOverviewPage.this.setEditorDirty();
                } else {
                    AttributeTypeEditorOverviewPage.this.oidText.setForeground(ViewUtils.COLOR_RED);
                    AttributeTypeEditorOverviewPage.this.oidText.setToolTipText(Messages.getString("AttributeTypeEditorOverviewPage.ElementOIDExists"));
                }
            } else {
                AttributeTypeEditorOverviewPage.this.oidText.setForeground(ViewUtils.COLOR_RED);
                AttributeTypeEditorOverviewPage.this.oidText.setToolTipText(Messages.getString("AttributeTypeEditorOverviewPage.MalformedOID"));
            }
        }
    };
    private VerifyListener oidTextVerifyListener = new VerifyListener(){

        public void verifyText(VerifyEvent e) {
            if (!e.text.matches("([0-9]*\\.?)*")) {
                e.doit = false;
            }
        }
    };
    private HyperlinkAdapter schemaLinkListener = new HyperlinkAdapter(){

        public void linkActivated(HyperlinkEvent e) {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            SchemaEditorInput input = new SchemaEditorInput(AttributeTypeEditorOverviewPage.this.schemaHandler.getSchema(AttributeTypeEditorOverviewPage.this.getModifiedAttributeType().getSchemaName()));
            String editorId = SchemaEditor.ID;
            try {
                page.openEditor((IEditorInput)input, editorId);
            }
            catch (PartInitException exception) {
                Logger.getLogger(AttributeTypeEditorInput.class).debug((Object)"error when opening the editor");
            }
        }
    };
    private ModifyListener descriptionTextListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            int caretPosition = AttributeTypeEditorOverviewPage.this.descriptionText.getCaretPosition();
            AttributeTypeEditorOverviewPage.this.getModifiedAttributeType().setDescription(AttributeTypeEditorOverviewPage.this.descriptionText.getText());
            AttributeTypeEditorOverviewPage.this.descriptionText.setSelection(caretPosition);
            AttributeTypeEditorOverviewPage.this.setEditorDirty();
        }
    };
    private HyperlinkAdapter supLabelListener = new HyperlinkAdapter(){

        public void linkActivated(HyperlinkEvent e) {
            Object selectedItem = ((StructuredSelection)AttributeTypeEditorOverviewPage.this.supComboViewer.getSelection()).getFirstElement();
            if (selectedItem instanceof AttributeType) {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                AttributeTypeEditorInput input = new AttributeTypeEditorInput((AttributeType)selectedItem);
                try {
                    page.openEditor((IEditorInput)input, AttributeTypeEditor.ID);
                }
                catch (PartInitException exception) {
                    Logger.getLogger(AttributeTypeEditorInput.class).debug((Object)"error when opening the editor");
                }
            }
        }
    };
    private ISelectionChangedListener supComboViewerListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            MutableAttributeType modifiedAttributeType = AttributeTypeEditorOverviewPage.this.getModifiedAttributeType();
            Object selectedItem = ((StructuredSelection)AttributeTypeEditorOverviewPage.this.supComboViewer.getSelection()).getFirstElement();
            if (selectedItem instanceof AttributeType) {
                AttributeType at = (AttributeType)selectedItem;
                List names = at.getNames();
                if (names != null && names.size() > 0) {
                    modifiedAttributeType.setSuperiorOid((String)names.get(0));
                } else {
                    modifiedAttributeType.setSuperiorOid(at.getOid());
                }
            } else if (selectedItem instanceof NonExistingAttributeType) {
                NonExistingAttributeType neat = (NonExistingAttributeType)selectedItem;
                if ("(None)".equals(neat.getName())) {
                    modifiedAttributeType.setSuperiorOid(null);
                } else {
                    modifiedAttributeType.setSuperiorOid(((NonExistingAttributeType)selectedItem).getName());
                }
            }
            AttributeTypeEditorOverviewPage.this.setEditorDirty();
        }
    };
    private ModifyListener usageComboListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            MutableAttributeType modifiedAttributeType = AttributeTypeEditorOverviewPage.this.getModifiedAttributeType();
            if (AttributeTypeEditorOverviewPage.this.usageCombo.getSelectionIndex() == 0) {
                modifiedAttributeType.setUsage(UsageEnum.DIRECTORY_OPERATION);
            } else if (AttributeTypeEditorOverviewPage.this.usageCombo.getSelectionIndex() == 1) {
                modifiedAttributeType.setUsage(UsageEnum.DISTRIBUTED_OPERATION);
            } else if (AttributeTypeEditorOverviewPage.this.usageCombo.getSelectionIndex() == 2) {
                modifiedAttributeType.setUsage(UsageEnum.DSA_OPERATION);
            } else if (AttributeTypeEditorOverviewPage.this.usageCombo.getSelectionIndex() == 3) {
                modifiedAttributeType.setUsage(UsageEnum.USER_APPLICATIONS);
            }
            AttributeTypeEditorOverviewPage.this.setEditorDirty();
        }
    };
    private ISelectionChangedListener syntaxComboViewerListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            MutableAttributeType modifiedAttributeType = AttributeTypeEditorOverviewPage.this.getModifiedAttributeType();
            Object selectedItem = ((StructuredSelection)AttributeTypeEditorOverviewPage.this.syntaxComboViewer.getSelection()).getFirstElement();
            if (selectedItem instanceof LdapSyntax) {
                modifiedAttributeType.setSyntaxOid(((LdapSyntax)selectedItem).getOid());
            } else if (selectedItem instanceof NonExistingSyntax) {
                NonExistingSyntax nes = (NonExistingSyntax)selectedItem;
                if ("(None)".equals(nes.getDescription())) {
                    modifiedAttributeType.setSyntaxOid(null);
                } else {
                    modifiedAttributeType.setSyntaxOid(((NonExistingSyntax)selectedItem).getDescription());
                }
            }
            AttributeTypeEditorOverviewPage.this.setEditorDirty();
        }
    };
    private ModifyListener syntaxLengthTextModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            MutableAttributeType modifiedAttributeType = AttributeTypeEditorOverviewPage.this.getModifiedAttributeType();
            if (AttributeTypeEditorOverviewPage.this.syntaxLengthText.getText().length() <= 0) {
                modifiedAttributeType.setSyntaxLength(-1L);
            } else {
                modifiedAttributeType.setSyntaxLength((long)Integer.parseInt(AttributeTypeEditorOverviewPage.this.syntaxLengthText.getText()));
            }
            AttributeTypeEditorOverviewPage.this.setEditorDirty();
        }
    };
    private VerifyListener syntaxLengthTextVerifyListener = new VerifyListener(){

        public void verifyText(VerifyEvent e) {
            if (!e.text.matches("[0-9]*")) {
                e.doit = false;
            }
        }
    };
    private SelectionAdapter obsoleteCheckboxListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            AttributeTypeEditorOverviewPage.this.getModifiedAttributeType().setObsolete(AttributeTypeEditorOverviewPage.this.obsoleteCheckbox.getSelection());
            AttributeTypeEditorOverviewPage.this.setEditorDirty();
        }
    };
    private SelectionAdapter singleValueCheckboxListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            AttributeTypeEditorOverviewPage.this.getModifiedAttributeType().setSingleValued(AttributeTypeEditorOverviewPage.this.singleValueCheckbox.getSelection());
            AttributeTypeEditorOverviewPage.this.setEditorDirty();
        }
    };
    private SelectionAdapter collectiveCheckboxListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            AttributeTypeEditorOverviewPage.this.getModifiedAttributeType().setCollective(AttributeTypeEditorOverviewPage.this.collectiveCheckbox.getSelection());
            AttributeTypeEditorOverviewPage.this.setEditorDirty();
        }
    };
    private SelectionAdapter noUserModificationCheckboxListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            AttributeTypeEditorOverviewPage.this.getModifiedAttributeType().setUserModifiable(!AttributeTypeEditorOverviewPage.this.noUserModificationCheckbox.getSelection());
            AttributeTypeEditorOverviewPage.this.setEditorDirty();
        }
    };
    private ISelectionChangedListener equalityComboViewerListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            MutableAttributeType modifiedAttributeType = AttributeTypeEditorOverviewPage.this.getModifiedAttributeType();
            Object selectedItem = ((StructuredSelection)AttributeTypeEditorOverviewPage.this.equalityComboViewer.getSelection()).getFirstElement();
            if (selectedItem instanceof MatchingRule) {
                modifiedAttributeType.setEqualityOid(((MatchingRule)selectedItem).getName());
            } else if (selectedItem instanceof NonExistingMatchingRule) {
                NonExistingMatchingRule nemr = (NonExistingMatchingRule)selectedItem;
                if ("(None)".equals(nemr.getName())) {
                    modifiedAttributeType.setEqualityOid(null);
                } else {
                    modifiedAttributeType.setEqualityOid(((NonExistingMatchingRule)selectedItem).getName());
                }
            }
            AttributeTypeEditorOverviewPage.this.setEditorDirty();
        }
    };
    private ISelectionChangedListener orderingComboViewerListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            MutableAttributeType modifiedAttributeType = AttributeTypeEditorOverviewPage.this.getModifiedAttributeType();
            Object selectedItem = ((StructuredSelection)AttributeTypeEditorOverviewPage.this.orderingComboViewer.getSelection()).getFirstElement();
            if (selectedItem instanceof MatchingRule) {
                modifiedAttributeType.setOrderingOid(((MatchingRule)selectedItem).getName());
            } else if (selectedItem instanceof NonExistingMatchingRule) {
                NonExistingMatchingRule nemr = (NonExistingMatchingRule)selectedItem;
                if ("(None)".equals(nemr.getName())) {
                    modifiedAttributeType.setOrderingOid(null);
                } else {
                    modifiedAttributeType.setOrderingOid(((NonExistingMatchingRule)selectedItem).getName());
                }
            }
            AttributeTypeEditorOverviewPage.this.setEditorDirty();
        }
    };
    private ISelectionChangedListener substringComboViewerListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            MutableAttributeType modifiedAttributeType = AttributeTypeEditorOverviewPage.this.getModifiedAttributeType();
            Object selectedItem = ((StructuredSelection)AttributeTypeEditorOverviewPage.this.substringComboViewer.getSelection()).getFirstElement();
            if (selectedItem instanceof MatchingRule) {
                modifiedAttributeType.setSubstringOid(((MatchingRule)selectedItem).getName());
            } else if (selectedItem instanceof NonExistingMatchingRule) {
                NonExistingMatchingRule nemr = (NonExistingMatchingRule)selectedItem;
                if ("(None)".equals(nemr.getName())) {
                    modifiedAttributeType.setSubstringOid(null);
                } else {
                    modifiedAttributeType.setSubstringOid(((NonExistingMatchingRule)selectedItem).getName());
                }
            }
            AttributeTypeEditorOverviewPage.this.setEditorDirty();
        }
    };
    private Listener mouseWheelFilter = new Listener(){

        public void handleEvent(Event event) {
            if (event.widget instanceof Combo) {
                event.doit = false;
            }
        }
    };

    public AttributeTypeEditorOverviewPage(AttributeTypeEditor editor) {
        super(editor, ID, Messages.getString("AttributeTypeEditorOverviewPage.Overview"));
        this.schemaHandler = Activator.getDefault().getSchemaHandler();
        this.schemaHandler.addListener(this.schemaHandlerListener);
    }

    @Override
    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        GridLayout layout = new GridLayout();
        form.getBody().setLayout((Layout)layout);
        this.createGeneralInformationSection(form.getBody(), toolkit);
        this.createMatchingRulesSection(form.getBody(), toolkit);
        this.fillInUiFields();
        this.addListeners();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)form, PluginConstants.PLUGIN_ID + "." + "attribute_type_editor");
    }

    private void createGeneralInformationSection(Composite parent, FormToolkit toolkit) {
        Section section_general_information = toolkit.createSection(parent, 448);
        section_general_information.setDescription(Messages.getString("AttributeTypeEditorOverviewPage.SpecifyGeneralInformation"));
        section_general_information.setText(Messages.getString("AttributeTypeEditorOverviewPage.GeneralInformation"));
        Composite client_general_information = toolkit.createComposite((Composite)section_general_information);
        client_general_information.setLayout((Layout)new GridLayout(2, false));
        toolkit.paintBordersFor(client_general_information);
        section_general_information.setClient((Control)client_general_information);
        section_general_information.setLayoutData((Object)new GridData(4, 0, true, false));
        toolkit.createLabel(client_general_information, Messages.getString("AttributeTypeEditorOverviewPage.Aliases"));
        Composite aliasComposite = toolkit.createComposite(client_general_information);
        GridLayout aliasCompositeGridLayout = new GridLayout(2, false);
        toolkit.paintBordersFor(aliasComposite);
        aliasCompositeGridLayout.marginHeight = 1;
        aliasCompositeGridLayout.marginWidth = 1;
        aliasComposite.setLayout((Layout)aliasCompositeGridLayout);
        aliasComposite.setLayoutData((Object)new GridData(4, 0, true, false));
        this.aliasesText = toolkit.createText(aliasComposite, "");
        this.aliasesText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.aliasesButton = toolkit.createButton(aliasComposite, Messages.getString("AttributeTypeEditorOverviewPage.EditAliases"), 8);
        this.aliasesButton.setLayoutData((Object)new GridData(0, 0x1000000, false, false));
        toolkit.createLabel(client_general_information, Messages.getString("AttributeTypeEditorOverviewPage.OID"));
        this.oidText = toolkit.createText(client_general_information, "");
        this.oidText.setLayoutData((Object)new GridData(4, 0, true, false));
        toolkit.createLabel(client_general_information, Messages.getString("AttributeTypeEditorOverviewPage.Description"));
        this.descriptionText = toolkit.createText(client_general_information, "", 514);
        GridData descriptionGridData = new GridData(4, 0, true, false);
        descriptionGridData.heightHint = 42;
        this.descriptionText.setLayoutData((Object)descriptionGridData);
        this.schemaLink = toolkit.createHyperlink(client_general_information, Messages.getString("AttributeTypeEditorOverviewPage.Schema"), 64);
        this.schemaLabel = toolkit.createLabel(client_general_information, "");
        this.schemaLabel.setLayoutData((Object)new GridData(4, 0, true, false));
        this.supLabel = toolkit.createHyperlink(client_general_information, Messages.getString("AttributeTypeEditorOverviewPage.SuperiorType"), 64);
        this.supCombo = new Combo(client_general_information, 12);
        this.supCombo.setLayoutData((Object)new GridData(4, 0, true, false));
        this.supComboViewer = new ComboViewer(this.supCombo);
        this.supComboViewer.setContentProvider((IContentProvider)new ATESuperiorComboContentProvider());
        this.supComboViewer.setLabelProvider((IBaseLabelProvider)new ATESuperiorComboLabelProvider());
        toolkit.createLabel(client_general_information, Messages.getString("AttributeTypeEditorOverviewPage.Usage"));
        this.usageCombo = new Combo(client_general_information, 12);
        this.usageCombo.setLayoutData((Object)new GridData(4, 0, true, false));
        this.initUsageCombo();
        toolkit.createLabel(client_general_information, Messages.getString("AttributeTypeEditorOverviewPage.Syntax"));
        this.syntaxCombo = new Combo(client_general_information, 12);
        this.syntaxCombo.setLayoutData((Object)new GridData(4, 0, true, false));
        this.syntaxComboViewer = new ComboViewer(this.syntaxCombo);
        this.syntaxComboViewer.setContentProvider((IContentProvider)new ATESyntaxComboContentProvider());
        this.syntaxComboViewer.setLabelProvider((IBaseLabelProvider)new ATESyntaxComboLabelProvider());
        toolkit.createLabel(client_general_information, Messages.getString("AttributeTypeEditorOverviewPage.SyntaxLength"));
        this.syntaxLengthText = toolkit.createText(client_general_information, "");
        this.syntaxLengthText.setLayoutData((Object)new GridData(4, 0, true, false));
        toolkit.createLabel(client_general_information, "");
        Composite propertiesComposite = toolkit.createComposite(client_general_information);
        GridLayout propertiesCompositeGridLayout = new GridLayout(2, true);
        propertiesCompositeGridLayout.horizontalSpacing = 0;
        propertiesCompositeGridLayout.verticalSpacing = 0;
        propertiesCompositeGridLayout.marginHeight = 0;
        propertiesCompositeGridLayout.marginWidth = 0;
        propertiesComposite.setLayout((Layout)propertiesCompositeGridLayout);
        propertiesComposite.setLayoutData((Object)new GridData(4, 0, true, false));
        this.obsoleteCheckbox = toolkit.createButton(propertiesComposite, Messages.getString("AttributeTypeEditorOverviewPage.Obsolete"), 32);
        this.obsoleteCheckbox.setLayoutData((Object)new GridData(4, 0, true, false));
        this.singleValueCheckbox = toolkit.createButton(propertiesComposite, Messages.getString("AttributeTypeEditorOverviewPage.SingleValue"), 32);
        this.singleValueCheckbox.setLayoutData((Object)new GridData(4, 0, true, false));
        toolkit.createLabel(client_general_information, "");
        this.collectiveCheckbox = toolkit.createButton(propertiesComposite, Messages.getString("AttributeTypeEditorOverviewPage.Collective"), 32);
        this.collectiveCheckbox.setLayoutData((Object)new GridData(4, 0, true, false));
        this.noUserModificationCheckbox = toolkit.createButton(propertiesComposite, Messages.getString("AttributeTypeEditorOverviewPage.NoUserModification"), 32);
        this.noUserModificationCheckbox.setLayoutData((Object)new GridData(4, 0, true, false));
    }

    private void createMatchingRulesSection(Composite parent, FormToolkit toolkit) {
        Section section_matching_rules = toolkit.createSection(parent, 448);
        section_matching_rules.setDescription(Messages.getString("AttributeTypeEditorOverviewPage.SpecifyMatchingRules"));
        section_matching_rules.setText(Messages.getString("AttributeTypeEditorOverviewPage.MatchingRules"));
        Composite client_matching_rules = toolkit.createComposite((Composite)section_matching_rules);
        GridLayout layout_matching_rules = new GridLayout();
        layout_matching_rules.numColumns = 2;
        client_matching_rules.setLayout((Layout)layout_matching_rules);
        toolkit.paintBordersFor(client_matching_rules);
        section_matching_rules.setClient((Control)client_matching_rules);
        section_matching_rules.setLayoutData((Object)new GridData(4, 4, true, true));
        toolkit.createLabel(client_matching_rules, Messages.getString("AttributeTypeEditorOverviewPage.Equality"));
        this.equalityCombo = new Combo(client_matching_rules, 12);
        this.equalityCombo.setLayoutData((Object)new GridData(4, 0, true, false));
        this.equalityComboViewer = new ComboViewer(this.equalityCombo);
        this.equalityComboViewer.setContentProvider((IContentProvider)new ATEMatchingRulesComboContentProvider());
        this.equalityComboViewer.setLabelProvider((IBaseLabelProvider)new ATEMatchingRulesComboLabelProvider());
        toolkit.createLabel(client_matching_rules, Messages.getString("AttributeTypeEditorOverviewPage.Ordering"));
        this.orderingCombo = new Combo(client_matching_rules, 12);
        this.orderingCombo.setLayoutData((Object)new GridData(4, 0, true, false));
        this.orderingComboViewer = new ComboViewer(this.orderingCombo);
        this.orderingComboViewer.setContentProvider((IContentProvider)new ATEMatchingRulesComboContentProvider());
        this.orderingComboViewer.setLabelProvider((IBaseLabelProvider)new ATEMatchingRulesComboLabelProvider());
        toolkit.createLabel(client_matching_rules, Messages.getString("AttributeTypeEditorOverviewPage.Substring"));
        this.substringCombo = new Combo(client_matching_rules, 12);
        this.substringCombo.setLayoutData((Object)new GridData(4, 0, true, false));
        this.substringComboViewer = new ComboViewer(this.substringCombo);
        this.substringComboViewer.setContentProvider((IContentProvider)new ATEMatchingRulesComboContentProvider());
        this.substringComboViewer.setLabelProvider((IBaseLabelProvider)new ATEMatchingRulesComboLabelProvider());
    }

    private void initUsageCombo() {
        this.usageCombo.add("Directory Operation", 0);
        this.usageCombo.add("Distributed Operation", 1);
        this.usageCombo.add("DSA Operation", 2);
        this.usageCombo.add("User Applications", 3);
    }

    @Override
    protected void fillInUiFields() {
        MutableAttributeType modifiedAttributeType = this.getModifiedAttributeType();
        this.originalSchema = this.schemaHandler.getSchema(this.getOriginalAttributeType().getSchemaName());
        if (modifiedAttributeType.getNames() != null && modifiedAttributeType.getNames().size() != 0) {
            this.aliasesText.setText(ViewUtils.concateAliases(modifiedAttributeType.getNames()));
        } else {
            this.aliasesText.setText("");
        }
        if (modifiedAttributeType.getOid() != null) {
            this.oidText.setText(modifiedAttributeType.getOid());
        }
        this.schemaLabel.setText(modifiedAttributeType.getSchemaName());
        if (modifiedAttributeType.getDescription() != null) {
            this.descriptionText.setText(modifiedAttributeType.getDescription());
        }
        this.fillSupCombo();
        this.fillInUsageCombo();
        this.fillSyntaxCombo();
        if (modifiedAttributeType.getSyntaxLength() > 0L) {
            this.syntaxLengthText.setText(modifiedAttributeType.getSyntaxLength() + "");
        }
        this.obsoleteCheckbox.setSelection(modifiedAttributeType.isObsolete());
        this.singleValueCheckbox.setSelection(modifiedAttributeType.isSingleValued());
        this.collectiveCheckbox.setSelection(modifiedAttributeType.isCollective());
        this.noUserModificationCheckbox.setSelection(!modifiedAttributeType.isUserModifiable());
        this.fillEqualityCombo();
        this.fillOrderingCombo();
        this.fillSubstringCombo();
    }

    private void fillSupCombo() {
        this.supComboViewer.setInput((Object)new ATESuperiorComboInput(this.getOriginalAttributeType()));
        String supAtName = this.getModifiedAttributeType().getSuperiorOid();
        if (supAtName == null) {
            this.supComboViewer.setSelection((ISelection)new StructuredSelection((Object)new NonExistingAttributeType("(None)")), true);
        } else {
            AttributeType supAT = this.schemaHandler.getAttributeType(supAtName);
            if (supAT != null) {
                this.supComboViewer.setSelection((ISelection)new StructuredSelection((Object)supAT), true);
            } else {
                ATESuperiorComboInput input = (ATESuperiorComboInput)this.supComboViewer.getInput();
                NonExistingAttributeType neat = new NonExistingAttributeType(supAtName);
                if (!input.getChildren().contains(neat)) {
                    input.addChild(neat);
                }
                this.supComboViewer.refresh();
                this.supComboViewer.setSelection((ISelection)new StructuredSelection((Object)neat), true);
            }
        }
    }

    private void fillInUsageCombo() {
        UsageEnum usage = this.getModifiedAttributeType().getUsage();
        switch (usage) {
            case DIRECTORY_OPERATION: {
                this.usageCombo.select(0);
                return;
            }
            case DISTRIBUTED_OPERATION: {
                this.usageCombo.select(1);
                return;
            }
            case DSA_OPERATION: {
                this.usageCombo.select(2);
                return;
            }
            case USER_APPLICATIONS: {
                this.usageCombo.select(3);
                return;
            }
        }
    }

    private void fillSyntaxCombo() {
        this.syntaxComboViewer.setInput((Object)new ATESyntaxComboInput());
        String syntaxOID = this.getModifiedAttributeType().getSyntaxOid();
        if (syntaxOID == null) {
            this.syntaxComboViewer.setSelection((ISelection)new StructuredSelection((Object)new NonExistingSyntax("(None)")), true);
        } else {
            LdapSyntax syntax = this.schemaHandler.getSyntax(syntaxOID);
            if (syntax != null) {
                this.syntaxComboViewer.setSelection((ISelection)new StructuredSelection((Object)syntax), true);
            } else {
                ATESyntaxComboInput input = (ATESyntaxComboInput)this.syntaxComboViewer.getInput();
                NonExistingSyntax nes = new NonExistingSyntax(syntaxOID);
                if (!input.getChildren().contains(nes)) {
                    input.addChild(nes);
                }
                this.syntaxComboViewer.refresh();
                this.syntaxComboViewer.setSelection((ISelection)new StructuredSelection((Object)nes), true);
            }
        }
    }

    private void fillEqualityCombo() {
        this.equalityComboViewer.setInput((Object)new ATEMatchingRulesComboInput());
        String equalityName = this.getModifiedAttributeType().getEqualityOid();
        if (equalityName == null) {
            this.equalityComboViewer.setSelection((ISelection)new StructuredSelection((Object)new NonExistingMatchingRule("(None)")), true);
        } else {
            MatchingRule matchingRule = this.schemaHandler.getMatchingRule(equalityName);
            if (matchingRule != null) {
                this.equalityComboViewer.setSelection((ISelection)new StructuredSelection((Object)matchingRule), true);
            } else {
                ATEMatchingRulesComboInput input = (ATEMatchingRulesComboInput)this.equalityComboViewer.getInput();
                NonExistingMatchingRule nemr = new NonExistingMatchingRule(equalityName);
                if (!input.getChildren().contains(nemr)) {
                    input.addChild(nemr);
                }
                this.equalityComboViewer.refresh();
                this.equalityComboViewer.setSelection((ISelection)new StructuredSelection((Object)nemr), true);
            }
        }
    }

    private void fillOrderingCombo() {
        this.orderingComboViewer.setInput((Object)new ATEMatchingRulesComboInput());
        String orderingName = this.getModifiedAttributeType().getOrderingOid();
        if (orderingName == null) {
            this.orderingComboViewer.setSelection((ISelection)new StructuredSelection((Object)new NonExistingMatchingRule("(None)")), true);
        } else {
            MatchingRule matchingRule = this.schemaHandler.getMatchingRule(orderingName);
            if (matchingRule != null) {
                this.orderingComboViewer.setSelection((ISelection)new StructuredSelection((Object)matchingRule), true);
            } else {
                ATEMatchingRulesComboInput input = (ATEMatchingRulesComboInput)this.orderingComboViewer.getInput();
                NonExistingMatchingRule nemr = new NonExistingMatchingRule(orderingName);
                if (!input.getChildren().contains(nemr)) {
                    input.addChild(nemr);
                }
                this.orderingComboViewer.refresh();
                this.orderingComboViewer.setSelection((ISelection)new StructuredSelection((Object)nemr), true);
            }
        }
    }

    private void fillSubstringCombo() {
        this.substringComboViewer.setInput((Object)new ATEMatchingRulesComboInput());
        String substringName = this.getModifiedAttributeType().getSubstringOid();
        if (substringName == null) {
            this.substringComboViewer.setSelection((ISelection)new StructuredSelection((Object)new NonExistingMatchingRule("(None)")), true);
        } else {
            MatchingRule matchingRule = this.schemaHandler.getMatchingRule(substringName);
            if (matchingRule != null) {
                this.substringComboViewer.setSelection((ISelection)new StructuredSelection((Object)matchingRule), true);
            } else {
                ATEMatchingRulesComboInput input = (ATEMatchingRulesComboInput)this.substringComboViewer.getInput();
                NonExistingMatchingRule nemr = new NonExistingMatchingRule(substringName);
                if (!input.getChildren().contains(nemr)) {
                    input.addChild(nemr);
                }
                this.substringComboViewer.refresh();
                this.substringComboViewer.setSelection((ISelection)new StructuredSelection((Object)nemr), true);
            }
        }
    }

    @Override
    protected void addListeners() {
        this.addModifyListener(this.aliasesText, this.aliasesTextModifyListener);
        this.addSelectionListener(this.aliasesButton, (SelectionListener)this.aliasesButtonListener);
        this.addModifyListener(this.oidText, this.oidTextModifyListener);
        this.addVerifyListener(this.oidText, this.oidTextVerifyListener);
        this.addHyperlinkListener(this.schemaLink, (IHyperlinkListener)this.schemaLinkListener);
        this.addModifyListener(this.descriptionText, this.descriptionTextListener);
        this.addHyperlinkListener(this.supLabel, (IHyperlinkListener)this.supLabelListener);
        this.addSelectionChangedListener((Viewer)this.supComboViewer, this.supComboViewerListener);
        this.addModifyListener(this.usageCombo, this.usageComboListener);
        this.addSelectionChangedListener((Viewer)this.syntaxComboViewer, this.syntaxComboViewerListener);
        this.addModifyListener(this.syntaxLengthText, this.syntaxLengthTextModifyListener);
        this.addVerifyListener(this.syntaxLengthText, this.syntaxLengthTextVerifyListener);
        this.addSelectionListener(this.obsoleteCheckbox, (SelectionListener)this.obsoleteCheckboxListener);
        this.addSelectionListener(this.singleValueCheckbox, (SelectionListener)this.singleValueCheckboxListener);
        this.addSelectionListener(this.collectiveCheckbox, (SelectionListener)this.collectiveCheckboxListener);
        this.addSelectionListener(this.noUserModificationCheckbox, (SelectionListener)this.noUserModificationCheckboxListener);
        this.addSelectionChangedListener((Viewer)this.equalityComboViewer, this.equalityComboViewerListener);
        this.addSelectionChangedListener((Viewer)this.orderingComboViewer, this.orderingComboViewerListener);
        this.addSelectionChangedListener((Viewer)this.substringComboViewer, this.substringComboViewerListener);
        Display.getCurrent().addFilter(37, this.mouseWheelFilter);
    }

    @Override
    protected void removeListeners() {
        this.removeModifyListener(this.aliasesText, this.aliasesTextModifyListener);
        this.removeSelectionListener(this.aliasesButton, (SelectionListener)this.aliasesButtonListener);
        this.removeModifyListener(this.oidText, this.oidTextModifyListener);
        this.removeVerifyListener(this.oidText, this.oidTextVerifyListener);
        this.removeHyperlinkListener(this.schemaLink, (IHyperlinkListener)this.schemaLinkListener);
        this.removeModifyListener(this.descriptionText, this.descriptionTextListener);
        this.removeHyperlinkListener(this.supLabel, (IHyperlinkListener)this.supLabelListener);
        this.removeSelectionChangedListener((Viewer)this.supComboViewer, this.supComboViewerListener);
        this.removeModifyListener(this.usageCombo, this.usageComboListener);
        this.removeSelectionChangedListener((Viewer)this.syntaxComboViewer, this.syntaxComboViewerListener);
        this.removeModifyListener(this.syntaxLengthText, this.syntaxLengthTextModifyListener);
        this.removeVerifyListener(this.syntaxLengthText, this.syntaxLengthTextVerifyListener);
        this.removeSelectionListener(this.obsoleteCheckbox, (SelectionListener)this.obsoleteCheckboxListener);
        this.removeSelectionListener(this.singleValueCheckbox, (SelectionListener)this.singleValueCheckboxListener);
        this.removeSelectionListener(this.collectiveCheckbox, (SelectionListener)this.collectiveCheckboxListener);
        this.removeSelectionListener(this.noUserModificationCheckbox, (SelectionListener)this.noUserModificationCheckboxListener);
        this.removeSelectionChangedListener((Viewer)this.equalityComboViewer, this.equalityComboViewerListener);
        this.removeSelectionChangedListener((Viewer)this.orderingComboViewer, this.orderingComboViewerListener);
        this.removeSelectionChangedListener((Viewer)this.substringComboViewer, this.substringComboViewerListener);
        Display.getCurrent().removeFilter(37, this.mouseWheelFilter);
    }

    @Override
    public void dispose() {
        this.schemaHandler.removeListener(this.schemaHandlerListener);
        super.dispose();
    }
}

