/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.editors.objectclass;

import java.util.ArrayList;
import java.util.List;
import org.apache.directory.api.asn1.util.Oid;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.LdapSyntax;
import org.apache.directory.api.ldap.model.schema.MatchingRule;
import org.apache.directory.api.ldap.model.schema.MutableObjectClass;
import org.apache.directory.api.ldap.model.schema.ObjectClass;
import org.apache.directory.api.ldap.model.schema.ObjectClassTypeEnum;
import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.PluginConstants;
import org.apache.directory.studio.schemaeditor.controller.SchemaHandler;
import org.apache.directory.studio.schemaeditor.controller.SchemaHandlerListener;
import org.apache.directory.studio.schemaeditor.model.Schema;
import org.apache.directory.studio.schemaeditor.model.alias.Alias;
import org.apache.directory.studio.schemaeditor.model.alias.AliasWithError;
import org.apache.directory.studio.schemaeditor.model.alias.AliasesStringParser;
import org.apache.directory.studio.schemaeditor.view.ViewUtils;
import org.apache.directory.studio.schemaeditor.view.dialogs.AttributeTypeSelectionDialog;
import org.apache.directory.studio.schemaeditor.view.dialogs.EditObjectClassAliasesDialog;
import org.apache.directory.studio.schemaeditor.view.dialogs.ObjectClassSelectionDialog;
import org.apache.directory.studio.schemaeditor.view.editors.NonExistingAttributeType;
import org.apache.directory.studio.schemaeditor.view.editors.NonExistingObjectClass;
import org.apache.directory.studio.schemaeditor.view.editors.attributetype.AttributeTypeEditor;
import org.apache.directory.studio.schemaeditor.view.editors.attributetype.AttributeTypeEditorInput;
import org.apache.directory.studio.schemaeditor.view.editors.objectclass.AbstractObjectClassEditorPage;
import org.apache.directory.studio.schemaeditor.view.editors.objectclass.Messages;
import org.apache.directory.studio.schemaeditor.view.editors.objectclass.ObjectClassEditor;
import org.apache.directory.studio.schemaeditor.view.editors.objectclass.ObjectClassEditorAttributesTableContentProvider;
import org.apache.directory.studio.schemaeditor.view.editors.objectclass.ObjectClassEditorAttributesTableLabelProvider;
import org.apache.directory.studio.schemaeditor.view.editors.objectclass.ObjectClassEditorInput;
import org.apache.directory.studio.schemaeditor.view.editors.objectclass.ObjectClassEditorSuperiorsTableContentProvider;
import org.apache.directory.studio.schemaeditor.view.editors.objectclass.ObjectClassEditorSuperiorsTableLabelProvider;
import org.apache.directory.studio.schemaeditor.view.editors.schema.SchemaEditor;
import org.apache.directory.studio.schemaeditor.view.editors.schema.SchemaEditorInput;
import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class ObjectClassEditorOverviewPage
extends AbstractObjectClassEditorPage {
    public static final String ID = ObjectClassEditor.ID + "overviewPage";
    private Schema originalSchema;
    private SchemaHandler schemaHandler;
    private SchemaHandlerListener schemaHandlerListener = new SchemaHandlerListener(){

        @Override
        public void attributeTypeAdded(AttributeType at) {
            ObjectClassEditorOverviewPage.this.refreshUI();
        }

        @Override
        public void attributeTypeModified(AttributeType at) {
            ObjectClassEditorOverviewPage.this.refreshUI();
        }

        @Override
        public void attributeTypeRemoved(AttributeType at) {
            ObjectClassEditorOverviewPage.this.refreshUI();
        }

        @Override
        public void matchingRuleAdded(MatchingRule mr) {
            ObjectClassEditorOverviewPage.this.refreshUI();
        }

        @Override
        public void matchingRuleModified(MatchingRule mr) {
            ObjectClassEditorOverviewPage.this.refreshUI();
        }

        @Override
        public void matchingRuleRemoved(MatchingRule mr) {
            ObjectClassEditorOverviewPage.this.refreshUI();
        }

        @Override
        public void objectClassAdded(ObjectClass oc) {
            ObjectClassEditorOverviewPage.this.refreshUI();
        }

        @Override
        public void objectClassModified(ObjectClass oc) {
            ObjectClassEditorOverviewPage.this.refreshUI();
        }

        @Override
        public void objectClassRemoved(ObjectClass oc) {
            if (!oc.equals((Object)ObjectClassEditorOverviewPage.this.getOriginalObjectClass())) {
                ObjectClassEditorOverviewPage.this.refreshUI();
            }
        }

        @Override
        public void schemaAdded(Schema schema) {
            ObjectClassEditorOverviewPage.this.refreshUI();
        }

        @Override
        public void schemaRemoved(Schema schema) {
            if (!((Object)((Object)schema)).equals((Object)ObjectClassEditorOverviewPage.this.originalSchema)) {
                ObjectClassEditorOverviewPage.this.refreshUI();
            }
        }

        @Override
        public void schemaRenamed(Schema schema) {
            ObjectClassEditorOverviewPage.this.refreshUI();
        }

        @Override
        public void syntaxAdded(LdapSyntax syntax) {
            ObjectClassEditorOverviewPage.this.refreshUI();
        }

        @Override
        public void syntaxModified(LdapSyntax syntax) {
            ObjectClassEditorOverviewPage.this.refreshUI();
        }

        @Override
        public void syntaxRemoved(LdapSyntax syntax) {
            ObjectClassEditorOverviewPage.this.refreshUI();
        }
    };
    private Text aliasesText;
    private Button aliasesButton;
    private Text oidText;
    private Hyperlink schemaLink;
    private Label schemaLabel;
    private Text descriptionText;
    private Table superiorsTable;
    private TableViewer superiorsTableViewer;
    private Button addButtonSuperiorsTable;
    private Button removeButtonSuperiorsTable;
    private Combo classTypeCombo;
    private Button obsoleteCheckbox;
    private Table mandatoryAttributesTable;
    private TableViewer mandatoryAttributesTableViewer;
    private Button addButtonMandatoryTable;
    private Button removeButtonMandatoryTable;
    private Table optionalAttributesTable;
    private TableViewer optionalAttributesTableViewer;
    private Button addButtonOptionalTable;
    private Button removeButtonOptionalTable;
    private ModifyListener aliasesTextModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            MutableObjectClass modifiedObjectClass = ObjectClassEditorOverviewPage.this.getModifiedObjectClass();
            AliasesStringParser parser = new AliasesStringParser();
            parser.parse(ObjectClassEditorOverviewPage.this.aliasesText.getText());
            List<Alias> parsedAliases = parser.getAliases();
            modifiedObjectClass.setNames(new String[0]);
            ArrayList<String> aliasesList = new ArrayList<String>();
            for (Alias parsedAlias : parsedAliases) {
                if (parsedAlias instanceof AliasWithError) continue;
                aliasesList.add(parsedAlias.getAlias());
            }
            modifiedObjectClass.setNames(aliasesList.toArray(new String[0]));
            ObjectClassEditorOverviewPage.this.setEditorDirty();
        }
    };
    private SelectionAdapter aliasesButtonListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            MutableObjectClass modifiedObjectClass = ObjectClassEditorOverviewPage.this.getModifiedObjectClass();
            EditObjectClassAliasesDialog dialog = new EditObjectClassAliasesDialog(modifiedObjectClass.getNames());
            if (dialog.open() == 0) {
                modifiedObjectClass.setNames(dialog.getAliases());
                if (modifiedObjectClass.getNames() != null && modifiedObjectClass.getNames().size() != 0) {
                    ObjectClassEditorOverviewPage.this.aliasesText.setText(ViewUtils.concateAliases(modifiedObjectClass.getNames()));
                } else {
                    ObjectClassEditorOverviewPage.this.aliasesText.setText("");
                }
                ObjectClassEditorOverviewPage.this.setEditorDirty();
            }
        }
    };
    private ModifyListener oidTextModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            ObjectClassEditorOverviewPage.this.oidText.setForeground(ViewUtils.COLOR_BLACK);
            ObjectClassEditorOverviewPage.this.oidText.setToolTipText("");
            MutableObjectClass modifiedObjectClass = ObjectClassEditorOverviewPage.this.getModifiedObjectClass();
            String oid = ObjectClassEditorOverviewPage.this.oidText.getText();
            if (Oid.isOid((String)oid)) {
                if (ObjectClassEditorOverviewPage.this.getOriginalObjectClass().getOid().equals(oid) || !ObjectClassEditorOverviewPage.this.schemaHandler.isOidAlreadyTaken(oid)) {
                    modifiedObjectClass.setOid(oid);
                    ObjectClassEditorOverviewPage.this.setEditorDirty();
                } else {
                    ObjectClassEditorOverviewPage.this.oidText.setForeground(ViewUtils.COLOR_RED);
                    ObjectClassEditorOverviewPage.this.oidText.setToolTipText(Messages.getString("ObjectClassEditorOverviewPage.ElementOIDExists"));
                }
            } else {
                ObjectClassEditorOverviewPage.this.oidText.setForeground(ViewUtils.COLOR_RED);
                ObjectClassEditorOverviewPage.this.oidText.setToolTipText(Messages.getString("ObjectClassEditorOverviewPage.MalformedOID"));
            }
        }
    };
    private VerifyListener oidTextVerifyListener = new VerifyListener(){

        public void verifyText(VerifyEvent e) {
            if (!e.text.matches("([0-9]*\\.?)*")) {
                e.doit = false;
            }
        }
    };
    private HyperlinkAdapter schemaLinkListener = new HyperlinkAdapter(){

        public void linkActivated(HyperlinkEvent e) {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            SchemaEditorInput input = new SchemaEditorInput(ObjectClassEditorOverviewPage.this.schemaHandler.getSchema(ObjectClassEditorOverviewPage.this.getModifiedObjectClass().getSchemaName()));
            String editorId = SchemaEditor.ID;
            try {
                page.openEditor((IEditorInput)input, editorId);
            }
            catch (PartInitException exception) {
                Logger.getLogger(ObjectClassEditorOverviewPage.class).debug((Object)"error when opening the editor");
            }
        }
    };
    private ModifyListener descriptionTextListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            int caretPosition = ObjectClassEditorOverviewPage.this.descriptionText.getCaretPosition();
            ObjectClassEditorOverviewPage.this.getModifiedObjectClass().setDescription(ObjectClassEditorOverviewPage.this.descriptionText.getText());
            ObjectClassEditorOverviewPage.this.descriptionText.setSelection(caretPosition);
            ObjectClassEditorOverviewPage.this.setEditorDirty();
        }
    };
    private ModifyListener classTypeListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            MutableObjectClass modifiedObjectClass = ObjectClassEditorOverviewPage.this.getModifiedObjectClass();
            if (ObjectClassEditorOverviewPage.this.classTypeCombo.getSelectionIndex() == 0) {
                modifiedObjectClass.setType(ObjectClassTypeEnum.ABSTRACT);
            } else if (ObjectClassEditorOverviewPage.this.classTypeCombo.getSelectionIndex() == 1) {
                modifiedObjectClass.setType(ObjectClassTypeEnum.AUXILIARY);
            } else if (ObjectClassEditorOverviewPage.this.classTypeCombo.getSelectionIndex() == 2) {
                modifiedObjectClass.setType(ObjectClassTypeEnum.STRUCTURAL);
            }
            ObjectClassEditorOverviewPage.this.setEditorDirty();
        }
    };
    private SelectionAdapter obsoleteListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            ObjectClassEditorOverviewPage.this.getModifiedObjectClass().setObsolete(ObjectClassEditorOverviewPage.this.obsoleteCheckbox.getSelection());
            ObjectClassEditorOverviewPage.this.setEditorDirty();
        }
    };
    private MouseListener mandatoryAttributesTableListener = new MouseListener(){

        public void mouseDoubleClick(MouseEvent e) {
            StructuredSelection selection = (StructuredSelection)ObjectClassEditorOverviewPage.this.mandatoryAttributesTableViewer.getSelection();
            if (selection.isEmpty()) {
                return;
            }
            Object selectedElement = selection.getFirstElement();
            if (selectedElement != null && selectedElement instanceof AttributeType) {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    page.openEditor((IEditorInput)new AttributeTypeEditorInput((AttributeType)selectedElement), AttributeTypeEditor.ID);
                }
                catch (PartInitException exception) {
                    Logger.getLogger(ObjectClassEditorOverviewPage.class).debug((Object)"error when opening the editor");
                }
            }
        }

        public void mouseDown(MouseEvent e) {
        }

        public void mouseUp(MouseEvent e) {
            ObjectClassEditorOverviewPage.this.removeButtonMandatoryTable.setEnabled(ObjectClassEditorOverviewPage.this.mandatoryAttributesTable.getSelection().length != 0);
        }
    };
    private SelectionAdapter addButtonMandatoryTableListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            List names;
            MutableObjectClass modifiedObjectClass = ObjectClassEditorOverviewPage.this.getModifiedObjectClass();
            AttributeTypeSelectionDialog dialog = new AttributeTypeSelectionDialog();
            ArrayList<AttributeType> hiddenATs = new ArrayList<AttributeType>();
            List mustsHidden = modifiedObjectClass.getMustAttributeTypeOids();
            if (mustsHidden != null) {
                for (String must : mustsHidden) {
                    AttributeType at = ObjectClassEditorOverviewPage.this.schemaHandler.getAttributeType(must);
                    if (at == null) continue;
                    hiddenATs.add(at);
                }
            }
            dialog.setHiddenAttributeTypes(hiddenATs.toArray(new AttributeType[0]));
            if (dialog.open() != 0) {
                return;
            }
            AttributeType at = dialog.getSelectedAttributeType();
            if (at == null) {
                return;
            }
            ArrayList<String> newMusts = new ArrayList<String>();
            List musts = modifiedObjectClass.getMustAttributeTypeOids();
            if (musts != null) {
                for (String must : musts) {
                    newMusts.add(must);
                }
            }
            if ((names = at.getNames()) != null && names.size() > 0) {
                newMusts.add((String)names.get(0));
            } else {
                newMusts.add(at.getOid());
            }
            modifiedObjectClass.setMustAttributeTypeOids(newMusts);
            ObjectClassEditorOverviewPage.this.fillInMandatoryAttributesTable();
            ObjectClassEditorOverviewPage.this.setEditorDirty();
        }
    };
    private SelectionAdapter removeButtonMandatoryTableListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            StructuredSelection selection = (StructuredSelection)ObjectClassEditorOverviewPage.this.mandatoryAttributesTableViewer.getSelection();
            if (selection.isEmpty()) {
                return;
            }
            MutableObjectClass modifiedObjectClass = ObjectClassEditorOverviewPage.this.getModifiedObjectClass();
            Object selectedElement = selection.getFirstElement();
            if (selectedElement != null) {
                ArrayList<String> newMusts = new ArrayList<String>();
                List musts = modifiedObjectClass.getMustAttributeTypeOids();
                for (String must : musts) {
                    newMusts.add(must);
                }
                if (selectedElement instanceof AttributeType) {
                    for (String name : ((AttributeType)selectedElement).getNames()) {
                        newMusts.remove(name);
                    }
                } else if (selectedElement instanceof NonExistingAttributeType) {
                    newMusts.remove(((NonExistingAttributeType)selectedElement).getName());
                }
                modifiedObjectClass.setMustAttributeTypeOids(newMusts);
                ObjectClassEditorOverviewPage.this.fillInMandatoryAttributesTable();
                ObjectClassEditorOverviewPage.this.addButtonMandatoryTable.setFocus();
                ObjectClassEditorOverviewPage.this.removeButtonMandatoryTable.setEnabled(ObjectClassEditorOverviewPage.this.mandatoryAttributesTable.getSelection().length != 0);
                ObjectClassEditorOverviewPage.this.setEditorDirty();
            }
        }
    };
    private MouseListener optionalAttributesTableListener = new MouseAdapter(){

        public void mouseDoubleClick(MouseEvent e) {
            StructuredSelection selection = (StructuredSelection)ObjectClassEditorOverviewPage.this.optionalAttributesTableViewer.getSelection();
            if (selection.isEmpty()) {
                return;
            }
            Object selectedElement = selection.getFirstElement();
            if (selectedElement != null && selectedElement instanceof AttributeType) {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    page.openEditor((IEditorInput)new AttributeTypeEditorInput((AttributeType)selectedElement), AttributeTypeEditor.ID);
                }
                catch (PartInitException exception) {
                    Logger.getLogger(ObjectClassEditorOverviewPage.class).debug((Object)"error when opening the editor");
                }
            }
        }

        public void mouseUp(MouseEvent e) {
            ObjectClassEditorOverviewPage.this.removeButtonOptionalTable.setEnabled(ObjectClassEditorOverviewPage.this.optionalAttributesTable.getSelection().length != 0);
        }
    };
    private SelectionAdapter addButtonOptionalTableListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            List names;
            MutableObjectClass modifiedObjectClass = ObjectClassEditorOverviewPage.this.getModifiedObjectClass();
            AttributeTypeSelectionDialog dialog = new AttributeTypeSelectionDialog();
            ArrayList<AttributeType> hiddenATs = new ArrayList<AttributeType>();
            List maysHidden = modifiedObjectClass.getMayAttributeTypeOids();
            if (maysHidden != null) {
                for (String may : maysHidden) {
                    AttributeType at = ObjectClassEditorOverviewPage.this.schemaHandler.getAttributeType(may);
                    if (at == null) continue;
                    hiddenATs.add(at);
                }
            }
            dialog.setHiddenAttributeTypes(hiddenATs.toArray(new AttributeType[0]));
            if (dialog.open() != 0) {
                return;
            }
            AttributeType at = dialog.getSelectedAttributeType();
            if (at == null) {
                return;
            }
            ArrayList<String> newMays = new ArrayList<String>();
            List mays = modifiedObjectClass.getMayAttributeTypeOids();
            if (mays != null) {
                for (String may : mays) {
                    newMays.add(may);
                }
            }
            if ((names = at.getNames()) != null && names.size() > 0) {
                newMays.add((String)names.get(0));
            } else {
                newMays.add(at.getOid());
            }
            modifiedObjectClass.setMayAttributeTypeOids(newMays);
            ObjectClassEditorOverviewPage.this.fillInOptionalAttributesTable();
            ObjectClassEditorOverviewPage.this.setEditorDirty();
        }
    };
    private SelectionAdapter removeButtonOptionalTableListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            StructuredSelection selection = (StructuredSelection)ObjectClassEditorOverviewPage.this.optionalAttributesTableViewer.getSelection();
            if (selection.isEmpty()) {
                return;
            }
            MutableObjectClass modifiedObjectClass = ObjectClassEditorOverviewPage.this.getModifiedObjectClass();
            Object selectedElement = selection.getFirstElement();
            if (selectedElement != null) {
                ArrayList<String> newMays = new ArrayList<String>();
                List mays = modifiedObjectClass.getMayAttributeTypeOids();
                for (String may : mays) {
                    newMays.add(may);
                }
                if (selectedElement instanceof AttributeType) {
                    for (String name : ((AttributeType)selectedElement).getNames()) {
                        newMays.remove(name);
                    }
                } else if (selectedElement instanceof NonExistingAttributeType) {
                    newMays.remove(((NonExistingAttributeType)selectedElement).getName());
                }
                modifiedObjectClass.setMayAttributeTypeOids(newMays);
                ObjectClassEditorOverviewPage.this.fillInOptionalAttributesTable();
                ObjectClassEditorOverviewPage.this.addButtonOptionalTable.setFocus();
                ObjectClassEditorOverviewPage.this.removeButtonOptionalTable.setEnabled(ObjectClassEditorOverviewPage.this.optionalAttributesTable.getSelection().length != 0);
                ObjectClassEditorOverviewPage.this.setEditorDirty();
            }
        }
    };
    private MouseListener superiorsTableListener = new MouseAdapter(){

        public void mouseDoubleClick(MouseEvent e) {
            StructuredSelection selection = (StructuredSelection)ObjectClassEditorOverviewPage.this.superiorsTableViewer.getSelection();
            if (selection.isEmpty()) {
                return;
            }
            Object selectedElement = selection.getFirstElement();
            if (selectedElement != null && selectedElement instanceof ObjectClass) {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    page.openEditor((IEditorInput)new ObjectClassEditorInput((ObjectClass)((MutableObjectClass)selectedElement)), ObjectClassEditor.ID);
                }
                catch (PartInitException exception) {
                    Logger.getLogger(ObjectClassEditorOverviewPage.class).debug((Object)"error when opening the editor");
                }
            }
        }

        public void mouseUp(MouseEvent e) {
            ObjectClassEditorOverviewPage.this.removeButtonSuperiorsTable.setEnabled(ObjectClassEditorOverviewPage.this.superiorsTable.getSelection().length != 0);
        }
    };
    private SelectionAdapter addButtonSuperiorsTableListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            MutableObjectClass modifiedObjectClass = ObjectClassEditorOverviewPage.this.getModifiedObjectClass();
            ObjectClassSelectionDialog dialog = new ObjectClassSelectionDialog();
            ArrayList<Object> hiddenOCs = new ArrayList<Object>();
            for (String sup : modifiedObjectClass.getSuperiorOids()) {
                MutableObjectClass oc = ObjectClassEditorOverviewPage.this.schemaHandler.getObjectClass(sup);
                if (oc == null) continue;
                hiddenOCs.add(oc);
            }
            hiddenOCs.add(ObjectClassEditorOverviewPage.this.getOriginalObjectClass());
            dialog.setHiddenObjectClasses(hiddenOCs.toArray(new ObjectClass[0]));
            if (dialog.open() != 0) {
                return;
            }
            ObjectClass oc = dialog.getSelectedObjectClass();
            if (oc == null) {
                return;
            }
            ArrayList<String> superiors = new ArrayList<String>();
            List sups = modifiedObjectClass.getSuperiorOids();
            for (String sup : sups) {
                superiors.add(sup);
            }
            List names = oc.getNames();
            if (names != null && names.size() > 0) {
                superiors.add((String)names.get(0));
            } else {
                superiors.add(oc.getOid());
            }
            modifiedObjectClass.setSuperiorOids(superiors);
            ObjectClassEditorOverviewPage.this.fillInSuperiorsTable();
            ObjectClassEditorOverviewPage.this.setEditorDirty();
        }
    };
    private SelectionAdapter removeButtonSuperiorsTableListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            StructuredSelection selection = (StructuredSelection)ObjectClassEditorOverviewPage.this.superiorsTableViewer.getSelection();
            if (selection.isEmpty()) {
                return;
            }
            MutableObjectClass modifiedObjectClass = ObjectClassEditorOverviewPage.this.getModifiedObjectClass();
            Object selectedElement = selection.getFirstElement();
            if (selectedElement != null) {
                ArrayList<String> superiors = new ArrayList<String>();
                List sups = modifiedObjectClass.getSuperiorOids();
                for (String sup : sups) {
                    superiors.add(sup);
                }
                if (selectedElement instanceof ObjectClass) {
                    for (String name : ((ObjectClass)selectedElement).getNames()) {
                        superiors.remove(name);
                    }
                } else if (selectedElement instanceof NonExistingObjectClass) {
                    superiors.remove(((NonExistingObjectClass)selectedElement).getName());
                }
                modifiedObjectClass.setSuperiorOids(superiors);
                ObjectClassEditorOverviewPage.this.fillInSuperiorsTable();
                ObjectClassEditorOverviewPage.this.addButtonSuperiorsTable.setFocus();
                ObjectClassEditorOverviewPage.this.removeButtonSuperiorsTable.setEnabled(ObjectClassEditorOverviewPage.this.superiorsTable.getSelection().length != 0);
                ObjectClassEditorOverviewPage.this.setEditorDirty();
            }
        }
    };
    private Listener mouseWheelFilter = new Listener(){

        public void handleEvent(Event event) {
            if (event.widget instanceof Combo) {
                event.doit = false;
            }
        }
    };

    public ObjectClassEditorOverviewPage(ObjectClassEditor editor) {
        super(editor, ID, Messages.getString("ObjectClassEditorOverviewPage.Overview"));
        this.schemaHandler = Activator.getDefault().getSchemaHandler();
        this.schemaHandler.addListener(this.schemaHandlerListener);
    }

    @Override
    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        form.getBody().setLayout((Layout)new GridLayout());
        this.createGeneralInformationSection(form.getBody(), toolkit);
        Composite bottomComposite = toolkit.createComposite(form.getBody());
        bottomComposite.setLayout((Layout)new GridLayout(2, true));
        bottomComposite.setLayoutData((Object)new GridData(4, 0, true, false));
        this.createMandatoryAttributesSection(bottomComposite, toolkit);
        this.createOptionalAttributesSection(bottomComposite, toolkit);
        this.fillInUiFields();
        this.addListeners();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)form, PluginConstants.PLUGIN_ID + "." + "object_class_editor");
    }

    private void createGeneralInformationSection(Composite parent, FormToolkit toolkit) {
        Section section_general_information = toolkit.createSection(parent, 448);
        section_general_information.setDescription(Messages.getString("ObjectClassEditorOverviewPage.SpecifyGeneralInformation"));
        section_general_information.setText(Messages.getString("ObjectClassEditorOverviewPage.GeneralInformation"));
        section_general_information.setLayoutData((Object)new GridData(4, 0, true, false));
        Composite client_general_information = toolkit.createComposite((Composite)section_general_information);
        client_general_information.setLayout((Layout)new GridLayout(2, false));
        toolkit.paintBordersFor(client_general_information);
        section_general_information.setClient((Control)client_general_information);
        section_general_information.setLayoutData((Object)new GridData(4, 0, true, false));
        toolkit.createLabel(client_general_information, Messages.getString("ObjectClassEditorOverviewPage.Aliases"));
        Composite aliasComposite = toolkit.createComposite(client_general_information);
        GridLayout aliasCompositeGridLayout = new GridLayout(2, false);
        toolkit.paintBordersFor(aliasComposite);
        aliasCompositeGridLayout.marginHeight = 1;
        aliasCompositeGridLayout.marginWidth = 1;
        aliasComposite.setLayout((Layout)aliasCompositeGridLayout);
        aliasComposite.setLayoutData((Object)new GridData(4, 0, true, false));
        this.aliasesText = toolkit.createText(aliasComposite, "");
        this.aliasesText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.aliasesButton = toolkit.createButton(aliasComposite, Messages.getString("ObjectClassEditorOverviewPage.EditAliases"), 8);
        this.aliasesButton.setLayoutData((Object)new GridData(0, 0x1000000, false, false));
        toolkit.createLabel(client_general_information, Messages.getString("ObjectClassEditorOverviewPage.OID"));
        this.oidText = toolkit.createText(client_general_information, "");
        this.oidText.setLayoutData((Object)new GridData(4, 0, true, false));
        this.schemaLink = toolkit.createHyperlink(client_general_information, Messages.getString("ObjectClassEditorOverviewPage.Schema"), 64);
        this.schemaLabel = toolkit.createLabel(client_general_information, "");
        this.schemaLabel.setLayoutData((Object)new GridData(4, 0, true, false));
        toolkit.createLabel(client_general_information, Messages.getString("ObjectClassEditorOverviewPage.Description"));
        this.descriptionText = toolkit.createText(client_general_information, "", 514);
        GridData descriptionGridData = new GridData(4, 0, true, false);
        descriptionGridData.heightHint = 42;
        this.descriptionText.setLayoutData((Object)descriptionGridData);
        toolkit.createLabel(client_general_information, Messages.getString("ObjectClassEditorOverviewPage.SuperiorClasses"));
        Composite superiorsComposite = toolkit.createComposite(client_general_information);
        GridLayout superiorsCompositeGridLayout = new GridLayout(2, false);
        toolkit.paintBordersFor(superiorsComposite);
        superiorsCompositeGridLayout.marginHeight = 1;
        superiorsCompositeGridLayout.marginWidth = 1;
        superiorsComposite.setLayout((Layout)superiorsCompositeGridLayout);
        superiorsComposite.setLayoutData((Object)new GridData(4, 0, true, false));
        this.superiorsTable = toolkit.createTable(superiorsComposite, 66308);
        toolkit.paintBordersFor((Composite)this.superiorsTable);
        GridData gridData = new GridData(4, 0, true, false, 1, 2);
        gridData.heightHint = 45;
        gridData.minimumHeight = 45;
        this.superiorsTable.setLayoutData((Object)gridData);
        this.superiorsTableViewer = new TableViewer(this.superiorsTable);
        this.superiorsTableViewer.setContentProvider((IContentProvider)new ObjectClassEditorSuperiorsTableContentProvider());
        this.superiorsTableViewer.setLabelProvider((IBaseLabelProvider)new ObjectClassEditorSuperiorsTableLabelProvider());
        this.addButtonSuperiorsTable = toolkit.createButton(superiorsComposite, Messages.getString("ObjectClassEditorOverviewPage.Add"), 8);
        this.addButtonSuperiorsTable.setLayoutData((Object)new GridData(4, 0, false, false));
        this.removeButtonSuperiorsTable = toolkit.createButton(superiorsComposite, Messages.getString("ObjectClassEditorOverviewPage.Remove"), 8);
        this.removeButtonSuperiorsTable.setLayoutData((Object)new GridData(4, 0, false, false));
        toolkit.createLabel(client_general_information, Messages.getString("ObjectClassEditorOverviewPage.ClassType"));
        this.classTypeCombo = new Combo(client_general_information, 12);
        this.classTypeCombo.setLayoutData((Object)new GridData(4, 0, true, false));
        this.initClassTypeCombo();
        toolkit.createLabel(client_general_information, "");
        this.obsoleteCheckbox = toolkit.createButton(client_general_information, Messages.getString("ObjectClassEditorOverviewPage.Obsolete"), 32);
        this.obsoleteCheckbox.setLayoutData((Object)new GridData(4, 0, true, false));
    }

    private void createMandatoryAttributesSection(Composite parent, FormToolkit toolkit) {
        Section section = toolkit.createSection(parent, 384);
        section.setText(Messages.getString("ObjectClassEditorOverviewPage.MandatoryAttributes"));
        section.setDescription(Messages.getString("ObjectClassEditorOverviewPage.SpecifyMandatoryAttributes"));
        section.setExpanded(true);
        Composite client = toolkit.createComposite((Composite)section);
        section.setClient((Control)client);
        GridData gd = new GridData(4, 0, true, false);
        section.setLayoutData((Object)gd);
        toolkit.paintBordersFor(client);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        client.setLayout((Layout)layout);
        this.mandatoryAttributesTable = toolkit.createTable(client, 66308);
        gd = new GridData(4, 0, true, false);
        gd.verticalSpan = 2;
        gd.heightHint = 108;
        this.mandatoryAttributesTable.setLayoutData((Object)gd);
        this.mandatoryAttributesTableViewer = new TableViewer(this.mandatoryAttributesTable);
        this.mandatoryAttributesTableViewer.setContentProvider((IContentProvider)new ObjectClassEditorAttributesTableContentProvider());
        this.mandatoryAttributesTableViewer.setLabelProvider((IBaseLabelProvider)new ObjectClassEditorAttributesTableLabelProvider());
        this.addButtonMandatoryTable = toolkit.createButton(client, Messages.getString("ObjectClassEditorOverviewPage.Add"), 8);
        this.removeButtonMandatoryTable = toolkit.createButton(client, Messages.getString("ObjectClassEditorOverviewPage.Remove"), 8);
        gd = new GridData(2);
        this.addButtonMandatoryTable.setLayoutData((Object)gd);
        this.removeButtonMandatoryTable.setLayoutData((Object)gd);
        this.removeButtonMandatoryTable.setEnabled(false);
    }

    private void createOptionalAttributesSection(Composite parent, FormToolkit toolkit) {
        Section section = toolkit.createSection(parent, 384);
        section.setText(Messages.getString("ObjectClassEditorOverviewPage.OptionalAttributes"));
        section.setDescription(Messages.getString("ObjectClassEditorOverviewPage.SpecifyOptionalAttributes"));
        section.setExpanded(true);
        Composite client = toolkit.createComposite((Composite)section);
        section.setClient((Control)client);
        GridData gd = new GridData(4, 0, true, false);
        section.setLayoutData((Object)gd);
        toolkit.paintBordersFor(client);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        client.setLayout((Layout)layout);
        this.optionalAttributesTable = toolkit.createTable(client, 66308);
        gd = new GridData(4, 0, true, false);
        gd.verticalSpan = 2;
        gd.heightHint = 108;
        this.optionalAttributesTable.setLayoutData((Object)gd);
        this.optionalAttributesTableViewer = new TableViewer(this.optionalAttributesTable);
        this.optionalAttributesTableViewer.setContentProvider((IContentProvider)new ObjectClassEditorAttributesTableContentProvider());
        this.optionalAttributesTableViewer.setLabelProvider((IBaseLabelProvider)new ObjectClassEditorAttributesTableLabelProvider());
        this.addButtonOptionalTable = toolkit.createButton(client, Messages.getString("ObjectClassEditorOverviewPage.Add"), 8);
        this.removeButtonOptionalTable = toolkit.createButton(client, Messages.getString("ObjectClassEditorOverviewPage.Remove"), 8);
        gd = new GridData(2);
        this.addButtonOptionalTable.setLayoutData((Object)gd);
        this.removeButtonOptionalTable.setLayoutData((Object)gd);
        this.removeButtonOptionalTable.setEnabled(false);
    }

    @Override
    protected void fillInUiFields() {
        MutableObjectClass modifiedObjectClass = this.getModifiedObjectClass();
        this.originalSchema = this.schemaHandler.getSchema(this.getOriginalObjectClass().getSchemaName());
        if (modifiedObjectClass.getNames() != null && modifiedObjectClass.getNames().size() != 0) {
            this.aliasesText.setText(ViewUtils.concateAliases(modifiedObjectClass.getNames()));
        } else {
            this.aliasesText.setText("");
        }
        if (modifiedObjectClass.getOid() != null) {
            this.oidText.setText(modifiedObjectClass.getOid());
        }
        this.schemaLabel.setText(modifiedObjectClass.getSchemaName());
        if (modifiedObjectClass.getDescription() != null) {
            this.descriptionText.setText(modifiedObjectClass.getDescription());
        }
        this.fillInSuperiorsTable();
        this.fillInClassType();
        this.obsoleteCheckbox.setSelection(modifiedObjectClass.isObsolete());
        this.fillInMandatoryAttributesTable();
        this.fillInOptionalAttributesTable();
    }

    private void fillInSuperiorsTable() {
        if (this.getModifiedObjectClass().getSuperiorOids() != null) {
            this.superiorsTableViewer.setInput((Object)this.getModifiedObjectClass().getSuperiorOids());
        }
    }

    private void initClassTypeCombo() {
        this.classTypeCombo.add(Messages.getString("ObjectClassEditorOverviewPage.Abstract"), 0);
        this.classTypeCombo.add(Messages.getString("ObjectClassEditorOverviewPage.Auxiliary"), 1);
        this.classTypeCombo.add(Messages.getString("ObjectClassEditorOverviewPage.Structural"), 2);
    }

    private void fillInClassType() {
        ObjectClassTypeEnum type = this.getModifiedObjectClass().getType();
        switch (type) {
            case ABSTRACT: {
                this.classTypeCombo.select(0);
                return;
            }
            case AUXILIARY: {
                this.classTypeCombo.select(1);
                return;
            }
            case STRUCTURAL: {
                this.classTypeCombo.select(2);
                return;
            }
        }
    }

    private void fillInMandatoryAttributesTable() {
        if (this.getModifiedObjectClass().getMustAttributeTypeOids() != null) {
            this.mandatoryAttributesTableViewer.setInput((Object)this.getModifiedObjectClass().getMustAttributeTypeOids());
        }
    }

    private void fillInOptionalAttributesTable() {
        if (this.getModifiedObjectClass().getMayAttributeTypeOids() != null) {
            this.optionalAttributesTableViewer.setInput((Object)this.getModifiedObjectClass().getMayAttributeTypeOids());
        }
    }

    @Override
    protected void addListeners() {
        this.addModifyListener(this.aliasesText, this.aliasesTextModifyListener);
        this.addSelectionListener(this.aliasesButton, (SelectionListener)this.aliasesButtonListener);
        this.addModifyListener(this.oidText, this.oidTextModifyListener);
        this.addVerifyListener(this.oidText, this.oidTextVerifyListener);
        this.addHyperlinkListener(this.schemaLink, (IHyperlinkListener)this.schemaLinkListener);
        this.addModifyListener(this.descriptionText, this.descriptionTextListener);
        this.addMouseListener(this.superiorsTable, this.superiorsTableListener);
        this.addSelectionListener(this.addButtonSuperiorsTable, (SelectionListener)this.addButtonSuperiorsTableListener);
        this.addSelectionListener(this.removeButtonSuperiorsTable, (SelectionListener)this.removeButtonSuperiorsTableListener);
        this.addModifyListener(this.classTypeCombo, this.classTypeListener);
        this.addSelectionListener(this.obsoleteCheckbox, (SelectionListener)this.obsoleteListener);
        this.addMouseListener(this.mandatoryAttributesTable, this.mandatoryAttributesTableListener);
        this.addSelectionListener(this.addButtonMandatoryTable, (SelectionListener)this.addButtonMandatoryTableListener);
        this.addSelectionListener(this.removeButtonMandatoryTable, (SelectionListener)this.removeButtonMandatoryTableListener);
        this.addMouseListener(this.optionalAttributesTable, this.optionalAttributesTableListener);
        this.addSelectionListener(this.addButtonOptionalTable, (SelectionListener)this.addButtonOptionalTableListener);
        this.addSelectionListener(this.removeButtonOptionalTable, (SelectionListener)this.removeButtonOptionalTableListener);
        Display.getCurrent().addFilter(37, this.mouseWheelFilter);
    }

    @Override
    protected void removeListeners() {
        this.removeModifyListener(this.aliasesText, this.aliasesTextModifyListener);
        this.removeSelectionListener(this.aliasesButton, (SelectionListener)this.aliasesButtonListener);
        this.removeModifyListener(this.oidText, this.oidTextModifyListener);
        this.removeVerifyListener(this.oidText, this.oidTextVerifyListener);
        this.removeHyperlinkListener(this.schemaLink, (IHyperlinkListener)this.schemaLinkListener);
        this.removeModifyListener(this.descriptionText, this.descriptionTextListener);
        this.removeMouseListener(this.superiorsTable, this.superiorsTableListener);
        this.removeSelectionListener(this.addButtonSuperiorsTable, (SelectionListener)this.addButtonSuperiorsTableListener);
        this.removeSelectionListener(this.removeButtonSuperiorsTable, (SelectionListener)this.removeButtonSuperiorsTableListener);
        this.removeModifyListener(this.classTypeCombo, this.classTypeListener);
        this.removeSelectionListener(this.obsoleteCheckbox, (SelectionListener)this.obsoleteListener);
        this.removeMouseListener(this.mandatoryAttributesTable, this.mandatoryAttributesTableListener);
        this.removeSelectionListener(this.addButtonMandatoryTable, (SelectionListener)this.addButtonMandatoryTableListener);
        this.removeSelectionListener(this.removeButtonMandatoryTable, (SelectionListener)this.removeButtonMandatoryTableListener);
        this.removeMouseListener(this.optionalAttributesTable, this.optionalAttributesTableListener);
        this.removeSelectionListener(this.addButtonOptionalTable, (SelectionListener)this.addButtonOptionalTableListener);
        this.removeSelectionListener(this.removeButtonOptionalTable, (SelectionListener)this.removeButtonOptionalTableListener);
        Display.getCurrent().removeFilter(37, this.mouseWheelFilter);
    }

    @Override
    public void dispose() {
        this.schemaHandler.removeListener(this.schemaHandlerListener);
        super.dispose();
    }
}

