/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.views;

import java.util.List;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.ObjectClass;
import org.apache.directory.api.ldap.model.schema.SchemaObject;
import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.PluginConstants;
import org.apache.directory.studio.schemaeditor.view.ViewUtils;
import org.apache.directory.studio.schemaeditor.view.views.Messages;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class SearchViewLabelProvider
extends LabelProvider {
    private IPreferenceStore store = Activator.getDefault().getPreferenceStore();

    public String getText(Object element) {
        List names;
        String label = "";
        int labelValue = this.store.getInt(PluginConstants.PREFS_SEARCH_VIEW_LABEL);
        boolean abbreviate = this.store.getBoolean(PluginConstants.PREFS_SEARCH_VIEW_ABBREVIATE);
        int abbreviateMaxLength = this.store.getInt(PluginConstants.PREFS_SEARCH_VIEW_ABBREVIATE_MAX_LENGTH);
        boolean secondaryLabelDisplay = this.store.getBoolean(PluginConstants.PREFS_SEARCH_VIEW_SECONDARY_LABEL_DISPLAY);
        int secondaryLabelValue = this.store.getInt(PluginConstants.PREFS_SEARCH_VIEW_SECONDARY_LABEL);
        boolean secondaryLabelAbbreviate = this.store.getBoolean(PluginConstants.PREFS_SEARCH_VIEW_SECONDARY_LABEL_ABBREVIATE);
        int secondaryLabelAbbreviateMaxLength = this.store.getInt(PluginConstants.PREFS_SEARCH_VIEW_SECONDARY_LABEL_ABBREVIATE_MAX_LENGTH);
        boolean schemaLabelDisplay = this.store.getBoolean(PluginConstants.PREFS_SEARCH_VIEW_SCHEMA_LABEL_DISPLAY);
        if (element instanceof AttributeType) {
            AttributeType at = (AttributeType)element;
            label = labelValue == 0 ? ((names = at.getNames()) != null && names.size() > 0 ? (String)names.get(0) : Messages.getString("SearchViewLabelProvider.None")) : (labelValue == 1 ? ((names = at.getNames()) != null && names.size() > 0 ? ViewUtils.concateAliases(names) : Messages.getString("SearchViewLabelProvider.None")) : (labelValue == 2 ? at.getOid() : ((names = at.getNames()) != null && names.size() > 0 ? (String)names.get(0) : Messages.getString("SearchViewLabelProvider.None"))));
            if (abbreviate && abbreviateMaxLength < label.length()) {
                label = label.substring(0, abbreviateMaxLength) + "...";
            }
        } else if (element instanceof ObjectClass) {
            ObjectClass oc = (ObjectClass)element;
            label = labelValue == 0 ? ((names = oc.getNames()) != null && names.size() > 0 ? (String)names.get(0) : Messages.getString("SearchViewLabelProvider.None")) : (labelValue == 1 ? ((names = oc.getNames()) != null && names.size() > 0 ? ViewUtils.concateAliases(names) : Messages.getString("SearchViewLabelProvider.None")) : (labelValue == 2 ? oc.getOid() : ((names = oc.getNames()) != null && names.size() > 0 ? (String)names.get(0) : Messages.getString("SearchViewLabelProvider.None"))));
            if (abbreviate && abbreviateMaxLength < label.length()) {
                label = label.substring(0, abbreviateMaxLength) + "...";
            }
        }
        if (secondaryLabelDisplay) {
            String secondaryLabel = "";
            if (element instanceof AttributeType) {
                AttributeType at = (AttributeType)element;
                if (secondaryLabelValue == 0) {
                    List names2 = at.getNames();
                    secondaryLabel = names2 != null && names2.size() > 0 ? (String)names2.get(0) : Messages.getString("SearchViewLabelProvider.None");
                } else if (secondaryLabelValue == 1) {
                    List names3 = at.getNames();
                    secondaryLabel = names3 != null && names3.size() > 0 ? ViewUtils.concateAliases(names3) : Messages.getString("SearchViewLabelProvider.None");
                } else if (secondaryLabelValue == 2) {
                    secondaryLabel = at.getOid();
                }
            } else if (element instanceof ObjectClass) {
                ObjectClass oc = (ObjectClass)element;
                if (secondaryLabelValue == 0) {
                    List names4 = oc.getNames();
                    secondaryLabel = names4 != null && names4.size() > 0 ? (String)names4.get(0) : Messages.getString("SearchViewLabelProvider.None");
                } else if (secondaryLabelValue == 1) {
                    List names5 = oc.getNames();
                    secondaryLabel = names5 != null && names5.size() > 0 ? ViewUtils.concateAliases(names5) : Messages.getString("SearchViewLabelProvider.None");
                } else if (secondaryLabelValue == 2) {
                    secondaryLabel = oc.getOid();
                }
            }
            if (secondaryLabelAbbreviate && secondaryLabelAbbreviateMaxLength < secondaryLabel.length()) {
                secondaryLabel = secondaryLabel.substring(0, secondaryLabelAbbreviateMaxLength) + "...";
            }
            label = label + " [" + secondaryLabel + "]";
        }
        if (schemaLabelDisplay && element instanceof SchemaObject) {
            SchemaObject object = (SchemaObject)element;
            label = label + " " + Messages.getString("SearchViewLabelProvider.FromSchema") + " \"" + object.getSchemaName() + "\"";
        }
        return label;
    }

    public Image getImage(Object element) {
        if (element instanceof AttributeType) {
            return Activator.getDefault().getImage("resources/icons/attribute_type.gif");
        }
        if (element instanceof ObjectClass) {
            return Activator.getDefault().getImage("resources/icons/object_class.gif");
        }
        return null;
    }
}

