/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.directory.studio.ldapbrowser.core.BrowserCoreMessages;
import org.apache.directory.studio.ldapbrowser.core.events.BookmarkUpdateEvent;
import org.apache.directory.studio.ldapbrowser.core.events.EventRegistry;
import org.apache.directory.studio.ldapbrowser.core.model.IBookmark;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.eclipse.osgi.util.NLS;

public class BookmarkManager
implements Serializable {
    private static final long serialVersionUID = 7605293576518974531L;
    private List<IBookmark> bookmarkList;
    private IBrowserConnection connection;

    public BookmarkManager(IBrowserConnection connection) {
        this.connection = connection;
        this.bookmarkList = new ArrayList<IBookmark>();
    }

    public IBrowserConnection getConnection() {
        return this.connection;
    }

    public void addBookmark(IBookmark bookmark) {
        this.addBookmark(this.bookmarkList.size(), bookmark);
    }

    public void addBookmark(int index, IBookmark bookmark) {
        if (this.getBookmark(bookmark.getName()) != null) {
            String newBookmarkName = NLS.bind((String)BrowserCoreMessages.copy_n_of_s, (Object)"", (Object)bookmark.getName());
            int i = 2;
            while (this.getBookmark(newBookmarkName) != null) {
                newBookmarkName = NLS.bind((String)BrowserCoreMessages.copy_n_of_s, (Object)(i + " "), (Object)bookmark.getName());
                ++i;
            }
            bookmark.setName(newBookmarkName);
        }
        this.bookmarkList.add(index, bookmark);
        EventRegistry.fireBookmarkUpdated(new BookmarkUpdateEvent(bookmark, BookmarkUpdateEvent.Detail.BOOKMARK_ADDED), this);
    }

    public IBookmark getBookmark(String name) {
        for (IBookmark bookmark : this.bookmarkList) {
            if (!bookmark.getName().equals(name)) continue;
            return bookmark;
        }
        return null;
    }

    public int indexOf(IBookmark bookmark) {
        return this.bookmarkList.indexOf(bookmark);
    }

    public void removeBookmark(IBookmark bookmark) {
        this.bookmarkList.remove(bookmark);
        EventRegistry.fireBookmarkUpdated(new BookmarkUpdateEvent(bookmark, BookmarkUpdateEvent.Detail.BOOKMARK_REMOVED), this);
    }

    public void removeBookmark(String name) {
        this.removeBookmark(this.getBookmark(name));
    }

    public IBookmark[] getBookmarks() {
        return this.bookmarkList.toArray(new IBookmark[0]);
    }

    public int getBookmarkCount() {
        return this.bookmarkList.size();
    }
}

