/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.core;

import java.util.HashSet;
import java.util.Set;
import org.apache.directory.studio.ldapbrowser.core.BrowserCorePlugin;
import org.apache.directory.studio.ldapbrowser.core.model.schema.BinaryAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.schema.BinarySyntax;
import org.apache.directory.studio.ldapbrowser.core.model.schema.ObjectClassIconPair;
import org.apache.directory.studio.ldapbrowser.core.utils.Utils;
import org.eclipse.core.runtime.Preferences;

public class BrowserCorePreferences {
    private Set<String> binaryAttributeCache;
    private Set<String> binarySyntaxCache;

    public Set<String> getUpperCasedBinaryAttributeOidsAndNames() {
        if (this.binaryAttributeCache == null) {
            BinaryAttribute[] binaryAttributes;
            this.binaryAttributeCache = new HashSet<String>();
            for (BinaryAttribute binaryAttribute : binaryAttributes = this.getBinaryAttributes()) {
                if (binaryAttribute.getAttributeNumericOidOrName() == null) continue;
                this.binaryAttributeCache.add(binaryAttribute.getAttributeNumericOidOrName().toUpperCase());
            }
        }
        return this.binaryAttributeCache;
    }

    public BinaryAttribute[] getBinaryAttributes() {
        BinaryAttribute[] binaryAttributes = (BinaryAttribute[])BrowserCorePreferences.load("binaryAttributes");
        return binaryAttributes;
    }

    public void setBinaryAttributes(BinaryAttribute[] binaryAttributes) {
        BrowserCorePreferences.store("binaryAttributes", binaryAttributes);
        this.binaryAttributeCache = null;
    }

    public BinaryAttribute[] getDefaultBinaryAttributes() {
        BinaryAttribute[] binaryAttributes = (BinaryAttribute[])BrowserCorePreferences.loadDefault("binaryAttributes");
        return binaryAttributes;
    }

    public void setDefaultBinaryAttributes(BinaryAttribute[] defaultBinaryAttributes) {
        BrowserCorePreferences.storeDefault("binaryAttributes", defaultBinaryAttributes);
    }

    public Set<String> getUpperCasedBinarySyntaxOids() {
        if (this.binarySyntaxCache == null) {
            BinarySyntax[] binarySyntaxes;
            this.binarySyntaxCache = new HashSet<String>();
            for (BinarySyntax binarySyntax : binarySyntaxes = this.getBinarySyntaxes()) {
                if (binarySyntax.getSyntaxNumericOid() == null) continue;
                this.binarySyntaxCache.add(binarySyntax.getSyntaxNumericOid().toUpperCase());
            }
        }
        return this.binarySyntaxCache;
    }

    public BinarySyntax[] getBinarySyntaxes() {
        BinarySyntax[] binarySyntaxes = (BinarySyntax[])BrowserCorePreferences.load("binarySyntaxes");
        return binarySyntaxes;
    }

    public void setBinarySyntaxes(BinarySyntax[] binarySyntaxes) {
        BrowserCorePreferences.store("binarySyntaxes", binarySyntaxes);
        this.binarySyntaxCache = null;
    }

    public BinarySyntax[] getDefaultBinarySyntaxes() {
        BinarySyntax[] binarySyntaxes = (BinarySyntax[])BrowserCorePreferences.loadDefault("binarySyntaxes");
        return binarySyntaxes;
    }

    public void setDefaultBinarySyntaxes(BinarySyntax[] defaultBinarySyntaxes) {
        BrowserCorePreferences.storeDefault("binarySyntaxes", defaultBinarySyntaxes);
    }

    public ObjectClassIconPair[] getObjectClassIcons() {
        ObjectClassIconPair[] ocIcons = (ObjectClassIconPair[])BrowserCorePreferences.load("objectClassIcons");
        return ocIcons;
    }

    public void setObjectClassIcons(ObjectClassIconPair[] ocIcons) {
        BrowserCorePreferences.store("objectClassIcons", ocIcons);
    }

    public ObjectClassIconPair[] getDefaultObjectClassIcon() {
        ObjectClassIconPair[] ocIcons = (ObjectClassIconPair[])BrowserCorePreferences.loadDefault("objectClassIcons");
        return ocIcons;
    }

    public void setDefaultObjectClassIcons(ObjectClassIconPair[] ocIcons) {
        BrowserCorePreferences.storeDefault("objectClassIcons", ocIcons);
    }

    private static Object load(String key) {
        Preferences store = BrowserCorePlugin.getDefault().getPluginPreferences();
        String s = store.getString(key);
        return Utils.deserialize(s);
    }

    private static void store(String key, Object o) {
        Preferences store = BrowserCorePlugin.getDefault().getPluginPreferences();
        String s = Utils.serialize(o);
        store.setValue(key, s);
        BrowserCorePlugin.getDefault().savePluginPreferences();
    }

    private static Object loadDefault(String key) {
        Preferences store = BrowserCorePlugin.getDefault().getPluginPreferences();
        String s = store.getDefaultString(key);
        return Utils.deserialize(s);
    }

    private static void storeDefault(String key, Object o) {
        Preferences store = BrowserCorePlugin.getDefault().getPluginPreferences();
        String s = Utils.serialize(o);
        store.setDefault(key, s);
        BrowserCorePlugin.getDefault().savePluginPreferences();
    }
}

