/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.entryeditors;

import org.apache.directory.studio.entryeditors.EntryEditorInput;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorMatchingStrategy;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.PartInitException;

public class MultiTabEntryEditorMatchingStrategy
implements IEditorMatchingStrategy {
    public boolean matches(IEditorReference editorRef, IEditorInput input) {
        if (!(input instanceof EntryEditorInput)) {
            return false;
        }
        EntryEditorInput entryEditorInput = (EntryEditorInput)input;
        if (entryEditorInput.getExtension() == null) {
            return false;
        }
        if (!entryEditorInput.getExtension().isMultiWindow()) {
            return false;
        }
        if (!editorRef.getId().equals(entryEditorInput.getExtension().getEditorId())) {
            return false;
        }
        try {
            IEditorInput otherInput = editorRef.getEditorInput();
            if (!(otherInput instanceof EntryEditorInput)) {
                return false;
            }
            EntryEditorInput otherEntryEditorInput = (EntryEditorInput)otherInput;
            if (entryEditorInput.getResolvedEntry() == null && otherEntryEditorInput.getResolvedEntry() == null) {
                return true;
            }
            return entryEditorInput.getResolvedEntry() != null && otherEntryEditorInput.getResolvedEntry() != null && entryEditorInput.getResolvedEntry().equals(otherEntryEditorInput.getResolvedEntry());
        }
        catch (PartInitException e) {
            return false;
        }
    }
}

