/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.actions;

import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.studio.connection.core.Utils;
import org.apache.directory.studio.ldapbrowser.common.dialogs.DnDialog;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.ui.BrowserUIPlugin;
import org.apache.directory.studio.ldapbrowser.ui.actions.LocateInDitAction;
import org.apache.directory.studio.ldapbrowser.ui.actions.Messages;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;

public class GotoDnAction
extends LocateInDitAction {
    public String getText() {
        return Messages.getString("GotoDnAction.GotoDN");
    }

    public ImageDescriptor getImageDescriptor() {
        return BrowserUIPlugin.getDefault().getImageDescriptor("resources/icons/locate_dn_in_dit.gif");
    }

    @Override
    public String getCommandId() {
        return null;
    }

    @Override
    public boolean isEnabled() {
        return this.getInput() instanceof IBrowserConnection;
    }

    @Override
    protected LocateInDitAction.ConnectionAndDn getConnectionAndDn() {
        if (this.getInput() instanceof IBrowserConnection) {
            IBrowserConnection conn = (IBrowserConnection)this.getInput();
            Dn dn = Utils.getLdapDn((String)GotoDnAction.getStringFromClipboard());
            DnDialog dialog = new DnDialog(this.getShell(), Messages.getString("GotoDnAction.GotoDNAction"), Messages.getString("GotoDnAction.EnterDNAction"), conn, dn);
            if (dialog.open() == 0 && dialog.getDn() != null) {
                dn = dialog.getDn();
                return new LocateInDitAction.ConnectionAndDn(this, conn, dn);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getStringFromClipboard() {
        Clipboard clipboard = null;
        try {
            clipboard = new Clipboard(Display.getCurrent());
            Object contents = clipboard.getContents((Transfer)TextTransfer.getInstance());
            if (contents != null && contents instanceof String) {
                String string = (String)contents;
                return string;
            }
        }
        finally {
            if (clipboard != null) {
                clipboard.dispose();
            }
        }
        return null;
    }
}

