/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.handlers;

import org.eclipse.core.expressions.Expression;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.handlers.SlaveHandlerService;
import org.eclipse.ui.internal.services.INestable;

public final class NestableHandlerService
extends SlaveHandlerService
implements INestable {
    private boolean active = false;

    public NestableHandlerService(IHandlerService parentHandlerService, Expression defaultExpression) {
        super(parentHandlerService, defaultExpression);
    }

    public final void activate() {
        if (this.active) {
            return;
        }
        Object[] localActivations = this.localActivationsToParentActivations.keySet().toArray();
        int i = 0;
        while (i < localActivations.length) {
            IHandlerActivation localActivation;
            Object object = localActivations[i];
            if (object instanceof IHandlerActivation && this.localActivationsToParentActivations.containsKey(localActivation = (IHandlerActivation)object)) {
                super.doActivation(localActivation);
            }
            ++i;
        }
        this.active = true;
    }

    protected final IHandlerActivation doActivation(IHandlerActivation localActivation) {
        if (this.active) {
            return super.doActivation(localActivation);
        }
        this.localActivationsToParentActivations.put(localActivation, null);
        return localActivation;
    }

    public final void deactivate() {
        if (!this.active) {
            return;
        }
        this.deactivateHandlers(this.parentActivations);
        this.parentActivations.clear();
        Object[] localActivations = this.localActivationsToParentActivations.keySet().toArray();
        int i = 0;
        while (i < localActivations.length) {
            Object object = localActivations[i];
            if (this.localActivationsToParentActivations.containsKey(object)) {
                this.localActivationsToParentActivations.put(object, null);
            }
            ++i;
        }
        this.active = false;
    }
}

